/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs.cpd;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.internal.workbench.RenderedElementUtil;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.internal.provisional.action.ToolBarContributionItem2;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.OpenPerspectiveAction;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.ActionSetActionBars;
import org.eclipse.ui.internal.ActionSetContributionItem;
import org.eclipse.ui.internal.ActionSetMenuManager;
import org.eclipse.ui.internal.CoolBarToTrimManager;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PluginActionCoolBarContributionItem;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.cpd.ActionSetFilter;
import org.eclipse.ui.internal.dialogs.cpd.ActionSetSelectionChangedListener;
import org.eclipse.ui.internal.dialogs.cpd.CategoryCheckProvider;
import org.eclipse.ui.internal.dialogs.cpd.CustomizeActionBars;
import org.eclipse.ui.internal.dialogs.cpd.FilteredModelCheckListener;
import org.eclipse.ui.internal.dialogs.cpd.FilteredTreeCheckProvider;
import org.eclipse.ui.internal.dialogs.cpd.FilteredViewerCheckListener;
import org.eclipse.ui.internal.dialogs.cpd.GrayOutUnavailableLabelProvider;
import org.eclipse.ui.internal.dialogs.cpd.ItemDetailToolTip;
import org.eclipse.ui.internal.dialogs.cpd.ShortcutLabelProvider;
import org.eclipse.ui.internal.dialogs.cpd.ShowUsedActionSetsFilter;
import org.eclipse.ui.internal.dialogs.cpd.TableToolTip;
import org.eclipse.ui.internal.dialogs.cpd.TreeManager;
import org.eclipse.ui.internal.dialogs.cpd.UnavailableContributionItemCheckListener;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class CustomizePerspectiveDialog
extends TrayDialog {
    private static final String ALL_SETS_INITIALIZED = "ALL_SETS_INITIALIZED";
    private static final String TOOLBAR_ICON = "$nl$/icons/full/obj16/toolbar.png";
    private static final String SUBMENU_ICON = "$nl$/icons/full/obj16/submenu.png";
    private static final String MENU_ICON = "$nl$/icons/full/obj16/menu.png";
    private static final String WARNING_ICON = "$nl$/icons/full/obj16/warn_tsk.png";
    private static final String SHORTCUT_CONTRIBUTION_ITEM_ID_OPEN_PERSPECTIVE = "openPerspective";
    private static final String SHORTCUT_CONTRIBUTION_ITEM_ID_SHOW_VIEW = "showView";
    static final String KEYS_PREFERENCE_PAGE_ID = "org.eclipse.ui.preferencePages.Keys";
    static final String NEW_LINE = System.lineSeparator();
    static final int MIN_TOOLTIP_WIDTH = 160;
    WorkbenchWindow window;
    private WorkbenchPage windowPage;
    private Perspective perspective;
    private TabFolder tabFolder;
    private static final int TAB_WIDTH_IN_DLUS = 490;
    private static final int TAB_HEIGHT_IN_DLUS = 230;
    private final String[] shortcutMenuColumnHeaders = new String[]{WorkbenchMessages.ActionSetSelection_menuColumnHeader, WorkbenchMessages.ActionSetSelection_descriptionColumnHeader};
    private int[] shortcutMenuColumnWidths = new int[]{125, 300};
    ImageDescriptor menuImageDescriptor;
    ImageDescriptor submenuImageDescriptor;
    ImageDescriptor toolbarImageDescriptor;
    ImageDescriptor warningImageDescriptor;
    private TreeManager treeManager;
    private DisplayItem menuItems;
    private DisplayItem toolBarItems;
    private Category shortcuts;
    private DisplayItem wizards;
    private DisplayItem perspectives;
    private DisplayItem views;
    Map<String, ActionSet> idToActionSet = new HashMap<String, ActionSet>();
    private final List<ActionSet> actionSets = new ArrayList<ActionSet>();
    private IWorkbenchWindowConfigurer configurer;
    private TabItem actionSetTab;
    private CheckboxTableViewer actionSetAvailabilityTable;
    private TreeViewer actionSetMenuViewer;
    private TreeViewer actionSetToolbarViewer;
    private CheckboxTreeViewer menuStructureViewer1;
    private CheckboxTreeViewer menuStructureViewer2;
    private CheckboxTreeViewer toolbarStructureViewer1;
    private CheckboxTreeViewer toolbarStructureViewer2;
    private CustomizeActionBars customizeActionBars;
    private MenuManagerRenderer menuMngrRenderer;
    private ToolBarManagerRenderer toolbarMngrRenderer;
    private ISWTResourceUtilities resUtils;
    private IEclipseContext context;

    private static ActionContributionItem getIContributionItem(IWizardDescriptor descriptor, IWorkbenchWindow window) {
        NewWizardShortcutAction action = new NewWizardShortcutAction(window, descriptor);
        return new ActionContributionItem((IAction)action);
    }

    private static ActionContributionItem getIContributionItem(IPerspectiveDescriptor descriptor, IWorkbenchWindow window) {
        OpenPerspectiveAction action = new OpenPerspectiveAction(window, descriptor, null);
        return new ActionContributionItem((IAction)action);
    }

    private static ActionContributionItem getIContributionItem(IWorkbenchWindow window) {
        ActionFactory.IWorkbenchAction action = ActionFactory.SHOW_VIEW_MENU.create(window);
        return new ActionContributionItem((IAction)action);
    }

    public CustomizePerspectiveDialog(IWorkbenchWindowConfigurer configurer, Perspective persp, IEclipseContext context) {
        super(configurer.getWindow().getShell());
        this.treeManager = new TreeManager();
        this.configurer = configurer;
        this.context = context;
        this.perspective = persp;
        this.window = (WorkbenchWindow)configurer.getWindow();
        this.windowPage = (WorkbenchPage)this.window.getActivePage();
        this.menuMngrRenderer = (MenuManagerRenderer)context.get(MenuManagerRenderer.class);
        this.toolbarMngrRenderer = (ToolBarManagerRenderer)context.get(ToolBarManagerRenderer.class);
        this.resUtils = (ISWTResourceUtilities)context.get(IResourceUtilities.class);
        this.initializeIcons();
        this.initializeActionSetInput();
        this.loadMenuAndToolbarStructure();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String title = this.perspective.getDesc().getLabel();
        title = NLS.bind((String)WorkbenchMessages.ActionSetSelection_customize, (Object)title);
        shell.setText(title);
        this.window.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.action_set_selection_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createButton(parent, 0, WorkbenchMessages.CustomizePerspectiveDialog_okButtonLabel, true);
        okButton.setFocus();
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.tabFolder = new TabFolder(composite, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertHorizontalDLUsToPixels(490);
        gd.heightHint = this.convertVerticalDLUsToPixels(230);
        this.tabFolder.setLayoutData((Object)gd);
        TabItem tab = new TabItem(this.tabFolder, 0);
        tab.setText(WorkbenchMessages.HideToolBarItems_toolBarItemsTab);
        tab.setControl((Control)this.createToolBarVisibilityPage((Composite)this.tabFolder));
        tab = new TabItem(this.tabFolder, 0);
        tab.setControl((Control)this.createMenuVisibilityPage((Composite)this.tabFolder));
        tab.setText(WorkbenchMessages.HideMenuItems_menuItemsTab);
        this.actionSetTab = new TabItem(this.tabFolder, 0);
        this.actionSetTab.setText(WorkbenchMessages.ActionSetSelection_actionSetsTab);
        this.actionSetTab.setControl((Control)this.createActionSetAvailabilityPage((Composite)this.tabFolder));
        if (this.showShortcutTab()) {
            TabItem item1 = new TabItem(this.tabFolder, 0);
            item1.setText(WorkbenchMessages.Shortcuts_shortcutTab);
            item1.setControl((Control)this.createShortCutsPage((Composite)this.tabFolder));
        }
        CustomizePerspectiveDialog.applyDialogFont((Control)this.tabFolder);
        return composite;
    }

    private Composite createShortCutsPage(Composite parent) {
        Composite menusComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        menusComposite.setLayout((Layout)layout);
        Label label = new Label(menusComposite, 64);
        label.setText(NLS.bind((String)WorkbenchMessages.Shortcuts_selectShortcutsLabel, (Object)this.perspective.getDesc().getLabel()));
        GridData data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        Label sep = new Label(menusComposite, 258);
        sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SashForm sashComposite = new SashForm(menusComposite, 256);
        data = new GridData(4, 4, true, true);
        sashComposite.setLayoutData((Object)data);
        Composite menusGroup = new Composite((Composite)sashComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        menusGroup.setLayout((Layout)layout);
        menusGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(menusGroup, 64);
        label.setText(WorkbenchMessages.Shortcuts_availableMenus);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Combo menusCombo = new Combo(menusGroup, 8);
        menusCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ComboViewer menusViewer = new ComboViewer(menusCombo);
        menusViewer.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        menusViewer.setLabelProvider(TreeManager.getLabelProvider());
        label = new Label(menusGroup, 64);
        label.setText(WorkbenchMessages.Shortcuts_availableCategories);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        CheckboxTreeViewer menuCategoriesViewer = new CheckboxTreeViewer(menusGroup);
        menuCategoriesViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        menuCategoriesViewer.setLabelProvider(TreeManager.getLabelProvider());
        menuCategoriesViewer.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        menuCategoriesViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        menuCategoriesViewer.setCheckStateProvider((ICheckStateProvider)new CategoryCheckProvider());
        menuCategoriesViewer.addCheckStateListener(event -> {
            Category category = (Category)event.getElement();
            category.setItemsState(event.getChecked());
            this.updateCategoryAndParents((StructuredViewer)menuCategoriesViewer, category);
        });
        this.treeManager.addListener(changedItem -> {
            ShortcutItem item;
            if (changedItem instanceof Category) {
                menuCategoriesViewer.update((Object)changedItem, null);
            } else if (changedItem instanceof ShortcutItem && (item = (ShortcutItem)changedItem).getCategory() != null) {
                item.getCategory().update();
                this.updateCategoryAndParents((StructuredViewer)menuCategoriesViewer, item.getCategory());
            }
        });
        Composite menuItemsGroup = new Composite((Composite)sashComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        menuItemsGroup.setLayout((Layout)layout);
        menuItemsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(menuItemsGroup, 64);
        label.setText(WorkbenchMessages.Shortcuts_allShortcuts);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        CheckboxTableViewer menuItemsViewer = CheckboxTableViewer.newCheckList((Composite)menuItemsGroup, (int)2816);
        Table menuTable = menuItemsViewer.getTable();
        menuTable.setLayoutData((Object)new GridData(4, 4, true, true));
        menuItemsViewer.setLabelProvider((IBaseLabelProvider)new ShortcutLabelProvider());
        menuItemsViewer.setCheckStateProvider(TreeManager.getCheckStateProvider());
        menuItemsViewer.addCheckStateListener(this.treeManager.getViewerCheckStateListener());
        this.treeManager.getCheckListener((ICheckable)menuItemsViewer);
        menuItemsViewer.setContentProvider((IContentProvider)new TreeManager.TreeItemContentProvider(){

            @Override
            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Category) {
                    return ((Category)parentElement).getContributionItems().toArray();
                }
                return super.getChildren(parentElement);
            }
        });
        menuItemsViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        menusViewer.addSelectionChangedListener(event -> {
            Category category = (Category)event.getStructuredSelection().getFirstElement();
            menuCategoriesViewer.setInput((Object)category);
            menuItemsViewer.setInput((Object)category);
            if (category.getChildrenCount() != 0) {
                CustomizePerspectiveDialog.setSelectionOn((Viewer)menuCategoriesViewer, category.getChildren().get(0));
            }
        });
        menuCategoriesViewer.addSelectionChangedListener(event -> {
            Category category = (Category)event.getStructuredSelection().getFirstElement();
            menuItemsViewer.setInput((Object)category);
        });
        menuTable.setHeaderVisible(true);
        int[] columnWidths = new int[this.shortcutMenuColumnWidths.length];
        int i = 0;
        while (i < this.shortcutMenuColumnWidths.length) {
            columnWidths[i] = this.convertHorizontalDLUsToPixels(this.shortcutMenuColumnWidths[i]);
            ++i;
        }
        i = 0;
        while (i < this.shortcutMenuColumnHeaders.length) {
            TableColumn tc = new TableColumn(menuTable, 0, i);
            tc.setResizable(true);
            tc.setText(this.shortcutMenuColumnHeaders[i]);
            tc.setWidth(columnWidths[i]);
            ++i;
        }
        sashComposite.setWeights(new int[]{30, 70});
        menusViewer.setInput((Object)this.shortcuts);
        if (this.shortcuts.getChildrenCount() > 0) {
            CustomizePerspectiveDialog.setSelectionOn((Viewer)menusViewer, this.shortcuts.getChildren().get(0));
        }
        return menusComposite;
    }

    private Composite createActionSetAvailabilityPage(Composite parent) {
        CheckboxTableViewer actionSetsViewer;
        Composite actionSetsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        actionSetsComposite.setLayout((Layout)layout);
        Label label = new Label(actionSetsComposite, 64);
        label.setText(NLS.bind((String)WorkbenchMessages.ActionSetSelection_selectActionSetsLabel, (Object)this.perspective.getDesc().getLabel()));
        GridData data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        Label sep = new Label(actionSetsComposite, 258);
        sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SashForm sashComposite = new SashForm(actionSetsComposite, 256);
        data = new GridData(4, 4, true, true);
        sashComposite.setLayoutData((Object)data);
        Composite actionSetGroup = new Composite((Composite)sashComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        actionSetGroup.setLayout((Layout)layout);
        actionSetGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(actionSetGroup, 64);
        label.setText(WorkbenchMessages.ActionSetSelection_availableActionSets);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.actionSetAvailabilityTable = actionSetsViewer = CheckboxTableViewer.newCheckList((Composite)actionSetGroup, (int)2816);
        actionSetsViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        actionSetsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        actionSetsViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        actionSetsViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return ((ActionSet)element).isActive();
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        actionSetsViewer.setInput((Object)this.actionSets.toArray());
        Table table = actionSetsViewer.getTable();
        new TableToolTip(table);
        final ActionSet[] selectedActionSet = new ActionSet[1];
        ViewerFilter setFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (selectedActionSet[0] == null) {
                    return false;
                }
                return CustomizePerspectiveDialog.includeInSetStructure((DisplayItem)element, selectedActionSet[0]);
            }
        };
        actionSetsViewer.addCheckStateListener(event -> {
            ActionSet actionSet = (ActionSet)event.getElement();
            if (event.getChecked()) {
                actionSet.setActive(true);
                for (DisplayItem item : actionSet.contributionItems) {
                    item.setCheckState(true);
                }
            } else {
                actionSet.setActive(false);
            }
        });
        Composite actionGroup = new Composite((Composite)sashComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        actionGroup.setLayout((Layout)layout);
        actionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite menubarGroup = new Composite(actionGroup, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        menubarGroup.setLayout((Layout)layout);
        menubarGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(menubarGroup, 64);
        label.setText(WorkbenchMessages.ActionSetSelection_menubarActions);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.actionSetMenuViewer = new TreeViewer(menubarGroup);
        this.actionSetMenuViewer.setAutoExpandLevel(-1);
        this.actionSetMenuViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.actionSetMenuViewer.setUseHashlookup(true);
        this.actionSetMenuViewer.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        this.actionSetMenuViewer.setLabelProvider((IBaseLabelProvider)new GrayOutUnavailableLabelProvider(null));
        this.actionSetMenuViewer.addFilter(setFilter);
        this.actionSetMenuViewer.setInput((Object)this.menuItems);
        Tree tree = this.actionSetMenuViewer.getTree();
        new ItemDetailToolTip(this, this.actionSetMenuViewer, tree, false, true, setFilter);
        Composite toolbarGroup = new Composite(actionGroup, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        toolbarGroup.setLayout((Layout)layout);
        toolbarGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(toolbarGroup, 64);
        label.setText(WorkbenchMessages.ActionSetSelection_toolbarActions);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.actionSetToolbarViewer = new TreeViewer(toolbarGroup);
        this.actionSetToolbarViewer.setAutoExpandLevel(-1);
        this.actionSetToolbarViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.actionSetToolbarViewer.setUseHashlookup(true);
        this.actionSetToolbarViewer.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        this.actionSetToolbarViewer.setLabelProvider((IBaseLabelProvider)new GrayOutUnavailableLabelProvider(null));
        this.actionSetToolbarViewer.addFilter(setFilter);
        this.actionSetToolbarViewer.setInput((Object)this.toolBarItems);
        tree = this.actionSetToolbarViewer.getTree();
        new ItemDetailToolTip(this, this.actionSetToolbarViewer, tree, false, true, setFilter);
        actionSetsViewer.addSelectionChangedListener(event -> {
            actionSetArray[0] = (ActionSet)event.getStructuredSelection().getFirstElement();
            this.actionSetMenuViewer.setInput((Object)this.menuItems);
            this.actionSetToolbarViewer.setInput((Object)this.toolBarItems);
        });
        sashComposite.setWeights(new int[]{30, 70});
        return actionSetsComposite;
    }

    private Composite createMenuVisibilityPage(Composite parent) {
        Composite hideMenuItemsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        hideMenuItemsComposite.setLayout((Layout)layout);
        Label label = new Label(hideMenuItemsComposite, 64);
        label.setText(WorkbenchMessages.HideMenuItems_chooseMenuItemsLabel);
        GridData data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        Label sep = new Label(hideMenuItemsComposite, 258);
        sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final PageBook book = new PageBook(hideMenuItemsComposite, 0);
        data = new GridData(1808);
        book.setLayoutData(data);
        final Composite simpleComposite = CustomizePerspectiveDialog.createItemStructureGroup(book, WorkbenchMessages.HideMenuItems_menuStructure);
        this.menuStructureViewer1 = this.initStructureViewer(simpleComposite, new TreeManager.ViewerCheckStateListener(), null);
        this.treeManager.getCheckListener((ICheckable)this.menuStructureViewer1);
        this.menuStructureViewer1.setCheckStateProvider(TreeManager.getCheckStateProvider());
        this.menuStructureViewer1.setInput((Object)this.menuItems);
        final SashForm advancedComposite = new SashForm((Composite)book, 256);
        data = new GridData(4, 4, true, true);
        advancedComposite.setLayoutData((Object)data);
        final TableViewer actionSetViewer = CustomizePerspectiveDialog.initActionSetViewer(CustomizePerspectiveDialog.createActionSetGroup((Composite)advancedComposite));
        actionSetViewer.addFilter((ViewerFilter)new ShowUsedActionSetsFilter(this.menuItems));
        actionSetViewer.setInput((Object)this.actionSets.toArray());
        ActionSetFilter menuStructureFilterByActionSet = new ActionSetFilter();
        Composite menuStructureComposite = CustomizePerspectiveDialog.createItemStructureGroup((Composite)advancedComposite, WorkbenchMessages.HideMenuItems_menuStructure);
        FilteredViewerCheckListener menuStructureFilter = new FilteredViewerCheckListener(TreeManager.getTreeContentProvider(), menuStructureFilterByActionSet);
        this.menuStructureViewer2 = this.initStructureViewer(menuStructureComposite, menuStructureFilter, menuStructureFilterByActionSet);
        this.treeManager.addListener(new FilteredModelCheckListener(menuStructureFilterByActionSet, (StructuredViewer)this.menuStructureViewer2));
        this.menuStructureViewer2.addFilter((ViewerFilter)menuStructureFilterByActionSet);
        actionSetViewer.addSelectionChangedListener((ISelectionChangedListener)new ActionSetSelectionChangedListener((TreeViewer)this.menuStructureViewer2, menuStructureFilterByActionSet));
        this.menuStructureViewer2.setCheckStateProvider((ICheckStateProvider)new FilteredTreeCheckProvider(TreeManager.getTreeContentProvider(), menuStructureFilterByActionSet));
        this.menuStructureViewer2.setInput((Object)this.menuItems);
        this.treeManager.addListener(changedItem -> {
            if (!(changedItem instanceof DisplayItem)) {
                return;
            }
            if (!changedItem.getState()) {
                return;
            }
            if (CustomizePerspectiveDialog.isAvailable((DisplayItem)changedItem)) {
                return;
            }
            changedItem.setCheckState(false);
        });
        final Button showCommandGroupFilterButton = new Button(hideMenuItemsComposite, 32);
        showCommandGroupFilterButton.setText(WorkbenchMessages.HideItems_turnOnActionSets);
        showCommandGroupFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (showCommandGroupFilterButton.getSelection()) {
                    Object o = ((StructuredSelection)CustomizePerspectiveDialog.this.menuStructureViewer1.getSelection()).getFirstElement();
                    ActionSet initSelectAS = null;
                    DisplayItem initSelectCI = null;
                    if (o instanceof DisplayItem) {
                        initSelectCI = (DisplayItem)o;
                        initSelectAS = initSelectCI.getActionSet();
                    }
                    if (initSelectAS == null) {
                        initSelectAS = (ActionSet)actionSetViewer.getElementAt(0);
                    }
                    if (initSelectAS != null) {
                        CustomizePerspectiveDialog.setSelectionOn((Viewer)actionSetViewer, initSelectAS);
                        actionSetViewer.reveal((Object)initSelectAS);
                    }
                    if (initSelectCI != null) {
                        CustomizePerspectiveDialog.setSelectionOn((Viewer)CustomizePerspectiveDialog.this.menuStructureViewer2, initSelectCI);
                        CustomizePerspectiveDialog.this.menuStructureViewer2.reveal((Object)initSelectCI);
                    }
                    book.showPage((Control)advancedComposite);
                } else {
                    book.showPage((Control)simpleComposite);
                }
            }
        });
        book.showPage((Control)simpleComposite);
        advancedComposite.setWeights(new int[]{30, 70});
        return hideMenuItemsComposite;
    }

    private Composite createToolBarVisibilityPage(Composite parent) {
        Composite hideToolbarItemsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        hideToolbarItemsComposite.setLayout((Layout)layout);
        Label label = new Label(hideToolbarItemsComposite, 64);
        label.setText(WorkbenchMessages.HideToolBarItems_chooseToolBarItemsLabel);
        GridData data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        Label sep = new Label(hideToolbarItemsComposite, 258);
        sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final PageBook book = new PageBook(hideToolbarItemsComposite, 0);
        data = new GridData(1808);
        book.setLayoutData(data);
        final Composite simpleComposite = CustomizePerspectiveDialog.createItemStructureGroup(book, WorkbenchMessages.HideToolBarItems_toolBarStructure);
        this.toolbarStructureViewer1 = this.initStructureViewer(simpleComposite, new TreeManager.ViewerCheckStateListener(), null);
        this.treeManager.getCheckListener((ICheckable)this.toolbarStructureViewer1);
        this.toolbarStructureViewer1.setCheckStateProvider(TreeManager.getCheckStateProvider());
        this.toolbarStructureViewer1.setInput((Object)this.toolBarItems);
        final SashForm advancedComposite = new SashForm((Composite)book, 256);
        data = new GridData(4, 4, true, true);
        advancedComposite.setLayoutData((Object)data);
        final TableViewer actionSetViewer = CustomizePerspectiveDialog.initActionSetViewer(CustomizePerspectiveDialog.createActionSetGroup((Composite)advancedComposite));
        actionSetViewer.addFilter((ViewerFilter)new ShowUsedActionSetsFilter(this.toolBarItems));
        actionSetViewer.setInput((Object)this.actionSets.toArray());
        ActionSetFilter toolbarStructureFilterByActionSet = new ActionSetFilter();
        Composite toolbarStructureComposite = CustomizePerspectiveDialog.createItemStructureGroup((Composite)advancedComposite, WorkbenchMessages.HideToolBarItems_toolBarStructure);
        FilteredViewerCheckListener toolbarStructureFilter = new FilteredViewerCheckListener(TreeManager.getTreeContentProvider(), toolbarStructureFilterByActionSet);
        this.toolbarStructureViewer2 = this.initStructureViewer(toolbarStructureComposite, toolbarStructureFilter, toolbarStructureFilterByActionSet);
        this.toolbarStructureViewer2.addFilter((ViewerFilter)toolbarStructureFilterByActionSet);
        this.treeManager.addListener(new FilteredModelCheckListener(toolbarStructureFilterByActionSet, (StructuredViewer)this.toolbarStructureViewer2));
        actionSetViewer.addSelectionChangedListener((ISelectionChangedListener)new ActionSetSelectionChangedListener((TreeViewer)this.toolbarStructureViewer2, toolbarStructureFilterByActionSet));
        this.toolbarStructureViewer2.setCheckStateProvider((ICheckStateProvider)new FilteredTreeCheckProvider(TreeManager.getTreeContentProvider(), toolbarStructureFilterByActionSet));
        this.toolbarStructureViewer2.setInput((Object)this.toolBarItems);
        this.treeManager.addListener(changedItem -> {
            if (!(changedItem instanceof DisplayItem)) {
                return;
            }
            if (!changedItem.getState()) {
                return;
            }
            if (CustomizePerspectiveDialog.isAvailable((DisplayItem)changedItem)) {
                return;
            }
            changedItem.setCheckState(false);
        });
        final Button showCommandGroupFilterButton = new Button(hideToolbarItemsComposite, 32);
        showCommandGroupFilterButton.setText(WorkbenchMessages.HideItems_turnOnActionSets);
        showCommandGroupFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (showCommandGroupFilterButton.getSelection()) {
                    Object o = ((StructuredSelection)CustomizePerspectiveDialog.this.toolbarStructureViewer1.getSelection()).getFirstElement();
                    ActionSet initSelectAS = null;
                    DisplayItem initSelectCI = null;
                    if (o instanceof DisplayItem) {
                        initSelectCI = (DisplayItem)o;
                        initSelectAS = initSelectCI.getActionSet();
                    }
                    if (initSelectAS == null) {
                        initSelectAS = (ActionSet)actionSetViewer.getElementAt(0);
                    }
                    if (initSelectAS != null) {
                        CustomizePerspectiveDialog.setSelectionOn((Viewer)actionSetViewer, initSelectAS);
                        actionSetViewer.reveal((Object)initSelectAS);
                    }
                    if (initSelectCI != null) {
                        CustomizePerspectiveDialog.setSelectionOn((Viewer)CustomizePerspectiveDialog.this.toolbarStructureViewer2, initSelectCI);
                        CustomizePerspectiveDialog.this.toolbarStructureViewer2.reveal((Object)initSelectCI);
                    }
                    book.showPage((Control)advancedComposite);
                } else {
                    book.showPage((Control)simpleComposite);
                }
            }
        });
        book.showPage((Control)simpleComposite);
        advancedComposite.setWeights(new int[]{30, 70});
        return hideToolbarItemsComposite;
    }

    private static TableViewer initActionSetViewer(Composite parent) {
        TableViewer actionSetViewer = new TableViewer(parent, 2816);
        actionSetViewer.getTable().setLayoutData((Object)new GridData(1808));
        actionSetViewer.setLabelProvider((IBaseLabelProvider)new GrayOutUnavailableLabelProvider(null));
        actionSetViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        actionSetViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Table table = actionSetViewer.getTable();
        new TableToolTip(table);
        return actionSetViewer;
    }

    private CheckboxTreeViewer initStructureViewer(Composite parent, ICheckStateListener checkStateListener, ViewerFilter filter) {
        CheckboxTreeViewer ctv = new CheckboxTreeViewer(parent, 2816);
        ctv.getControl().setLayoutData((Object)new GridData(1808));
        ctv.setUseHashlookup(true);
        ctv.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        ctv.addCheckStateListener((ICheckStateListener)new UnavailableContributionItemCheckListener(this, ctv, checkStateListener));
        ctv.setLabelProvider((IBaseLabelProvider)new GrayOutUnavailableLabelProvider(filter));
        new ItemDetailToolTip(this, (TreeViewer)ctv, ctv.getTree(), true, true, filter);
        return ctv;
    }

    private static Composite createItemStructureGroup(Composite composite, String labelText) {
        GridLayout layout = new GridLayout();
        Composite menubarGroup = new Composite(composite, 0);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        menubarGroup.setLayout((Layout)layout);
        menubarGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(menubarGroup, 64);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return menubarGroup;
    }

    private static Composite createActionSetGroup(Composite composite) {
        Composite actionSetGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        actionSetGroup.setLayout((Layout)layout);
        actionSetGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(actionSetGroup, 64);
        label.setText(WorkbenchMessages.HideItems_commandGroupTitle);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return actionSetGroup;
    }

    private static void setSelectionOn(Viewer viewer, Object selected) {
        StructuredSelection selection = selected == null ? StructuredSelection.EMPTY : new StructuredSelection(selected);
        boolean reveal = selection != StructuredSelection.EMPTY;
        viewer.setSelection((ISelection)selection, reveal);
    }

    static boolean includeInSetStructure(DisplayItem item, ActionSet set) {
        if (item.actionSet != null && item.actionSet.equals(set)) {
            return true;
        }
        for (TreeManager.TreeItem treeItem : item.getChildren()) {
            DisplayItem child = (DisplayItem)treeItem;
            if (!CustomizePerspectiveDialog.includeInSetStructure(child, set)) continue;
            return true;
        }
        return false;
    }

    static boolean isAvailable(DisplayItem item) {
        if (item.getActionSet() != null && item.getChildren().isEmpty()) {
            return item.getActionSet().isActive();
        }
        for (TreeManager.TreeItem treeItem : item.getChildren()) {
            DisplayItem child = (DisplayItem)treeItem;
            if (!CustomizePerspectiveDialog.isAvailable(child)) continue;
            return true;
        }
        return item.getIContributionItem() != null && item.getIContributionItem().isVisible();
    }

    static boolean isEffectivelyAvailable(DisplayItem item, ViewerFilter filter) {
        DisplayItem child;
        if (!CustomizePerspectiveDialog.isAvailable(item)) {
            return false;
        }
        List<TreeManager.TreeItem> children = item.getChildren();
        if (children.isEmpty()) {
            return true;
        }
        for (TreeManager.TreeItem treeItem : children) {
            child = (DisplayItem)treeItem;
            if (filter != null && !filter.select(null, null, (Object)child) || !CustomizePerspectiveDialog.isAvailable(child)) continue;
            return true;
        }
        for (TreeManager.TreeItem treeItem : children) {
            child = (DisplayItem)treeItem;
            if (filter != null && !filter.select(null, null, (Object)child) || !CustomizePerspectiveDialog.isEffectivelyAvailable(child, filter)) continue;
            return true;
        }
        return false;
    }

    private void actionSetAvailabilityChanged() {
        this.actionSetAvailabilityTable.refresh();
        this.actionSetMenuViewer.refresh();
        this.actionSetToolbarViewer.refresh();
        this.menuStructureViewer1.refresh();
        this.menuStructureViewer2.refresh();
        this.toolbarStructureViewer1.refresh();
        this.toolbarStructureViewer2.refresh();
    }

    private void initializeActionSetInput() {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] sets = reg.getActionSets();
        Object initDone = this.context.get(ALL_SETS_INITIALIZED);
        if (initDone == null) {
            this.context.set(ALL_SETS_INITIALIZED, (Object)Boolean.TRUE);
            this.window.getActionPresentation().setActionSets(sets);
            this.window.updateActionSets();
        }
        IActionSetDescriptor[] actionSetDescriptors = ((WorkbenchPage)this.window.getActivePage()).getActionSets();
        List<IActionSetDescriptor> initiallyAvailableActionSets = Arrays.asList(actionSetDescriptors);
        IActionSetDescriptor[] iActionSetDescriptorArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor set = iActionSetDescriptorArray[n2];
            ActionSetDescriptor actionSetDesc = (ActionSetDescriptor)set;
            if (!WorkbenchActivityHelper.filterItem(actionSetDesc)) {
                ActionSet actionSet = new ActionSet(actionSetDesc, initiallyAvailableActionSets.contains(actionSetDesc));
                this.idToActionSet.put(actionSetDesc.getId(), actionSet);
                this.actionSets.add(actionSet);
            }
            ++n2;
        }
    }

    private String getToolbarLabel(MUIElement elt) {
        MApplication app = (MApplication)this.context.get(MApplication.class);
        String toolbarLabel = CoolBarToTrimManager.getToolbarLabel(app, elt);
        if (toolbarLabel != null) {
            return toolbarLabel;
        }
        String elementId = elt.getElementId();
        ActionSetRegistry registry = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor findActionSet = registry.findActionSet(elementId);
        if (findActionSet != null) {
            return findActionSet.getLabel();
        }
        String[] nameParts = elementId.split("\\.");
        return nameParts[nameParts.length - 1];
    }

    private void initializeIcons() {
        String iconPath = MENU_ICON;
        URL url = BundleUtility.find("org.eclipse.ui", iconPath);
        this.menuImageDescriptor = ImageDescriptor.createFromURL((URL)url);
        iconPath = SUBMENU_ICON;
        url = BundleUtility.find("org.eclipse.ui", iconPath);
        this.submenuImageDescriptor = ImageDescriptor.createFromURL((URL)url);
        iconPath = TOOLBAR_ICON;
        url = BundleUtility.find("org.eclipse.ui", iconPath);
        this.toolbarImageDescriptor = ImageDescriptor.createFromURL((URL)url);
        iconPath = WARNING_ICON;
        url = BundleUtility.find("org.eclipse.ui", iconPath);
        this.warningImageDescriptor = ImageDescriptor.createFromURL((URL)url);
    }

    private void initializeNewWizardsMenu(DisplayItem menu, Category parentCategory, IWizardCategory element, List<String> activeIds) {
        Category category = new Category(element.getLabel());
        parentCategory.addChild(category);
        IWizardDescriptor[] wizards = element.getWizards();
        Object[] objectArray = wizards;
        int n = wizards.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardDescriptor wizard2 = objectArray[n2];
            WorkbenchWizardElement wizard = (WorkbenchWizardElement)wizard2;
            ShortcutItem item = new ShortcutItem(wizard.getLabel(), wizard);
            item.setLabel(wizard.getLabel());
            item.setDescription(wizard.getDescription());
            if (wizard.getImageDescriptor() != null) {
                item.setImageDescriptor(wizard.getImageDescriptor());
            }
            item.setCheckState(activeIds.contains(wizard.getId()));
            menu.addChild(item);
            category.addShortcutItem(item);
            ++n2;
        }
        objectArray = element.getCategories();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.initializeNewWizardsMenu(menu, category, (IWizardCategory)child, activeIds);
            ++n2;
        }
    }

    private void initializeNewWizardsMenu(DisplayItem menu) {
        Category rootForNewWizards = new Category(WorkbenchMessages.ActionSetDialogInput_wizardCategory);
        this.shortcuts.addChild(rootForNewWizards);
        IWizardCategory wizardCollection = WorkbenchPlugin.getDefault().getNewWizardRegistry().getRootCategory();
        IWizardCategory[] wizardCategories = wizardCollection.getCategories();
        List<String> activeIDs = Arrays.asList(this.perspective.getNewWizardShortcuts());
        IWizardCategory[] iWizardCategoryArray = wizardCategories;
        int n = wizardCategories.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardCategory element = iWizardCategoryArray[n2];
            if (!WorkbenchActivityHelper.filterItem(element)) {
                this.initializeNewWizardsMenu(menu, rootForNewWizards, element, activeIDs);
            }
            ++n2;
        }
    }

    private void initializePerspectivesMenu(DisplayItem menu) {
        Category rootForPerspectives = new Category(WorkbenchMessages.ActionSetDialogInput_perspectiveCategory);
        this.shortcuts.addChild(rootForPerspectives);
        IPerspectiveRegistry perspReg = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        IPerspectiveDescriptor[] persps = perspReg.getPerspectives();
        List<String> activeIds = Arrays.asList(this.perspective.getPerspectiveShortcuts());
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = persps;
        int n = persps.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor perspective = iPerspectiveDescriptorArray[n2];
            if (!WorkbenchActivityHelper.filterItem(perspective)) {
                ShortcutItem child = new ShortcutItem(perspective.getLabel(), perspective);
                child.setImageDescriptor(perspective.getImageDescriptor());
                child.setDescription(perspective.getDescription());
                child.setCheckState(activeIds.contains(perspective.getId()));
                menu.addChild(child);
                rootForPerspectives.addShortcutItem(child);
            }
            ++n2;
        }
    }

    private void initializeViewsMenu(DisplayItem menu) {
        Category rootForViews = new Category(WorkbenchMessages.ActionSetDialogInput_viewCategory);
        this.shortcuts.addChild(rootForViews);
        IViewRegistry viewReg = WorkbenchPlugin.getDefault().getViewRegistry();
        IViewCategory[] categories = viewReg.getCategories();
        List<String> activeIds = Arrays.asList(this.perspective.getShowViewShortcuts());
        IViewCategory[] iViewCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IViewCategory category = iViewCategoryArray[n2];
            if (!WorkbenchActivityHelper.filterItem(category)) {
                Category viewCategory = new Category(category.getLabel());
                rootForViews.addChild(viewCategory);
                IViewDescriptor[] views = category.getViews();
                if (views != null) {
                    IViewDescriptor[] iViewDescriptorArray = views;
                    int n3 = views.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IViewDescriptor view = iViewDescriptorArray[n4];
                        if (!view.getId().equals("org.eclipse.ui.internal.introview") && !WorkbenchActivityHelper.filterItem(view)) {
                            ShortcutItem child = new ShortcutItem(view.getLabel(), view);
                            child.setImageDescriptor(view.getImageDescriptor());
                            child.setDescription(view.getDescription());
                            child.setCheckState(activeIds.contains(view.getId()));
                            menu.addChild(child);
                            viewCategory.addShortcutItem(child);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private void loadMenuAndToolbarStructure() {
        IContributionItem[] items;
        this.customizeActionBars = new CustomizeActionBars(this.configurer, this.context);
        this.window.fillActionBars(this.customizeActionBars, 7);
        for (ActionSet actionSet : this.actionSets) {
            ActionSetDescriptor descriptor = actionSet.descriptor;
            PluginActionSet pluginActionSet = this.buildMenusAndToolbarsFor(this.customizeActionBars, descriptor);
            if (pluginActionSet == null) continue;
            pluginActionSet.dispose();
        }
        MenuManager menuManager = this.customizeActionBars.menuManager;
        IContributionItem[] iContributionItemArray = items = menuManager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionSetContributionItem) {
                ActionSetContributionItem asci = (ActionSetContributionItem)item;
                menuManager.add(asci.getInnerItem());
            }
            ++n2;
        }
        this.customizeActionBars.menuManager.setVisible(true);
        CustomizePerspectiveDialog.makeAllContributionsVisible((IContributionManager)this.customizeActionBars.menuManager);
        this.customizeActionBars.menuRenderer.reconcileManagerToModel(this.customizeActionBars.menuManager, this.customizeActionBars.mainMenu);
        IPresentationEngine engine = (IPresentationEngine)this.context.get(IPresentationEngine.class);
        engine.createGui((MUIElement)this.customizeActionBars.mainMenu, this.customizeActionBars.windowModel.getWidget(), this.customizeActionBars.windowModel.getContext());
        this.shortcuts = new Category("");
        this.toolBarItems = this.createTrimBarEntries(this.window.getTopTrim());
        this.menuItems = this.createMenuStructure(this.customizeActionBars.mainMenu);
    }

    private PluginActionSet buildMenusAndToolbarsFor(CustomizeActionBars customizeActionBars, ActionSetDescriptor actionSetDesc) {
        String id = actionSetDesc.getId();
        ActionSetActionBars bars = new ActionSetActionBars(customizeActionBars, this.window, customizeActionBars, id);
        bars.getMenuManager().setVisible(true);
        PluginActionSetBuilder builder = new PluginActionSetBuilder();
        PluginActionSet actionSet = null;
        try {
            actionSet = (PluginActionSet)actionSetDesc.createActionSet();
            actionSet.init(null, bars);
        }
        catch (CoreException ex) {
            WorkbenchPlugin.log("Unable to create action set " + actionSetDesc.getId(), ex);
            return null;
        }
        builder.buildMenuAndToolBarStructure(actionSet, this.window);
        return actionSet;
    }

    static String getCommandID(DisplayItem item) {
        IContributionItem object = item.getIContributionItem();
        if (item instanceof ShortcutItem && CustomizePerspectiveDialog.isShowView(item)) {
            return "org.eclipse.ui.views.showView";
        }
        return CustomizePerspectiveDialog.getIDFromIContributionItem(object);
    }

    public static String getIDFromIContributionItem(Object object) {
        if (object instanceof ActionContributionItem) {
            ActionContributionItem item = (ActionContributionItem)object;
            IAction action = item.getAction();
            if (action == null) {
                return null;
            }
            if (action instanceof NewWizardShortcutAction) {
                return "org.eclipse.ui.newWizard";
            }
            if (action instanceof OpenPerspectiveAction) {
                return "org.eclipse.ui.perspectives.showPerspective";
            }
            String id = action.getActionDefinitionId();
            if (id != null) {
                return id;
            }
            return action.getId();
        }
        if (object instanceof ActionSetContributionItem) {
            ActionSetContributionItem item = (ActionSetContributionItem)object;
            IContributionItem subitem = item.getInnerItem();
            return CustomizePerspectiveDialog.getIDFromIContributionItem(subitem);
        }
        if (object instanceof CommandContributionItem) {
            CommandContributionItem item = (CommandContributionItem)((Object)object);
            ParameterizedCommand command = item.getCommand();
            if (command == null) {
                return null;
            }
            return command.getId();
        }
        if (object instanceof IPerspectiveDescriptor) {
            return ((IPerspectiveDescriptor)object).getId();
        }
        if (object instanceof IViewDescriptor) {
            return ((IViewDescriptor)object).getId();
        }
        if (object instanceof WorkbenchWizardElement) {
            return ((WorkbenchWizardElement)object).getLocalId();
        }
        if (object instanceof IContributionItem) {
            String id = ((IContributionItem)object).getId();
            if (id != null) {
                return id;
            }
            return object.getClass().getName();
        }
        return null;
    }

    static String getParamID(DisplayItem object) {
        if (object instanceof ShortcutItem) {
            ShortcutItem shortcutItem = (ShortcutItem)object;
            if (CustomizePerspectiveDialog.isNewWizard(shortcutItem)) {
                ActionContributionItem item = (ActionContributionItem)object.getIContributionItem();
                NewWizardShortcutAction nwsa = (NewWizardShortcutAction)item.getAction();
                return nwsa.getLocalId();
            }
            if (CustomizePerspectiveDialog.isShowPerspective(shortcutItem)) {
                ActionContributionItem item = (ActionContributionItem)object.getIContributionItem();
                OpenPerspectiveAction opa = (OpenPerspectiveAction)item.getAction();
                return opa.getLocalId();
            }
            if (CustomizePerspectiveDialog.isShowView(shortcutItem)) {
                IViewDescriptor descriptor = (IViewDescriptor)shortcutItem.getDescriptor();
                return descriptor.getId();
            }
        }
        return null;
    }

    static boolean isNewWizard(DisplayItem item) {
        if (!(item instanceof ShortcutItem)) {
            return false;
        }
        return ((ShortcutItem)item).getDescriptor() instanceof IWizardDescriptor;
    }

    static boolean isShowPerspective(DisplayItem item) {
        if (!(item instanceof ShortcutItem)) {
            return false;
        }
        return ((ShortcutItem)item).getDescriptor() instanceof IPerspectiveDescriptor;
    }

    static boolean isShowView(DisplayItem item) {
        if (!(item instanceof ShortcutItem)) {
            return false;
        }
        return ((ShortcutItem)item).getDescriptor() instanceof IViewDescriptor;
    }

    private static String getActionSetID(IContributionItem item) {
        if (item instanceof ActionSetContributionItem) {
            return ((ActionSetContributionItem)item).getActionSetId();
        }
        if (item instanceof PluginActionCoolBarContributionItem) {
            return ((PluginActionCoolBarContributionItem)item).getActionSetId();
        }
        if (item instanceof ContributionItem) {
            IContributionManager parent = ((ContributionItem)item).getParent();
            if (parent instanceof ActionSetMenuManager) {
                return ((ActionSetMenuManager)parent).getActionSetId();
            }
            if (item instanceof ToolBarContributionItem2) {
                return item.getId();
            }
        }
        return null;
    }

    private static String getActionSetID(MUIElement item) {
        String id = (String)item.getTransientData().get("actionSet");
        if (id != null) {
            return id;
        }
        Object data = OpaqueElementUtil.getOpaqueItem((MUIElement)item);
        if (data == null) {
            data = item.getTransientData().get("coolbar.object");
        }
        if (data instanceof IContributionItem) {
            return CustomizePerspectiveDialog.getActionSetID((IContributionItem)data);
        }
        return null;
    }

    private static void makeAllContributionsVisible(IContributionManager manager) {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = manager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            CustomizePerspectiveDialog.makeContributionVisible(item);
            ++n2;
        }
    }

    private static void makeContributionVisible(IContributionItem item) {
        item.setVisible(true);
        if (item instanceof IContributionManager) {
            CustomizePerspectiveDialog.makeAllContributionsVisible((IContributionManager)item);
        }
        if (item instanceof SubContributionItem) {
            CustomizePerspectiveDialog.makeContributionVisible(((SubContributionItem)item).getInnerItem());
        }
    }

    private DisplayItem createMenuStructure(MMenu menu) {
        DisplayItem root = new DisplayItem("", null);
        this.createMenuEntries(menu, root);
        return root;
    }

    private void createMenuEntries(MMenu menu, DisplayItem parent) {
        DynamicContributionItem dynamicEntry = null;
        HashMap<IContributionItem, DisplayItem> processedOpaqueItems = new HashMap<IContributionItem, DisplayItem>();
        for (MMenuElement menuItem : menu.getChildren()) {
            dynamicEntry = this.createMenuEntry(parent, dynamicEntry, menuItem, processedOpaqueItems);
        }
    }

    private DynamicContributionItem createMenuEntry(DisplayItem parent, DynamicContributionItem dynamicEntry, MMenuElement menuItem, Map<IContributionItem, DisplayItem> processedOpaqueItems) {
        if (!menuItem.isToBeRendered()) {
            return null;
        }
        if (menuItem instanceof MMenu) {
            String managerId;
            ImageDescriptor iconDescriptor;
            DisplayItem menuEntry;
            MenuManager manager = this.menuMngrRenderer.getManager((MMenu)menuItem);
            if (OpaqueElementUtil.isOpaqueMenu((MUIElement)menuItem)) {
                if (processedOpaqueItems.containsKey(manager)) {
                    menuEntry = processedOpaqueItems.get(manager);
                } else {
                    menuEntry = new DisplayItem(manager.getMenuText(), (IContributionItem)manager);
                    parent.addChild(menuEntry);
                }
                iconDescriptor = manager.getImageDescriptor();
            } else {
                menuEntry = new DisplayItem(menuItem.getLocalizedLabel(), (IContributionItem)manager);
                iconDescriptor = this.getIconDescriptor((MUILabel)menuItem);
                parent.addChild(menuEntry);
            }
            if (iconDescriptor != null) {
                menuEntry.setImageDescriptor(iconDescriptor);
            } else if (parent.getParent() == null) {
                menuEntry.setImageDescriptor(this.menuImageDescriptor);
            } else {
                menuEntry.setImageDescriptor(this.submenuImageDescriptor);
            }
            menuEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID((MUIElement)menuItem)));
            String string = managerId = manager != null ? manager.getId() : null;
            if (ActionFactory.NEW.getId().equals(managerId)) {
                this.initializeNewWizardsMenu(menuEntry);
                this.wizards = menuEntry;
            } else if (SHORTCUT_CONTRIBUTION_ITEM_ID_OPEN_PERSPECTIVE.equals(managerId)) {
                this.initializePerspectivesMenu(menuEntry);
                this.perspectives = menuEntry;
            } else if (SHORTCUT_CONTRIBUTION_ITEM_ID_SHOW_VIEW.equals(managerId)) {
                this.initializeViewsMenu(menuEntry);
                this.views = menuEntry;
            } else {
                this.createMenuEntries((MMenu)menuItem, menuEntry);
            }
            if (menuEntry.getChildren().isEmpty()) {
                menuEntry.setCheckState(this.getMenuItemIsVisible(menuEntry));
            }
        } else {
            if (RenderedElementUtil.isRenderedMenuItem((MUIElement)menuItem)) {
                IContributionItem contributionItem = this.menuMngrRenderer.getContribution(menuItem);
                if (dynamicEntry == null || !contributionItem.equals(dynamicEntry.getIContributionItem())) {
                    dynamicEntry = new DynamicContributionItem(contributionItem);
                    dynamicEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID((MUIElement)menuItem)));
                    dynamicEntry.setCheckState(this.getMenuItemIsVisible(dynamicEntry));
                    parent.addChild(dynamicEntry);
                }
                if (menuItem.getWidget() != null) {
                    dynamicEntry.addCurrentItem((MenuItem)menuItem.getWidget());
                }
                return dynamicEntry;
            }
            if (OpaqueElementUtil.isOpaqueMenuItem((MUIElement)menuItem)) {
                IContributionItem contributionItem = this.menuMngrRenderer.getContribution(menuItem);
                if (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof SubMenuManager) {
                    contributionItem = (IMenuManager)((SubMenuManager)contributionItem).getParent();
                }
                if (processedOpaqueItems.containsKey(contributionItem)) {
                    return null;
                }
                if (contributionItem.isDynamic()) {
                    if (dynamicEntry == null || !contributionItem.equals(dynamicEntry.getIContributionItem())) {
                        dynamicEntry = new DynamicContributionItem(contributionItem);
                        dynamicEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID(contributionItem)));
                        dynamicEntry.setCheckState(this.getMenuItemIsVisible(dynamicEntry));
                        parent.addChild(dynamicEntry);
                        processedOpaqueItems.put(contributionItem, dynamicEntry);
                    }
                    if (menuItem.getWidget() != null) {
                        dynamicEntry.addCurrentItem((MenuItem)menuItem.getWidget());
                    }
                    return dynamicEntry;
                }
                if (contributionItem instanceof CommandContributionItem) {
                    CommandContributionItem cci = (CommandContributionItem)contributionItem;
                    CommandContributionItemParameter data = cci.getData();
                    DisplayItem menuEntry = new DisplayItem(data.label, contributionItem);
                    menuEntry.setImageDescriptor(data.icon);
                    menuEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID(contributionItem)));
                    menuEntry.setCheckState(this.getMenuItemIsVisible(menuEntry));
                    parent.addChild(menuEntry);
                    processedOpaqueItems.put(contributionItem, menuEntry);
                } else if (contributionItem instanceof ActionContributionItem) {
                    IAction action = ((ActionContributionItem)contributionItem).getAction();
                    DisplayItem menuEntry = new DisplayItem(action.getText(), contributionItem);
                    menuEntry.setImageDescriptor(action.getImageDescriptor());
                    menuEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID(contributionItem)));
                    menuEntry.setCheckState(this.getMenuItemIsVisible(menuEntry));
                    parent.addChild(menuEntry);
                    processedOpaqueItems.put(contributionItem, menuEntry);
                } else if (contributionItem instanceof MenuManager) {
                    MenuManager manager = (MenuManager)contributionItem;
                    DisplayItem menuEntry = new DisplayItem(manager.getMenuText(), contributionItem);
                    menuEntry.setImageDescriptor(manager.getImageDescriptor());
                    menuEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID(contributionItem)));
                    menuEntry.setCheckState(this.getMenuItemIsVisible(menuEntry));
                    parent.addChild(menuEntry);
                    processedOpaqueItems.put(contributionItem, menuEntry);
                }
            } else if (menuItem instanceof MDynamicMenuContribution) {
                IContributionItem contributionItem = this.menuMngrRenderer.getContribution(menuItem);
                dynamicEntry = new DynamicContributionItem(menuItem.getLocalizedLabel(), contributionItem);
                dynamicEntry.setImageDescriptor(this.getIconDescriptor((MUILabel)menuItem));
                dynamicEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID((MUIElement)menuItem)));
                dynamicEntry.setCheckState(this.getMenuItemIsVisible(dynamicEntry));
                parent.addChild(dynamicEntry);
            } else if (menuItem instanceof MDirectMenuItem) {
                IContributionItem contributionItem = this.menuMngrRenderer.getContribution(menuItem);
                DisplayItem menuEntry = new DisplayItem(menuItem.getLocalizedLabel(), contributionItem);
                menuEntry.setImageDescriptor(this.getIconDescriptor((MUILabel)menuItem));
                menuEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID((MUIElement)menuItem)));
                menuEntry.setCheckState(this.getMenuItemIsVisible(menuEntry));
                parent.addChild(menuEntry);
            } else if (menuItem instanceof MHandledMenuItem) {
                IContributionItem contributionItem = this.menuMngrRenderer.getContribution(menuItem);
                MHandledMenuItem hmi = (MHandledMenuItem)menuItem;
                String text = hmi.getLocalizedLabel();
                if (text == null && hmi.getWbCommand() != null) {
                    try {
                        text = hmi.getWbCommand().getName();
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                DisplayItem menuEntry = new DisplayItem(text, contributionItem);
                menuEntry.setImageDescriptor(this.getIconDescriptor((MUILabel)menuItem));
                menuEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID((MUIElement)menuItem)));
                menuEntry.setCheckState(this.getMenuItemIsVisible(menuEntry));
                parent.addChild(menuEntry);
            }
        }
        return null;
    }

    private ImageDescriptor getIconDescriptor(MUILabel item) {
        String iconURI = item.getIconURI();
        if (iconURI != null && iconURI.length() > 0) {
            return (ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI));
        }
        return null;
    }

    private boolean getMenuItemIsVisible(DisplayItem item) {
        return this.getItemIsVisible(item, "persp.hideMenuSC:");
    }

    private boolean getToolbarItemIsVisible(DisplayItem item) {
        return this.getItemIsVisible(item, "persp.hideToolbarSC:");
    }

    private boolean getItemIsVisible(DisplayItem item, String prefix) {
        return CustomizePerspectiveDialog.isAvailable(item) && !this.isHiddenItem(item, prefix);
    }

    private boolean isHiddenItem(DisplayItem item, String prefix) {
        String itemId = String.valueOf(prefix) + CustomizePerspectiveDialog.getCommandID(item) + ",";
        return this.windowPage.getHiddenItems().contains(itemId);
    }

    private void updateCategoryAndParents(StructuredViewer viewer, Category category) {
        while (category.getParent() != this.shortcuts) {
            viewer.update((Object)category, null);
            category = (Category)category.getParent();
        }
    }

    private static boolean hasVisibleItems(MToolBar toolBar) {
        for (MToolBarElement e : toolBar.getChildren()) {
            if (e instanceof MToolBarSeparator) continue;
            return true;
        }
        return false;
    }

    private DisplayItem createTrimBarEntries(MTrimBar trimBar) {
        DisplayItem root = new DisplayItem(null, null);
        if (trimBar == null) {
            return root;
        }
        for (MTrimElement trimElement : trimBar.getChildren()) {
            MToolBar toolBar;
            ToolBarManager manager;
            if (!(trimElement instanceof MToolBar) || (manager = this.toolbarMngrRenderer.getManager(toolBar = (MToolBar)trimElement)) == null) continue;
            IContributionItem contributionItem = (IContributionItem)toolBar.getTransientData().get("coolbar.object");
            String text = this.getToolbarLabel((MUIElement)toolBar);
            DisplayItem toolBarEntry = new DisplayItem(text, contributionItem);
            toolBarEntry.setImageDescriptor(this.toolbarImageDescriptor);
            toolBarEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID((MUIElement)toolBar)));
            if (!CustomizePerspectiveDialog.hasVisibleItems(toolBar)) continue;
            root.addChild(toolBarEntry);
            toolBarEntry.setCheckState(this.getToolbarItemIsVisible(toolBarEntry));
            this.createToolbarEntries(toolBar, toolBarEntry);
        }
        return root;
    }

    private void createToolbarEntries(MToolBar toolbar, DisplayItem parent) {
        if (toolbar == null) {
            return;
        }
        for (MToolBarElement element : toolbar.getChildren()) {
            this.createToolbarEntry(parent, element);
        }
    }

    private void createToolbarEntry(DisplayItem parent, MToolBarElement element) {
        ImageDescriptor iconDescriptor;
        IContributionItem contributionItem = this.toolbarMngrRenderer.getContribution(element);
        if (CustomizePerspectiveDialog.isGroupOrSeparator(element, contributionItem)) {
            return;
        }
        if (OpaqueElementUtil.isOpaqueToolItem((MUIElement)element)) {
            if (contributionItem instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)contributionItem).getAction();
                DisplayItem toolbarEntry = new DisplayItem(action.getText(), contributionItem);
                toolbarEntry.setImageDescriptor(action.getImageDescriptor());
                toolbarEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID(contributionItem)));
                if (toolbarEntry.getChildren().isEmpty()) {
                    toolbarEntry.setCheckState(this.getToolbarItemIsVisible(toolbarEntry));
                }
                parent.addChild(toolbarEntry);
            }
            return;
        }
        String text = null;
        if (element instanceof MItem) {
            text = this.getToolTipText((MItem)element);
        }
        ImageDescriptor imageDescriptor = iconDescriptor = element instanceof MItem ? this.getIconDescriptor((MUILabel)((MItem)element)) : null;
        if (element.getWidget() instanceof ToolItem) {
            Image image;
            ToolItem item = (ToolItem)element.getWidget();
            if (text == null) {
                text = item.getToolTipText();
            }
            if (text == null) {
                text = item.getText();
            }
            if (iconDescriptor == null && (image = item.getImage()) != null) {
                iconDescriptor = ImageDescriptor.createFromImage((Image)image);
            }
        }
        if (text == null) {
            text = this.getToolbarLabel((MUIElement)element);
        }
        DisplayItem toolBarEntry = new DisplayItem(text, contributionItem);
        if (iconDescriptor != null) {
            toolBarEntry.setImageDescriptor(iconDescriptor);
        }
        toolBarEntry.setActionSet(this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID((MUIElement)element)));
        if (toolBarEntry.getChildren().isEmpty()) {
            toolBarEntry.setCheckState(this.getToolbarItemIsVisible(toolBarEntry));
        }
        parent.addChild(toolBarEntry);
    }

    private static boolean isGroupOrSeparator(MToolBarElement element, IContributionItem contributionItem) {
        return element instanceof MToolBarSeparator || contributionItem == null || contributionItem.isGroupMarker() || contributionItem.isSeparator();
    }

    private static ParameterizedCommand generateParameterizedCommand(MHandledItem item, IEclipseContext lclContext) {
        ECommandService cmdService = (ECommandService)lclContext.get(ECommandService.class);
        HashMap<String, String> parameters = null;
        List modelParms = item.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = cmdService.createCommand(item.getCommand().getElementId(), parameters);
        item.setWbCommand(cmd);
        return cmd;
    }

    private String getToolTipText(MItem item) {
        Object opaque;
        String text = item.getLocalizedTooltip();
        if (item instanceof MHandledItem) {
            TriggerSequence sequence;
            MHandledItem handledItem = (MHandledItem)item;
            EBindingService bs = (EBindingService)this.context.get(EBindingService.class);
            ParameterizedCommand cmd = handledItem.getWbCommand();
            if (cmd == null) {
                cmd = CustomizePerspectiveDialog.generateParameterizedCommand(handledItem, this.context);
            }
            if ((sequence = bs.getBestSequenceFor(handledItem.getWbCommand())) != null) {
                if (text == null) {
                    try {
                        text = cmd.getName();
                    }
                    catch (NotDefinedException notDefinedException) {
                        return null;
                    }
                }
                text = String.valueOf(text) + " (" + sequence.format() + ')';
            }
            return text;
        }
        if (OpaqueElementUtil.isOpaqueMenuItem((MUIElement)item)) {
            Object opaque2 = OpaqueElementUtil.getOpaqueItem((MUIElement)item);
            if (opaque2 instanceof ActionContributionItem) {
                return ((ActionContributionItem)opaque2).getAction().getText();
            }
        } else if (OpaqueElementUtil.isOpaqueToolItem((MUIElement)item) && (opaque = OpaqueElementUtil.getOpaqueItem((MUIElement)item)) instanceof ActionContributionItem) {
            return ((ActionContributionItem)opaque).getAction().getToolTipText();
        }
        return text;
    }

    private boolean showShortcutTab() {
        return this.window.containsSubmenu(4) || this.window.containsSubmenu(2) || this.window.containsSubmenu(1);
    }

    private static ArrayList<String> getVisibleIDs(DisplayItem root) {
        if (root == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> ids = new ArrayList<String>(root.getChildrenCount());
        for (TreeManager.TreeItem treeItem : root.getChildren()) {
            DisplayItem object = (DisplayItem)treeItem;
            if (!(object instanceof ShortcutItem) || !object.getState()) continue;
            ids.add(CustomizePerspectiveDialog.getParamID(object));
        }
        return ids;
    }

    private void getChangedIds(DisplayItem item, List<String> invisible, List<String> visible) {
        String id;
        if (item instanceof ShortcutItem) {
            return;
        }
        if (item == this.wizards || item == this.perspectives || item == this.views) {
            return;
        }
        if (item.getChildrenCount() > 0) {
            String id2;
            if (item.isChangedByUser() && (id2 = CustomizePerspectiveDialog.getCommandID(item)) != null) {
                if (item.getState()) {
                    visible.add(id2);
                } else {
                    invisible.add(id2);
                }
            }
            for (TreeManager.TreeItem treeItem : item.getChildren()) {
                this.getChangedIds((DisplayItem)treeItem, invisible, visible);
            }
        } else if (item.isChangedByUser() && (id = CustomizePerspectiveDialog.getCommandID(item)) != null) {
            if (item.getState()) {
                visible.add(id);
            } else {
                invisible.add(id);
            }
        }
    }

    private boolean updateHiddenElements(List<ActionSet> items, String currentHidden, String prefix) {
        ArrayList<String> changedAndVisible = new ArrayList<String>();
        ArrayList<String> changedAndInvisible = new ArrayList<String>();
        for (ActionSet actionSet : items) {
            if (!actionSet.wasChanged()) continue;
            if (actionSet.isActive()) {
                changedAndVisible.add(actionSet.descriptor.getId());
                continue;
            }
            changedAndInvisible.add(actionSet.descriptor.getId());
        }
        return this.updateHiddenElements(currentHidden, prefix, changedAndVisible, changedAndInvisible);
    }

    private boolean updateHiddenElements(DisplayItem items, String currentHidden, String prefix) {
        ArrayList<String> changedAndVisible = new ArrayList<String>();
        ArrayList<String> changedAndInvisible = new ArrayList<String>();
        this.getChangedIds(items, changedAndInvisible, changedAndVisible);
        return this.updateHiddenElements(currentHidden, prefix, changedAndVisible, changedAndInvisible);
    }

    private boolean updateHiddenElements(String currentHidden, String prefix, List<String> changedAndVisible, List<String> changedAndInvisible) {
        String itemId;
        boolean hasChanges = false;
        for (String id : changedAndVisible) {
            itemId = String.valueOf(prefix) + id;
            if (!currentHidden.contains(String.valueOf(itemId) + ",")) continue;
            hasChanges = true;
            this.windowPage.removeHiddenItems(itemId);
        }
        for (String id : changedAndInvisible) {
            itemId = String.valueOf(prefix) + id;
            if (currentHidden.contains(String.valueOf(itemId) + ",")) continue;
            hasChanges = true;
            this.windowPage.addHiddenItems(itemId);
        }
        return hasChanges;
    }

    protected void okPressed() {
        if (this.showShortcutTab()) {
            this.windowPage.setNewShortcuts(CustomizePerspectiveDialog.getVisibleIDs(this.wizards), "persp.newWizSC:");
            this.windowPage.setNewShortcuts(CustomizePerspectiveDialog.getVisibleIDs(this.perspectives), "persp.perspSC:");
            this.windowPage.setNewShortcuts(CustomizePerspectiveDialog.getVisibleIDs(this.views), "persp.viewSC:");
        }
        boolean requiresUpdate = false;
        ArrayList<ActionSetDescriptor> toAdd = new ArrayList<ActionSetDescriptor>();
        ArrayList<ActionSetDescriptor> toRemove = new ArrayList<ActionSetDescriptor>();
        for (ActionSet actionSet : this.actionSets) {
            if (!actionSet.wasChanged()) continue;
            requiresUpdate = true;
            if (actionSet.isActive()) {
                toAdd.add(actionSet.descriptor);
                continue;
            }
            toRemove.add(actionSet.descriptor);
        }
        this.perspective.turnOnActionSets(toAdd.toArray(new IActionSetDescriptor[toAdd.size()]));
        this.perspective.turnOffActionSets(toRemove.toArray(new IActionSetDescriptor[toRemove.size()]));
        requiresUpdate |= this.updateHiddenElements(this.actionSets, this.windowPage.getHiddenItems(), "persp.hideActionSetSC:");
        requiresUpdate |= this.updateHiddenElements(this.menuItems, this.windowPage.getHiddenItems(), "persp.hideMenuSC:");
        if (requiresUpdate |= this.updateHiddenElements(this.toolBarItems, this.windowPage.getHiddenItems(), "persp.hideToolbarSC:")) {
            this.perspective.updateActionBars();
        }
        super.okPressed();
    }

    public boolean close() {
        this.treeManager.dispose();
        this.customizeActionBars.dispose();
        return super.close();
    }

    private static String removeShortcut(String label) {
        if (label == null) {
            return label;
        }
        int end = label.lastIndexOf(64);
        if (end >= 0) {
            label = label.substring(0, end);
        }
        if ((end = label.lastIndexOf(9)) >= 0) {
            label = label.substring(0, end);
        }
        return label;
    }

    protected boolean isResizable() {
        return true;
    }

    void showActionSet(DisplayItem item) {
        if (item.getActionSet() != null) {
            this.showActionSet(item.getActionSet());
        }
    }

    void showActionSet(ActionSet actionSet) {
        this.tabFolder.setSelection(this.actionSetTab);
        this.actionSetAvailabilityTable.reveal((Object)actionSet);
        CustomizePerspectiveDialog.setSelectionOn((Viewer)this.actionSetAvailabilityTable, actionSet);
        this.actionSetAvailabilityTable.getControl().setFocus();
    }

    class ActionSet {
        ActionSetDescriptor descriptor;
        private List<DisplayItem> contributionItems;
        private boolean active;
        private boolean wasChanged = false;

        public ActionSet(ActionSetDescriptor descriptor, boolean active) {
            this.descriptor = descriptor;
            this.active = active;
            this.contributionItems = new ArrayList<DisplayItem>();
        }

        public void addItem(DisplayItem item) {
            this.contributionItems.add(item);
        }

        public String toString() {
            return this.descriptor.getLabel();
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean wasChanged() {
            return this.wasChanged;
        }

        public void setActive(boolean active) {
            boolean wasActive = this.active;
            this.active = active;
            if (!active) {
                for (DisplayItem item : this.contributionItems) {
                    item.setCheckState(false);
                }
            }
            if (wasActive != active) {
                CustomizePerspectiveDialog.this.actionSetAvailabilityChanged();
            }
            this.wasChanged = true;
        }
    }

    class Category
    extends TreeManager.TreeItem {
        private List<ShortcutItem> contributionItems;

        public Category(String label) {
            TreeManager treeManager = CustomizePerspectiveDialog.this.treeManager;
            treeManager.getClass();
            super(label == null ? null : DialogUtil.removeAccel(CustomizePerspectiveDialog.removeShortcut(label)));
            this.contributionItems = new ArrayList<ShortcutItem>();
        }

        public List<ShortcutItem> getContributionItems() {
            return this.contributionItems;
        }

        public void addShortcutItem(ShortcutItem item) {
            this.contributionItems.add(item);
            item.setCategory(this);
        }

        public void update() {
            for (ShortcutItem shortcutItem : this.contributionItems) {
                ShortcutItem item = shortcutItem;
                if (!item.getState()) continue;
                this.setCheckState(true);
                return;
            }
            this.setCheckState(false);
        }

        public void setItemsState(boolean state) {
            for (ShortcutItem shortcutItem : this.contributionItems) {
                shortcutItem.setCheckState(state);
            }
            for (TreeManager.TreeItem o : this.getChildren()) {
                Category category = (Category)o;
                category.setItemsState(state);
            }
        }
    }

    class DisplayItem
    extends TreeManager.TreeItem {
        private IContributionItem item;
        ActionSet actionSet;

        public DisplayItem(String label, IContributionItem item) {
            TreeManager treeManager = CustomizePerspectiveDialog.this.treeManager;
            treeManager.getClass();
            super(label == null ? null : DialogUtil.removeAccel(CustomizePerspectiveDialog.removeShortcut(label)));
            this.item = item;
        }

        public void setActionSet(ActionSet actionSet) {
            this.actionSet = actionSet;
            if (actionSet != null) {
                actionSet.addItem(this);
            }
        }

        public ActionSet getActionSet() {
            return this.actionSet;
        }

        public IContributionItem getIContributionItem() {
            return this.item;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + (this.item == null ? "" : " [" + this.item.getId() + "]");
        }
    }

    class DynamicContributionItem
    extends DisplayItem {
        private List<MenuItem> preview;

        public DynamicContributionItem(String label, IContributionItem item) {
            super(String.valueOf(WorkbenchMessages.HideItems_dynamicItemName) + " - " + label, item);
            this.preview = new ArrayList<MenuItem>();
        }

        public DynamicContributionItem(IContributionItem item) {
            super(WorkbenchMessages.HideItems_dynamicItemName, item);
            this.preview = new ArrayList<MenuItem>();
        }

        public void addCurrentItem(MenuItem item) {
            this.preview.add(item);
        }

        public List<MenuItem> getCurrentItems() {
            return this.preview;
        }
    }

    class ShortcutItem
    extends DisplayItem {
        private String description;
        private Category category;
        private Object descriptor;

        public ShortcutItem(String label, IWizardDescriptor descriptor) {
            super(label, (IContributionItem)CustomizePerspectiveDialog.getIContributionItem(descriptor, CustomizePerspectiveDialog.this.window));
            this.descriptor = descriptor;
        }

        public ShortcutItem(String label, IPerspectiveDescriptor descriptor) {
            super(label, (IContributionItem)CustomizePerspectiveDialog.getIContributionItem(descriptor, CustomizePerspectiveDialog.this.window));
            this.descriptor = descriptor;
        }

        public ShortcutItem(String label, IViewDescriptor descriptor) {
            super(label, (IContributionItem)CustomizePerspectiveDialog.getIContributionItem(CustomizePerspectiveDialog.this.window));
            this.descriptor = descriptor;
        }

        public Object getDescriptor() {
            return this.descriptor;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setCategory(Category category) {
            this.category = category;
        }

        public Category getCategory() {
            return this.category;
        }
    }
}

