/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingCustom;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDContentValueHandler;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettingsExt;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterSQL
extends StreamExporterAbstract {
    private static final Log log = Log.getLog(DataExporterSQL.class);
    private static final String PROP_INCLUDE_AUTO_GENERATED = "includeAutoGenerated";
    private static final String PROP_OMIT_SCHEMA = "omitSchema";
    private static final String PROP_ROWS_IN_STATEMENT = "rowsInStatement";
    private static final String PROP_DATA_FORMAT = "nativeFormat";
    private static final char STRING_QUOTE = '\'';
    private static final String PROP_LINE_BEFORE_ROWS = "lineBeforeRows";
    private static final String PROP_KEYWORD_CASE = "keywordCase";
    private static final String PROP_UPSERT = "upsertKeyword";
    private static final String PROP_ON_CONFLICT = "insertOnConflict";
    private boolean includeAutoGenerated;
    private String rowDelimiter;
    private boolean omitSchema;
    private int rowsInStatement;
    private boolean useNativeDataFormat = true;
    private boolean lineBeforeRows = true;
    private String tableName;
    private DBDAttributeBinding[] columns;
    private final String KEYWORD_INSERT_INTO = "INSERT INTO";
    private final String KEYWORD_VALUES = "VALUES";
    private static final String KEYWORD_UPDATE_OR = "UPDATE OR";
    private static final String KEYWORD_UPSERT = "UPSERT INTO";
    private static final String KEYWORD_DUPLICATE_KEY = "ON DUPLICATE KEY UPDATE";
    private static final String KEYWORD_ON_CONFLICT = "ON CONFLICT";
    private DBPIdentifierCase identifierCase;
    private static String onConflictExpression;
    private transient StringBuilder sqlBuffer = new StringBuilder(100);
    private transient long rowCount;
    private SQLDialect dialect;
    private InsertKeyword insertKeyword;

    private boolean isSkipColumn(DBDAttributeBinding attr) {
        return attr.isPseudoAttribute() || !this.includeAutoGenerated && attr.isAutoGenerated() || attr instanceof DBDAttributeBindingCustom;
    }

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        Map<String, Object> properties = site.getProperties();
        if (properties.containsKey(PROP_INCLUDE_AUTO_GENERATED)) {
            this.includeAutoGenerated = CommonUtils.toBoolean((Object)properties.get(PROP_INCLUDE_AUTO_GENERATED));
        }
        if (properties.containsKey(PROP_OMIT_SCHEMA)) {
            this.omitSchema = CommonUtils.toBoolean((Object)properties.get(PROP_OMIT_SCHEMA));
        }
        try {
            this.rowsInStatement = CommonUtils.toInt((Object)properties.get(PROP_ROWS_IN_STATEMENT));
        }
        catch (NumberFormatException numberFormatException) {
            this.rowsInStatement = 10;
        }
        this.useNativeDataFormat = CommonUtils.toBoolean((Object)properties.get(PROP_DATA_FORMAT));
        this.lineBeforeRows = CommonUtils.toBoolean((Object)properties.get(PROP_LINE_BEFORE_ROWS));
        this.rowDelimiter = GeneralUtils.getDefaultLineSeparator();
        this.dialect = SQLUtils.getDialectFromObject((DBPObject)site.getSource());
        String keywordCase = CommonUtils.toString((Object)properties.get(PROP_KEYWORD_CASE));
        this.identifierCase = keywordCase.equalsIgnoreCase("lower") ? DBPIdentifierCase.LOWER : DBPIdentifierCase.UPPER;
        this.insertKeyword = InsertKeyword.fromValue(CommonUtils.toString((Object)properties.get(PROP_UPSERT)));
        onConflictExpression = CommonUtils.toString((Object)properties.get(PROP_ON_CONFLICT));
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        if (this.useNativeDataFormat && session instanceof DBDFormatSettingsExt) {
            ((DBDFormatSettingsExt)session).setUseNativeDateTimeFormat(true);
        }
        this.columns = this.getSite().getAttributes();
        DBPNamedObject source = this.getSite().getSource();
        this.tableName = DTUtils.getTableName(session.getDataSource(), source, this.omitSchema);
        this.rowCount = 0L;
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        DBDAttributeBinding column;
        int i;
        SQLDialect.MultiValueInsertMode insertMode;
        PrintWriter out = this.getWriter();
        SQLDialect.MultiValueInsertMode multiValueInsertMode = insertMode = this.rowsInStatement == 1 ? SQLDialect.MultiValueInsertMode.NOT_SUPPORTED : this.getMultiValueInsertMode();
        if (insertMode == SQLDialect.MultiValueInsertMode.NOT_SUPPORTED) {
            this.rowsInStatement = 1;
        }
        int columnsSize = this.columns.length;
        boolean firstRow = false;
        if (insertMode == SQLDialect.MultiValueInsertMode.NOT_SUPPORTED || this.rowCount % (long)this.rowsInStatement == 0L) {
            this.sqlBuffer.setLength(0);
            if (this.rowCount > 0L) {
                if (insertMode == SQLDialect.MultiValueInsertMode.PLAIN) {
                    this.sqlBuffer.append(");");
                } else if (insertMode == SQLDialect.MultiValueInsertMode.GROUP_ROWS) {
                    if (!CommonUtils.isEmpty((String)onConflictExpression)) {
                        this.addOnConflictExpression(out);
                    }
                    this.sqlBuffer.append(";");
                }
                if (this.lineBeforeRows) {
                    this.sqlBuffer.append(this.rowDelimiter);
                }
            }
            if (this.insertKeyword == InsertKeyword.UPDATE) {
                this.sqlBuffer.append(this.identifierCase.transform(KEYWORD_UPDATE_OR)).append(" ");
            }
            if (this.insertKeyword == InsertKeyword.UPSERT) {
                this.sqlBuffer.append(this.identifierCase.transform(KEYWORD_UPSERT));
            } else {
                this.sqlBuffer.append(this.identifierCase.transform("INSERT INTO"));
            }
            this.sqlBuffer.append(" ").append(this.tableName).append(" (");
            boolean hasColumn = false;
            i = 0;
            while (i < columnsSize) {
                column = this.columns[i];
                if (!this.isSkipColumn(column)) {
                    if (hasColumn) {
                        this.sqlBuffer.append(',');
                    }
                    hasColumn = true;
                    this.sqlBuffer.append(DBUtils.getQuotedIdentifier((DBSObject)column));
                }
                ++i;
            }
            this.sqlBuffer.append(") ");
            this.sqlBuffer.append(this.identifierCase.transform("VALUES"));
            if (insertMode != SQLDialect.MultiValueInsertMode.GROUP_ROWS) {
                this.sqlBuffer.append(" (");
            }
            if (this.rowsInStatement > 1 && this.lineBeforeRows) {
                this.sqlBuffer.append(this.rowDelimiter);
            }
            out.write(this.sqlBuffer.toString());
            firstRow = true;
        }
        if (insertMode != SQLDialect.MultiValueInsertMode.NOT_SUPPORTED && !firstRow) {
            out.write(",");
            if (this.lineBeforeRows) {
                out.write(this.rowDelimiter);
            }
        }
        if (insertMode == SQLDialect.MultiValueInsertMode.GROUP_ROWS) {
            if (this.lineBeforeRows) {
                out.write("\t");
            }
            out.write(" (");
        }
        ++this.rowCount;
        boolean hasValue = false;
        i = 0;
        while (i < columnsSize) {
            block51: {
                column = this.columns[i];
                if (!this.isSkipColumn(column)) {
                    if (hasValue) {
                        out.write(44);
                    }
                    hasValue = true;
                    Object value = row[i];
                    if (DBUtils.isNullValue((Object)value)) {
                        out.write("NULL");
                    } else if (row[i] instanceof DBDContent) {
                        DBDContent content;
                        block50: {
                            content = (DBDContent)row[i];
                            try {
                                try {
                                    if (column.getValueHandler() instanceof DBDContentValueHandler) {
                                        ((DBDContentValueHandler)column.getValueHandler()).writeStreamValue(session.getProgressMonitor(), session.getDataSource(), (DBSTypedObject)column, content, (Writer)out);
                                        break block50;
                                    }
                                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                                    if (cs == null) break block50;
                                    if (ContentUtils.isTextContent((DBDContent)content)) {
                                        Throwable throwable = null;
                                        Object var15_18 = null;
                                        try (Reader contentReader = cs.getContentReader();){
                                            this.writeStringValue(contentReader);
                                            break block50;
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                            } else if (throwable != throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            throw throwable;
                                        }
                                    }
                                    this.getSite().writeBinaryData(cs);
                                }
                                catch (Exception e) {
                                    log.warn((Object)e);
                                    content.release();
                                    break block51;
                                }
                            }
                            catch (Throwable throwable) {
                                content.release();
                                throw throwable;
                            }
                        }
                        content.release();
                    } else if (value instanceof File) {
                        out.write("@");
                        out.write(((File)value).getAbsolutePath());
                    } else {
                        boolean needQuotes = false;
                        DBDDisplayFormat displayFormat = DBDDisplayFormat.NATIVE;
                        if (!this.useNativeDataFormat && column.getDataKind() == DBPDataKind.DATETIME) {
                            displayFormat = DBDDisplayFormat.UI;
                            needQuotes = true;
                        }
                        String sqlValue = SQLUtils.convertValueToSQL((DBPDataSource)session.getDataSource(), (DBSAttributeBase)column, (DBDValueHandler)column.getValueHandler(), (Object)row[i], (DBDDisplayFormat)displayFormat);
                        if (needQuotes) {
                            out.write(39);
                        }
                        out.write(sqlValue);
                        if (needQuotes) {
                            out.write(39);
                        }
                    }
                }
            }
            ++i;
        }
        if (insertMode != SQLDialect.MultiValueInsertMode.PLAIN) {
            out.write(")");
        }
        if (!CommonUtils.isEmpty((String)onConflictExpression) && insertMode == SQLDialect.MultiValueInsertMode.NOT_SUPPORTED) {
            this.addOnConflictExpression(out);
        }
        if (insertMode == SQLDialect.MultiValueInsertMode.NOT_SUPPORTED) {
            out.write(";");
        }
    }

    private void addOnConflictExpression(PrintWriter out) {
        if (this.insertKeyword == InsertKeyword.ON_CONFLICT) {
            out.write(" " + this.identifierCase.transform(KEYWORD_ON_CONFLICT) + " " + onConflictExpression);
        } else if (this.insertKeyword == InsertKeyword.ON_DUPLICATE) {
            out.write(" " + this.identifierCase.transform(KEYWORD_DUPLICATE_KEY) + " " + onConflictExpression);
        }
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) {
        PrintWriter out = this.getWriter();
        switch (this.getMultiValueInsertMode()) {
            case GROUP_ROWS: {
                if (this.rowCount <= 0L) break;
                this.addOnConflictExpression(out);
                out.write(";");
                break;
            }
            case PLAIN: {
                if (this.rowCount <= 0L) break;
                out.write(");");
                break;
            }
        }
    }

    private void writeStringValue(String value) {
        PrintWriter out = this.getWriter();
        out.write(39);
        if (this.dialect != null) {
            out.write(this.dialect.escapeString(value));
        } else {
            out.write(value);
        }
        out.write(39);
    }

    private void writeStringValue(Reader reader) throws IOException {
        try {
            int count;
            PrintWriter out = this.getWriter();
            out.write(39);
            char[] buffer = new char[2000];
            while ((count = reader.read(buffer)) > 0) {
                if (this.dialect != null) {
                    out.write(this.dialect.escapeString(String.valueOf(buffer, 0, count)));
                    continue;
                }
                out.write(buffer, 0, count);
            }
            out.write(39);
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    private SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        SQLDialect.MultiValueInsertMode insertMode = SQLDialect.MultiValueInsertMode.NOT_SUPPORTED;
        if (this.dialect != null && this.rowsInStatement != 1) {
            insertMode = this.dialect.getMultiValueInsertMode();
        }
        return insertMode;
    }

    static enum InsertKeyword {
        INSERT("INSERT"),
        UPDATE("UPDATE OR"),
        UPSERT("UPSERT INTO"),
        ON_DUPLICATE("ON DUPLICATE KEY UPDATE"),
        ON_CONFLICT("ON CONFLICT");

        private String value;

        private InsertKeyword(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static InsertKeyword fromValue(String v) {
            InsertKeyword[] insertKeywordArray = InsertKeyword.values();
            int n = insertKeywordArray.length;
            int n2 = 0;
            while (n2 < n) {
                InsertKeyword s = insertKeywordArray[n2];
                if (s.value.equals(v)) {
                    return s;
                }
                ++n2;
            }
            return INSERT;
        }
    }
}

