/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.Theme;
import org.eclipse.ui.themes.ITheme;

public final class ThemeElementHelper {
    public static void populateDefinition(org.eclipse.e4.ui.css.swt.theme.ITheme cssTheme, ITheme theme, FontRegistry registry, FontDefinition definition, IPreferenceStore store) {
        String key = ThemeElementHelper.createPreferenceKey(cssTheme, theme, definition.getId());
        String value = store.getString(key);
        if (!"".equals(value)) {
            definition.appendState(1);
            definition.appendState(4);
            registry.put(definition.getId(), PreferenceConverter.basicGetFontData((String)value));
        }
    }

    public static void populateRegistry(ITheme theme, FontDefinition[] definitions, IPreferenceStore store) {
        FontDefinition[] copyOfDefinitions = null;
        FontDefinition[] defaults = null;
        if (!theme.getId().equals("org.eclipse.ui.defaultTheme")) {
            definitions = ThemeElementHelper.addDefaulted(definitions);
            if (store != null) {
                defaults = ThemeElementHelper.getDefaults(definitions);
            }
        }
        copyOfDefinitions = new FontDefinition[definitions.length];
        System.arraycopy(definitions, 0, copyOfDefinitions, 0, definitions.length);
        Arrays.sort(copyOfDefinitions, new IThemeRegistry.HierarchyComparator(definitions));
        FontDefinition[] fontDefinitionArray = copyOfDefinitions;
        int n = copyOfDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            FontDefinition definition = fontDefinitionArray[n2];
            ThemeElementHelper.installFont(definition, theme, store, true);
            ++n2;
        }
        if (defaults != null) {
            fontDefinitionArray = defaults;
            n = defaults.length;
            n2 = 0;
            while (n2 < n) {
                FontDefinition fontDef = fontDefinitionArray[n2];
                ThemeElementHelper.installFont(fontDef, theme, store, false);
                ++n2;
            }
        }
    }

    private static FontDefinition[] addDefaulted(FontDefinition[] definitions) {
        IThemeRegistry registry = WorkbenchPlugin.getDefault().getThemeRegistry();
        IHierarchalThemeElementDefinition[] allDefs = registry.getFonts();
        SortedSet set = ThemeElementHelper.addDefaulted(definitions, allDefs);
        return set.toArray(new FontDefinition[set.size()]);
    }

    private static void installFont(FontDefinition definition, ITheme theme, IPreferenceStore store, boolean setInRegistry) {
        FontData[] fontData;
        FontRegistry registry = theme.getFontRegistry();
        Display display = PlatformUI.getWorkbench().getDisplay();
        String id = definition.getId();
        String key = ThemeElementHelper.createPreferenceKey(theme, id);
        FontData[] prefFont = store != null ? PreferenceConverter.getFontDataArray((IPreferenceStore)store, (String)key) : null;
        FontData[] defaultFont = null;
        if (definition.getValue() != null) {
            defaultFont = definition.getValue();
        } else if (definition.getDefaultsTo() != null) {
            String defaultsToKey = ThemeElementHelper.createPreferenceKey(theme, definition.getDefaultsTo());
            FontData[] defaultFontData = PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)store, (String)defaultsToKey);
            defaultFont = registry.filterData(defaultFontData, display);
        } else {
            fontData = JFaceResources.getFontRegistry().getFontData(display.getHighContrast() ? "org.eclipse.jface.defaultfont" : id);
            defaultFont = registry.bestDataArray(fontData, display);
        }
        if (setInRegistry) {
            if (prefFont == null || prefFont == PreferenceConverter.getFontDataArrayDefaultDefault()) {
                if (definition.getValue() != null) {
                    prefFont = definition.getValue();
                } else if (definition.getDefaultsTo() != null) {
                    fontData = registry.getFontData(definition.getDefaultsTo());
                    prefFont = registry.filterData(fontData, display);
                } else {
                    prefFont = defaultFont;
                }
            }
            if (!definition.isEditable()) {
                prefFont = defaultFont;
            }
            if (prefFont != null) {
                registry.put(id, prefFont);
            }
        }
        if (defaultFont != null && store != null) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (FontData[])defaultFont);
        }
    }

    public static void populateDefinition(org.eclipse.e4.ui.css.swt.theme.ITheme cssTheme, ITheme theme, ColorRegistry registry, ColorDefinition definition, IPreferenceStore store) {
        String key = ThemeElementHelper.createPreferenceKey(cssTheme, theme, definition.getId());
        String value = store.getString(key);
        if (!"".equals(value)) {
            definition.appendState(1);
            definition.appendState(4);
            registry.put(definition.getId(), StringConverter.asRGB((String)value));
        }
    }

    public static void populateRegistry(ITheme theme, ColorDefinition[] definitions, IPreferenceStore store) {
        ColorDefinition[] copyOfDefinitions = null;
        ColorDefinition[] defaults = null;
        if (!theme.getId().equals("org.eclipse.ui.defaultTheme")) {
            definitions = ThemeElementHelper.addDefaulted(definitions);
            if (store != null) {
                defaults = ThemeElementHelper.getDefaults(definitions);
            }
        }
        copyOfDefinitions = new ColorDefinition[definitions.length];
        System.arraycopy(definitions, 0, copyOfDefinitions, 0, definitions.length);
        Arrays.sort(copyOfDefinitions, new IThemeRegistry.HierarchyComparator(definitions));
        ColorDefinition[] colorDefinitionArray = copyOfDefinitions;
        int n = copyOfDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            ColorDefinition definition = colorDefinitionArray[n2];
            ThemeElementHelper.installColor(definition, theme, store, true);
            ++n2;
        }
        if (defaults != null) {
            colorDefinitionArray = defaults;
            n = defaults.length;
            n2 = 0;
            while (n2 < n) {
                ColorDefinition colorDef = colorDefinitionArray[n2];
                ThemeElementHelper.installColor(colorDef, theme, store, false);
                ++n2;
            }
        }
    }

    private static ColorDefinition[] getDefaults(ColorDefinition[] definitions) {
        IThemeRegistry registry = WorkbenchPlugin.getDefault().getThemeRegistry();
        ColorDefinition[] allDefs = registry.getColors();
        TreeSet<Object> set = new TreeSet<Object>(IThemeRegistry.ID_COMPARATOR);
        set.addAll(Arrays.asList(allDefs));
        set.removeAll(Arrays.asList(definitions));
        return set.toArray(new ColorDefinition[set.size()]);
    }

    private static FontDefinition[] getDefaults(FontDefinition[] definitions) {
        IThemeRegistry registry = WorkbenchPlugin.getDefault().getThemeRegistry();
        FontDefinition[] allDefs = registry.getFonts();
        TreeSet<Object> set = new TreeSet<Object>(IThemeRegistry.ID_COMPARATOR);
        set.addAll(Arrays.asList(allDefs));
        set.removeAll(Arrays.asList(definitions));
        return set.toArray(new FontDefinition[set.size()]);
    }

    private static ColorDefinition[] addDefaulted(ColorDefinition[] definitions) {
        IThemeRegistry registry = WorkbenchPlugin.getDefault().getThemeRegistry();
        IHierarchalThemeElementDefinition[] allDefs = registry.getColors();
        SortedSet set = ThemeElementHelper.addDefaulted(definitions, allDefs);
        return set.toArray(new ColorDefinition[set.size()]);
    }

    private static SortedSet addDefaulted(IHierarchalThemeElementDefinition[] definitions, IHierarchalThemeElementDefinition[] allDefs) {
        TreeSet<Object> set = new TreeSet<Object>(IThemeRegistry.ID_COMPARATOR);
        set.addAll(Arrays.asList(definitions));
        IHierarchalThemeElementDefinition[] copy = new IHierarchalThemeElementDefinition[allDefs.length];
        System.arraycopy(allDefs, 0, copy, 0, allDefs.length);
        Arrays.sort(allDefs, new IThemeRegistry.HierarchyComparator(copy));
        IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray = allDefs;
        int n = allDefs.length;
        int n2 = 0;
        while (n2 < n) {
            IHierarchalThemeElementDefinition def = iHierarchalThemeElementDefinitionArray[n2];
            if (def.getDefaultsTo() != null && set.contains(def.getDefaultsTo())) {
                set.add(def);
            }
            ++n2;
        }
        return set;
    }

    private static void installColor(ColorDefinition definition, ITheme theme, IPreferenceStore store, boolean setInRegistry) {
        RGB defaultColor;
        RGB prefColor;
        ColorRegistry registry = theme.getColorRegistry();
        String id = definition.getId();
        String key = ThemeElementHelper.createPreferenceKey(theme, id);
        RGB rGB = prefColor = store != null ? PreferenceConverter.getColor((IPreferenceStore)store, (String)key) : null;
        if (definition.getValue() != null) {
            defaultColor = definition.getValue();
        } else if (definition.getDefaultsTo() != null) {
            String defaultsToKey = ThemeElementHelper.createPreferenceKey(theme, definition.getDefaultsTo());
            defaultColor = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)defaultsToKey);
        } else {
            defaultColor = null;
        }
        if (defaultColor == null) {
            defaultColor = PreferenceConverter.COLOR_DEFAULT_DEFAULT;
        }
        if (prefColor == null || prefColor == PreferenceConverter.COLOR_DEFAULT_DEFAULT) {
            if (definition.getValue() != null) {
                prefColor = definition.getValue();
            } else if (definition.getDefaultsTo() != null) {
                prefColor = registry.getRGB(definition.getDefaultsTo());
            }
        }
        if (prefColor == null || !definition.isEditable()) {
            prefColor = defaultColor;
        }
        if (setInRegistry) {
            registry.put(id, prefColor);
        }
        if (store != null) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)defaultColor);
        }
    }

    public static String createPreferenceKey(ITheme theme, String id) {
        String themeId = theme.getId();
        if (themeId.equals("org.eclipse.ui.defaultTheme")) {
            return id;
        }
        return String.valueOf(themeId) + '.' + id;
    }

    public static String createPreferenceKey(org.eclipse.e4.ui.css.swt.theme.ITheme cssTheme, ITheme theme, String id) {
        String cssThemePrefix = cssTheme != null ? String.valueOf(cssTheme.getId()) + '.' : "";
        return String.valueOf(cssThemePrefix) + ThemeElementHelper.createPreferenceKey(theme, id);
    }

    public static String[] splitPropertyName(Theme theme, String property) {
        IThemeDescriptor[] descriptors;
        IThemeDescriptor[] iThemeDescriptorArray = descriptors = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IThemeDescriptor themeDescriptor = iThemeDescriptorArray[n2];
            String id = themeDescriptor.getId();
            if (property.startsWith(String.valueOf(id) + '.')) {
                return new String[]{property.substring(0, id.length()), property.substring(id.length() + 1)};
            }
            ++n2;
        }
        return new String[]{"org.eclipse.ui.defaultTheme", property};
    }

    private ThemeElementHelper() {
    }
}

