/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.MySQLDataSourceProvider;
import org.jkiss.dbeaver.ext.mysql.MySQLServerHome;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.tasks.nativetool.AbstractScriptExecuteSettings;
import org.jkiss.utils.CommonUtils;

public class MySQLScriptExecuteSettings
extends AbstractScriptExecuteSettings<MySQLCatalog> {
    private LogLevel logLevel = LogLevel.Normal;
    private boolean noBeep = true;
    private boolean isImport;

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isNoBeep() {
        return this.noBeep;
    }

    public void setNoBeep(boolean noBeep) {
        this.noBeep = noBeep;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public void setImport(boolean anImport) {
        this.isImport = anImport;
    }

    public boolean isVerbose() {
        return this.logLevel == LogLevel.Verbose || this.logLevel == LogLevel.Debug;
    }

    public MySQLServerHome findNativeClientHome(String clientHomeId) {
        return MySQLDataSourceProvider.getServerHome(clientHomeId);
    }

    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) throws DBException {
        super.loadSettings(runnableContext, preferenceStore);
        this.isImport = CommonUtils.getBoolean((String)preferenceStore.getString("MySQL.script.import"), (boolean)this.isImport);
        this.logLevel = (LogLevel)CommonUtils.valueOf(LogLevel.class, (String)preferenceStore.getString("MySQL.script.logLevel"), (Enum)LogLevel.Normal);
        this.noBeep = CommonUtils.toBoolean((Object)preferenceStore.getString("MySQL.script.noBeep"));
    }

    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) {
        super.saveSettings(runnableContext, preferenceStore);
        preferenceStore.setValue("MySQL.script.import", this.isImport);
        preferenceStore.setValue("MySQL.script.logLevel", this.logLevel.name());
        preferenceStore.setValue("MySQL.script.noBeep", this.noBeep);
    }

    public static enum LogLevel {
        Normal,
        Verbose,
        Debug;

    }
}

