/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.app;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.app.DB2ServerApplication;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;

public class DB2ServerApplicationManager
implements DBAServerSessionManager<DB2ServerApplication> {
    private static final String FORCE_APP_CMD = "FORCE APPLICATION (%d)";
    private final DB2DataSource dataSource;

    public DB2ServerApplicationManager(DB2DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public Collection<DB2ServerApplication> getSessions(DBCSession session, Map<String, Object> options) throws DBException {
        try {
            return DB2Utils.readApplications(session.getProgressMonitor(), (JDBCSession)session);
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(DBCSession session, DB2ServerApplication sessionType, Map<String, Object> options) throws DBException {
        try {
            String cmd = String.format(FORCE_APP_CMD, sessionType.getAgentId());
            DB2Utils.callAdminCmd(session.getProgressMonitor(), this.dataSource, cmd);
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }
}

