/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.network;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.utils.CommonUtils;

public class NetworkHandlerDescriptor
extends AbstractContextDescriptor
implements DBWHandlerDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.networkHandler";
    private final String id;
    private final String label;
    private final String codeName;
    private final String description;
    private DBWHandlerType type;
    private final boolean secured;
    private final AbstractDescriptor.ObjectType handlerType;
    private final int order;
    private final List<String> replacesIDs = new ArrayList<String>();
    private NetworkHandlerDescriptor replacedBy;

    NetworkHandlerDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.codeName = config.getAttribute("codeName") == null ? this.id : config.getAttribute("codeName");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.type = DBWHandlerType.valueOf((String)config.getAttribute("type").toUpperCase(Locale.ENGLISH));
        this.secured = CommonUtils.getBoolean((String)config.getAttribute("secured"), (boolean)false);
        this.handlerType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("handlerClass"));
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"), (int)1);
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("replace");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement re = iConfigurationElementArray[n2];
            this.replacesIDs.add(re.getAttribute("id"));
            ++n2;
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getCodeName() {
        return this.codeName;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBWHandlerType getType() {
        return this.type;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean matches(DBPDataSourceContainer dataSource) {
        return this.appliesTo((DBPObject)dataSource.getDriver().getDataSourceProvider(), dataSource);
    }

    public AbstractDescriptor.ObjectType getHandlerType() {
        return this.handlerType;
    }

    public <T extends DBWNetworkHandler> T createHandler(Class<T> impl) throws DBException {
        return (T)((DBWNetworkHandler)this.handlerType.createInstance(impl));
    }

    public boolean replaces(NetworkHandlerDescriptor otherDesc) {
        return this.replacesIDs.contains(otherDesc.id);
    }

    public String toString() {
        return this.id;
    }

    NetworkHandlerDescriptor getReplacedBy() {
        return this.replacedBy;
    }

    void setReplacedBy(NetworkHandlerDescriptor replacedBy) {
        this.replacedBy = replacedBy;
    }
}

