/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditor;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.VariablesHintLabel;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public abstract class ConnectionPageAbstract
extends DialogPage
implements IDataSourceConnectionEditor {
    protected IDataSourceConnectionEditorSite site;
    protected Text driverText;
    protected Text passwordText;
    protected Button savePasswordCheck;
    protected ToolBar userManagementToolbar;
    private VariablesHintLabel variablesHintLabel;
    private ImageDescriptor curImageDescriptor;

    public IDataSourceConnectionEditorSite getSite() {
        return this.site;
    }

    public void dispose() {
        super.dispose();
    }

    public void setSite(IDataSourceConnectionEditorSite site) {
        this.site = site;
    }

    protected boolean isCustomURL() {
        return false;
    }

    public void loadSettings() {
        DBPDriver driver = this.site.getDriver();
        if (driver != null && this.driverText != null) {
            this.driverText.setText(CommonUtils.toString((Object)driver.getFullName()));
        }
        DataSourceDescriptor dataSource = (DataSourceDescriptor)this.getSite().getActiveDataSource();
        if (this.savePasswordCheck != null) {
            if (dataSource != null) {
                this.savePasswordCheck.setSelection(dataSource.isSavePassword());
            } else {
                this.savePasswordCheck.setSelection(true);
            }
        }
        if (this.variablesHintLabel != null) {
            if (dataSource != null) {
                this.variablesHintLabel.setResolver((IVariableResolver)new DataSourceVariableResolver((DBPDataSourceContainer)dataSource, dataSource.getConnectionConfiguration()));
            } else {
                this.variablesHintLabel.setResolver(null);
            }
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        this.saveConnectionURL(dataSource.getConnectionConfiguration());
        if (this.savePasswordCheck != null) {
            DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
            descriptor.setSavePassword(this.savePasswordCheck.getSelection());
            if (!descriptor.isSavePassword()) {
                descriptor.resetPassword();
            }
        }
    }

    protected void saveConnectionURL(DBPConnectionConfiguration connectionInfo) {
        if (!this.isCustomURL()) {
            connectionInfo.setUrl(this.site.getDriver().getDataSourceProvider().getConnectionURL(this.site.getDriver(), connectionInfo));
        }
    }

    protected void createDriverPanel(Composite parent) {
        Composite panel = UIUtils.createComposite((Composite)parent, (int)4);
        GridData gd = new GridData(776);
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        panel.setLayoutData((Object)gd);
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("database.connect.processEnvVars")) {
            this.variablesHintLabel = new VariablesHintLabel(panel, UIConnectionMessages.dialog_connection_edit_connection_settings_variables_hint_label, UIConnectionMessages.dialog_connection_edit_connection_settings_variables_hint_label, DataSourceDescriptor.CONNECT_VARIABLES, false);
            ((GridData)this.variablesHintLabel.getInfoLabel().getLayoutData()).horizontalSpan = this.site.isNew() ? 3 : 4;
        } else {
            UIUtils.createEmptyLabel((Composite)panel, (int)3, (int)1);
        }
        if (this.site.isNew()) {
            Button advSettingsButton = UIUtils.createDialogButton((Composite)panel, (String)UIConnectionMessages.dialog_connection_edit_wizard_conn_conf_general_link, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageAbstract.this.site.openSettingsPage("ConnectionPageGeneral");
                }
            });
            advSettingsButton.setLayoutData((Object)new GridData(128));
        }
        Label divLabel = new Label(panel, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        divLabel.setLayoutData((Object)gd);
        Label driverLabel = new Label(panel, 0);
        driverLabel.setText(UIConnectionMessages.dialog_connection_driver);
        driverLabel.setLayoutData((Object)new GridData(32));
        this.driverText = new Text(panel, 8);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.driverText.setLayoutData((Object)gd);
        Button driverButton = UIUtils.createDialogButton((Composite)panel, (String)UIConnectionMessages.dialog_connection_edit_driver_button, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionPageAbstract.this.site.openDriverEditor()) {
                    ConnectionPageAbstract.this.updateDriverInfo(ConnectionPageAbstract.this.site.getDriver());
                }
            }
        });
        driverButton.setLayoutData((Object)new GridData(128));
    }

    protected void updateDriverInfo(DBPDriver driver) {
    }

    public void setImageDescriptor(ImageDescriptor desc) {
        if (this.curImageDescriptor != desc) {
            super.setImageDescriptor(desc);
            this.curImageDescriptor = desc;
        }
    }

    protected Text createPasswordText(Composite parent, String label) {
        if (label != null) {
            UIUtils.createControlLabel((Composite)parent, (String)label);
        }
        Composite ph = UIUtils.createPlaceholder((Composite)parent, (int)1);
        ph.setLayoutData((Object)new GridData(768));
        this.passwordText = new Text(ph, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(768));
        return this.passwordText;
    }

    protected void createPasswordControls(Composite parent) {
        this.createPasswordControls(parent, 1);
    }

    protected void createPasswordControls(Composite parent, int hSpan) {
        final UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
        boolean supportsPasswordView = serviceSecurity != null;
        Composite panel = UIUtils.createComposite((Composite)parent, (int)(supportsPasswordView ? 2 : 1));
        GridData gd = new GridData(32);
        if (hSpan > 1) {
            gd.horizontalSpan = hSpan;
        }
        panel.setLayoutData((Object)gd);
        DataSourceDescriptor dataSource = (DataSourceDescriptor)this.getSite().getActiveDataSource();
        this.savePasswordCheck = UIUtils.createCheckbox((Composite)panel, (String)UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password_locally, (dataSource == null || dataSource.isSavePassword() ? 1 : 0) != 0);
        this.savePasswordCheck.setToolTipText(UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password_locally);
        if (supportsPasswordView) {
            this.userManagementToolbar = new ToolBar(panel, 256);
            ToolItem showPasswordLabel = new ToolItem(this.userManagementToolbar, 0);
            showPasswordLabel.setToolTipText("Show password on screen");
            showPasswordLabel.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SHOW_ALL_DETAILS));
            showPasswordLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageAbstract.this.showPasswordText(serviceSecurity);
                }
            });
        }
    }

    private void showPasswordText(UIServiceSecurity serviceSecurity) {
        boolean passHidden;
        Composite passContainer = this.passwordText.getParent();
        boolean bl = passHidden = (this.passwordText.getStyle() & 0x400000) == 0x400000;
        if (passHidden && !serviceSecurity.validatePassword(this.site.getProject().getSecureStorage(), "Enter project password", "Enter project master password to unlock connection password view", true)) {
            return;
        }
        Object layoutData = this.passwordText.getLayoutData();
        String curValue = this.passwordText.getText();
        this.passwordText.dispose();
        this.passwordText = passHidden ? new Text(passContainer, 2048) : new Text(passContainer, 0x400800);
        this.passwordText.setLayoutData(layoutData);
        this.passwordText.setText(curValue);
        passContainer.layout(true, true);
    }
}

