/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataSourcePermissionOwner;
import org.jkiss.dbeaver.model.access.DBAAuthProfile;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.connection.DBPConfigurationProfile;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.registry.DataSourceOriginLazy;
import org.jkiss.dbeaver.registry.DataSourceOriginLocal;
import org.jkiss.dbeaver.registry.DataSourcePreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.DataSourceSerializer;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.registry.FilterMapping;
import org.jkiss.dbeaver.registry.SecureCredentials;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.encode.ContentEncrypter;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

class DataSourceSerializerModern
implements DataSourceSerializer {
    static final String ATTR_NAVIGATOR_SHOW_SYSTEM_OBJECTS = "show-system-objects";
    static final String ATTR_NAVIGATOR_SHOW_UTIL_OBJECTS = "show-util-objects";
    static final String ATTR_NAVIGATOR_SHOW_ONLY_ENTITIES = "navigator-show-only-entities";
    static final String ATTR_NAVIGATOR_HIDE_FOLDERS = "navigator-hide-folders";
    static final String ATTR_NAVIGATOR_HIDE_SCHEMAS = "navigator-hide-schemas";
    static final String ATTR_NAVIGATOR_HIDE_VIRTUAL = "navigator-hide-virtual";
    static final String ATTR_NAVIGATOR_MERGE_ENTITIES = "navigator-merge-entities";
    public static final String TAG_ORIGIN = "origin";
    private static final String ATTR_ORIGIN_ID = "_id";
    private static final Log log = Log.getLog(DataSourceSerializerModern.class);
    private static final String NODE_CONNECTION = "#connection";
    private static Gson CONFIG_GSON = new GsonBuilder().setLenient().serializeNulls().setPrettyPrinting().create();
    private static Gson SECURE_GSON = new GsonBuilder().setLenient().serializeNulls().create();
    private boolean passwordReadCanceled = false;
    private boolean passwordWriteCanceled = false;
    private final DataSourceRegistry registry;
    private Map<String, Map<String, Map<String, String>>> secureProperties = new LinkedHashMap<String, Map<String, Map<String, String>>>();

    DataSourceSerializerModern(DataSourceRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void saveDataSources(DBRProgressMonitor monitor, DBPDataSourceConfigurationStorage configurationStorage, List<DataSourceDescriptor> localDataSources, File configFile) throws DBException {
        ByteArrayOutputStream dsConfigBuffer = new ByteArrayOutputStream(10000);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)dsConfigBuffer, StandardCharsets.UTF_8);){
                Throwable throwable2 = null;
                Object var10_15 = null;
                try (JsonWriter jsonWriter = CONFIG_GSON.newJsonWriter((Writer)osw);){
                    jsonWriter.setIndent("\t");
                    jsonWriter.beginObject();
                    if (configurationStorage.isDefault()) {
                        jsonWriter.name("folders");
                        jsonWriter.beginObject();
                        for (DataSourceFolder folder : this.registry.getAllFolders()) {
                            DataSourceSerializerModern.saveFolder(jsonWriter, folder);
                        }
                        jsonWriter.endObject();
                    }
                    LinkedHashMap<String, DBVModel> virtualModels = new LinkedHashMap<String, DBVModel>();
                    LinkedHashMap<String, DBPConnectionType> connectionTypes = new LinkedHashMap<String, DBPConnectionType>();
                    LinkedHashMap<String, Map> drivers = new LinkedHashMap<String, Map>();
                    jsonWriter.name("connections");
                    jsonWriter.beginObject();
                    for (DataSourceDescriptor dataSource : localDataSources) {
                        if (dataSource.isDetached()) continue;
                        this.saveDataSource(jsonWriter, dataSource);
                        if (dataSource.getVirtualModel().hasValuableData()) {
                            virtualModels.put(dataSource.getVirtualModel().getId(), dataSource.getVirtualModel());
                        }
                        DBPConnectionType connectionType = dataSource.getConnectionConfiguration().getConnectionType();
                        connectionTypes.put(connectionType.getId(), connectionType);
                        DBPDriver dBPDriver = dataSource.getDriver();
                        if (!dBPDriver.isCustom() || dBPDriver.getProviderDescriptor().isTemporary()) continue;
                        Map driverMap = drivers.computeIfAbsent(dBPDriver.getProviderId(), s -> new LinkedHashMap());
                        driverMap.put(dBPDriver.getId(), dBPDriver);
                    }
                    jsonWriter.endObject();
                    if (configurationStorage.isDefault()) {
                        List<DBSObjectFilter> savedFilters;
                        List<DBAAuthProfile> authProfiles;
                        List<DBWNetworkProfile> profiles;
                        if (!virtualModels.isEmpty()) {
                            jsonWriter.name("virtual-models");
                            jsonWriter.beginObject();
                            for (DBVModel model : virtualModels.values()) {
                                model.serialize(monitor, jsonWriter);
                            }
                            jsonWriter.endObject();
                        }
                        if (!CommonUtils.isEmpty(profiles = this.registry.getNetworkProfiles())) {
                            jsonWriter.name("network-profiles");
                            jsonWriter.beginObject();
                            for (DBWNetworkProfile np : profiles) {
                                jsonWriter.name(np.getProfileId());
                                jsonWriter.beginObject();
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"name", (String)np.getProfileName());
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"description", (String)np.getProfileDescription());
                                jsonWriter.name("handlers");
                                jsonWriter.beginObject();
                                for (DBWHandlerConfiguration dBWHandlerConfiguration : np.getConfigurations()) {
                                    if (!dBWHandlerConfiguration.hasValuableInfo()) continue;
                                    this.saveNetworkHandlerConfiguration(jsonWriter, null, np, dBWHandlerConfiguration);
                                }
                                jsonWriter.endObject();
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        if (!CommonUtils.isEmpty(authProfiles = this.registry.getAllAuthProfiles())) {
                            jsonWriter.name("auth-profiles");
                            jsonWriter.beginObject();
                            for (DBAAuthProfile authProfile : authProfiles) {
                                jsonWriter.name(authProfile.getProfileId());
                                jsonWriter.beginObject();
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"name", (String)authProfile.getProfileName());
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"description", (String)authProfile.getProfileDescription());
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"auth-model", (String)authProfile.getAuthModelId());
                                if (authProfile.isSavePassword()) {
                                    JSONUtils.field((JsonWriter)jsonWriter, (String)"save-password", (boolean)authProfile.isSavePassword());
                                }
                                this.saveSecuredCredentials(null, (DBPConfigurationProfile)authProfile, null, new SecureCredentials(authProfile));
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        if (!CommonUtils.isEmpty(savedFilters = this.registry.getSavedFilters())) {
                            jsonWriter.name("saved-filters");
                            jsonWriter.beginArray();
                            for (DBSObjectFilter dBSObjectFilter : savedFilters) {
                                if (dBSObjectFilter.isEmpty()) continue;
                                DataSourceSerializerModern.saveObjectFiler(jsonWriter, null, null, dBSObjectFilter);
                            }
                            jsonWriter.endArray();
                        }
                        if (!CommonUtils.isEmpty(connectionTypes)) {
                            jsonWriter.name("connection-types");
                            jsonWriter.beginObject();
                            for (DBPConnectionType dBPConnectionType : connectionTypes.values()) {
                                jsonWriter.name(dBPConnectionType.getId());
                                jsonWriter.beginObject();
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"name", (String)dBPConnectionType.getName());
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"color", (String)dBPConnectionType.getColor());
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"description", (String)dBPConnectionType.getDescription());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"auto-commit", (boolean)dBPConnectionType.isAutocommit());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"confirm-execute", (boolean)dBPConnectionType.isConfirmExecute());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"confirm-data-change", (boolean)dBPConnectionType.isConfirmDataChange());
                                this.serializeModifyPermissions(jsonWriter, (DBPDataSourcePermissionOwner)dBPConnectionType);
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        if (!CommonUtils.isEmpty(drivers)) {
                            jsonWriter.name("drivers");
                            jsonWriter.beginObject();
                            for (Map.Entry entry : drivers.entrySet()) {
                                jsonWriter.name((String)entry.getKey());
                                jsonWriter.beginObject();
                                for (DBPDriver driver : ((Map)entry.getValue()).values()) {
                                    ((DriverDescriptor)driver).serialize(jsonWriter, true);
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                    }
                    jsonWriter.endObject();
                    jsonWriter.flush();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"IO error while saving datasources json", (Throwable)e);
        }
        String jsonString = new String(dsConfigBuffer.toByteArray(), StandardCharsets.UTF_8);
        boolean encryptProject = CommonUtils.toBoolean((Object)this.registry.getProject().getProjectProperty("secureProject"));
        this.saveConfigFile(configFile, jsonString, false, encryptProject);
        this.saveSecureCredentialsFile(monitor.getNestedMonitor(), configFile.getParentFile(), configurationStorage);
    }

    private String loadConfigFile(File file, boolean decrypt) throws IOException {
        ByteArrayOutputStream credBuffer = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream crdStream = new FileInputStream(file);){
                IOUtils.copyStream((InputStream)crdStream, (OutputStream)credBuffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading secure credentials file", (Throwable)e);
        }
        if (!decrypt) {
            return new String(credBuffer.toByteArray(), StandardCharsets.UTF_8);
        }
        ContentEncrypter encrypter = new ContentEncrypter(this.registry.getProject().getSecureStorage().getLocalSecretKey());
        try {
            return encrypter.decrypt(credBuffer.toByteArray());
        }
        catch (Exception e) {
            throw new IOException("Error decrypting encrypted file", e);
        }
    }

    private void saveConfigFile(File configFile, String contents, boolean teamPrivate, boolean encrypt) {
        try {
            byte[] binaryContents;
            if (encrypt) {
                ContentEncrypter encrypter = new ContentEncrypter(this.registry.getProject().getSecureStorage().getLocalSecretKey());
                binaryContents = encrypter.encrypt(contents);
            } else {
                binaryContents = contents.getBytes(StandardCharsets.UTF_8);
            }
            IOUtils.writeFileFromBuffer((File)configFile, (byte[])binaryContents);
        }
        catch (Exception e) {
            log.error((Object)("Error saving configuration file " + configFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private void saveSecureCredentialsFile(IProgressMonitor monitor, File parent, DBPDataSourceConfigurationStorage storage) {
        File credFile = new File(parent, "credentials-config" + storage.getConfigurationFileSuffix() + ".json");
        try {
            ContentUtils.makeFileBackup((File)credFile);
            if (this.secureProperties.isEmpty()) {
                if (credFile.exists() && !credFile.delete()) {
                    log.debug((Object)("Error deleting file " + credFile.getAbsolutePath()));
                }
            } else {
                String jsonString = SECURE_GSON.toJson(this.secureProperties, Map.class);
                this.saveConfigFile(credFile, jsonString, true, true);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error saving secure credentials", (Throwable)e);
        }
    }

    @Override
    public void parseDataSources(File configFile, DBPDataSourceConfigurationStorage configurationStorage, boolean refresh, DataSourceRegistry.ParseResults parseResults) throws IOException {
        DBWNetworkProfile profile;
        Map profileMap;
        String profileId;
        File credFile;
        File mdFolder = this.registry.getProject().getMetadataFolder(false);
        if (mdFolder.exists() && (credFile = new File(mdFolder, "credentials-config" + configurationStorage.getConfigurationFileSuffix() + ".json")).exists()) {
            try {
                String credJson = this.loadConfigFile(credFile, true);
                Map res = (Map)CONFIG_GSON.fromJson(credJson, new TypeToken<Map<String, Map<String, Map<String, String>>>>(){}.getType());
                this.secureProperties.putAll(res);
            }
            catch (Exception e) {
                log.error((Object)"Error decrypting secure credentials", (Throwable)e);
            }
        }
        boolean decryptProject = CommonUtils.toBoolean((Object)this.registry.getProject().getProjectProperty("secureProject"));
        String configJson = this.loadConfigFile(configFile, decryptProject);
        Map jsonMap = JSONUtils.parseMap((Gson)CONFIG_GSON, (Reader)new StringReader(configJson));
        for (Map.Entry folderMap : JSONUtils.getNestedObjects((Map)jsonMap, (String)"folders")) {
            DataSourceFolder folder;
            String name = (String)folderMap.getKey();
            String description = (String)JSONUtils.getObjectProperty(folderMap.getValue(), (String)"description");
            String parentFolder = (String)JSONUtils.getObjectProperty(folderMap.getValue(), (String)"parent");
            DataSourceFolder parent = parentFolder == null ? null : this.registry.findFolderByPath(parentFolder, true);
            DataSourceFolder dataSourceFolder = folder = parent == null ? this.registry.findFolderByPath(name, true) : parent.getChild(name);
            if (folder == null) {
                folder = new DataSourceFolder(this.registry, parent, name, description);
                this.registry.addDataSourceFolder(folder);
                continue;
            }
            folder.setDescription(description);
        }
        for (Map.Entry ctMap : JSONUtils.getNestedObjects((Map)jsonMap, (String)"connection-types")) {
            String id = (String)ctMap.getKey();
            Map ctConfig = (Map)ctMap.getValue();
            String name = (String)JSONUtils.getObjectProperty((Object)ctConfig, (String)"name");
            String description = (String)JSONUtils.getObjectProperty((Object)ctConfig, (String)"description");
            String color = (String)JSONUtils.getObjectProperty((Object)ctConfig, (String)"color");
            Boolean autoCommit = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"auto-commit");
            Boolean confirmExecute = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"confirm-execute");
            Boolean confirmDataChange = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"confirm-data-change");
            DBPConnectionType ct = DBWorkbench.getPlatform().getDataSourceProviderRegistry().getConnectionType(id, null);
            if (ct == null) {
                ct = new DBPConnectionType(id, name, color, description, CommonUtils.toBoolean((Object)autoCommit), CommonUtils.toBoolean((Object)confirmExecute), CommonUtils.toBoolean((Object)confirmDataChange));
                DBWorkbench.getPlatform().getDataSourceProviderRegistry().addConnectionType(ct);
            }
            this.deserializeModifyPermissions(ctConfig, (DBPDataSourcePermissionOwner)ct);
        }
        LinkedHashMap<String, DBVModel> modelMap = new LinkedHashMap<String, DBVModel>();
        for (Map.Entry vmMap : JSONUtils.getNestedObjects((Map)jsonMap, (String)"virtual-models")) {
            String id = (String)vmMap.getKey();
            DBVModel model = new DBVModel(id, (Map)vmMap.getValue());
            modelMap.put(id, model);
        }
        for (Map.Entry vmMap : JSONUtils.getNestedObjects((Map)jsonMap, (String)"network-profiles")) {
            profileId = (String)vmMap.getKey();
            profileMap = (Map)vmMap.getValue();
            profile = new DBWNetworkProfile();
            profile.setProfileName(profileId);
            profile.setProfileName(profileId);
            profile.setProperties(JSONUtils.deserializeStringMap((Map)profileMap, (String)"properties"));
            for (Map.Entry handlerMap : JSONUtils.getNestedObjects((Map)profileMap, (String)"handlers")) {
                DBWHandlerConfiguration configuration = this.parseNetworkHandlerConfig(null, profile, handlerMap);
                if (configuration == null) continue;
                profile.updateConfiguration(configuration);
            }
            this.registry.updateNetworkProfile(profile);
        }
        for (Map.Entry vmMap : JSONUtils.getNestedObjects((Map)jsonMap, (String)"auth-profiles")) {
            profileId = (String)vmMap.getKey();
            profileMap = (Map)vmMap.getValue();
            profile = new DBAAuthProfile();
            profile.setProfileId(profileId);
            profile.setProfileName(JSONUtils.getString((Map)profileMap, (String)"name"));
            profile.setAuthModelId(JSONUtils.getString((Map)profileMap, (String)"auth-model"));
            profile.setSavePassword(JSONUtils.getBoolean((Map)profileMap, (String)"save-password"));
            SecureCredentials authCreds = this.readSecuredCredentials(null, (DBPConfigurationProfile)profile, null);
            profile.setUserName(authCreds.getUserName());
            profile.setUserPassword(authCreds.getUserPassword());
            profile.setProperties(authCreds.getProperties());
            this.registry.updateAuthProfile((DBAAuthProfile)profile);
        }
        for (Map.Entry conMap : JSONUtils.getNestedObjects((Map)jsonMap, (String)"connections")) {
            int keepAlive;
            String userPassword;
            String userName;
            DataSourceDescriptor dataSource;
            boolean newDataSource;
            String driverId;
            DriverDescriptor driver;
            Map conObject = (Map)conMap.getValue();
            String id = (String)conMap.getKey();
            String dsProviderID = CommonUtils.toString(conObject.get("provider"));
            if (CommonUtils.isEmpty((String)dsProviderID)) {
                log.warn((Object)("Empty datasource provider for datasource '" + id + "'"));
                continue;
            }
            DataSourceProviderDescriptor provider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(dsProviderID);
            if (provider == null) {
                log.warn((Object)("Can't find datasource provider " + dsProviderID + " for datasource '" + id + "'"));
                provider = (DataSourceProviderDescriptor)DataSourceProviderRegistry.getInstance().makeFakeProvider(dsProviderID);
            }
            if ((driver = provider.getDriver(driverId = CommonUtils.toString(conObject.get("driver")))) == null) {
                log.warn((Object)("Can't find driver " + driverId + " in datasource provider " + provider.getId() + " for datasource '" + id + "'. Create new driver"));
                driver = provider.createDriver(driverId);
                driver.setName(driverId);
                driver.setDescription("Missing driver " + driverId);
                driver.setDriverClassName("java.sql.Driver");
                driver.setTemporary(true);
                provider.addDriver(driver);
            }
            boolean bl = newDataSource = (dataSource = this.registry.getDataSource(id)) == null;
            if (newDataSource) {
                DBPDataSourceOrigin origin;
                Map originProperties = JSONUtils.deserializeProperties((Map)conObject, (String)TAG_ORIGIN);
                if (CommonUtils.isEmpty((Map)originProperties) || !originProperties.containsKey(ATTR_ORIGIN_ID)) {
                    origin = DataSourceOriginLocal.INSTANCE;
                } else {
                    String originID = CommonUtils.toString(originProperties.remove(ATTR_ORIGIN_ID));
                    origin = new DataSourceOriginLazy(originID, originProperties);
                }
                dataSource = new DataSourceDescriptor(this.registry, configurationStorage, origin, id, driver, new DBPConnectionConfiguration());
            } else {
                dataSource.getConnectionConfiguration().setProperties(Collections.emptyMap());
                dataSource.getConnectionConfiguration().setHandlers(Collections.emptyList());
                dataSource.clearFilters();
            }
            dataSource.setName(JSONUtils.getString((Map)conObject, (String)"name"));
            dataSource.setDescription(JSONUtils.getString((Map)conObject, (String)"description"));
            dataSource.setSavePassword(JSONUtils.getBoolean((Map)conObject, (String)"save-password"));
            dataSource.setTemplate(JSONUtils.getBoolean((Map)conObject, (String)"template"));
            DataSourceNavigatorSettings navSettings = dataSource.getNavigatorSettings();
            navSettings.setShowSystemObjects(JSONUtils.getBoolean((Map)conObject, (String)ATTR_NAVIGATOR_SHOW_SYSTEM_OBJECTS));
            navSettings.setShowUtilityObjects(JSONUtils.getBoolean((Map)conObject, (String)ATTR_NAVIGATOR_SHOW_UTIL_OBJECTS));
            navSettings.setShowOnlyEntities(JSONUtils.getBoolean((Map)conObject, (String)ATTR_NAVIGATOR_SHOW_ONLY_ENTITIES));
            navSettings.setHideFolders(JSONUtils.getBoolean((Map)conObject, (String)ATTR_NAVIGATOR_HIDE_FOLDERS));
            navSettings.setHideSchemas(JSONUtils.getBoolean((Map)conObject, (String)ATTR_NAVIGATOR_HIDE_SCHEMAS));
            navSettings.setHideVirtualModel(JSONUtils.getBoolean((Map)conObject, (String)ATTR_NAVIGATOR_HIDE_VIRTUAL));
            navSettings.setMergeEntities(JSONUtils.getBoolean((Map)conObject, (String)ATTR_NAVIGATOR_MERGE_ENTITIES));
            dataSource.setConnectionReadOnly(JSONUtils.getBoolean((Map)conObject, (String)"read-only"));
            String folderPath = JSONUtils.getString((Map)conObject, (String)"folder");
            if (folderPath != null) {
                dataSource.setFolder(this.registry.findFolderByPath(folderPath, true));
            }
            dataSource.setLockPasswordHash(CommonUtils.toString(conObject.get("lockPassword")));
            Map cfgObject = JSONUtils.getObject((Map)conObject, (String)"configuration");
            DBPConnectionConfiguration config = dataSource.getConnectionConfiguration();
            config.setHostName(JSONUtils.getString((Map)cfgObject, (String)"host"));
            config.setHostPort(JSONUtils.getString((Map)cfgObject, (String)"port"));
            config.setServerName(JSONUtils.getString((Map)cfgObject, (String)"server"));
            config.setDatabaseName(JSONUtils.getString((Map)cfgObject, (String)"database"));
            config.setUrl(JSONUtils.getString((Map)cfgObject, (String)"url"));
            if (!this.passwordReadCanceled) {
                SecureCredentials creds = this.readSecuredCredentials(dataSource, null, null);
                config.setUserName(creds.getUserName());
                if (dataSource.isSavePassword()) {
                    config.setUserPassword(creds.getUserPassword());
                }
            }
            if (!CommonUtils.isEmpty((String)(userName = JSONUtils.getString((Map)cfgObject, (String)"user")))) {
                config.setUserName(userName);
            }
            if (!CommonUtils.isEmpty((String)(userPassword = JSONUtils.getString((Map)cfgObject, (String)"password")))) {
                config.setUserPassword(userPassword);
            }
            config.setClientHomeId(JSONUtils.getString((Map)cfgObject, (String)"home"));
            config.setConfigProfileName(JSONUtils.getString((Map)cfgObject, (String)"config-profile"));
            config.setConnectionType(DataSourceProviderRegistry.getInstance().getConnectionType(JSONUtils.getString((Map)cfgObject, (String)"type"), DBPConnectionType.DEFAULT_TYPE));
            String colorValue = JSONUtils.getString((Map)cfgObject, (String)"color");
            if (!CommonUtils.isEmpty((String)colorValue)) {
                config.setConnectionColor(colorValue);
            }
            if ((keepAlive = JSONUtils.getInteger((Map)cfgObject, (String)"keepAlive")) > 0) {
                config.setKeepAliveInterval(keepAlive);
            }
            config.setProperties(JSONUtils.deserializeStringMap((Map)cfgObject, (String)"properties"));
            config.setProviderProperties(JSONUtils.deserializeStringMap((Map)cfgObject, (String)"provider-properties"));
            config.setAuthModelId(JSONUtils.getString((Map)cfgObject, (String)"auth-model"));
            config.setAuthProperties(JSONUtils.deserializeStringMapOrNull((Map)cfgObject, (String)"auth-properties"));
            for (Map.Entry eventObject : JSONUtils.getNestedObjects((Map)cfgObject, (String)"events")) {
                DBPConnectionEventType eventType = (DBPConnectionEventType)CommonUtils.valueOf(DBPConnectionEventType.class, (String)((String)eventObject.getKey()), (Enum)DBPConnectionEventType.BEFORE_CONNECT);
                Map eventCfg = (Map)eventObject.getValue();
                DBRShellCommand command = new DBRShellCommand("");
                command.setEnabled(JSONUtils.getBoolean((Map)eventCfg, (String)"enabled"));
                command.setShowProcessPanel(JSONUtils.getBoolean((Map)eventCfg, (String)"show-panel"));
                command.setWaitProcessFinish(JSONUtils.getBoolean((Map)eventCfg, (String)"wait-process"));
                if (command.isWaitProcessFinish()) {
                    command.setWaitProcessTimeoutMs(JSONUtils.getInteger((Map)eventCfg, (String)"wait-process-timeout"));
                }
                command.setTerminateAtDisconnect(JSONUtils.getBoolean((Map)eventCfg, (String)"terminate-at-disconnect"));
                command.setPauseAfterExecute(JSONUtils.getInteger((Map)eventCfg, (String)"pauseAfterExecute"));
                command.setWorkingDirectory(JSONUtils.getString((Map)eventCfg, (String)"workingDirectory"));
                command.setCommand(JSONUtils.getString((Map)eventCfg, (String)"command"));
                config.setEvent(eventType, command);
            }
            for (Map.Entry handlerObject : JSONUtils.getNestedObjects((Map)cfgObject, (String)"handlers")) {
                DBWHandlerConfiguration configuration = this.parseNetworkHandlerConfig(dataSource, null, handlerObject);
                if (configuration == null) continue;
                dataSource.getConnectionConfiguration().updateHandler(configuration);
            }
            Map bootstrapCfg = JSONUtils.getObject((Map)cfgObject, (String)"bootstrap");
            DBPConnectionBootstrap bootstrap = config.getBootstrap();
            if (bootstrapCfg.containsKey("autocommit")) {
                bootstrap.setDefaultAutoCommit(Boolean.valueOf(JSONUtils.getBoolean((Map)bootstrapCfg, (String)"autocommit")));
            }
            if (bootstrapCfg.containsKey("txnIsolation")) {
                bootstrap.setDefaultTransactionIsolation(Integer.valueOf(JSONUtils.getInteger((Map)bootstrapCfg, (String)"txnIsolation")));
            }
            bootstrap.setDefaultCatalogName(JSONUtils.getString((Map)bootstrapCfg, (String)"defaultCatalog"));
            bootstrap.setDefaultSchemaName(JSONUtils.getString((Map)bootstrapCfg, (String)"defaultSchema"));
            String defObjectName = JSONUtils.getString((Map)bootstrapCfg, (String)"defaultObject");
            if (!CommonUtils.isEmpty((String)defObjectName) && CommonUtils.isEmpty((String)bootstrap.getDefaultSchemaName())) {
                bootstrap.setDefaultSchemaName(JSONUtils.getString((Map)bootstrapCfg, (String)defObjectName));
            }
            if (bootstrapCfg.containsKey("ignoreErrors")) {
                bootstrap.setIgnoreErrors(JSONUtils.getBoolean((Map)bootstrapCfg, (String)"ignoreErrors"));
            }
            bootstrap.setInitQueries((Collection)JSONUtils.deserializeStringList((Map)bootstrapCfg, (String)"query"));
            this.deserializeModifyPermissions(conObject, (DBPDataSourcePermissionOwner)dataSource);
            for (Map filterCfg : JSONUtils.getObjectList((Map)conObject, (String)"filters")) {
                String typeName = JSONUtils.getString((Map)filterCfg, (String)"type");
                String objectID = JSONUtils.getString((Map)filterCfg, (String)"id");
                if (CommonUtils.isEmpty((String)typeName)) continue;
                DBSObjectFilter filter = DataSourceSerializerModern.readObjectFiler(filterCfg);
                dataSource.updateObjectFilter(typeName, objectID, filter);
            }
            dataSource.getPreferenceStore().getProperties().putAll(JSONUtils.deserializeStringMap((Map)conObject, (String)"custom-properties"));
            String vmID = CommonUtils.toString(conObject.get("virtual-model-id"), (String)id);
            DBVModel dbvModel = (DBVModel)modelMap.get(vmID);
            if (dbvModel != null) {
                dataSource.setVirtualModel(dbvModel);
            }
            if (newDataSource) {
                this.registry.addDataSourceToList(dataSource);
                parseResults.addedDataSources.add(dataSource);
                continue;
            }
            parseResults.updatedDataSources.add(dataSource);
        }
        for (Map ctMap : JSONUtils.getObjectList((Map)jsonMap, (String)"saved-filters")) {
            DBSObjectFilter filter = DataSourceSerializerModern.readObjectFiler(ctMap);
            this.registry.addSavedFilter(filter);
        }
    }

    private void deserializeModifyPermissions(Map<String, Object> conObject, DBPDataSourcePermissionOwner permissionOwner) {
        List permissionRestrictions;
        Map securityCfg = JSONUtils.getObject(conObject, (String)"security");
        if (!CommonUtils.isEmpty((Map)securityCfg) && !CommonUtils.isEmpty((Collection)(permissionRestrictions = JSONUtils.deserializeStringList((Map)securityCfg, (String)"permission-restrictions")))) {
            ArrayList<DBPDataSourcePermission> permissions = new ArrayList<DBPDataSourcePermission>();
            for (String perm : permissionRestrictions) {
                try {
                    DBPDataSourcePermission permission = DBPDataSourcePermission.getById((String)perm);
                    if (permission == null) continue;
                    permissions.add(permission);
                }
                catch (IllegalArgumentException e) {
                    log.debug((Object)e);
                }
            }
            if (!permissions.isEmpty()) {
                permissionOwner.setModifyPermissions(permissions);
            }
        }
    }

    @Nullable
    private DBWHandlerConfiguration parseNetworkHandlerConfig(@Nullable DataSourceDescriptor dataSource, @Nullable DBWNetworkProfile profile, @NotNull Map.Entry<String, Map<String, Object>> handlerObject) {
        Map properties;
        String userPassword;
        String userName;
        String handlerId = handlerObject.getKey();
        Map<String, Object> handlerCfg = handlerObject.getValue();
        NetworkHandlerDescriptor handlerDescriptor = NetworkHandlerRegistry.getInstance().getDescriptor(handlerId);
        if (handlerDescriptor == null) {
            log.warn((Object)("Can't find network handler '" + handlerId + "'"));
            return null;
        }
        DBWHandlerConfiguration curNetworkHandler = new DBWHandlerConfiguration((DBWHandlerDescriptor)handlerDescriptor, (DBPDataSourceContainer)dataSource);
        curNetworkHandler.setEnabled(JSONUtils.getBoolean(handlerCfg, (String)"enabled"));
        curNetworkHandler.setSavePassword(JSONUtils.getBoolean(handlerCfg, (String)"save-password"));
        if (!this.passwordReadCanceled) {
            SecureCredentials creds = this.readSecuredCredentials(dataSource, (DBPConfigurationProfile)profile, "network/" + handlerId + (profile == null ? "" : "/profile/" + profile.getProfileName()));
            curNetworkHandler.setUserName(creds.getUserName());
            if (curNetworkHandler.isSavePassword()) {
                curNetworkHandler.setPassword(creds.getUserPassword());
            }
        }
        if (!CommonUtils.isEmpty((String)(userName = JSONUtils.getString(handlerCfg, (String)"user")))) {
            curNetworkHandler.setUserName(userName);
        }
        if (!CommonUtils.isEmpty((String)(userPassword = JSONUtils.getString(handlerCfg, (String)"password")))) {
            curNetworkHandler.setPassword(userPassword);
        }
        if ((properties = JSONUtils.deserializeProperties(handlerCfg, (String)"properties")) != null) {
            curNetworkHandler.setProperties(properties);
        }
        return curNetworkHandler;
    }

    private static DBSObjectFilter readObjectFiler(Map<String, Object> map) {
        DBSObjectFilter filter = new DBSObjectFilter();
        filter.setName(JSONUtils.getString(map, (String)"name"));
        filter.setDescription(JSONUtils.getString(map, (String)"description"));
        filter.setEnabled(JSONUtils.getBoolean(map, (String)"enabled"));
        filter.setInclude(JSONUtils.deserializeStringList(map, (String)"include"));
        filter.setExclude(JSONUtils.deserializeStringList(map, (String)"exclude"));
        return filter;
    }

    private static void saveFolder(JsonWriter json, DataSourceFolder folder) throws IOException {
        json.name(folder.getName());
        json.beginObject();
        if (folder.getParent() != null) {
            JSONUtils.field((JsonWriter)json, (String)"parent", (String)folder.getParent().getFolderPath());
        }
        JSONUtils.fieldNE((JsonWriter)json, (String)"description", (String)folder.getDescription());
        json.endObject();
    }

    /*
     * WARNING - void declaration
     */
    private void saveDataSource(@NotNull JsonWriter json, @NotNull DataSourceDescriptor dataSource) throws IOException {
        void var9_12;
        DBPConnectionBootstrap bootstrap;
        String lockPasswordHash;
        DataSourceNavigatorSettings navSettings;
        json.name(dataSource.getId());
        json.beginObject();
        JSONUtils.field((JsonWriter)json, (String)"provider", (String)dataSource.getDriver().getProviderDescriptor().getId());
        JSONUtils.field((JsonWriter)json, (String)"driver", (String)dataSource.getDriver().getId());
        DBPDataSourceOrigin origin = dataSource.getOrigin();
        if (origin != DataSourceOriginLocal.INSTANCE) {
            LinkedHashMap<String, String> originProps = new LinkedHashMap<String, String>();
            originProps.put(ATTR_ORIGIN_ID, origin.getId());
            originProps.putAll(origin.getConfiguration());
            JSONUtils.serializeProperties((JsonWriter)json, (String)TAG_ORIGIN, originProps);
        }
        JSONUtils.field((JsonWriter)json, (String)"name", (String)dataSource.getName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"description", (String)dataSource.getDescription());
        JSONUtils.field((JsonWriter)json, (String)"save-password", (boolean)dataSource.isSavePassword());
        if (dataSource.isTemplate()) {
            JSONUtils.field((JsonWriter)json, (String)"template", (boolean)dataSource.isTemplate());
        }
        if ((navSettings = dataSource.getNavigatorSettings()).isShowSystemObjects()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_SHOW_SYSTEM_OBJECTS, (boolean)true);
        }
        if (navSettings.isShowUtilityObjects()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_SHOW_UTIL_OBJECTS, (boolean)true);
        }
        if (navSettings.isShowOnlyEntities()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_SHOW_ONLY_ENTITIES, (boolean)true);
        }
        if (navSettings.isHideFolders()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_HIDE_FOLDERS, (boolean)true);
        }
        if (navSettings.isHideSchemas()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_HIDE_SCHEMAS, (boolean)true);
        }
        if (navSettings.isHideVirtualModel()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_HIDE_VIRTUAL, (boolean)true);
        }
        if (navSettings.isMergeEntities()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_MERGE_ENTITIES, (boolean)true);
        }
        JSONUtils.field((JsonWriter)json, (String)"read-only", (boolean)dataSource.isConnectionReadOnly());
        if (dataSource.getFolder() != null) {
            JSONUtils.field((JsonWriter)json, (String)"folder", (String)dataSource.getFolder().getFolderPath());
        }
        if (!CommonUtils.isEmpty((String)(lockPasswordHash = dataSource.getLockPasswordHash()))) {
            JSONUtils.field((JsonWriter)json, (String)"lockPassword", (String)lockPasswordHash);
        }
        if (dataSource.hasSharedVirtualModel()) {
            JSONUtils.field((JsonWriter)json, (String)"virtual-model-id", (String)dataSource.getVirtualModel().getId());
        }
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        json.name("configuration");
        json.beginObject();
        JSONUtils.fieldNE((JsonWriter)json, (String)"host", (String)connectionInfo.getHostName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"port", (String)connectionInfo.getHostPort());
        JSONUtils.fieldNE((JsonWriter)json, (String)"server", (String)connectionInfo.getServerName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"database", (String)connectionInfo.getDatabaseName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"url", (String)connectionInfo.getUrl());
        this.saveSecuredCredentials(dataSource, null, null, new SecureCredentials(dataSource));
        JSONUtils.fieldNE((JsonWriter)json, (String)"home", (String)connectionInfo.getClientHomeId());
        if (connectionInfo.getConnectionType() != null) {
            JSONUtils.field((JsonWriter)json, (String)"type", (String)connectionInfo.getConnectionType().getId());
        }
        JSONUtils.fieldNE((JsonWriter)json, (String)"color", (String)connectionInfo.getConnectionColor());
        if (connectionInfo.getKeepAliveInterval() > 0) {
            JSONUtils.field((JsonWriter)json, (String)"keepAlive", (long)connectionInfo.getKeepAliveInterval());
        }
        JSONUtils.fieldNE((JsonWriter)json, (String)"config-profile", (String)connectionInfo.getConfigProfileName());
        JSONUtils.serializeProperties((JsonWriter)json, (String)"properties", (Map)connectionInfo.getProperties());
        JSONUtils.serializeProperties((JsonWriter)json, (String)"provider-properties", (Map)connectionInfo.getProviderProperties());
        JSONUtils.fieldNE((JsonWriter)json, (String)"auth-model", (String)connectionInfo.getAuthModelId());
        JSONUtils.serializeProperties((JsonWriter)json, (String)"auth-properties", (Map)connectionInfo.getAuthProperties());
        if (!ArrayUtils.isEmpty((Object[])connectionInfo.getDeclaredEvents())) {
            json.name("events");
            json.beginObject();
            DBPConnectionEventType[] dBPConnectionEventTypeArray = connectionInfo.getDeclaredEvents();
            int n = dBPConnectionEventTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBPConnectionEventType eventType = dBPConnectionEventTypeArray[n2];
                DBRShellCommand command = connectionInfo.getEvent(eventType);
                if (command.isEnabled()) {
                    json.name(eventType.name());
                    json.beginObject();
                    JSONUtils.field((JsonWriter)json, (String)"enabled", (boolean)command.isEnabled());
                    JSONUtils.field((JsonWriter)json, (String)"show-panel", (boolean)command.isShowProcessPanel());
                    JSONUtils.field((JsonWriter)json, (String)"wait-process", (boolean)command.isWaitProcessFinish());
                    if (command.isWaitProcessFinish()) {
                        JSONUtils.field((JsonWriter)json, (String)"wait-process-timeout", (long)command.getWaitProcessTimeoutMs());
                    }
                    JSONUtils.field((JsonWriter)json, (String)"terminate-at-disconnect", (boolean)command.isTerminateAtDisconnect());
                    JSONUtils.field((JsonWriter)json, (String)"pauseAfterExecute", (long)command.getPauseAfterExecute());
                    JSONUtils.fieldNE((JsonWriter)json, (String)"workingDirectory", (String)command.getWorkingDirectory());
                    JSONUtils.fieldNE((JsonWriter)json, (String)"command", (String)command.getCommand());
                    json.endObject();
                }
                ++n2;
            }
            json.endObject();
        }
        if (!CommonUtils.isEmpty((Collection)connectionInfo.getHandlers())) {
            json.name("handlers");
            json.beginObject();
            for (DBWHandlerConfiguration configuration : connectionInfo.getHandlers()) {
                if (!configuration.isEnabled()) continue;
                this.saveNetworkHandlerConfiguration(json, dataSource, null, configuration);
            }
            json.endObject();
        }
        if ((bootstrap = connectionInfo.getBootstrap()).hasData()) {
            json.name("bootstrap");
            json.beginObject();
            if (bootstrap.getDefaultAutoCommit() != null) {
                JSONUtils.field((JsonWriter)json, (String)"autocommit", (boolean)bootstrap.getDefaultAutoCommit());
            }
            if (bootstrap.getDefaultTransactionIsolation() != null) {
                JSONUtils.field((JsonWriter)json, (String)"txnIsolation", (Number)bootstrap.getDefaultTransactionIsolation());
            }
            JSONUtils.fieldNE((JsonWriter)json, (String)"defaultCatalog", (String)bootstrap.getDefaultCatalogName());
            JSONUtils.fieldNE((JsonWriter)json, (String)"defaultSchema", (String)bootstrap.getDefaultSchemaName());
            if (bootstrap.isIgnoreErrors()) {
                JSONUtils.field((JsonWriter)json, (String)"ignoreErrors", (boolean)true);
            }
            JSONUtils.serializeStringList((JsonWriter)json, (String)"query", (Collection)bootstrap.getInitQueries());
            json.endObject();
        }
        json.endObject();
        this.serializeModifyPermissions(json, (DBPDataSourcePermissionOwner)dataSource);
        Collection<FilterMapping> filterMappings = dataSource.getObjectFilters();
        if (!CommonUtils.isEmpty(filterMappings)) {
            json.name("filters");
            json.beginArray();
            for (FilterMapping filter : filterMappings) {
                if (filter.defaultFilter != null && !filter.defaultFilter.isEmpty()) {
                    DataSourceSerializerModern.saveObjectFiler(json, filter.typeName, null, filter.defaultFilter);
                }
                for (Map.Entry entry : filter.customFilters.entrySet()) {
                    if (((DBSObjectFilter)entry.getValue()).isEmpty()) continue;
                    DataSourceSerializerModern.saveObjectFiler(json, filter.typeName, (String)entry.getKey(), (DBSObjectFilter)entry.getValue());
                }
            }
            json.endArray();
        }
        DataSourcePreferenceStore prefStore = dataSource.getPreferenceStore();
        TreeMap<String, String> props = new TreeMap<String, String>();
        String[] stringArray = prefStore.preferenceNames();
        int n3 = stringArray.length;
        boolean bl = false;
        while (var9_12 < n3) {
            String propName = stringArray[var9_12];
            String propValue = prefStore.getString(propName);
            String defValue = prefStore.getDefaultString(propName);
            if (propValue != null && !CommonUtils.equalObjects((Object)propValue, (Object)defValue)) {
                props.put(propName, propValue);
            }
            ++var9_12;
        }
        if (!props.isEmpty()) {
            JSONUtils.serializeProperties((JsonWriter)json, (String)"custom-properties", props);
        }
        json.endObject();
    }

    private void serializeModifyPermissions(@NotNull JsonWriter json, DBPDataSourcePermissionOwner permissionOwner) throws IOException {
        List permissions = permissionOwner.getModifyPermission();
        if (!CommonUtils.isEmpty((Collection)permissions)) {
            json.name("security");
            json.beginObject();
            ArrayList<String> permIds = new ArrayList<String>(permissions.size());
            for (DBPDataSourcePermission perm : permissions) {
                permIds.add(perm.getId());
            }
            JSONUtils.serializeStringList((JsonWriter)json, (String)"permission-restrictions", permIds);
            json.endObject();
        }
    }

    private void saveNetworkHandlerConfiguration(@NotNull JsonWriter json, @Nullable DataSourceDescriptor dataSource, @Nullable DBWNetworkProfile profile, @NotNull DBWHandlerConfiguration configuration) throws IOException {
        json.name(CommonUtils.notEmpty((String)configuration.getId()));
        json.beginObject();
        JSONUtils.field((JsonWriter)json, (String)"type", (String)configuration.getType().name());
        JSONUtils.field((JsonWriter)json, (String)"enabled", (boolean)configuration.isEnabled());
        JSONUtils.field((JsonWriter)json, (String)"save-password", (boolean)configuration.isSavePassword());
        if (!CommonUtils.isEmpty((String)configuration.getUserName()) || !CommonUtils.isEmpty((String)configuration.getPassword())) {
            this.saveSecuredCredentials(dataSource, (DBPConfigurationProfile)profile, "network/" + configuration.getId() + (profile == null ? "" : "/profile/" + profile.getProfileName()), new SecureCredentials(configuration));
        }
        JSONUtils.serializeProperties((JsonWriter)json, (String)"properties", (Map)configuration.getProperties());
        json.endObject();
    }

    private static void saveObjectFiler(JsonWriter json, String typeName, String objectID, DBSObjectFilter filter) throws IOException {
        json.beginObject();
        JSONUtils.fieldNE((JsonWriter)json, (String)"id", (String)objectID);
        JSONUtils.fieldNE((JsonWriter)json, (String)"type", (String)typeName);
        JSONUtils.fieldNE((JsonWriter)json, (String)"name", (String)filter.getName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"description", (String)filter.getDescription());
        JSONUtils.field((JsonWriter)json, (String)"enabled", (boolean)filter.isEnabled());
        JSONUtils.serializeStringList((JsonWriter)json, (String)"include", (Collection)filter.getInclude());
        JSONUtils.serializeStringList((JsonWriter)json, (String)"exclude", (Collection)filter.getExclude());
        json.endObject();
    }

    private void saveSecuredCredentials(@Nullable DataSourceDescriptor dataSource, @Nullable DBPConfigurationProfile profile, @Nullable String subNode, @NotNull SecureCredentials credentials) {
        boolean saved;
        assert (dataSource != null || profile != null);
        boolean bl = saved = !this.passwordWriteCanceled && DataSourceUtils.saveCredentialsInSecuredStorage(this.registry.getProject(), dataSource, subNode, credentials);
        if (!saved) {
            String topNodeId;
            this.passwordWriteCanceled = true;
            String string = topNodeId = profile != null ? "profile:" + profile.getProfileId() : dataSource.getId();
            if (subNode == null) {
                subNode = NODE_CONNECTION;
            }
            Map nodeMap = this.secureProperties.computeIfAbsent(topNodeId, s -> new LinkedHashMap());
            Map propMap = nodeMap.computeIfAbsent(subNode, s -> new LinkedHashMap());
            if (!CommonUtils.isEmpty((String)credentials.getUserName())) {
                propMap.put("user", credentials.getUserName());
            }
            if (!CommonUtils.isEmpty((String)credentials.getUserPassword())) {
                propMap.put("password", credentials.getUserPassword());
            }
            if (!CommonUtils.isEmpty(credentials.getProperties())) {
                propMap.putAll(credentials.getProperties());
            }
        }
    }

    private SecureCredentials readSecuredCredentials(@Nullable DataSourceDescriptor dataSource, @Nullable DBPConfigurationProfile profile, @Nullable String subNode) {
        SecureCredentials creds;
        block30: {
            Map<String, String> propMap;
            Map<String, Map<String, String>> subMap;
            String topNodeId;
            block28: {
                assert (dataSource != null || profile != null);
                creds = new SecureCredentials();
                DBASecureStorage secureStorage = dataSource == null ? this.registry.getProject().getSecureStorage() : dataSource.getProject().getSecureStorage();
                try {
                    int n;
                    Object object;
                    ISecurePreferences prefNode;
                    if (!secureStorage.useSecurePreferences()) break block28;
                    ISecurePreferences iSecurePreferences = prefNode = dataSource == null ? secureStorage.getSecurePreferences() : dataSource.getSecurePreferences();
                    if (subNode != null) {
                        object = subNode.split("/");
                        int n2 = ((String[])object).length;
                        n = 0;
                        while (n < n2) {
                            String nodeName = object[n];
                            prefNode = prefNode.node(nodeName);
                            ++n;
                        }
                    }
                    object = prefNode.keys();
                    int n2 = ((String[])object).length;
                    n = 0;
                    while (n < n2) {
                        String key;
                        switch (key = object[n]) {
                            case "user": {
                                creds.setUserName(prefNode.get(key, null));
                                break;
                            }
                            case "password": {
                                creds.setUserPassword(prefNode.get(key, null));
                                break;
                            }
                            default: {
                                creds.setSecureProp(key, prefNode.get(key, null));
                            }
                        }
                        ++n;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Can't read password from secure storage", e);
                    this.passwordReadCanceled = true;
                }
            }
            String string = topNodeId = profile != null ? "profile:" + profile.getProfileId() : dataSource.getId();
            if (subNode == null) {
                subNode = NODE_CONNECTION;
            }
            if ((subMap = this.secureProperties.get(topNodeId)) == null || (propMap = subMap.get(subNode)) == null) break block30;
            for (Map.Entry entry : propMap.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "user": {
                        creds.setUserName((String)entry.getValue());
                        break;
                    }
                    case "password": {
                        creds.setUserPassword((String)entry.getValue());
                        break;
                    }
                    default: {
                        creds.setSecureProp((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
        }
        return creds;
    }
}

