/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.util.stream.Collectors;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public class DatabaseConsumerPageLoadSettings
extends ActiveWizardPage<DataTransferWizard> {
    private Button transferAutoGeneratedColumns;
    private Button truncateTargetTable;

    public DatabaseConsumerPageLoadSettings() {
        super(DTUIMessages.database_consumer_wizard_name);
        this.setTitle(DTUIMessages.database_consumer_wizard_title);
        this.setDescription(DTUIMessages.database_consumer_wizard_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        final DatabaseConsumerSettings settings = this.getSettings();
        Group loadSettings = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.database_consumer_wizard_name, (int)1, (int)768, (int)0);
        this.transferAutoGeneratedColumns = UIUtils.createCheckbox((Composite)loadSettings, (String)DTUIMessages.database_consumer_wizard_transfer_checkbox_label, (String)DTUIMessages.database_consumer_wizard_transfer_checkbox_tooltip, (boolean)settings.isTransferAutoGeneratedColumns(), (int)1);
        this.transferAutoGeneratedColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setTransferAutoGeneratedColumns(DatabaseConsumerPageLoadSettings.this.transferAutoGeneratedColumns.getSelection());
            }
        });
        this.truncateTargetTable = UIUtils.createCheckbox((Composite)loadSettings, (String)DTUIMessages.database_consumer_wizard_truncate_checkbox_label, (boolean)settings.isTruncateBeforeLoad());
        this.truncateTargetTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DatabaseConsumerPageLoadSettings.this.truncateTargetTable.getSelection() && !DatabaseConsumerPageLoadSettings.this.confirmDataTruncate()) {
                    DatabaseConsumerPageLoadSettings.this.truncateTargetTable.setSelection(false);
                    return;
                }
                settings.setTruncateBeforeLoad(DatabaseConsumerPageLoadSettings.this.truncateTargetTable.getSelection());
            }
        });
        Group performanceSettings = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.database_consumer_wizard_performance_group_label, (int)4, (int)768, (int)0);
        final Button newConnectionCheckbox = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_new_connection, null, (boolean)settings.isOpenNewConnections(), (int)4);
        newConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenNewConnections(newConnectionCheckbox.getSelection());
            }
        });
        final Button useTransactionsCheck = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_transactions_checkbox_label, null, (boolean)settings.isUseTransactions(), (int)4);
        useTransactionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setUseTransactions(useTransactionsCheck.getSelection());
            }
        });
        final Spinner commitAfterEdit = UIUtils.createLabelSpinner((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_commit_spinner_label, (int)settings.getCommitAfterRows(), (int)1, (int)Integer.MAX_VALUE);
        commitAfterEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCommitAfterRows(commitAfterEdit.getSelection());
            }
        });
        commitAfterEdit.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        final Button useBatchCheck = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_disable_import_batches_label, (String)DTUIMessages.database_consumer_wizard_disable_import_batches_description, (boolean)settings.isDisableUsingBatches(), (int)4);
        useBatchCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setDisableUsingBatches(useBatchCheck.getSelection());
            }
        });
        Group generalSettings = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.database_consumer_wizard_general_group_label, (int)4, (int)768, (int)0);
        final Button showTableCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTUIMessages.database_consumer_wizard_table_checkbox_label, null, (boolean)settings.isOpenTableOnFinish(), (int)4);
        showTableCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenTableOnFinish(showTableCheckbox.getSelection());
            }
        });
        final Button showFinalMessageCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTUIMessages.database_consumer_wizard_final_message_checkbox_label, null, (boolean)((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage(), (int)4);
        showFinalMessageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((DataTransferWizard)DatabaseConsumerPageLoadSettings.this.getWizard()).getSettings().setShowFinalMessage(showFinalMessageCheckbox.getSelection());
            }
        });
        this.setControl((Control)composite);
    }

    private DatabaseConsumerSettings getSettings() {
        return ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
    }

    public void activatePage() {
        this.updatePageCompletion();
        UIUtils.asyncExec(() -> {
            DatabaseConsumerSettings settings = this.getSettings();
            if (settings.isTruncateBeforeLoad() && !this.confirmDataTruncate()) {
                this.truncateTargetTable.setSelection(false);
                settings.setTruncateBeforeLoad(false);
            }
        });
    }

    private boolean confirmDataTruncate() {
        String tableNames;
        String checkbox_question;
        Shell shell = this.getContainer().getShell();
        return !shell.isVisible() && !this.getSettings().isTruncateBeforeLoad() || UIUtils.confirmAction((Shell)shell, (String)DTUIMessages.database_consumer_wizard_truncate_checkbox_title, (String)(checkbox_question = NLS.bind((String)DTUIMessages.database_consumer_wizard_truncate_checkbox_question, (Object)(tableNames = ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes().stream().map(pipe -> pipe.getConsumer() == null ? "" : pipe.getConsumer().getObjectName()).collect(Collectors.joining(","))))));
    }

    public void deactivatePage() {
        super.deactivatePage();
    }

    protected boolean determinePageCompletion() {
        return true;
    }
}

