/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericDataTypeCache;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModelDescriptor;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class GenericMetaModel {
    private static final Log log = Log.getLog(GenericMetaModel.class);
    private static final String DEFAULT_NULL_SCHEMA_NAME = "DEFAULT";
    private static final Set<String> INVALID_TABLE_TYPES = new HashSet<String>();
    GenericMetaModelDescriptor descriptor;

    static {
        INVALID_TABLE_TYPES.add("INDEX");
        INVALID_TABLE_TYPES.add("SEQUENCE");
        INVALID_TABLE_TYPES.add("TYPE");
        INVALID_TABLE_TYPES.add("SYSTEM INDEX");
        INVALID_TABLE_TYPES.add("SYSTEM SEQUENCE");
        INVALID_TABLE_TYPES.add("TRIGGER");
    }

    public GenericMetaObject getMetaObject(String id) {
        return this.descriptor == null ? null : this.descriptor.getObject(id);
    }

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new GenericDataSource(monitor, container, this, (SQLDialect)new GenericSQLDialect());
    }

    public JDBCBasicDataTypeCache<GenericStructContainer, ? extends JDBCDataType> createDataTypeCache(@NotNull GenericStructContainer container) {
        return new GenericDataTypeCache(container);
    }

    public DBCQueryPlanner getQueryPlanner(@NotNull GenericDataSource dataSource) {
        return null;
    }

    public DBPErrorAssistant.ErrorPosition getErrorPosition(@NotNull Throwable error) {
        return null;
    }

    public boolean supportsUpsertStatement() {
        return false;
    }

    public String getAutoIncrementClause(GenericTableColumn column) {
        return null;
    }

    public boolean useCatalogInObjectNames() {
        return true;
    }

    public boolean isSystemSchema(GenericSchema schema) {
        return false;
    }

    public List<GenericSchema> loadSchemas(JDBCSession session, GenericDataSource dataSource, GenericCatalog catalog) throws DBException {
        if (dataSource.isOmitSchema()) {
            return null;
        }
        try {
            GenericMetaObject schemaObject = this.getMetaObject("schema");
            DBSObjectFilter schemaFilters = dataSource.getContainer().getObjectFilter(GenericSchema.class, (DBSObject)catalog, false);
            ArrayList<GenericSchema> tmpSchemas = new ArrayList<GenericSchema>();
            JDBCResultSet dbResult = null;
            boolean catalogSchemas = false;
            boolean schemasFiltered = false;
            if (catalog != null) {
                try {
                    dbResult = session.getMetaData().getSchemas(catalog.getName(), schemaFilters != null && schemaFilters.hasSingleMask() ? schemaFilters.getSingleMask() : dataSource.getAllObjectsPattern());
                    catalogSchemas = true;
                }
                catch (Throwable e) {
                    log.debug((Object)("Error reading schemas in catalog '" + catalog.getName() + "' - " + e.getClass().getSimpleName() + " - " + e.getMessage()));
                }
            } else if (dataSource.isSchemaFiltersEnabled()) {
                try {
                    dbResult = session.getMetaData().getSchemas(null, schemaFilters != null && schemaFilters.hasSingleMask() ? schemaFilters.getSingleMask() : dataSource.getAllObjectsPattern());
                }
                catch (Throwable e) {
                    log.debug((Object)("Error reading global schemas  - " + e.getMessage()));
                }
            }
            if (dbResult == null) {
                dbResult = session.getMetaData().getSchemas();
            }
            try {
                while (dbResult.next()) {
                    if (session.getProgressMonitor().isCanceled()) {
                        break;
                    }
                    String schemaName = GenericUtils.safeGetString(schemaObject, (ResultSet)dbResult, "TABLE_SCHEM");
                    if (CommonUtils.isEmpty((String)schemaName)) {
                        schemaName = GenericUtils.safeGetString(schemaObject, (ResultSet)dbResult, "TABLE_OWNER");
                    }
                    boolean nullSchema = false;
                    if (CommonUtils.isEmpty((String)schemaName)) {
                        if (!this.supportsNullSchemas()) continue;
                        schemaName = DEFAULT_NULL_SCHEMA_NAME;
                        nullSchema = true;
                    }
                    if (schemaFilters != null && !schemaFilters.matches(schemaName)) {
                        schemasFiltered = true;
                        continue;
                    }
                    String catalogName = GenericUtils.safeGetString(schemaObject, (ResultSet)dbResult, "TABLE_CATALOG");
                    if (!CommonUtils.isEmpty((String)catalogName)) {
                        if (catalog == null) {
                            if (!dataSource.isOmitCatalog()) {
                                log.debug((Object)("Catalog name (" + catalogName + ") found for schema '" + schemaName + "' while schema doesn't have parent catalog"));
                            }
                        } else if (!catalog.getName().equals(catalogName)) {
                            if (!catalogSchemas) continue;
                            log.debug((Object)("Catalog name '" + catalogName + "' differs from schema's catalog '" + catalog.getName() + "'"));
                        }
                    }
                    session.getProgressMonitor().subTask("Schema " + schemaName);
                    GenericSchema schema = this.createSchemaImpl(dataSource, catalog, schemaName);
                    if (nullSchema) {
                        schema.setVirtual(true);
                    }
                    tmpSchemas.add(schema);
                }
            }
            finally {
                dbResult.close();
            }
            if (tmpSchemas.isEmpty() && catalogSchemas && !schemasFiltered && dataSource.getCatalogs().size() == 1) {
                return this.loadSchemas(session, dataSource, null);
            }
            if (dataSource.isOmitSingleSchema() && catalog == null && tmpSchemas.size() == 1 && (schemaFilters == null || schemaFilters.isNotApplicable())) {
                tmpSchemas.clear();
            }
            return tmpSchemas;
        }
        catch (UnsupportedOperationException | SQLFeatureNotSupportedException e) {
            log.debug((Object)("Can't read schema list: " + e.getMessage()));
            return null;
        }
        catch (Throwable ex) {
            log.warn((Object)"Can't read schema list", ex);
            return null;
        }
    }

    public boolean supportsNullSchemas() {
        return false;
    }

    public GenericSchema createSchemaImpl(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName) throws DBException {
        return new GenericSchema(dataSource, catalog, schemaName);
    }

    public void loadProcedures(DBRProgressMonitor monitor, @NotNull GenericObjectContainer container) throws DBException {
        block41: {
            TreeMap<String, GenericObjectContainer> packageMap = null;
            LinkedHashMap<String, GenericProcedure> funcMap = new LinkedHashMap<String, GenericProcedure>();
            GenericDataSource dataSource = container.getDataSource();
            GenericMetaObject procObject = dataSource.getMetaObject("procedure");
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Load procedures");){
                    JDBCResultSet dbResult;
                    boolean supportsFunctions = false;
                    if (this.hasFunctionSupport()) {
                        try {
                            dbResult = session.getMetaData().getFunctions(container.getCatalog() == null ? null : container.getCatalog().getName(), container.getSchema() == null || DBUtils.isVirtualObject((Object)container.getSchema()) ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)container.getSchema().getName()), dataSource.getAllObjectsPattern());
                            try {
                                supportsFunctions = true;
                                while (dbResult.next()) {
                                    GenericFunctionResultType functionResultType;
                                    if (monitor.isCanceled()) {
                                        break;
                                    }
                                    String functionName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "FUNCTION_NAME");
                                    if (functionName == null) continue;
                                    String specificName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "SPECIFIC_NAME");
                                    if (specificName == null && functionName.indexOf(59) != -1) {
                                        specificName = functionName;
                                        functionName = functionName.substring(0, functionName.lastIndexOf(59));
                                    }
                                    if (container.hasProcedure(functionName)) continue;
                                    int funcTypeNum = GenericUtils.safeGetInt(procObject, (ResultSet)dbResult, "FUNCTION_TYPE");
                                    String remarks = GenericUtils.safeGetString(procObject, (ResultSet)dbResult, "REMARKS");
                                    switch (funcTypeNum) {
                                        case 1: {
                                            functionResultType = GenericFunctionResultType.NO_TABLE;
                                            break;
                                        }
                                        case 2: {
                                            functionResultType = GenericFunctionResultType.TABLE;
                                            break;
                                        }
                                        default: {
                                            functionResultType = GenericFunctionResultType.UNKNOWN;
                                        }
                                    }
                                    GenericProcedure procedure = this.createProcedureImpl(container, functionName, specificName, remarks, DBSProcedureType.FUNCTION, functionResultType);
                                    container.addProcedure(procedure);
                                    funcMap.put(specificName == null ? functionName : specificName, procedure);
                                }
                            }
                            finally {
                                dbResult.close();
                            }
                        }
                        catch (Throwable e) {
                            log.debug((Object)"Can't read generic functions", e);
                        }
                    }
                    if (!this.hasProcedureSupport()) break block41;
                    dbResult = session.getMetaData().getProcedures(container.getCatalog() == null ? null : container.getCatalog().getName(), container.getSchema() == null || DBUtils.isVirtualObject((Object)container.getSchema()) ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)container.getSchema().getName()), dataSource.getAllObjectsPattern());
                    try {
                        while (dbResult.next()) {
                            GenericProcedure function;
                            DBSProcedureType procedureType;
                            if (monitor.isCanceled()) {
                                break;
                            }
                            String procedureCatalog = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "PROCEDURE_CAT");
                            String procedureName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "PROCEDURE_NAME");
                            String specificName = GenericUtils.safeGetStringTrimmed(procObject, (ResultSet)dbResult, "SPECIFIC_NAME");
                            int procTypeNum = GenericUtils.safeGetInt(procObject, (ResultSet)dbResult, "PROCEDURE_TYPE");
                            String remarks = GenericUtils.safeGetString(procObject, (ResultSet)dbResult, "REMARKS");
                            switch (procTypeNum) {
                                case 1: {
                                    procedureType = DBSProcedureType.PROCEDURE;
                                    break;
                                }
                                case 2: {
                                    procedureType = supportsFunctions ? DBSProcedureType.PROCEDURE : DBSProcedureType.FUNCTION;
                                    break;
                                }
                                case 0: {
                                    procedureType = DBSProcedureType.PROCEDURE;
                                    break;
                                }
                                default: {
                                    procedureType = DBSProcedureType.UNKNOWN;
                                }
                            }
                            if (CommonUtils.isEmpty((String)specificName)) {
                                specificName = procedureName;
                            }
                            if ((function = (GenericProcedure)funcMap.get(specificName)) != null) {
                                log.debug((Object)("Broken driver [" + session.getDataSource().getContainer().getDriver().getName() + "] - returns the same list for getProcedures and getFunctons"));
                                break;
                            }
                            procedureName = GenericUtils.normalizeProcedureName(procedureName);
                            GenericObjectContainer procedurePackage = null;
                            String packageName = this.getPackageName(dataSource, procedureCatalog, procedureName, specificName);
                            if (packageName != null && !CommonUtils.isEmpty((String)packageName)) {
                                if (packageMap == null) {
                                    packageMap = new TreeMap<String, GenericObjectContainer>();
                                }
                                if ((procedurePackage = (GenericPackage)packageMap.get(packageName)) == null) {
                                    procedurePackage = new GenericPackage(container, packageName, true);
                                    packageMap.put(packageName, procedurePackage);
                                    container.addPackage((GenericPackage)procedurePackage);
                                }
                            }
                            GenericProcedure procedure = this.createProcedureImpl(procedurePackage != null ? procedurePackage : container, procedureName, specificName, remarks, procedureType, null);
                            if (procedurePackage != null) {
                                ((GenericPackage)procedurePackage).addProcedure(procedure);
                                continue;
                            }
                            container.addProcedure(procedure);
                        }
                    }
                    finally {
                        dbResult.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, (DBPDataSource)dataSource);
            }
        }
    }

    public GenericProcedure createProcedureImpl(GenericStructContainer container, String procedureName, String specificName, String remarks, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        return new GenericProcedure(container, procedureName, specificName, remarks, procedureType, functionResultType);
    }

    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure sourceObject) throws DBException {
        return "-- Source code not available";
    }

    public String getPackageName(GenericDataSource dataSource, String catalogName, String procedureName, String specificName) {
        if (!CommonUtils.isEmpty((String)catalogName)) {
            CommonUtils.isEmpty(dataSource.getCatalogs());
        }
        return null;
    }

    public GenericCatalog createCatalogImpl(@NotNull GenericDataSource dataSource, @NotNull String catalogName) {
        return new GenericCatalog(dataSource, catalogName);
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        String tableNamePattern;
        if (object == null && objectName == null) {
            DBSObjectFilter tableFilters = session.getDataSource().getContainer().getObjectFilter(GenericTable.class, (DBSObject)owner, false);
            if (tableFilters != null && tableFilters.hasSingleMask()) {
                tableNamePattern = tableFilters.getSingleMask();
                if (!CommonUtils.isEmpty((String)tableNamePattern)) {
                    tableNamePattern = SQLUtils.makeSQLLike((String)tableNamePattern);
                }
            } else {
                tableNamePattern = owner.getDataSource().getAllObjectsPattern();
            }
        } else {
            tableNamePattern = JDBCUtils.escapeWildCards((JDBCSession)session, (String)(object != null ? object.getName() : objectName));
        }
        return session.getMetaData().getTables(owner.getCatalog() == null ? null : owner.getCatalog().getName(), owner.getSchema() == null || DBUtils.isVirtualObject((Object)owner.getSchema()) ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)owner.getSchema().getName()), tableNamePattern, null).getSourceStatement();
    }

    public GenericTableBase createTableImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericMetaObject tableObject, @NotNull JDBCResultSet dbResult) {
        String tableName = GenericUtils.safeGetStringTrimmed(tableObject, (ResultSet)dbResult, "TABLE_NAME");
        String tableType = GenericUtils.safeGetStringTrimmed(tableObject, (ResultSet)dbResult, "TABLE_TYPE");
        String tableSchema = GenericUtils.safeGetStringTrimmed(tableObject, (ResultSet)dbResult, "TABLE_SCHEM");
        if (!CommonUtils.isEmpty((String)tableSchema) && owner.getDataSource().isOmitSchema()) {
            log.debug((Object)("Ignore table " + tableSchema + "." + tableName + " (schemas are omitted)"));
            return null;
        }
        if (CommonUtils.isEmpty((String)tableName)) {
            log.debug((Object)("Empty table name " + (owner == null ? "" : " in container " + owner.getName())));
            return null;
        }
        if (CommonUtils.isEmpty((String)tableName)) {
            return null;
        }
        if (tableType != null && INVALID_TABLE_TYPES.contains(tableType)) {
            return null;
        }
        if (DBUtils.isVirtualObject((Object)owner) && !CommonUtils.isEmpty((String)tableSchema)) {
            return null;
        }
        GenericTableBase table = this.createTableImpl(owner, tableName, tableType, dbResult);
        if (table == null) {
            return null;
        }
        boolean isSystemTable = table.isSystem();
        if (isSystemTable && !owner.getDataSource().getContainer().getNavigatorSettings().isShowSystemObjects()) {
            return null;
        }
        return table;
    }

    public GenericTableBase createTableImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new GenericView(container, tableName, tableType, dbResult);
        }
        return new GenericTable(container, tableName, tableType, dbResult);
    }

    public String getViewDDL(DBRProgressMonitor monitor, GenericView sourceObject, Map<String, Object> options) throws DBException {
        return "-- View definition not available";
    }

    public String getTableDDL(DBRProgressMonitor monitor, GenericTableBase sourceObject, Map<String, Object> options) throws DBException {
        return DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSEntity)sourceObject, options, (boolean)false);
    }

    public boolean supportsTableDDLSplit(GenericTableBase sourceObject) {
        return true;
    }

    public boolean isSystemTable(GenericTableBase table) {
        String tableType = table.getTableType().toUpperCase(Locale.ENGLISH);
        return tableType.contains("SYSTEM");
    }

    public boolean isView(String tableType) {
        return tableType.toUpperCase(Locale.ENGLISH).contains("VIEW");
    }

    public JDBCStatement prepareTableColumnLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException {
        return session.getMetaData().getColumns(owner.getCatalog() == null ? null : owner.getCatalog().getName(), owner.getSchema() == null || DBUtils.isVirtualObject((Object)owner.getSchema()) ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)owner.getSchema().getName()), forTable == null ? owner.getDataSource().getAllObjectsPattern() : JDBCUtils.escapeWildCards((JDBCSession)session, (String)forTable.getName()), owner.getDataSource().getAllObjectsPattern()).getSourceStatement();
    }

    public GenericTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, @Nullable JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        return new GenericTableColumn(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException, DBException {
        return session.getMetaData().getPrimaryKeys(owner.getCatalog() == null ? null : owner.getCatalog().getName(), owner.getSchema() == null || DBUtils.isVirtualObject((Object)owner.getSchema()) ? null : owner.getSchema().getName(), forParent == null ? owner.getDataSource().getAllObjectsPattern() : forParent.getName()).getSourceStatement();
    }

    public DBSEntityConstraintType getUniqueConstraintType(JDBCResultSet dbResult) throws DBException, SQLException {
        return DBSEntityConstraintType.PRIMARY_KEY;
    }

    public GenericTableIndex createIndexImpl(GenericTableBase table, boolean nonUnique, String qualifier, long cardinality, String indexName, DBSIndexType indexType, boolean persisted) {
        return new GenericTableIndex(table, nonUnique, qualifier, cardinality, indexName, indexType, persisted);
    }

    public GenericUniqueKey createConstraintImpl(GenericTableBase table, String constraintName, DBSEntityConstraintType constraintType, JDBCResultSet dbResult, boolean persisted) {
        return new GenericUniqueKey(table, constraintName, null, constraintType, persisted);
    }

    public GenericTableConstraintColumn[] createConstraintColumnsImpl(JDBCSession session, GenericTableBase parent, GenericUniqueKey object, GenericMetaObject pkObject, JDBCResultSet dbResult) throws DBException {
        String columnName = GenericUtils.safeGetStringTrimmed(pkObject, (ResultSet)dbResult, "COLUMN_NAME");
        if (CommonUtils.isEmpty((String)columnName)) {
            log.debug((Object)("Null primary key column for '" + object.getName() + "'"));
            return null;
        }
        if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("\"") && columnName.endsWith("\"")) {
            columnName = columnName.substring(1, columnName.length() - 1);
        }
        int keySeq = GenericUtils.safeGetInt(pkObject, (ResultSet)dbResult, "KEY_SEQ");
        GenericTableColumn tableColumn = parent.getAttribute(session.getProgressMonitor(), columnName);
        if (tableColumn == null) {
            log.warn((Object)("Column '" + columnName + "' not found in table '" + parent.getFullyQualifiedName(DBPEvaluationContext.DDL) + "' for PK '" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'"));
            return null;
        }
        return new GenericTableConstraintColumn[]{new GenericTableConstraintColumn(object, tableColumn, keySeq)};
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return false;
    }

    public List<GenericSequence> loadSequences(@NotNull DBRProgressMonitor monitor, @NotNull GenericStructContainer container) throws DBException {
        return new ArrayList<GenericSequence>();
    }

    public boolean supportsSynonyms(@NotNull GenericDataSource dataSource) {
        return false;
    }

    public List<? extends GenericSynonym> loadSynonyms(@NotNull DBRProgressMonitor monitor, @NotNull GenericStructContainer container) throws DBException {
        return new ArrayList();
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return false;
    }

    public boolean supportsDatabaseTriggers(@NotNull GenericDataSource dataSource) {
        return false;
    }

    public List<? extends GenericTrigger> loadTriggers(DBRProgressMonitor monitor, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws DBException {
        return new ArrayList();
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        return "-- Source code not available";
    }

    public boolean isTableCommentEditable() {
        return false;
    }

    public boolean isTableColumnCommentEditable() {
        return false;
    }

    public boolean isColumnNotNullByDefault() {
        return false;
    }

    public boolean hasProcedureSupport() {
        return true;
    }

    public boolean hasFunctionSupport() {
        return true;
    }

    public boolean supportsCheckConstraints() {
        return false;
    }

    public boolean supportsViews(@NotNull GenericDataSource dataSource) {
        DBPDataSourceInfo dataSourceInfo = dataSource.getInfo();
        return !(dataSourceInfo instanceof JDBCDataSourceInfo) || ((JDBCDataSourceInfo)dataSourceInfo).supportsViews();
    }
}

