/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.task;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.tools.transfer.DataTransferJob;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.DataTransferState;

public class DTTaskHandlerTransfer
implements DBTTaskHandler {
    public void executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        DataTransferSettings[] settings = new DataTransferSettings[1];
        try {
            runnableContext.run(true, true, monitor -> {
                dataTransferSettingsArray[0] = new DataTransferSettings(monitor, task, log, Collections.emptyMap(), new DataTransferState());
            });
        }
        catch (InvocationTargetException e) {
            throw new DBException("Error loading task settings", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.executeWithSettings(runnableContext, task, locale, log, listener, settings[0]);
    }

    public void executeWithSettings(@NotNull DBRRunnableContext runnableContext, DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull DBTTaskExecutionListener listener, DataTransferSettings settings) throws DBException {
        listener.taskStarted((Object)settings);
        List<DataTransferPipe> dataPipes = settings.getDataPipes();
        try {
            runnableContext.run(true, false, monitor -> {
                monitor.beginTask("Initialize pipes", dataPipes.size());
                try {
                    try {
                        int i = 0;
                        while (i < dataPipes.size()) {
                            DataTransferPipe pipe = (DataTransferPipe)dataPipes.get(i);
                            pipe.initPipe(settings, i, dataPipes.size());
                            pipe.getConsumer().startTransfer(monitor);
                            monitor.worked(1);
                            ++i;
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new DBException("Error starting data transfer", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        int totalJobs = settings.getDataPipes().size();
        if (totalJobs > settings.getMaxJobCount()) {
            totalJobs = settings.getMaxJobCount();
        }
        Throwable error = null;
        int i = 0;
        while (i < totalJobs) {
            DataTransferJob job = new DataTransferJob(settings, task, locale, log, listener);
            try {
                runnableContext.run(true, true, (DBRRunnableWithProgress)job);
            }
            catch (InvocationTargetException e) {
                error = e.getTargetException();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            listener.subTaskFinished(error);
            ++i;
        }
        listener.taskFinished((Object)settings, error);
    }
}

