/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

class ColumnsMappingDialog
extends BaseDialog {
    private final DatabaseConsumerSettings settings;
    private final DatabaseMappingContainer mapping;
    private final Collection<DatabaseMappingAttribute> attributeMappings;
    private TableViewer mappingViewer;
    private Font boldFont;

    ColumnsMappingDialog(DataTransferWizard wizard, DatabaseConsumerSettings settings, DatabaseMappingContainer mapping) {
        super(wizard.getShell(), String.valueOf(DTUIMessages.columns_mapping_dialog_shell_text) + mapping.getTargetName(), null);
        this.settings = settings;
        this.mapping = mapping;
        this.attributeMappings = mapping.getAttributeMappings(wizard.getRunnableContext());
    }

    protected boolean isResizable() {
        return true;
    }

    protected Composite createDialogArea(Composite parent) {
        DBPDataSource targetDataSource = this.settings.getTargetDataSource((DatabaseMappingObject)this.mapping);
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        DBPDataSource sourceDataSource = this.mapping.getSource().getDataSource();
        UIUtils.createLabelText((Composite)composite, (String)DTUIMessages.columns_mapping_dialog_composite_label_text_source_container, (String)(sourceDataSource == null ? "" : sourceDataSource.getContainer().getName()), (int)2056);
        Text sourceEntity = UIUtils.createLabelText((Composite)composite, (String)DTUIMessages.columns_mapping_dialog_composite_label_text_source_entity, (String)DBUtils.getObjectFullName((DBPNamedObject)this.mapping.getSource(), (DBPEvaluationContext)DBPEvaluationContext.UI), (int)2570);
        ((GridData)sourceEntity.getLayoutData()).widthHint = 600;
        ((GridData)sourceEntity.getLayoutData()).heightHint = UIUtils.getFontHeight((Control)sourceEntity) * 3;
        UIUtils.createLabelText((Composite)composite, (String)DTUIMessages.columns_mapping_dialog_composite_label_text_target_container, (String)(targetDataSource == null ? "?" : targetDataSource.getContainer().getName()), (int)2056);
        Text targetEntity = UIUtils.createLabelText((Composite)composite, (String)DTUIMessages.columns_mapping_dialog_composite_label_text_target_entity, (String)this.mapping.getTargetName(), (int)2056);
        ((GridData)targetEntity.getLayoutData()).widthHint = 600;
        ((GridData)targetEntity.getLayoutData()).heightHint = UIUtils.getFontHeight((Control)sourceEntity) * 3;
        this.mappingViewer = new TableViewer(composite, 67586);
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 300;
        gd.horizontalSpan = 2;
        this.mappingViewer.getTable().setLayoutData((Object)gd);
        this.mappingViewer.getTable().setLinesVisible(true);
        this.mappingViewer.getTable().setHeaderVisible(true);
        this.mappingViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.mappingViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f') {
                    TableItem[] tableItemArray = ColumnsMappingDialog.this.mappingViewer.getTable().getSelection();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        DatabaseMappingAttribute attribute = (DatabaseMappingAttribute)item.getData();
                        attribute.setMappingType(DatabaseMappingType.skip);
                        ++n2;
                    }
                    ColumnsMappingDialog.this.mappingViewer.refresh();
                } else if (e.character == ' ') {
                    TableItem[] tableItemArray = ColumnsMappingDialog.this.mappingViewer.getTable().getSelection();
                    int n = tableItemArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TableItem item = tableItemArray[n3];
                        DatabaseMappingAttribute attribute = (DatabaseMappingAttribute)item.getData();
                        attribute.setMappingType(DatabaseMappingType.existing);
                        try {
                            attribute.updateMappingType((DBRProgressMonitor)new VoidProgressMonitor());
                        }
                        catch (DBException e1) {
                            DBWorkbench.getPlatformUI().showError("Bad mapping", "Invalid column mapping", (Throwable)e1);
                        }
                        ++n3;
                    }
                    ColumnsMappingDialog.this.mappingViewer.refresh();
                }
            }
        });
        TableViewerColumn columnSource = new TableViewerColumn(this.mappingViewer, 16384);
        columnSource.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)cell.getElement();
                cell.setText(DBUtils.getObjectFullName((DBPNamedObject)attrMapping.getSource(), (DBPEvaluationContext)DBPEvaluationContext.UI));
                if (attrMapping.getIcon() != null) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)attrMapping.getIcon()));
                }
            }
        });
        columnSource.getColumn().setText(DTUIMessages.columns_mapping_dialog_column_source_text);
        columnSource.getColumn().setWidth(170);
        TableViewerColumn columnSourceType = new TableViewerColumn(this.mappingViewer, 16384);
        columnSourceType.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((DatabaseMappingAttribute)cell.getElement()).getSourceType());
            }
        });
        columnSourceType.getColumn().setText(DTUIMessages.columns_mapping_dialog_column_source_type_text);
        columnSourceType.getColumn().setWidth(100);
        TableViewerColumn columnTarget = new TableViewerColumn(this.mappingViewer, 16384);
        columnTarget.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DatabaseMappingAttribute mapping = (DatabaseMappingAttribute)cell.getElement();
                cell.setText(mapping.getTargetName());
                if (mapping.getMappingType() == DatabaseMappingType.unspecified) {
                    cell.setBackground(UIUtils.getSharedTextColors().getColor(SharedTextColors.COLOR_WARNING));
                } else {
                    cell.setBackground(null);
                }
                cell.setFont(ColumnsMappingDialog.this.boldFont);
            }
        });
        columnTarget.getColumn().setText(DTUIMessages.columns_mapping_dialog_column_target_text);
        columnTarget.getColumn().setWidth(170);
        columnTarget.setEditingSupport(new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                try {
                    ArrayList<String> items = new ArrayList<String>();
                    DatabaseMappingAttribute mapping = (DatabaseMappingAttribute)element;
                    if (mapping.getParent().getMappingType() == DatabaseMappingType.existing && mapping.getParent().getTarget() instanceof DBSEntity) {
                        DBSEntity parentEntity = (DBSEntity)mapping.getParent().getTarget();
                        for (DBSEntityAttribute attr : CommonUtils.safeCollection((Collection)parentEntity.getAttributes((DBRProgressMonitor)new VoidProgressMonitor()))) {
                            items.add(attr.getName());
                        }
                    }
                    items.add("[skip]");
                    return new CustomComboBoxCellEditor((ColumnViewer)ColumnsMappingDialog.this.mappingViewer, (Composite)ColumnsMappingDialog.this.mappingViewer.getTable(), items.toArray(new String[0]), 4);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Bad value", "Wrong target column", (Throwable)e);
                    return null;
                }
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((DatabaseMappingAttribute)element).getTargetName();
            }

            /*
             * Exception decompiling
             */
            protected void setValue(Object element, Object value) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        TableViewerColumn columnTargetType = new TableViewerColumn(this.mappingViewer, 16384);
        columnTargetType.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)cell.getElement();
                DBPDataSource dataSource = ColumnsMappingDialog.this.settings.getTargetDataSource((DatabaseMappingObject)attrMapping);
                cell.setText(attrMapping.getTargetType(dataSource, true));
                cell.setFont(ColumnsMappingDialog.this.boldFont);
            }
        });
        columnTargetType.getColumn().setText(DTUIMessages.columns_mapping_dialog_column_target_type_text);
        columnTargetType.getColumn().setWidth(100);
        columnTargetType.setEditingSupport(new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)element;
                TreeSet<String> types = new TreeSet<String>();
                DBPDataSource dataSource = ColumnsMappingDialog.this.settings.getTargetDataSource((DatabaseMappingObject)attrMapping);
                if (dataSource instanceof DBPDataTypeProvider) {
                    for (DBSDataType type : ((DBPDataTypeProvider)dataSource).getLocalDataTypes()) {
                        types.add(type.getName());
                    }
                }
                types.add(attrMapping.getTargetType(dataSource, true));
                return new CustomComboBoxCellEditor((ColumnViewer)ColumnsMappingDialog.this.mappingViewer, (Composite)ColumnsMappingDialog.this.mappingViewer.getTable(), types.toArray(new String[0]), 2048);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)element;
                return attrMapping.getTargetType(ColumnsMappingDialog.this.settings.getTargetDataSource((DatabaseMappingObject)attrMapping), true);
            }

            protected void setValue(Object element, Object value) {
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)element;
                attrMapping.setTargetType(CommonUtils.toString((Object)value));
                ColumnsMappingDialog.this.mappingViewer.refresh(element);
            }
        });
        TableViewerColumn columnType = new TableViewerColumn(this.mappingViewer, 16384);
        columnType.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DatabaseMappingAttribute mapping = (DatabaseMappingAttribute)cell.getElement();
                String text = "";
                switch (mapping.getMappingType()) {
                    case unspecified: {
                        text = "?";
                        break;
                    }
                    case existing: {
                        text = DTUIMessages.columns_mapping_dialog_cell_text_existing;
                        break;
                    }
                    case create: {
                        text = DTUIMessages.columns_mapping_dialog_cell_text_new;
                        break;
                    }
                    case skip: {
                        text = DTUIMessages.columns_mapping_dialog_cell_text_skip;
                    }
                }
                cell.setText(text);
            }
        });
        columnType.getColumn().setText(DTUIMessages.columns_mapping_dialog_column_type_text_mapping);
        columnType.getColumn().setWidth(60);
        this.mappingViewer.setInput(this.attributeMappings);
        return parent;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public boolean close() {
        UIUtils.dispose((Resource)this.boldFont);
        return super.close();
    }
}

