/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLScriptPosition;

public class SQLReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private static final Comparator<SQLScriptPosition> COMPARATOR = Comparator.comparingInt(Position::getOffset).thenComparingInt(Position::getLength);
    private final SQLEditorBase editor;
    private SortedSet<SQLScriptPosition> registeredPositions = new TreeSet<SQLScriptPosition>(COMPARATOR);
    private IDocument document;

    public SQLReconcilingStrategy(SQLEditorBase editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile();
    }

    public void reconcile(IRegion partition) {
        this.reconcile();
    }

    public void initialReconcile() {
        this.reconcile();
    }

    private void reconcile() {
        if (!this.editor.isFoldingEnabled()) {
            return;
        }
        ProjectionAnnotationModel model = this.editor.getAnnotationModel();
        if (model == null) {
            return;
        }
        List<SQLScriptElement> queries = this.editor.extractScriptQueries(0, this.document.getLength(), false, true, false);
        if (queries == null) {
            return;
        }
        this.reconcile(model, queries);
    }

    private void reconcile(ProjectionAnnotationModel model, Iterable<SQLScriptElement> queries) {
        HashMap<ProjectionAnnotation, SQLScriptPosition> newAnnotations = new HashMap<ProjectionAnnotation, SQLScriptPosition>();
        TreeSet<SQLScriptPosition> newRegisteredPositions = new TreeSet<SQLScriptPosition>(COMPARATOR);
        for (SQLScriptElement element : queries) {
            if (!this.deservesFolding(element)) continue;
            SQLScriptPosition position = this.retrievePosition(element);
            newRegisteredPositions.add(position);
            newAnnotations.put(position.getFoldingAnnotation(), position);
        }
        Annotation[] oldAnnotations = (Annotation[])this.registeredPositions.stream().map(SQLScriptPosition::getFoldingAnnotation).toArray(Annotation[]::new);
        model.modifyAnnotations(oldAnnotations, newAnnotations, null);
        this.registeredPositions = newRegisteredPositions;
    }

    private boolean deservesFolding(SQLScriptElement element) {
        int numberOfLines = this.getNumberOfLines(element);
        if (numberOfLines == 1) {
            return false;
        }
        if (element.getOffset() + element.getLength() != this.document.getLength() && this.expandQueryLength(element) == element.getLength()) {
            return numberOfLines > 2;
        }
        return true;
    }

    private int getNumberOfLines(SQLScriptElement element) {
        try {
            return this.document.getLineOfOffset(element.getOffset() + element.getLength()) - this.document.getLineOfOffset(element.getOffset()) + 1;
        }
        catch (BadLocationException e) {
            throw new SQLReconcilingStrategyException(e);
        }
    }

    private int expandQueryLength(SQLScriptElement element) {
        int position;
        for (position = element.getOffset() + element.getLength(); position < this.document.getLength(); ++position) {
            char c = this.unsafeGetChar(position);
            if (c == '\n' && position + 1 < this.document.getLength()) {
                ++position;
                break;
            }
            if (Character.isWhitespace(c)) {
                continue;
            }
            return element.getLength();
        }
        return position - element.getOffset();
    }

    private char unsafeGetChar(int index) {
        try {
            return this.document.getChar(index);
        }
        catch (BadLocationException e) {
            throw new SQLReconcilingStrategyException(e);
        }
    }

    private SQLScriptPosition retrievePosition(SQLScriptElement element) {
        int expandedQueryLength = this.expandQueryLength(element);
        SQLScriptPosition newPosition = new SQLScriptPosition(element.getOffset(), expandedQueryLength, true, new ProjectionAnnotation());
        SortedSet<SQLScriptPosition> registeredPositionsSubset = this.registeredPositions.tailSet(newPosition);
        if (registeredPositionsSubset.isEmpty()) {
            return newPosition;
        }
        SQLScriptPosition firstRegisteredPosition = registeredPositionsSubset.first();
        if (firstRegisteredPosition.equals(newPosition)) {
            return firstRegisteredPosition;
        }
        return newPosition;
    }

    private static class SQLReconcilingStrategyException
    extends RuntimeException {
        private SQLReconcilingStrategyException(Throwable cause) {
            super(cause);
        }
    }
}

