/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.MultiPartName;

public class Sequence
extends ASTNodeAccessImpl
implements MultiPartName {
    private static final int NAME_IDX = 0;
    private static final int SCHEMA_IDX = 1;
    private static final int DATABASE_IDX = 2;
    private static final int SERVER_IDX = 3;
    private List<String> partItems = new ArrayList<String>();
    private List<Parameter> parameters;

    public Sequence() {
    }

    public Sequence(List<String> partItems) {
        this.partItems = new ArrayList<String>(partItems);
        Collections.reverse(this.partItems);
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Database getDatabase() {
        return new Database(this.getIndex(2));
    }

    public void setDatabase(Database database) {
        this.setIndex(2, database.getDatabaseName());
        if (database.getServer() != null) {
            this.setIndex(3, database.getServer().getFullyQualifiedName());
        }
    }

    public String getSchemaName() {
        return this.getIndex(1);
    }

    public void setSchemaName(String string) {
        this.setIndex(1, string);
    }

    public String getName() {
        return this.getIndex(0);
    }

    public void setName(String string) {
        this.setIndex(0, string);
    }

    private void setIndex(int idx, String value) {
        int size = this.partItems.size();
        for (int i = 0; i < idx - size + 1; ++i) {
            this.partItems.add(null);
        }
        this.partItems.set(idx, value);
    }

    private String getIndex(int idx) {
        if (idx < this.partItems.size()) {
            return this.partItems.get(idx);
        }
        return null;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder fqn = new StringBuilder();
        for (int i = this.partItems.size() - 1; i >= 0; --i) {
            String part = this.partItems.get(i);
            if (part == null) {
                part = "";
            }
            fqn.append(part);
            if (i == 0) continue;
            fqn.append(".");
        }
        return fqn.toString();
    }

    public String toString() {
        StringBuilder sql = new StringBuilder(this.getFullyQualifiedName());
        if (this.parameters != null) {
            for (Parameter parameter : this.parameters) {
                sql.append(" ").append(parameter.formatParameter());
            }
        }
        return sql.toString();
    }

    public static class Parameter {
        private final ParameterType option;
        private Long value;

        public Parameter(ParameterType option) {
            this.option = option;
        }

        public Long getValue() {
            return this.value;
        }

        public void setValue(Long value) {
            this.value = value;
        }

        public String formatParameter() {
            switch (this.option) {
                case INCREMENT_BY: {
                    return this.withValue("INCREMENT BY");
                }
                case START_WITH: {
                    return this.withValue("START WITH");
                }
                case MAXVALUE: 
                case MINVALUE: 
                case CACHE: {
                    return this.withValue(this.option.name());
                }
            }
            return this.option.name();
        }

        private String withValue(String prefix) {
            return prefix + " " + this.value;
        }
    }

    public static enum ParameterType {
        INCREMENT_BY,
        START_WITH,
        MAXVALUE,
        NOMAXVALUE,
        MINVALUE,
        NOMINVALUE,
        CYCLE,
        NOCYCLE,
        CACHE,
        NOCACHE,
        ORDER,
        NOORDER,
        KEEP,
        NOKEEP,
        SESSION,
        GLOBAL;

    }
}

