/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceHandler;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPExclusiveResource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.DBAAuthCredentialsProvider;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.SimpleExclusiveLock;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.registry.DataSourceOriginLazy;
import org.jkiss.dbeaver.registry.DataSourceOriginLocal;
import org.jkiss.dbeaver.registry.DataSourcePreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.FilterMapping;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.formatter.DataFormatterProfile;
import org.jkiss.dbeaver.registry.internal.RegistryMessages;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;

public class DataSourceDescriptor
implements DBPDataSourceContainer,
DBPImageProvider,
IAdaptable,
DBPStatefulObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(DataSourceDescriptor.class);
    public static final String[][] CONNECT_VARIABLES = new String[][]{{"host", "target database host"}, {"port", "target database port"}, {"server", "target server name"}, {"database", "target database name"}, {"user", "database user name"}, {"password", "database password (plain)"}, {"url", "connection URL"}, {"connectionType", "connection type"}, {"project.path", "project path"}, {"project.name", "project name"}, {"workspace", "workspace path"}, {"home", "OS user home path"}, {"dbeaver_home", "application install path"}, {"application.path", "application install path"}, {"application.name", "application name"}, {"application.version", "application version"}, {"local.ip", "local IP address"}};
    public static final String CATEGORY_SERVER = "Server";
    public static final String CATEGORY_DRIVER = "Driver";
    @NotNull
    private final DBPDataSourceRegistry registry;
    @NotNull
    private final DBPDataSourceConfigurationStorage storage;
    @NotNull
    private DBPDataSourceOrigin origin;
    private final boolean manageable;
    @NotNull
    private DBPDriver driver;
    @NotNull
    private DBPConnectionConfiguration connectionInfo;
    private DBPConnectionConfiguration resolvedConnectionInfo;
    @NotNull
    private String id;
    private String name;
    private String description;
    private boolean savePassword;
    private boolean connectionReadOnly;
    private List<DBPDataSourcePermission> connectionModifyRestrictions;
    private final Map<String, FilterMapping> filterMap = new HashMap<String, FilterMapping>();
    private DBDDataFormatterProfile formatterProfile;
    @Nullable
    private DBPNativeClientLocation clientHome;
    @Nullable
    private String lockPasswordHash;
    @Nullable
    private DataSourceFolder folder;
    @NotNull
    private DataSourcePreferenceStore preferenceStore;
    @Nullable
    private DBPDataSource dataSource;
    private final List<DBPDataSourceTask> users = new ArrayList<DBPDataSourceTask>();
    private volatile boolean connectFailed = false;
    private volatile Date connectTime = null;
    private volatile boolean disposed = false;
    private volatile boolean connecting = false;
    private boolean temporary;
    private boolean hidden;
    private boolean template;
    private final List<DBRProcessDescriptor> childProcesses = new ArrayList<DBRProcessDescriptor>();
    private DBWNetworkHandler proxyHandler;
    private DBWTunnel tunnelHandler;
    @NotNull
    private DBVModel virtualModel;
    private final DBPExclusiveResource exclusiveLock = new SimpleExclusiveLock();
    private DataSourceNavigatorSettings navigatorSettings;

    public DataSourceDescriptor(@NotNull DBPDataSourceRegistry registry, @NotNull String id, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        this(registry, ((DataSourceRegistry)registry).getDefaultStorage(), DataSourceOriginLocal.INSTANCE, id, driver, connectionInfo);
    }

    public DataSourceDescriptor(@NotNull DBPDataSourceRegistry registry, @NotNull DBPDataSourceConfigurationStorage storage, @NotNull DBPDataSourceOrigin origin, @NotNull String id, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        this.registry = registry;
        this.storage = storage;
        this.origin = origin;
        this.manageable = storage.isDefault();
        this.id = id;
        this.driver = driver;
        this.connectionInfo = connectionInfo;
        this.preferenceStore = new DataSourcePreferenceStore(this);
        this.virtualModel = new DBVModel((DBPDataSourceContainer)this);
        this.navigatorSettings = new DataSourceNavigatorSettings(DataSourceNavigatorSettings.PRESET_FULL.getSettings());
    }

    public DataSourceDescriptor(@NotNull DataSourceDescriptor source, @NotNull DBPDataSourceRegistry registry) {
        this(source, registry, true);
    }

    public DataSourceDescriptor(@NotNull DataSourceDescriptor source, @NotNull DBPDataSourceRegistry registry, boolean setDefaultStorage) {
        this.registry = registry;
        this.storage = setDefaultStorage ? ((DataSourceRegistry)registry).getDefaultStorage() : source.storage;
        this.origin = source.origin;
        this.manageable = setDefaultStorage && ((DataSourceRegistry)registry).getDefaultStorage().isDefault();
        this.id = source.id;
        this.name = source.name;
        this.description = source.description;
        this.savePassword = source.savePassword;
        this.navigatorSettings = new DataSourceNavigatorSettings(source.navigatorSettings);
        this.connectionReadOnly = source.connectionReadOnly;
        this.driver = source.driver;
        this.connectionInfo = source.connectionInfo;
        this.clientHome = source.clientHome;
        this.connectionModifyRestrictions = source.connectionModifyRestrictions == null ? null : new ArrayList<DBPDataSourcePermission>(source.connectionModifyRestrictions);
        this.connectionInfo = new DBPConnectionConfiguration(source.connectionInfo);
        for (Map.Entry<String, FilterMapping> fe : source.filterMap.entrySet()) {
            this.filterMap.put(fe.getKey(), new FilterMapping(fe.getValue()));
        }
        this.lockPasswordHash = source.lockPasswordHash;
        if (source.getRegistry() == registry) {
            this.folder = source.folder;
        } else if (source.folder != null) {
            this.folder = (DataSourceFolder)registry.getFolder(source.folder.getFolderPath());
        }
        this.preferenceStore = new DataSourcePreferenceStore(this);
        this.preferenceStore.setProperties(source.preferenceStore.getProperties());
        this.preferenceStore.setDefaultProperties(source.preferenceStore.getDefaultProperties());
        this.formatterProfile = source.formatterProfile == null || source.formatterProfile.getProfileName().equals(source.getId()) ? null : new DataFormatterProfile(source.formatterProfile.getProfileName(), (DBPPreferenceStore)this.preferenceStore);
        this.virtualModel = new DBVModel((DBPDataSourceContainer)this, source.virtualModel);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            log.warn((Object)"Dispose of already disposed data source");
            return;
        }
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            this.users.clear();
        }
        this.virtualModel.dispose();
        this.disposed = true;
    }

    @Property(name="ID", viewable=false, order=0)
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(@NotNull String id) {
        this.id = id;
    }

    @NotNull
    public DBPDriver getDriver() {
        return this.driver;
    }

    @NotNull
    public DBPDataSourceConfigurationStorage getConfigurationStorage() {
        return this.storage;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public DBPDataSourceOrigin getOrigin() {
        if (this.origin instanceof DataSourceOriginLazy) {
            this.origin = ((DataSourceOriginLazy)this.origin).resolveRealOrigin();
        }
        return this.origin;
    }

    @NotNull
    public DBPPlatform getPlatform() {
        return this.registry.getPlatform();
    }

    public void setDriver(@NotNull DriverDescriptor driver) {
        this.driver = driver;
    }

    @NotNull
    public DBPConnectionConfiguration getConnectionConfiguration() {
        return this.connectionInfo;
    }

    public void setConnectionInfo(@NotNull DBPConnectionConfiguration connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    @NotNull
    public DBPConnectionConfiguration getActualConnectionConfiguration() {
        return this.resolvedConnectionInfo != null ? this.resolvedConnectionInfo : this.connectionInfo;
    }

    @NotNull
    public DataSourceNavigatorSettings getNavigatorSettings() {
        return this.navigatorSettings;
    }

    public void setNavigatorSettings(DBNBrowseSettings copyFrom) {
        this.navigatorSettings = new DataSourceNavigatorSettings(copyFrom);
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(viewable=true, multiline=true, order=2)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public boolean isConnectionReadOnly() {
        return this.connectionReadOnly;
    }

    public void setConnectionReadOnly(boolean connectionReadOnly) {
        this.connectionReadOnly = connectionReadOnly;
    }

    public boolean hasModifyPermission(DBPDataSourcePermission permission) {
        if ((permission == DBPDataSourcePermission.PERMISSION_EDIT_DATA || permission == DBPDataSourcePermission.PERMISSION_EDIT_METADATA) && this.connectionReadOnly) {
            return false;
        }
        if (CommonUtils.isEmpty(this.connectionModifyRestrictions)) {
            return this.getConnectionConfiguration().getConnectionType().hasModifyPermission(permission);
        }
        return !this.connectionModifyRestrictions.contains(permission);
    }

    public List<DBPDataSourcePermission> getModifyPermission() {
        if (CommonUtils.isEmpty(this.connectionModifyRestrictions)) {
            return Collections.emptyList();
        }
        return new ArrayList<DBPDataSourcePermission>(this.connectionModifyRestrictions);
    }

    public void setModifyPermissions(@Nullable Collection<DBPDataSourcePermission> permissions) {
        this.connectionModifyRestrictions = CommonUtils.isEmpty(permissions) ? null : new ArrayList<DBPDataSourcePermission>(permissions);
    }

    public boolean isDefaultAutoCommit() {
        if (this.connectionInfo.getBootstrap().getDefaultAutoCommit() != null) {
            return this.connectionInfo.getBootstrap().getDefaultAutoCommit();
        }
        return this.getConnectionConfiguration().getConnectionType().isAutocommit();
    }

    public void setDefaultAutoCommit(boolean autoCommit) {
        if (autoCommit == this.getConnectionConfiguration().getConnectionType().isAutocommit()) {
            this.connectionInfo.getBootstrap().setDefaultAutoCommit(null);
        } else {
            this.connectionInfo.getBootstrap().setDefaultAutoCommit(Boolean.valueOf(autoCommit));
        }
    }

    @Nullable
    public DBPTransactionIsolation getActiveTransactionsIsolation() {
        DBCTransactionManager txnManager;
        DBSInstance defaultInstance;
        if (this.dataSource != null && (defaultInstance = this.dataSource.getDefaultInstance()) != null && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)DBUtils.getDefaultContext((DBSObject)defaultInstance, (boolean)false))) != null) {
            try {
                return txnManager.getTransactionIsolation();
            }
            catch (DBCException e) {
                log.debug((Object)"Can't determine isolation level", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public Integer getDefaultTransactionsIsolation() {
        return this.connectionInfo.getBootstrap().getDefaultTransactionIsolation();
    }

    public void setDefaultTransactionsIsolation(@Nullable DBPTransactionIsolation isolationLevel) {
        if (isolationLevel == null) {
            this.connectionInfo.getBootstrap().setDefaultTransactionIsolation(null);
        } else {
            this.connectionInfo.getBootstrap().setDefaultTransactionIsolation(Integer.valueOf(isolationLevel.getCode()));
        }
    }

    public Collection<FilterMapping> getObjectFilters() {
        return this.filterMap.values();
    }

    @Nullable
    public DBSObjectFilter getObjectFilter(Class<?> type, @Nullable DBSObject parentObject, boolean firstMatch) {
        FilterMapping filterMapping = this.getFilterMapping(type, parentObject, firstMatch);
        if (filterMapping != null) {
            return filterMapping.getFilter(parentObject, firstMatch);
        }
        return null;
    }

    @Nullable
    private FilterMapping getFilterMapping(Class<?> type, @Nullable DBSObject parentObject, boolean firstMatch) {
        if (this.filterMap.isEmpty()) {
            return null;
        }
        Class<?> testType = type;
        while (testType != null) {
            FilterMapping filterMapping = this.getTypeFilterMapping(parentObject, firstMatch, testType);
            if (filterMapping != null) {
                return filterMapping;
            }
            testType = testType.getSuperclass();
        }
        Class<?>[] classArray = type.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            testType = classArray[n2];
            FilterMapping filterMapping = this.getTypeFilterMapping(parentObject, firstMatch, testType);
            if (filterMapping != null) {
                return filterMapping;
            }
            ++n2;
        }
        return null;
    }

    private FilterMapping getTypeFilterMapping(@Nullable DBSObject parentObject, boolean firstMatch, Class<?> testType) {
        DBSObjectFilter filter;
        FilterMapping filterMapping = this.filterMap.get(testType.getName());
        if (filterMapping == null) {
            Class<?>[] classArray = testType.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> it = classArray[n2];
                filterMapping = this.filterMap.get(it.getName());
                if (filterMapping != null && (filter = filterMapping.getFilter(parentObject, firstMatch)) != null && (firstMatch || filter.isEnabled())) {
                    return filterMapping;
                }
                ++n2;
            }
        }
        if (filterMapping != null && (filter = filterMapping.getFilter(parentObject, firstMatch)) != null && (firstMatch || filter.isEnabled())) {
            return filterMapping;
        }
        return null;
    }

    public void setObjectFilter(Class<?> type, DBSObject parentObject, DBSObjectFilter filter) {
        FilterMapping filterMapping = this.getFilterMapping(type, parentObject, true);
        if (filterMapping != null) {
            if (parentObject == null) {
                filterMapping.defaultFilter = filter;
            } else {
                filterMapping.customFilters.put(FilterMapping.getFilterContainerUniqueID(parentObject), filter);
            }
        }
        this.updateObjectFilter(type.getName(), parentObject == null ? null : FilterMapping.getFilterContainerUniqueID(parentObject), filter);
    }

    void clearFilters() {
        this.filterMap.clear();
    }

    void updateObjectFilter(String typeName, @Nullable String objectID, DBSObjectFilter filter) {
        FilterMapping filterMapping = this.filterMap.get(typeName);
        if (filterMapping == null) {
            filterMapping = new FilterMapping(typeName);
            this.filterMap.put(typeName, filterMapping);
        }
        if (objectID == null) {
            filterMapping.defaultFilter = filter;
        } else {
            filterMapping.customFilters.put(objectID, filter);
        }
    }

    @NotNull
    public DBVModel getVirtualModel() {
        return this.virtualModel;
    }

    public boolean hasSharedVirtualModel() {
        return !CommonUtils.equalObjects((Object)this.virtualModel.getId(), (Object)this.getId());
    }

    public void setVirtualModel(@NotNull DBVModel virtualModel) {
        if (virtualModel.getId().equals(this.getId())) {
            this.virtualModel = virtualModel;
            this.virtualModel.setDataSourceContainer((DBPDataSourceContainer)this);
        } else {
            this.virtualModel = new DBVModel((DBPDataSourceContainer)this, virtualModel);
            this.virtualModel.setId(virtualModel.getId());
        }
    }

    public DBPNativeClientLocation getClientHome() {
        if (this.clientHome == null && !CommonUtils.isEmpty((String)this.connectionInfo.getClientHomeId())) {
            this.clientHome = (DBPNativeClientLocation)DBUtils.findObject((Collection)this.driver.getNativeClientLocations(), (String)this.connectionInfo.getClientHomeId());
        }
        return this.clientHome;
    }

    public DBWNetworkHandler[] getActiveNetworkHandlers() {
        DBWNetworkHandler[] dBWNetworkHandlerArray;
        if (this.proxyHandler == null && this.tunnelHandler == null) {
            return new DBWNetworkHandler[0];
        }
        if (this.proxyHandler == null) {
            DBWNetworkHandler[] dBWNetworkHandlerArray2 = new DBWNetworkHandler[1];
            dBWNetworkHandlerArray = dBWNetworkHandlerArray2;
            dBWNetworkHandlerArray2[0] = this.tunnelHandler;
        } else if (this.tunnelHandler == null) {
            DBWNetworkHandler[] dBWNetworkHandlerArray3 = new DBWNetworkHandler[1];
            dBWNetworkHandlerArray = dBWNetworkHandlerArray3;
            dBWNetworkHandlerArray3[0] = this.proxyHandler;
        } else {
            DBWNetworkHandler[] dBWNetworkHandlerArray4 = new DBWNetworkHandler[2];
            dBWNetworkHandlerArray4[0] = this.proxyHandler;
            dBWNetworkHandlerArray = dBWNetworkHandlerArray4;
            dBWNetworkHandlerArray4[1] = this.tunnelHandler;
        }
        return dBWNetworkHandlerArray;
    }

    @NotNull
    DBPDataSourceConfigurationStorage getStorage() {
        return this.storage;
    }

    public boolean isDetached() {
        return this.hidden || this.temporary;
    }

    public boolean isManageable() {
        return this.manageable;
    }

    public boolean isProvided() {
        return !this.storage.isDefault();
    }

    public boolean isExternallyProvided() {
        return this.origin.isDynamic();
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public DBSObject getParentObject() {
        return null;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.dataSource instanceof DBPRefreshableObject) {
            this.dataSource = (DBPDataSource)((DBPRefreshableObject)this.dataSource).refreshObject(monitor);
        } else {
            this.reconnect(monitor, false);
        }
        this.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)this));
        return this;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Date getConnectTime() {
        return this.connectTime;
    }

    @NotNull
    public SQLDialectMetadata getScriptDialect() {
        return this.driver.getScriptDialect();
    }

    public boolean isLocked() {
        return !CommonUtils.isEmpty((String)this.lockPasswordHash);
    }

    @Nullable
    public String getLockPasswordHash() {
        return this.lockPasswordHash;
    }

    void setLockPasswordHash(@Nullable String lockPasswordHash) {
        this.lockPasswordHash = lockPasswordHash;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @Nullable
    public DataSourceFolder getFolder() {
        return this.folder;
    }

    public void setFolder(@Nullable DBPDataSourceFolder folder) {
        this.folder = (DataSourceFolder)folder;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public DBPDataSourceRegistry getRegistry() {
        return this.registry;
    }

    @NotNull
    public DBPProject getProject() {
        return this.registry.getProject();
    }

    public void persistConfiguration() {
        this.registry.flushConfig();
    }

    public boolean isConnected() {
        return this.dataSource != null;
    }

    public boolean connect(DBRProgressMonitor monitor, boolean initialize, boolean reflect) throws DBException {
        if (this.connecting) {
            log.debug((Object)"Can't connect - connect/disconnect is in progress");
            return false;
        }
        if (this.isConnected()) {
            log.debug((Object)"Can't connect - already connected");
            return false;
        }
        log.debug((Object)("Connect with '" + this.getName() + "' (" + this.getId() + ")"));
        this.resolvedConnectionInfo = new DBPConnectionConfiguration(this.connectionInfo);
        boolean authProvided = true;
        DBAAuthCredentialsProvider authProvider = this.registry.getAuthCredentialsProvider();
        if (authProvider != null) {
            authProvided = authProvider.provideAuthParameters((DBPDataSourceContainer)this, this.resolvedConnectionInfo);
        } else if (!this.isSavePassword() && !this.getDriver().isAnonymousAccess()) {
            authProvided = DataSourceDescriptor.askForPassword(this, null, false);
        }
        if (!authProvided) {
            this.updateDataSourceObject(this);
            return false;
        }
        this.processEvents(monitor, DBPConnectionEventType.BEFORE_CONNECT);
        this.connecting = true;
        try {
            if (this.preferenceStore.getBoolean("database.connect.processEnvVars") || !CommonUtils.isEmpty((String)this.connectionInfo.getConfigProfileName())) {
                DBWNetworkProfile profile;
                if (!CommonUtils.isEmpty((String)this.connectionInfo.getConfigProfileName()) && (profile = this.registry.getNetworkProfile(this.resolvedConnectionInfo.getConfigProfileName())) != null) {
                    for (DBWHandlerConfiguration handlerCfg : profile.getConfigurations()) {
                        if (!handlerCfg.isEnabled()) continue;
                        this.resolvedConnectionInfo.updateHandler(new DBWHandlerConfiguration(handlerCfg));
                    }
                }
                if (this.preferenceStore.getBoolean("database.connect.processEnvVars")) {
                    DataSourceVariableResolver variableResolver = new DataSourceVariableResolver((DBPDataSourceContainer)this, this.resolvedConnectionInfo);
                    this.resolvedConnectionInfo.resolveDynamicVariables((IVariableResolver)variableResolver);
                }
            }
            this.proxyHandler = null;
            this.tunnelHandler = null;
            DBWHandlerConfiguration tunnelConfiguration = null;
            DBWHandlerConfiguration proxyConfiguration = null;
            for (DBWHandlerConfiguration handler : this.resolvedConnectionInfo.getHandlers()) {
                if (!handler.isEnabled()) continue;
                handler.setDataSource((DBPDataSourceContainer)this);
                if (handler.getType() == DBWHandlerType.TUNNEL) {
                    tunnelConfiguration = handler;
                    continue;
                }
                if (handler.getType() != DBWHandlerType.PROXY) continue;
                proxyConfiguration = handler;
            }
            String target = this.getActualConnectionConfiguration().getUrl();
            if (CommonUtils.isEmpty((String)target)) {
                target = this.getName();
            }
            monitor.beginTask("Connect to " + target, tunnelConfiguration != null ? 3 : 2);
            Object dsLock = this.exclusiveLock.acquireExclusiveLock();
            try {
                if (proxyConfiguration != null) {
                    monitor.subTask("Initialize proxy");
                    this.proxyHandler = proxyConfiguration.createHandler(DBWNetworkHandler.class);
                    this.proxyHandler.initializeHandler(monitor, this.registry.getPlatform(), proxyConfiguration, this.resolvedConnectionInfo);
                }
                if (tunnelConfiguration != null) {
                    block43: {
                        monitor.subTask("Initialize tunnel");
                        this.tunnelHandler = (DBWTunnel)tunnelConfiguration.createHandler(DBWTunnel.class);
                        try {
                            DBWTunnel.AuthCredentials rc;
                            if (tunnelConfiguration.isSavePassword() || (rc = this.tunnelHandler.getRequiredCredentials(tunnelConfiguration)) == DBWTunnel.AuthCredentials.NONE || DataSourceDescriptor.askForPassword(this, tunnelConfiguration, rc == DBWTunnel.AuthCredentials.PASSWORD)) break block43;
                            this.updateDataSourceObject(this);
                            this.tunnelHandler = null;
                            return false;
                        }
                        catch (Exception e) {
                            throw new DBCException("Can't initialize tunnel", (Throwable)e);
                        }
                    }
                    DBExecUtils.startContextInitiation((DBPDataSourceContainer)this);
                    try {
                        this.resolvedConnectionInfo = this.tunnelHandler.initializeHandler(monitor, this.registry.getPlatform(), tunnelConfiguration, this.resolvedConnectionInfo);
                    }
                    finally {
                        DBExecUtils.finishContextInitiation((DBPDataSourceContainer)this);
                    }
                    monitor.worked(1);
                }
                monitor.subTask("Connect to data source");
                this.dataSource = this.getDriver().getDataSourceProvider().openDataSource(monitor, (DBPDataSourceContainer)this);
                this.connectTime = new Date();
                monitor.worked(1);
                if (initialize) {
                    monitor.subTask("Initialize data source");
                    try {
                        this.dataSource.initialize(monitor);
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error initializing datasource", e);
                        throw e;
                    }
                }
                this.connectFailed = false;
            }
            finally {
                this.exclusiveLock.releaseExclusiveLock(dsLock);
            }
            this.processEvents(monitor, DBPConnectionEventType.AFTER_CONNECT);
            if (reflect) {
                this.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)this, true));
            }
            try {
                log.debug((Object)("Connected (" + this.getId() + ", " + this.getPropertyDriver() + ")"));
            }
            catch (Throwable throwable) {
                log.debug((Object)("Connected (" + this.getId() + ", driver unknown)"));
            }
            return true;
        }
        catch (Exception e) {
            block47: {
                log.debug((Object)("Connection failed (" + this.getId() + ")"));
                if (this.tunnelHandler != null) {
                    try {
                        try {
                            this.tunnelHandler.closeTunnel(monitor);
                        }
                        catch (IOException iOException) {
                            log.error((Object)"Error closing tunnel", (Throwable)e);
                            this.tunnelHandler = null;
                            break block47;
                        }
                    }
                    catch (Throwable throwable) {
                        this.tunnelHandler = null;
                        throw throwable;
                    }
                    this.tunnelHandler = null;
                }
            }
            this.proxyHandler = null;
            this.connectFailed = true;
            this.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)this, false));
            if (e instanceof DBException) {
                throw (DBException)e;
            }
            throw new DBException("Internal error connecting to " + this.getName(), (Throwable)e);
        }
        finally {
            monitor.done();
            this.connecting = false;
        }
    }

    private void processEvents(DBRProgressMonitor monitor, DBPConnectionEventType eventType) {
        DBPConnectionConfiguration info = this.getActualConnectionConfiguration();
        DBRShellCommand command = info.getEvent(eventType);
        if (command != null && command.isEnabled()) {
            final DBRProcessDescriptor processDescriptor = new DBRProcessDescriptor(command, this.getVariablesResolver(true));
            monitor.subTask("Execute process " + processDescriptor.getName());
            DBWorkbench.getPlatformUI().executeProcess(processDescriptor);
            new AbstractJob(String.valueOf(processDescriptor.getName()) + ": output reader"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        String output = processDescriptor.dumpErrors();
                        log.debug((Object)("Process error output:\n" + output));
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
            if (command.isWaitProcessFinish()) {
                int resultCode = command.getWaitProcessTimeoutMs() >= 0 ? processDescriptor.waitFor(command.getWaitProcessTimeoutMs()) : processDescriptor.waitFor();
                log.debug((Object)(String.valueOf(processDescriptor.getName()) + " result code: " + resultCode));
            }
            this.addChildProcess(processDescriptor);
        }
    }

    public boolean disconnect(DBRProgressMonitor monitor) {
        return this.disconnect(monitor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disconnect(DBRProgressMonitor monitor, boolean reflect) {
        if (this.dataSource == null) {
            log.error((Object)"Datasource is not connected");
            return true;
        }
        if (this.connecting) {
            log.error((Object)"Connect/disconnect is in progress");
            return false;
        }
        this.connecting = true;
        try {
            this.releaseDataSourceUsers(monitor);
            monitor.beginTask("Disconnect from '" + this.getName() + "'", 5 + this.dataSource.getAvailableInstances().size());
            this.processEvents(monitor, DBPConnectionEventType.BEFORE_DISCONNECT);
            monitor.worked(1);
            monitor.subTask("Close connection");
            if (this.dataSource != null) {
                this.dataSource.shutdown(monitor);
            }
            monitor.worked(1);
            if (this.tunnelHandler != null) {
                monitor.subTask("Close tunnel");
                try {
                    this.tunnelHandler.closeTunnel(monitor);
                }
                catch (Throwable e) {
                    log.error((Object)"Error closing tunnel", e);
                }
            }
            monitor.worked(1);
            this.proxyHandler = null;
            this.processEvents(monitor, DBPConnectionEventType.AFTER_DISCONNECT);
            monitor.worked(1);
            monitor.done();
            List<DBRProcessDescriptor> list = this.childProcesses;
            synchronized (list) {
                Iterator<DBRProcessDescriptor> iter = this.childProcesses.iterator();
                while (iter.hasNext()) {
                    DBRProcessDescriptor process = iter.next();
                    if (process.isRunning() && process.getCommand().isTerminateAtDisconnect()) {
                        process.terminate();
                    }
                    iter.remove();
                }
            }
            this.dataSource = null;
            this.resolvedConnectionInfo = null;
            this.connectTime = null;
            if (reflect) {
                this.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)this, false));
            }
            return true;
        }
        finally {
            this.connecting = false;
            log.debug((Object)("Disconnected (" + this.getId() + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDataSourceUsers(DBRProgressMonitor monitor) {
        ArrayList<DBPDataSourceTask> usersStamp;
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            usersStamp = new ArrayList<DBPDataSourceTask>(this.users);
        }
        int jobCount = 0;
        for (DBPDataSourceTask user : usersStamp) {
            if (user instanceof Job) {
                ++jobCount;
            }
            if (!(user instanceof DBPDataSourceHandler)) continue;
            ((DBPDataSourceHandler)user).beforeDisconnect();
        }
        if (jobCount > 0) {
            monitor.beginTask("Waiting for all active tasks to finish", jobCount);
            for (DBPDataSourceTask user : usersStamp) {
                if (!(user instanceof Job)) continue;
                Job job = (Job)user;
                monitor.subTask("Stop '" + job.getName() + "'");
                if (job.getState() == 4) {
                    job.cancel();
                    try {
                        int i = 0;
                        while (i < 30) {
                            Thread.sleep(100L);
                            if (job.getState() == 4) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                monitor.worked(1);
            }
            monitor.done();
        }
    }

    public boolean reconnect(DBRProgressMonitor monitor) throws DBException {
        return this.reconnect(monitor, true);
    }

    public boolean reconnect(DBRProgressMonitor monitor, boolean reflect) throws DBException {
        if (this.connecting) {
            log.debug((Object)"Can't reconnect - connect/disconnect is in progress");
            return false;
        }
        if (this.isConnected() && !this.disconnect(monitor, reflect)) {
            return false;
        }
        return this.connect(monitor, true, reflect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DBPDataSourceTask> getTasks() {
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            return new ArrayList<DBPDataSourceTask>(this.users);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(DBPDataSourceTask user) {
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            if (this.users.contains(user)) {
                log.warn((Object)("Datasource user '" + user + "' already registered in datasource '" + this.getName() + "'"));
            } else {
                this.users.add(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DBPDataSourceTask user) {
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            if (!this.users.remove(user) && !this.isDisposed()) {
                log.warn((Object)("Datasource user '" + user + "' is not registered in datasource '" + this.getName() + "'"));
            }
        }
    }

    public void fireEvent(DBPEvent event) {
        this.registry.notifyDataSourceListeners(event);
    }

    public DBDDataFormatterProfile getDataFormatterProfile() {
        if (this.formatterProfile == null) {
            this.formatterProfile = new DataFormatterProfile(this.getId(), (DBPPreferenceStore)this.preferenceStore);
        }
        return this.formatterProfile;
    }

    public boolean isUseNativeDateTimeFormat() {
        return this.getPreferenceStore().getBoolean("resultset.format.datetime.native");
    }

    public boolean isUseNativeNumericFormat() {
        return this.getPreferenceStore().getBoolean("resultset.format.numeric.native");
    }

    public boolean isUseScientificNumericFormat() {
        return this.getPreferenceStore().getBoolean("resultset.format.numeric.scientific");
    }

    @NotNull
    public DBDValueHandler getDefaultValueHandler() {
        if (this.dataSource instanceof DBDFormatSettings) {
            return ((DBDFormatSettings)this.dataSource).getDefaultValueHandler();
        }
        return DefaultValueHandler.INSTANCE;
    }

    @NotNull
    public DataSourcePreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void resetPassword() {
        this.connectionInfo.setUserPassword(null);
    }

    @Nullable
    public <T> T getAdapter(Class<T> adapter) {
        if (DBPDataSourceContainer.class.isAssignableFrom(adapter)) {
            return adapter.cast(this);
        }
        if (adapter == DBPPropertySource.class) {
            PropertyCollector coll = new PropertyCollector((Object)this, true);
            coll.collectProperties();
            if (this.dataSource != null) {
                int conIndex = 0;
                for (DBSInstance instance : this.dataSource.getAvailableInstances()) {
                    DBCExecutionContext[] dBCExecutionContextArray = instance.getAllContexts();
                    int n = dBCExecutionContextArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBCExecutionContext context = dBCExecutionContextArray[n2];
                        coll.addProperty("Connections", String.valueOf(++conIndex), String.valueOf(conIndex), (Object)new ContextInfo(context));
                        ++n2;
                    }
                }
            }
            return adapter.cast(coll);
        }
        return null;
    }

    @NotNull
    public DBPImage getObjectImage() {
        return this.driver.getPlainIcon();
    }

    @NotNull
    public DBSObjectState getObjectState() {
        if (this.isConnected()) {
            return DBSObjectState.ACTIVE;
        }
        if (this.connectFailed) {
            return DBSObjectState.INVALID;
        }
        return DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) {
    }

    public static String generateNewId(DBPDriver driver) {
        long rnd = new Random().nextLong();
        if (rnd < 0L) {
            rnd = -rnd;
        }
        return String.valueOf(driver.getId()) + "-" + Long.toHexString(System.currentTimeMillis()) + "-" + Long.toHexString(rnd);
    }

    @Property(viewable=true, order=20, category="Driver")
    public String getPropertyDriverType() {
        return this.driver.getName();
    }

    @Property(order=30, category="Server")
    public String getPropertyAddress() {
        StringBuilder addr = new StringBuilder();
        if (!CommonUtils.isEmpty((String)this.connectionInfo.getHostName())) {
            addr.append(this.connectionInfo.getHostName());
        }
        if (!CommonUtils.isEmpty((String)this.connectionInfo.getHostPort())) {
            addr.append(':').append(this.connectionInfo.getHostPort());
        }
        return addr.toString();
    }

    @Property(order=31, category="Server")
    public String getPropertyDatabase() {
        return this.connectionInfo.getDatabaseName();
    }

    @Property(order=32, category="Server")
    public String getPropertyURL() {
        return this.connectionInfo.getUrl();
    }

    @Property(order=33, category="Server")
    @Nullable
    public String getPropertyServerName() {
        if (this.dataSource != null) {
            String serverName = this.dataSource.getInfo().getDatabaseProductName();
            String serverVersion = this.dataSource.getInfo().getDatabaseProductVersion();
            if (serverName != null) {
                return String.valueOf(serverName) + (serverVersion == null ? "" : " [" + serverVersion + "]");
            }
        }
        return null;
    }

    @Property(order=34, category="Server")
    @Nullable
    public Map<String, Object> getPropertyServerDetails() {
        if (this.dataSource != null) {
            return this.dataSource.getInfo().getDatabaseProductDetails();
        }
        return null;
    }

    @Property(order=21, category="Driver")
    @Nullable
    public String getPropertyDriver() {
        if (this.dataSource != null) {
            String driverName = this.dataSource.getInfo().getDriverName();
            String driverVersion = this.dataSource.getInfo().getDriverVersion();
            if (driverName != null) {
                return String.valueOf(driverName) + (driverVersion == null ? "" : " [" + driverVersion + "]");
            }
        }
        return null;
    }

    @Property(order=8)
    @Nullable
    public String getPropertyConnectTime() {
        if (this.connectTime != null) {
            return DateFormat.getDateTimeInstance(3, 3).format(this.connectTime);
        }
        return null;
    }

    @Property(order=9)
    public String getPropertyConnectType() {
        return this.connectionInfo.getConnectionType().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildProcess(DBRProcessDescriptor process) {
        List<DBRProcessDescriptor> list = this.childProcesses;
        synchronized (list) {
            this.childProcesses.add(process);
        }
    }

    public void copyFrom(DataSourceDescriptor descriptor) {
        this.filterMap.clear();
        for (FilterMapping mapping : descriptor.getObjectFilters()) {
            this.filterMap.put(mapping.typeName, new FilterMapping(mapping));
        }
        this.virtualModel.copyFrom(descriptor.getVirtualModel());
        this.description = descriptor.description;
        this.savePassword = descriptor.savePassword;
        this.connectionReadOnly = descriptor.connectionReadOnly;
        this.navigatorSettings = new DataSourceNavigatorSettings(descriptor.getNavigatorSettings());
    }

    @NotNull
    public ISecurePreferences getSecurePreferences() {
        return this.registry.getSecurePreferences().node(this.id);
    }

    public String toString() {
        return String.valueOf(this.name) + " [" + this.driver + "]";
    }

    public boolean equalSettings(Object obj) {
        if (!(obj instanceof DataSourceDescriptor)) {
            return false;
        }
        DataSourceDescriptor source = (DataSourceDescriptor)obj;
        return CommonUtils.equalOrEmptyStrings((String)this.name, (String)source.name) && CommonUtils.equalOrEmptyStrings((String)this.description, (String)source.description) && CommonUtils.equalObjects((Object)this.savePassword, (Object)source.savePassword) && CommonUtils.equalObjects((Object)this.connectionReadOnly, (Object)source.connectionReadOnly) && CommonUtils.equalObjects((Object)this.navigatorSettings, (Object)source.navigatorSettings) && CommonUtils.equalObjects((Object)this.driver, (Object)source.driver) && CommonUtils.equalObjects((Object)this.connectionInfo, (Object)source.connectionInfo) && CommonUtils.equalObjects(this.filterMap, source.filterMap) && CommonUtils.equalObjects((Object)this.formatterProfile, (Object)source.formatterProfile) && CommonUtils.equalObjects((Object)this.clientHome, (Object)source.clientHome) && CommonUtils.equalObjects((Object)this.lockPasswordHash, (Object)source.lockPasswordHash) && CommonUtils.equalObjects((Object)this.folder, (Object)source.folder) && CommonUtils.equalObjects((Object)((Object)this.preferenceStore), (Object)((Object)source.preferenceStore)) && CommonUtils.equalsContents(this.connectionModifyRestrictions, source.connectionModifyRestrictions);
    }

    public IVariableResolver getVariablesResolver(boolean actualConfig) {
        return name -> {
            DBPConnectionConfiguration configuration = actualConfig ? this.getActualConnectionConfiguration() : this.getConnectionConfiguration();
            String propValue = (String)configuration.getProperties().get(name);
            if (propValue != null) {
                return propValue;
            }
            switch (name = name.toLowerCase(Locale.ENGLISH)) {
                case "host": {
                    return configuration.getHostName();
                }
                case "port": {
                    return configuration.getHostPort();
                }
                case "server": {
                    return configuration.getServerName();
                }
                case "database": {
                    return configuration.getDatabaseName();
                }
                case "user": {
                    return configuration.getUserName();
                }
                case "password": {
                    return configuration.getUserPassword();
                }
                case "url": {
                    return configuration.getUrl();
                }
                case "connectionType": {
                    return configuration.getConnectionType().getId();
                }
            }
            return SystemVariablesResolver.INSTANCE.get(name);
        };
    }

    public DBPDataSourceContainer createCopy(DBPDataSourceRegistry forRegistry) {
        DataSourceDescriptor copy = new DataSourceDescriptor(this, forRegistry, true);
        copy.setId(DataSourceDescriptor.generateNewId(copy.getDriver()));
        return copy;
    }

    public DBPExclusiveResource getExclusiveLock() {
        return this.exclusiveLock;
    }

    public static boolean askForPassword(@NotNull DataSourceDescriptor dataSourceContainer, @Nullable DBWHandlerConfiguration networkHandler, boolean passwordOnly) {
        DBPConnectionConfiguration actualConfig = dataSourceContainer.getActualConnectionConfiguration();
        DBPConnectionConfiguration connConfig = dataSourceContainer.getConnectionConfiguration();
        String prompt = networkHandler != null ? NLS.bind((String)RegistryMessages.dialog_connection_auth_title_for_handler, (Object)networkHandler.getTitle()) : "'" + dataSourceContainer.getName() + RegistryMessages.dialog_connection_auth_title;
        String user = networkHandler != null ? networkHandler.getUserName() : actualConfig.getUserName();
        String password = networkHandler != null ? networkHandler.getPassword() : actualConfig.getUserPassword();
        DBPAuthInfo authInfo = DBWorkbench.getPlatformUI().promptUserCredentials(prompt, user, password, passwordOnly, !dataSourceContainer.isTemporary());
        if (authInfo == null) {
            return false;
        }
        if (networkHandler != null) {
            if (!passwordOnly) {
                networkHandler.setUserName(authInfo.getUserName());
            }
            networkHandler.setPassword(authInfo.getUserPassword());
            networkHandler.setSavePassword(authInfo.isSavePassword());
            actualConfig.updateHandler(networkHandler);
            if (authInfo.isSavePassword() && connConfig != actualConfig) {
                connConfig.updateHandler(networkHandler);
            }
        } else {
            if (!passwordOnly) {
                actualConfig.setUserName(authInfo.getUserName());
            }
            actualConfig.setUserPassword(authInfo.getUserPassword());
            dataSourceContainer.setSavePassword(authInfo.isSavePassword());
        }
        if (authInfo.isSavePassword()) {
            if (authInfo.isSavePassword() && connConfig != actualConfig) {
                if (!passwordOnly) {
                    connConfig.setUserName(authInfo.getUserName());
                }
                connConfig.setUserPassword(authInfo.getUserPassword());
            }
            dataSourceContainer.getRegistry().updateDataSource((DBPDataSourceContainer)dataSourceContainer);
        }
        return true;
    }

    public void updateDataSourceObject(DataSourceDescriptor dataSourceDescriptor) {
        this.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)dataSourceDescriptor, false));
    }

    public static class ContextInfo
    implements DBPObject {
        private final DBCExecutionContext context;

        public ContextInfo(DBCExecutionContext context) {
            this.context = context;
        }

        @Property(viewable=true, order=1)
        public String getName() {
            return this.context.getContextName();
        }

        public String toString() {
            return this.getName();
        }
    }
}

