/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLNativeCredentialsSettings;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolHandler;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.utils.CommonUtils;

public abstract class MySQLNativeToolHandler<SETTINGS extends AbstractNativeToolSettings<BASE_OBJECT>, BASE_OBJECT extends DBSObject, PROCESS_ARG>
extends AbstractNativeToolHandler<SETTINGS, BASE_OBJECT, PROCESS_ARG> {
    private File config;

    protected boolean doExecute(DBRProgressMonitor monitor, DBTTask task, SETTINGS settings, Log log) throws DBException, InterruptedException {
        try {
            boolean bl = super.doExecute(monitor, task, settings, log);
            return bl;
        }
        finally {
            if (this.config != null && !this.config.delete()) {
                log.debug((Object)"Failed to delete configuration file");
            }
        }
    }

    protected void setupProcessParameters(SETTINGS settings, PROCESS_ARG arg, ProcessBuilder process) {
        if (!this.isOverrideCredentials(settings)) {
            String toolUserPassword = settings.getToolUserPassword();
            if (CommonUtils.isEmpty((String)settings.getToolUserName())) {
                toolUserPassword = settings.getDataSourceContainer().getActualConnectionConfiguration().getUserPassword();
            }
            if (CommonUtils.isNotEmpty((String)toolUserPassword)) {
                process.environment().put("MYSQL_PWD", toolUserPassword);
            }
        }
    }

    protected List<String> getCommandLine(SETTINGS settings, PROCESS_ARG arg) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        this.fillProcessParameters((AbstractNativeToolSettings)settings, arg, cmd);
        String toolUserName = settings.getToolUserName();
        String toolUserPassword = settings.getToolUserPassword();
        if (CommonUtils.isEmpty((String)toolUserName)) {
            toolUserName = settings.getDataSourceContainer().getActualConnectionConfiguration().getUserName();
            toolUserPassword = settings.getDataSourceContainer().getActualConnectionConfiguration().getUserPassword();
        }
        if (this.isOverrideCredentials(settings)) {
            this.config = MySQLNativeToolHandler.createCredentialsFile(toolUserName, toolUserPassword);
            cmd.add(1, "--defaults-file=" + this.config.getAbsolutePath());
        } else {
            cmd.add("-u");
            cmd.add(toolUserName);
        }
        DBPConnectionConfiguration connectionInfo = settings.getDataSourceContainer().getActualConnectionConfiguration();
        cmd.add("--host=" + connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            cmd.add("--port=" + connectionInfo.getHostPort());
        }
        return cmd;
    }

    private static File createCredentialsFile(String username, String password) throws IOException {
        File dir = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "mysql-native-handler");
        File cnf = new File(dir, ".my.cnf");
        cnf.deleteOnExit();
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileWriter writer = new FileWriter(cnf);){
            writer.write("[client]");
            writer.write("\nuser=" + CommonUtils.notEmpty((String)username));
            writer.write("\npassword=" + CommonUtils.notEmpty((String)password));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return cnf;
    }

    private boolean isOverrideCredentials(SETTINGS settings) {
        if (settings instanceof MySQLNativeCredentialsSettings) {
            return ((MySQLNativeCredentialsSettings)settings).isOverrideCredentials();
        }
        return false;
    }
}

