/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class LinuxKeyboardArrowsListener
implements KeyListener {
    private final Tree tree;
    @Nullable
    private TreeItem item;
    private boolean wasExpanded;

    private LinuxKeyboardArrowsListener(Tree tree) {
        this.tree = tree;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode != 0x1000003) {
            return;
        }
        TreeItem[] items = this.tree.getSelection();
        if (items.length != 1) {
            return;
        }
        this.item = items[0];
        this.wasExpanded = this.item.getExpanded();
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode != 0x1000003 || this.wasExpanded || this.item == null) {
            return;
        }
        TreeItem parentItem = this.item.getParentItem();
        if (parentItem == null) {
            return;
        }
        this.tree.setSelection(parentItem);
        this.tree.showSelection();
        this.item = null;
    }

    public static void installOn(Tree tree) {
        if (GeneralUtils.isLinux()) {
            tree.addKeyListener((KeyListener)new LinuxKeyboardArrowsListener(tree));
        }
    }
}

