/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;

public class SQLReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private final NavigableSet<SQLScriptElementImpl> cache = new TreeSet<SQLScriptElementImpl>();
    private final SQLEditorBase editor;
    private IDocument document;

    public SQLReconcilingStrategy(SQLEditorBase editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if ("__insert".equals(dirtyRegion.getType())) {
            this.reconcile(subRegion.getOffset(), subRegion.getLength());
        } else {
            this.reconcile(subRegion.getOffset(), 0);
        }
    }

    public void reconcile(IRegion partition) {
        this.reconcile(partition.getOffset(), partition.getLength());
    }

    public void initialReconcile() {
        this.reconcile(0, this.document.getLength());
    }

    public void onDataSourceChange() {
        if (this.document == null) {
            return;
        }
        this.initialReconcile();
    }

    private void reconcile(int damagedRegionOffset, int damagedRegionLength) {
        SQLScriptElement rightmostParsedQuery;
        SQLScriptElementImpl rightBound;
        List<SQLScriptElement> parsedQueries;
        if (!this.editor.isFoldingEnabled()) {
            return;
        }
        ProjectionAnnotationModel model = this.editor.getAnnotationModel();
        if (model == null) {
            return;
        }
        SQLScriptElementImpl leftBound = this.cache.lower(new SQLScriptElementImpl(damagedRegionOffset, damagedRegionLength));
        if (leftBound != null) {
            leftBound = this.cache.lower(leftBound);
        }
        if ((parsedQueries = this.extractQueries(damagedRegionOffset = leftBound == null ? 0 : leftBound.getOffset() + leftBound.getLength(), damagedRegionLength = (rightBound = this.cache.ceiling(new SQLScriptElementImpl(damagedRegionOffset + damagedRegionLength, 0))) == null ? this.document.getLength() : rightBound.getOffset() + rightBound.getLength() - damagedRegionOffset)) == null) {
            return;
        }
        if (rightBound != null && !parsedQueries.isEmpty() && !rightBound.equals(new SQLScriptElementImpl((rightmostParsedQuery = parsedQueries.get(parsedQueries.size() - 1)).getOffset(), this.expandQueryLength(rightmostParsedQuery)))) {
            parsedQueries = this.extractQueries(damagedRegionOffset, this.document.getLength());
            if (parsedQueries == null) {
                return;
            }
            rightBound = null;
        }
        NavigableSet<SQLScriptElementImpl> cachedQueries = leftBound == null && rightBound == null ? Collections.unmodifiableNavigableSet(this.cache) : (leftBound == null ? Collections.unmodifiableNavigableSet(this.cache.headSet(rightBound, true)) : (rightBound == null ? Collections.unmodifiableNavigableSet(this.cache.tailSet(leftBound, false)) : Collections.unmodifiableNavigableSet(this.cache.subSet(leftBound, false, rightBound, true))));
        List parsedElements = parsedQueries.stream().filter(this::deservesFolding).map(element -> new SQLScriptElementImpl(element.getOffset(), this.expandQueryLength((SQLScriptElement)element))).collect(Collectors.toList());
        HashMap<ProjectionAnnotation, SQLScriptElementImpl> additions = new HashMap<ProjectionAnnotation, SQLScriptElementImpl>();
        for (SQLScriptElementImpl element2 : parsedElements) {
            if (cachedQueries.contains(element2)) continue;
            element2.setAnnotation(new ProjectionAnnotation());
            additions.put(element2.getAnnotation(), element2);
        }
        Collection deletedPositions = cachedQueries.stream().filter(element -> !parsedElements.contains(element)).collect(Collectors.toList());
        Annotation[] deletions = (Annotation[])deletedPositions.stream().map(SQLScriptElementImpl::getAnnotation).toArray(Annotation[]::new);
        model.modifyAnnotations(deletions, additions, null);
        this.cache.removeAll(deletedPositions);
        this.cache.addAll(additions.values());
    }

    @Nullable
    private List<SQLScriptElement> extractQueries(int offset, int length) {
        return this.editor.extractScriptQueries(offset, length, false, true, false);
    }

    private boolean deservesFolding(SQLScriptElement element) {
        int numberOfLines = this.getNumberOfLines(element);
        if (numberOfLines == 1) {
            return false;
        }
        if (element.getOffset() + element.getLength() != this.document.getLength() && this.expandQueryLength(element) == element.getLength()) {
            return numberOfLines > 2;
        }
        return true;
    }

    private int getNumberOfLines(SQLScriptElement element) {
        try {
            return this.document.getLineOfOffset(element.getOffset() + element.getLength()) - this.document.getLineOfOffset(element.getOffset()) + 1;
        }
        catch (BadLocationException e) {
            throw new SQLReconcilingStrategyException(e);
        }
    }

    private int expandQueryLength(SQLScriptElement element) {
        int position;
        for (position = element.getOffset() + element.getLength(); position < this.document.getLength(); ++position) {
            char c = this.unsafeGetChar(position);
            if (c == '\n' && position + 1 < this.document.getLength()) {
                ++position;
                break;
            }
            if (Character.isWhitespace(c)) {
                continue;
            }
            return element.getLength();
        }
        return position - element.getOffset();
    }

    private char unsafeGetChar(int index) {
        try {
            return this.document.getChar(index);
        }
        catch (BadLocationException e) {
            throw new SQLReconcilingStrategyException(e);
        }
    }

    private static class SQLReconcilingStrategyException
    extends RuntimeException {
        private SQLReconcilingStrategyException(Throwable cause) {
            super(cause);
        }
    }

    private static class SQLScriptElementImpl
    extends Position
    implements SQLScriptElement,
    Comparable<SQLScriptElementImpl> {
        @Nullable
        private ProjectionAnnotation annotation;

        SQLScriptElementImpl(int offset, int length) {
            super(offset, length);
        }

        @Nullable
        public ProjectionAnnotation getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(@Nullable ProjectionAnnotation annotation) {
            this.annotation = annotation;
        }

        @Override
        public int compareTo(@NotNull SQLScriptElementImpl o) {
            int diff = this.getOffset() - o.getOffset();
            if (diff != 0) {
                return diff;
            }
            return this.getLength() - o.getLength();
        }

        public boolean equals(Object o) {
            if (o instanceof Position) {
                Position p = (Position)o;
                return this.equals(p.getOffset(), p.getLength());
            }
            if (o instanceof SQLScriptElement) {
                SQLScriptElement e = (SQLScriptElement)o;
                return this.equals(e.getOffset(), e.getLength());
            }
            return false;
        }

        private boolean equals(int offset, int length) {
            return this.getOffset() == offset && this.getLength() == length;
        }

        public int hashCode() {
            return Objects.hash(this.getOffset(), this.getLength());
        }

        @NotNull
        public String getOriginalText() {
            return "";
        }

        @NotNull
        public String getText() {
            return "";
        }

        public Object getData() {
            return "";
        }

        public void setData(Object data) {
        }

        public void reset() {
        }
    }
}

