/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndexColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableIndex;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;

public class GenericTableIndex
extends JDBCTableIndex<GenericStructContainer, GenericTableBase> {
    private boolean nonUnique;
    private String qualifier;
    private long cardinality;
    private List<GenericTableIndexColumn> columns;

    public GenericTableIndex(GenericTableBase table, boolean nonUnique, String qualifier, long cardinality, String indexName, DBSIndexType indexType, boolean persisted) {
        super((DBSObjectContainer)((GenericStructContainer)table.getContainer()), (JDBCTable)table, indexName, indexType, persisted);
        this.nonUnique = nonUnique;
        this.qualifier = qualifier;
        this.cardinality = cardinality;
    }

    GenericTableIndex(GenericTableIndex source) {
        super((JDBCTableIndex)source);
        this.nonUnique = source.nonUnique;
        this.qualifier = source.qualifier;
        this.cardinality = source.cardinality;
        if (source.columns != null) {
            this.columns = new ArrayList<GenericTableIndexColumn>(source.columns.size());
            for (GenericTableIndexColumn sourceColumn : source.columns) {
                this.columns.add(new GenericTableIndexColumn(this, sourceColumn));
            }
        }
    }

    @NotNull
    public GenericDataSource getDataSource() {
        return (GenericDataSource)((GenericTableBase)this.getTable()).getDataSource();
    }

    @Property(viewable=true, multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(viewable=true, order=4)
    public boolean isUnique() {
        return !this.nonUnique;
    }

    public void setUnique(boolean unique) {
        this.nonUnique = !unique;
    }

    @Property(viewable=true, order=5)
    public String getQualifier() {
        return this.qualifier;
    }

    @Property(viewable=true, order=5)
    public long getCardinality() {
        return this.cardinality;
    }

    public List<GenericTableIndexColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        return this.columns;
    }

    @Nullable
    public GenericTableIndexColumn getColumn(String columnName) {
        return (GenericTableIndexColumn)DBUtils.findObject(this.columns, (String)columnName);
    }

    public void setColumns(List<GenericTableIndexColumn> columns) {
        this.columns = columns;
    }

    public void addColumn(GenericTableIndexColumn column) {
        if (this.columns == null) {
            this.columns = new ArrayList<GenericTableIndexColumn>();
        }
        this.columns.add(column);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((GenericTableBase)this.getTable()).getCatalog(), ((GenericTableBase)this.getTable()).getSchema(), this});
    }
}

