/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.impl.app.CertificateGenHelper;
import org.jkiss.dbeaver.model.impl.app.PKCS1Util;
import org.jkiss.utils.Base64;

public class DefaultCertificateStorage
implements DBACertificateStorage {
    private static final Log log = Log.getLog(DefaultCertificateStorage.class);
    public static final char[] DEFAULT_PASSWORD = "".toCharArray();
    public static final String JKS_EXTENSION = ".jks";
    public static final String CA_CERT_ALIAS = "ca-cert";
    public static final String CLIENT_CERT_ALIAS = "client-cert";
    public static final String KEY_CERT_ALIAS = "key-cert";
    private final File localPath;

    public DefaultCertificateStorage(File localPath) {
        this.localPath = localPath;
        if (localPath.exists()) {
            File[] ksFiles = localPath.listFiles();
            if (ksFiles != null) {
                File[] fileArray = ksFiles;
                int n = ksFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File ksFile = fileArray[n2];
                    if (!ksFile.delete()) {
                        log.warn("Can't delete old keystore '" + ksFile.getAbsolutePath() + "'");
                    }
                    ++n2;
                }
            }
        } else if (!localPath.mkdirs()) {
            log.error("Can't create directory for security manager: " + localPath.getAbsolutePath());
        }
    }

    @Override
    public KeyStore getKeyStore(DBPDataSourceContainer container, String certType) throws DBException {
        try {
            KeyStore ks;
            block12: {
                File ksFile = this.getKeyStorePath(container, certType);
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                if (ksFile.exists()) {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (FileInputStream is = new FileInputStream(ksFile);){
                        ks.load(is, DEFAULT_PASSWORD);
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                ks.load(null, DEFAULT_PASSWORD);
                this.saveKeyStore(container, certType, ks);
            }
            return ks;
        }
        catch (Exception e) {
            throw new DBException("Error opening keystore", e);
        }
    }

    private void saveKeyStore(DBPDataSourceContainer container, String certType, KeyStore keyStore) throws Exception {
        File ksFile = this.getKeyStorePath(container, certType);
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileOutputStream os = new FileOutputStream(ksFile);){
            keyStore.store(os, DEFAULT_PASSWORD);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] readEncryptedString(InputStream stream) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            return DefaultCertificateStorage.readEncryptedString(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] readEncryptedString(Reader reader) throws IOException {
        StringBuilder result = new StringBuilder(4000);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) {
                    break;
                }
                if (line.startsWith("-") || line.startsWith("#")) continue;
                result.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return Base64.decode((String)result.toString());
    }

    @Override
    public void addCertificate(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType, byte[] caCertData, byte[] clientCertData, byte[] keyData) throws DBException {
        KeyStore keyStore = this.getKeyStore(dataSource, certType);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate> certChain = new ArrayList<Certificate>();
            if (caCertData != null) {
                Certificate caCert = cf.generateCertificate(new ByteArrayInputStream(caCertData));
                keyStore.setCertificateEntry(CA_CERT_ALIAS, caCert);
            }
            if (clientCertData != null) {
                Certificate clientCert = cf.generateCertificate(new ByteArrayInputStream(clientCertData));
                keyStore.setCertificateEntry(CLIENT_CERT_ALIAS, clientCert);
                certChain.add(clientCert);
            }
            if (keyData != null) {
                PrivateKey privateKey = DefaultCertificateStorage.loadPrivateKeyFromPEM(keyData);
                keyStore.setKeyEntry(KEY_CERT_ALIAS, privateKey, DEFAULT_PASSWORD, certChain.toArray(new Certificate[certChain.size()]));
            }
            this.saveKeyStore(dataSource, certType, keyStore);
        }
        catch (Throwable e) {
            throw new DBException("Error adding certificate to keystore", e);
        }
    }

    @Override
    public void addCertificate(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType, @NotNull byte[] keyStoreStream, @Nullable char[] keyStorePassword) throws DBException {
        KeyStore keyStore = this.getKeyStore(dataSource, certType);
        try {
            keyStore.load(new ByteArrayInputStream(keyStoreStream), keyStorePassword);
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                Key key = keyStore.getKey(alias, keyStorePassword);
                keyStore.setKeyEntry(alias, key, DEFAULT_PASSWORD, keyStore.getCertificateChain(alias));
                break;
            }
            this.saveKeyStore(dataSource, certType, keyStore);
        }
        catch (Throwable e) {
            throw new DBException("Error loading keystore", e);
        }
    }

    @Override
    public void addSelfSignedCertificate(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType, @NotNull String certDN) throws DBException {
        KeyStore keyStore = this.getKeyStore(dataSource, certType);
        try {
            ArrayList<Certificate> certChain = new ArrayList<Certificate>();
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Certificate clientCert = CertificateGenHelper.generateCertificate(certDN, keyPair, 365, "SHA256withRSA");
            keyStore.setCertificateEntry(CLIENT_CERT_ALIAS, clientCert);
            certChain.add(clientCert);
            PrivateKey privateKey = keyPair.getPrivate();
            keyStore.setKeyEntry(KEY_CERT_ALIAS, privateKey, DEFAULT_PASSWORD, certChain.toArray(new Certificate[certChain.size()]));
            this.saveKeyStore(dataSource, certType, keyStore);
        }
        catch (Throwable e) {
            throw new DBException("Error adding self signed certificate to keystore", e);
        }
    }

    @Override
    public void deleteCertificate(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType) throws DBException {
        KeyStore keyStore = this.getKeyStore(dataSource, certType);
        try {
            keyStore.deleteEntry(CA_CERT_ALIAS);
            keyStore.deleteEntry(CLIENT_CERT_ALIAS);
            keyStore.deleteEntry(KEY_CERT_ALIAS);
            this.saveKeyStore(dataSource, certType, keyStore);
        }
        catch (Exception e) {
            throw new DBException("Error deleting certificate from keystore", e);
        }
    }

    @Override
    public File getKeyStorePath(DBPDataSourceContainer dataSource, String certType) {
        return new File(this.localPath, String.valueOf(dataSource.getId()) + "-" + certType + JKS_EXTENSION);
    }

    @Override
    public String getKeyStoreType(DBPDataSourceContainer dataSource) {
        return KeyStore.getDefaultType();
    }

    public static PrivateKey loadPrivateKeyFromPEM(byte[] keyData) throws GeneralSecurityException, IOException {
        String privateKeyPem = new String(keyData);
        if (privateKeyPem.contains("-----BEGIN PRIVATE KEY-----")) {
            privateKeyPem = privateKeyPem.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
            privateKeyPem = privateKeyPem.replaceAll("\\s", "");
            byte[] pkcs8EncodedKey = Base64.decode((String)privateKeyPem);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePrivate(new PKCS8EncodedKeySpec(pkcs8EncodedKey));
        }
        if (privateKeyPem.contains("-----BEGIN RSA PRIVATE KEY-----")) {
            privateKeyPem = privateKeyPem.replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "");
            privateKeyPem = privateKeyPem.replaceAll("\\s", "");
            return PKCS1Util.loadPrivateKeyFromPKCS1(privateKeyPem);
        }
        throw new GeneralSecurityException("Not supported format of a private key");
    }
}

