/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCCallableStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCPreparedStatementImpl;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetCallable;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.utils.CommonUtils;

public class JDBCCallableStatementImpl
extends JDBCPreparedStatementImpl
implements JDBCCallableStatement {
    private static final Log log = Log.getLog(JDBCCallableStatementImpl.class);
    private static final Pattern EXEC_PATTERN = Pattern.compile("[\\w_\\.]+\\s+([^(]+)\\s*\\(");
    private DBSProcedure procedure;
    private JDBCResultSetCallable procResults = new JDBCResultSetCallable(this.getConnection(), this);

    public JDBCCallableStatementImpl(@NotNull JDBCSession connection, @NotNull CallableStatement original, @Nullable String query, boolean disableLogging) {
        super(connection, original, query, disableLogging);
        try {
            this.procedure = JDBCCallableStatementImpl.findProcedure(connection, query);
        }
        catch (Throwable e) {
            log.debug(e);
        }
        try {
            ParameterMetaData paramsMeta = original.getParameterMetaData();
            if (paramsMeta != null) {
                int n = this.bindProcedureFromJDBC(paramsMeta);
                if (this.procedure != null && n == 0 && this.hasOutputParameters()) {
                    try {
                        this.bindProcedureFromMeta();
                    }
                    catch (Throwable e) {
                        log.debug("Error binding procedure output parameters", e);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
            try {
                if (this.procedure != null) {
                    this.bindProcedureFromMeta();
                }
            }
            catch (Throwable throwable) {
                log.debug("Error binding procedure output parameters", throwable);
            }
        }
        if (this.procedure != null) {
            try {
                Collection<? extends DBSProcedureParameter> params = this.procedure.getParameters(this.getConnection().getProgressMonitor());
                if (!CommonUtils.isEmpty(params)) {
                    for (DBSProcedureParameter dBSProcedureParameter : params) {
                        if (dBSProcedureParameter.getParameterKind() != DBSProcedureParameterKind.OUT && dBSProcedureParameter.getParameterKind() != DBSProcedureParameterKind.INOUT && dBSProcedureParameter.getParameterKind() != DBSProcedureParameterKind.RETURN) continue;
                        this.procResults.addColumn(dBSProcedureParameter.getName(), dBSProcedureParameter.getParameterType());
                    }
                }
            }
            catch (DBException e) {
                log.debug("Error extracting callable results", e);
            }
        } else {
            try {
                JDBCDataSource dataSource = connection.getDataSource();
                ParameterMetaData parameterMetaData = original.getParameterMetaData();
                int parameterCount = parameterMetaData.getParameterCount();
                if (parameterCount > 0) {
                    int index = 0;
                    while (index < parameterCount) {
                        int parameterMode = parameterMetaData.getParameterMode(index + 1);
                        if (parameterMode == 4 || parameterMode == 2) {
                            DBSDataType dataType = dataSource.getLocalDataType(parameterMetaData.getParameterTypeName(index + 1));
                            if (dataType == null) {
                                DBPDataKind dataKind = JDBCUtils.resolveDataKind(dataSource, parameterMetaData.getParameterTypeName(index + 1), parameterMetaData.getParameterType(index + 1));
                                this.procResults.addColumn(String.valueOf(index + 1), dataKind);
                            } else {
                                this.procResults.addColumn(String.valueOf(index + 1), dataType);
                            }
                        }
                        ++index;
                    }
                }
            }
            catch (Throwable e) {
                log.debug("Error extracting parameters meta data: " + e.getMessage());
            }
        }
        this.procResults.addRow(new Object[0]);
    }

    private static DBSProcedure findProcedure(DBCSession session, String queryString) throws DBException {
        Matcher matcher;
        DBPDataSource dataSource = session.getDataSource();
        if (!CommonUtils.isEmpty((String)queryString) && (matcher = EXEC_PATTERN.matcher(queryString)).find()) {
            char divChar;
            String procName = matcher.group(1);
            if (procName.indexOf(divChar = dataSource.getSQLDialect().getStructSeparator()) != -1) {
                return JDBCCallableStatementImpl.findProcedureByNames(session, procName.split("\\" + divChar));
            }
            return JDBCCallableStatementImpl.findProcedureByNames(session, procName);
        }
        return null;
    }

    private static DBSProcedure findProcedureByNames(@NotNull DBCSession session, String ... names) throws DBException {
        if (!(session.getDataSource() instanceof DBSObjectContainer)) {
            return null;
        }
        DBSObjectContainer container = (DBSObjectContainer)((Object)session.getDataSource());
        if (names.length == 1) {
            DBSObject[] selectedObjects = DBUtils.getSelectedObjects(session.getProgressMonitor(), session.getExecutionContext());
            if (selectedObjects.length > 0 && selectedObjects[selectedObjects.length - 1] instanceof DBSObjectContainer) {
                container = (DBSObjectContainer)selectedObjects[selectedObjects.length - 1];
            }
        } else {
            container = (DBSObjectContainer)((Object)session.getDataSource());
            int i = 0;
            while (i < names.length - 1) {
                String childName = CommonUtils.trim((String)names[i]);
                if (CommonUtils.isEmpty((String)childName)) {
                    return null;
                }
                DBSObject child = container.getChild(session.getProgressMonitor(), DBObjectNameCaseTransformer.transformName(session.getDataSource(), childName));
                if (!(child instanceof DBSObjectContainer)) {
                    return null;
                }
                container = (DBSObjectContainer)child;
                ++i;
            }
        }
        if (container instanceof DBSProcedureContainer) {
            return ((DBSProcedureContainer)((Object)container)).getProcedure(session.getProgressMonitor(), DBObjectNameCaseTransformer.transformName(session.getDataSource(), names[names.length - 1]));
        }
        return null;
    }

    @Override
    public CallableStatement getOriginal() {
        return (CallableStatement)this.original;
    }

    private int bindProcedureFromJDBC(@NotNull ParameterMetaData paramsMeta) throws DBException {
        try {
            int parameterCount = paramsMeta.getParameterCount();
            if (parameterCount > 0) {
                int outParameters = 0;
                int index = 0;
                while (index < parameterCount) {
                    int parameterMode = paramsMeta.getParameterMode(index + 1);
                    if (parameterMode == 4 || parameterMode == 2) {
                        this.registerOutParameter(index + 1, paramsMeta.getParameterType(index + 1));
                        ++outParameters;
                    }
                    ++index;
                }
                return outParameters;
            }
            return parameterCount;
        }
        catch (SQLException e) {
            throw new DBException("Error binding callable statement parameters from metadata: " + e.getMessage(), e);
        }
    }

    private boolean hasOutputParameters() throws DBException {
        if (this.procedure == null) {
            return false;
        }
        Collection<? extends DBSProcedureParameter> params = this.procedure.getParameters(this.getConnection().getProgressMonitor());
        if (!CommonUtils.isEmpty(params)) {
            for (DBSProcedureParameter dBSProcedureParameter : params) {
                if (dBSProcedureParameter.getParameterKind() != DBSProcedureParameterKind.OUT && dBSProcedureParameter.getParameterKind() != DBSProcedureParameterKind.INOUT) continue;
                return true;
            }
        }
        return false;
    }

    private void bindProcedureFromMeta() throws DBException {
        if (this.procedure == null) {
            return;
        }
        try {
            Collection<? extends DBSProcedureParameter> params = this.procedure.getParameters(this.getConnection().getProgressMonitor());
            if (!CommonUtils.isEmpty(params)) {
                int index = 0;
                for (DBSProcedureParameter dBSProcedureParameter : params) {
                    if (dBSProcedureParameter.getParameterKind() != DBSProcedureParameterKind.OUT && dBSProcedureParameter.getParameterKind() != DBSProcedureParameterKind.INOUT) continue;
                    this.registerOutParameter(++index, dBSProcedureParameter.getParameterType().getTypeID());
                }
            }
        }
        catch (SQLException e) {
            throw new DBException("Error binding callable statement parameters", e);
        }
    }

    @Override
    public boolean executeStatement() throws DBCException {
        boolean hasResults = super.executeStatement();
        if (!hasResults && this.procResults.getColumnCount() > 0) {
            return true;
        }
        return hasResults;
    }

    @Override
    @Nullable
    public JDBCResultSet getResultSet() throws SQLException {
        JDBCResultSet resultSet = this.makeResultSet(this.getOriginal().getResultSet());
        if (resultSet == null && this.procResults != null) {
            return this.procResults;
        }
        return resultSet;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.getOriginal().registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.getOriginal().registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getOriginal().wasNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return this.getOriginal().getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.getOriginal().getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return this.getOriginal().getByte(parameterIndex);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return this.getOriginal().getShort(parameterIndex);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return this.getOriginal().getInt(parameterIndex);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return this.getOriginal().getLong(parameterIndex);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return this.getOriginal().getFloat(parameterIndex);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return this.getOriginal().getDouble(parameterIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.getOriginal().getBigDecimal(parameterIndex, scale);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.getOriginal().getBytes(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getOriginal().getDate(parameterIndex);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.getOriginal().getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getOriginal().getTimestamp(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        return this.getOriginal().getObject(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.getOriginal().getBigDecimal(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getOriginal().getObject(parameterIndex, map);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        return this.getOriginal().getRef(parameterIndex);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return this.getOriginal().getBlob(parameterIndex);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return this.getOriginal().getClob(parameterIndex);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        return this.getOriginal().getArray(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOriginal().getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOriginal().getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOriginal().getTimestamp(parameterIndex, cal);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getOriginal().registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.getOriginal().registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.getOriginal().registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.getOriginal().registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return this.getOriginal().getURL(parameterIndex);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.getOriginal().setURL(parameterName, val);
        this.handleStatementBind(parameterName, val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.getOriginal().setNull(parameterName, sqlType);
        this.handleStatementBind(parameterName, null);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.getOriginal().setBoolean(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.getOriginal().setByte(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.getOriginal().setShort(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.getOriginal().setInt(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.getOriginal().setLong(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.getOriginal().setFloat(parameterName, x);
        this.handleStatementBind(parameterName, Float.valueOf(x));
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.getOriginal().setDouble(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.getOriginal().setBigDecimal(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.getOriginal().setString(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.getOriginal().setBytes(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.getOriginal().setDate(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.getOriginal().setTime(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.getOriginal().setTimestamp(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.getOriginal().setAsciiStream(parameterName, x, length);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.getOriginal().setBinaryStream(parameterName, x, length);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.getOriginal().setObject(parameterName, x, targetSqlType, scale);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.getOriginal().setObject(parameterName, x, targetSqlType);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.getOriginal().setObject(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.getOriginal().setCharacterStream(parameterName, reader, length);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.getOriginal().setDate(parameterName, x, cal);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.getOriginal().setTime(parameterName, x, cal);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.getOriginal().setTimestamp(parameterName, x, cal);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.getOriginal().setNull(parameterName, sqlType, typeName);
        this.handleStatementBind(parameterName, null);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.getOriginal().getString(parameterName);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getOriginal().getBoolean(parameterName);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.getOriginal().getByte(parameterName);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.getOriginal().getShort(parameterName);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.getOriginal().getInt(parameterName);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.getOriginal().getLong(parameterName);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.getOriginal().getFloat(parameterName);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.getOriginal().getDouble(parameterName);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getOriginal().getBytes(parameterName);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.getOriginal().getDate(parameterName);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.getOriginal().getTime(parameterName);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getOriginal().getTimestamp(parameterName);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.getOriginal().getObject(parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getOriginal().getBigDecimal(parameterName);
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getOriginal().getObject(parameterName, map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.getOriginal().getRef(parameterName);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.getOriginal().getBlob(parameterName);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.getOriginal().getClob(parameterName);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.getOriginal().getArray(parameterName);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getOriginal().getDate(parameterName, cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getOriginal().getTime(parameterName, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getOriginal().getTimestamp(parameterName, cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.getOriginal().getURL(parameterName);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        return this.getOriginal().getRowId(parameterIndex);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return this.getOriginal().getRowId(parameterName);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.getOriginal().setRowId(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.getOriginal().setNString(parameterName, value);
        this.handleStatementBind(parameterName, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.getOriginal().setNCharacterStream(parameterName, value, length);
        this.handleStatementBind(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.getOriginal().setNClob(parameterName, value);
        this.handleStatementBind(parameterName, value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.getOriginal().setClob(parameterName, reader, length);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.getOriginal().setBlob(parameterName, inputStream, length);
        this.handleStatementBind(parameterName, inputStream);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.getOriginal().setNClob(parameterName, reader, length);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return this.getOriginal().getNClob(parameterIndex);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getOriginal().getNClob(parameterName);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.getOriginal().setSQLXML(parameterName, xmlObject);
        this.handleStatementBind(parameterName, xmlObject);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return this.getOriginal().getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.getOriginal().getSQLXML(parameterName);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.getOriginal().getNString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getOriginal().getNString(parameterName);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.getOriginal().getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getOriginal().getNCharacterStream(parameterName);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.getOriginal().getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getOriginal().getCharacterStream(parameterName);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.getOriginal().setBlob(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.getOriginal().setClob(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.getOriginal().setAsciiStream(parameterName, x, length);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.getOriginal().setBinaryStream(parameterName, x, length);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.getOriginal().setCharacterStream(parameterName, reader, length);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.getOriginal().setAsciiStream(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.getOriginal().setBinaryStream(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.getOriginal().setCharacterStream(parameterName, reader);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.getOriginal().setNCharacterStream(parameterName, value);
        this.handleStatementBind(parameterName, value);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.getOriginal().setClob(parameterName, reader);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.getOriginal().setBlob(parameterName, inputStream);
        this.handleStatementBind(parameterName, inputStream);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.getOriginal().setNClob(parameterName, reader);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return this.getOriginal().getObject(parameterIndex, type);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getOriginal().getObject(parameterName, type);
    }
}

