/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingType;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.runtime.DBRFinder;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public final class SQLUtils {
    private static final Log log = Log.getLog(SQLUtils.class);
    public static final Pattern PATTERN_OUT_PARAM = Pattern.compile("((\\?)|(:[a-z0-9]+))\\s*:=");
    public static final Pattern PATTERN_SIMPLE_NAME = Pattern.compile("[a-z][a-z0-9_]*", 2);
    private static final Pattern CREATE_PREFIX_PATTERN = Pattern.compile("(CREATE (:OR REPLACE)?).+", 10);
    private static final int MIN_SQL_DESCRIPTION_LENGTH = 512;
    private static final int MAX_SQL_DESCRIPTION_LENGTH = 500;
    private static final String DBEAVER_DDL_COMMENT = "-- DDL generated by ";
    private static final String DBEAVER_DDL_WARNING = "-- WARNING: It may differ from actual native database DDL";
    private static final String DBEAVER_SCRIPT_DELIMITER = "$$";

    public static String stripTransformations(String query) {
        return query;
    }

    public static String stripComments(@NotNull SQLDialect dialect, @NotNull String query) {
        Pair<String, String> multiLineComments = dialect.getMultiLineComments();
        return SQLUtils.stripComments(query, multiLineComments == null ? null : (String)multiLineComments.getFirst(), multiLineComments == null ? null : (String)multiLineComments.getSecond(), dialect.getSingleLineComments());
    }

    public static boolean isCommentLine(SQLDialect dialect, String line) {
        String[] stringArray = dialect.getSingleLineComments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String slc = stringArray[n2];
            if (line.startsWith(slc)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static String stripComments(@NotNull String query, @Nullable String mlCommentStart, @Nullable String mlCommentEnd, String[] slComments) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> splitFilter(String filter) {
        if (CommonUtils.isEmpty((String)filter)) {
            return Collections.emptyList();
        }
        return CommonUtils.splitString((String)filter, (char)',');
    }

    public static boolean matchesAnyLike(String string, Collection<String> likes) {
        for (String like : likes) {
            if (!SQLUtils.matchesLike(string, like)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLikePattern(String like) {
        return like.indexOf(37) != -1 || like.indexOf(42) != -1 || like.indexOf(95) != -1 || like.indexOf(63) != -1;
    }

    public static String makeLikePattern(String like) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < like.length()) {
            char c = like.charAt(i);
            if (c == '*') {
                result.append(".*");
            } else if (c == '?' || c == '_') {
                result.append(".");
            } else if (c == '%') {
                result.append(".*");
            } else if (Character.isLetterOrDigit(c)) {
                result.append(c);
            } else if (c == '\\') {
                if (i < like.length() - 1) {
                    char nc = like.charAt(i + 1);
                    if (nc == '_' || nc == '*' || nc == '?' || nc == '.') {
                        result.append("\\").append(nc);
                        ++i;
                    } else {
                        result.append("\\");
                    }
                }
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String makeSQLLike(String like) {
        return like.replace("*", "%").replace("?", "_");
    }

    public static boolean matchesLike(String string, String like) {
        Pattern pattern = Pattern.compile(SQLUtils.makeLikePattern(like), 10);
        return pattern.matcher(string).matches();
    }

    public static void appendValue(StringBuilder buffer, DBSTypedObject type, Object value) {
        if (type.getDataKind() == DBPDataKind.NUMERIC || type.getDataKind() == DBPDataKind.BOOLEAN) {
            buffer.append(value);
        } else {
            buffer.append('\'').append(value).append('\'');
        }
    }

    public static boolean isStringQuoted(String string) {
        return string.length() > 1 && string.startsWith("'") && string.endsWith("'");
    }

    public static String quoteString(DBSObject object, String string) {
        return SQLUtils.quoteString(object.getDataSource(), string);
    }

    public static String quoteString(DBPDataSource dataSource, String string) {
        return "'" + SQLUtils.escapeString(dataSource, string) + "'";
    }

    public static String escapeString(DBPDataSource dataSource, String string) {
        return dataSource.getSQLDialect().escapeString(string);
    }

    public static String unQuoteString(DBPDataSource dataSource, String string) {
        if (string.length() > 1 && string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return dataSource.getSQLDialect().unEscapeString(string.substring(1, string.length() - 1));
        }
        return string;
    }

    public static String getFirstKeyword(SQLDialect dialect, String query) {
        query = SQLUtils.stripComments(dialect, query);
        int startPos = 0;
        int endPos = -1;
        int i = 0;
        while (i < query.length()) {
            if (Character.isLetterOrDigit(query.charAt(i))) {
                startPos = i;
                break;
            }
            ++i;
        }
        i = startPos;
        while (i < query.length()) {
            if (Character.isWhitespace(query.charAt(i))) {
                endPos = i;
                break;
            }
            ++i;
        }
        if (endPos == -1) {
            return query;
        }
        return query.substring(startPos, endPos);
    }

    @Nullable
    public static String getQueryOutputParameter(DBCSession session, String query) {
        Matcher matcher = PATTERN_OUT_PARAM.matcher(query);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String makeUnifiedLineFeeds(DBPDataSource dataSource, String query) {
        SQLDialect dialect = SQLUtils.getDialectFromDataSource(dataSource);
        if (!dialect.isCRLFBroken()) {
            return query;
        }
        if (query.indexOf(13) == -1) {
            return query;
        }
        StringBuilder result = new StringBuilder(query.length());
        int i = 0;
        while (i < query.length()) {
            char c = query.charAt(i);
            if (c != '\r') {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static void appendLikeCondition(StringBuilder sql, String value, boolean not) {
        if ((value = SQLUtils.makeSQLLike(value)).contains("%") || value.contains("_")) {
            if (not) {
                sql.append(" NOT");
            }
            sql.append(" LIKE ?");
        } else {
            sql.append(not ? "<>?" : "=?");
        }
    }

    public static boolean appendFirstClause(StringBuilder sql, boolean firstClause) {
        if (firstClause) {
            sql.append(" WHERE ");
        } else {
            sql.append(" AND ");
        }
        return false;
    }

    public static String trimQueryStatement(SQLSyntaxManager syntaxManager, String sql, boolean trimDelimiter) {
        if (sql.isEmpty() || !trimDelimiter) {
            return sql;
        }
        String trailingSpaces = "";
        int trailingSpacesCount = 0;
        int i = sql.length() - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(sql.charAt(i))) break;
            ++trailingSpacesCount;
            --i;
        }
        if (trailingSpacesCount > 0) {
            trailingSpaces = sql.substring(sql.length() - trailingSpacesCount);
            sql = sql.substring(0, sql.length() - trailingSpacesCount);
        }
        String[] stringArray = syntaxManager.getStatementDelimiters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String statementDelimiter = stringArray[n2];
            if (sql.endsWith(statementDelimiter) || sql.length() <= statementDelimiter.length()) {
                char lastChar;
                if (Character.isAlphabetic(statementDelimiter.charAt(0)) && Character.isUnicodeIdentifierPart(lastChar = sql.charAt(sql.length() - statementDelimiter.length() - 1))) break;
                boolean isBlockQuery = false;
                String trimmed = sql.substring(0, sql.length() - statementDelimiter.length());
                String test = trimmed.toUpperCase().trim();
                String[][] blockBoundStrings = syntaxManager.getDialect().getBlockBoundStrings();
                if (blockBoundStrings != null) {
                    String[][] stringArray2 = blockBoundStrings;
                    int n3 = blockBoundStrings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String[] blocks = stringArray2[n4];
                        int endIndex = test.indexOf(blocks[1]);
                        if (endIndex > 0) {
                            if (test.endsWith(blocks[1])) {
                                isBlockQuery = true;
                                break;
                            }
                            String afterEnd = test.substring(endIndex + blocks[1].length()).trim();
                            if (CommonUtils.isJavaIdentifier((CharSequence)afterEnd)) {
                                isBlockQuery = true;
                                break;
                            }
                        }
                        ++n4;
                    }
                }
                if (isBlockQuery) break;
                sql = trimmed;
                break;
            }
            ++n2;
        }
        return String.valueOf(sql) + trailingSpaces;
    }

    public static boolean isBlockStartKeyword(SQLDialect dialect, String keyword) {
        String[][] blockBoundStrings = dialect.getBlockBoundStrings();
        if (blockBoundStrings != null) {
            String[][] stringArray = blockBoundStrings;
            int n = blockBoundStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] block = stringArray[n2];
                if (block.length > 0 && keyword.equalsIgnoreCase(block[0])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isBlockEndKeyword(SQLDialect dialect, String keyword) {
        String[][] blockBoundStrings = dialect.getBlockBoundStrings();
        if (blockBoundStrings != null) {
            String[][] stringArray = blockBoundStrings;
            int n = blockBoundStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] block = stringArray[n2];
                if (block.length > 1 && keyword.equalsIgnoreCase(block[1])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @NotNull
    public static SQLDialect getDialectFromObject(DBPObject object) {
        if (object instanceof DBSObject) {
            DBPDataSource dataSource = ((DBSObject)object).getDataSource();
            return SQLUtils.getDialectFromDataSource(dataSource);
        }
        return BasicSQLDialect.INSTANCE;
    }

    @NotNull
    public static SQLDialect getDialectFromDataSource(@Nullable DBPDataSource dataSource) {
        return dataSource == null ? BasicSQLDialect.INSTANCE : dataSource.getSQLDialect();
    }

    public static void appendConditionString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria) {
        String operator = filter.isAnyConstraint() ? " OR " : " AND ";
        boolean hasWhere = false;
        for (DBDAttributeConstraint constraint : filter.getConstraints()) {
            DBDAttributeBinding binding;
            String condition = SQLUtils.getConstraintCondition(dataSource, constraint, inlineCriteria);
            if (condition == null) continue;
            if (hasWhere) {
                query.append(operator);
            }
            hasWhere = true;
            if (constraint.getEntityAlias() != null) {
                query.append(constraint.getEntityAlias()).append('.');
            } else if (conditionTable != null) {
                query.append(conditionTable).append('.');
            }
            DBSAttributeBase cAttr = constraint.getAttribute();
            String attrName = cAttr instanceof DBDAttributeBinding ? ((binding = (DBDAttributeBinding)cAttr).getEntityAttribute() != null && binding.getEntityAttribute().getName().equals(binding.getMetaAttribute().getName()) || binding instanceof DBDAttributeBindingType ? DBUtils.getObjectFullName(dataSource, binding, DBPEvaluationContext.DML) : binding.getMetaAttribute().getName()) : (cAttr != null ? DBUtils.getObjectFullName(dataSource, cAttr, DBPEvaluationContext.DML) : DBUtils.getQuotedIdentifier(dataSource, constraint.getAttributeName()));
            query.append(attrName).append(' ').append(condition);
        }
        if (!CommonUtils.isEmpty((String)filter.getWhere())) {
            if (hasWhere) {
                query.append(operator);
            }
            query.append(filter.getWhere());
        }
    }

    public static void appendOrderString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query) {
        boolean hasOrder = false;
        for (DBDAttributeConstraint co : filter.getOrderConstraints()) {
            if (hasOrder) {
                query.append(',');
            }
            String orderString = null;
            if (co.getAttribute() == null || co.getAttribute() instanceof DBDAttributeBindingMeta || co.getAttribute() instanceof DBDAttributeBindingType) {
                String orderColumn = co.getAttributeName();
                if (co.getAttribute() == null || PATTERN_SIMPLE_NAME.matcher(orderColumn).matches()) {
                    orderString = co.getFullAttributeName();
                    if (conditionTable != null) {
                        orderString = String.valueOf(conditionTable) + '.' + orderString;
                    }
                }
            }
            if (orderString == null) {
                int orderIndex = filter.getConstraints().indexOf(co);
                if (orderIndex != -1) {
                    orderString = String.valueOf(orderIndex + 1);
                } else {
                    log.debug("Can't generate column order: no name and no position found");
                    continue;
                }
            }
            query.append(orderString);
            if (co.isOrderDescending()) {
                query.append(" DESC");
            }
            hasOrder = true;
        }
        if (!CommonUtils.isEmpty((String)filter.getOrder())) {
            if (hasOrder) {
                query.append(',');
            }
            query.append(filter.getOrder());
        }
    }

    @Nullable
    public static String getConstraintCondition(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, boolean inlineCriteria) {
        String criteria = constraint.getCriteria();
        if (!CommonUtils.isEmpty((String)criteria)) {
            char firstChar = criteria.trim().charAt(0);
            if (!Character.isLetter(firstChar) && firstChar != '=' && firstChar != '>' && firstChar != '<' && firstChar != '!') {
                return String.valueOf('=') + criteria;
            }
            return criteria;
        }
        if (constraint.getOperator() != null) {
            DBCLogicalOperator operator = constraint.getOperator();
            StringBuilder conString = new StringBuilder();
            Object[] value = constraint.getValue();
            if (DBUtils.isNullValue(value)) {
                if (operator.getArgumentCount() == 0) {
                    return operator.getStringValue();
                }
                conString.append("IS ");
                if (constraint.isReverseOperator()) {
                    conString.append("NOT ");
                }
                conString.append("NULL");
                return conString.toString();
            }
            if (constraint.isReverseOperator()) {
                conString.append("NOT ");
            }
            if (operator.getArgumentCount() > 0) {
                conString.append(operator.getStringValue());
                int i = 0;
                while (i < operator.getArgumentCount()) {
                    if (i > 0) {
                        conString.append(" AND");
                    }
                    String strValue = inlineCriteria ? SQLUtils.convertValueToSQL(dataSource, constraint.getAttribute(), value) : dataSource.getSQLDialect().getTypeCastClause(constraint.getAttribute(), "?");
                    conString.append(' ').append(strValue);
                    ++i;
                }
            } else if (operator.getArgumentCount() < 0) {
                int valueCount = Array.getLength(value);
                boolean hasNull = false;
                boolean hasNotNull = false;
                int i = 0;
                while (i < valueCount) {
                    boolean isNull = DBUtils.isNullValue(Array.get(value, i));
                    if (isNull && !hasNull) {
                        hasNull = true;
                    }
                    if (!isNull && !hasNotNull) {
                        hasNotNull = true;
                    }
                    ++i;
                }
                if (!hasNotNull) {
                    return "IS NULL";
                }
                if (hasNull) {
                    conString.append("IS NULL OR ").append(DBUtils.getObjectFullName(dataSource, constraint.getAttribute(), DBPEvaluationContext.DML)).append(" ");
                }
                conString.append(operator.getStringValue());
                conString.append(" (");
                if (!value.getClass().isArray()) {
                    value = new Object[]{value};
                }
                boolean hasValue = false;
                int i2 = 0;
                while (i2 < valueCount) {
                    Object itemValue = Array.get(value, i2);
                    if (!DBUtils.isNullValue(itemValue)) {
                        if (hasValue) {
                            conString.append(",");
                        }
                        hasValue = true;
                        if (inlineCriteria) {
                            conString.append(SQLUtils.convertValueToSQL(dataSource, constraint.getAttribute(), itemValue));
                        } else {
                            conString.append(dataSource.getSQLDialect().getTypeCastClause(constraint.getAttribute(), "?"));
                        }
                    }
                    ++i2;
                }
                conString.append(")");
            }
            return conString.toString();
        }
        return null;
    }

    public static String convertValueToSQL(@NotNull DBPDataSource dataSource, @NotNull DBSAttributeBase attribute, @Nullable Object value) {
        DBDValueHandler valueHandler = DBUtils.findValueHandler(dataSource, (DBSTypedObject)attribute);
        return SQLUtils.convertValueToSQL(dataSource, attribute, valueHandler, value, DBDDisplayFormat.NATIVE);
    }

    public static String convertValueToSQL(@NotNull DBPDataSource dataSource, @NotNull DBSAttributeBase attribute, @NotNull DBDValueHandler valueHandler, @Nullable Object value, DBDDisplayFormat displayFormat) {
        if (DBUtils.isNullValue(value)) {
            return "NULL";
        }
        return dataSource.getSQLDialect().getTypeCastClause(attribute, SQLUtils.convertValueToSQLFormat(dataSource, attribute, valueHandler, value, displayFormat));
    }

    private static String convertValueToSQLFormat(@NotNull DBPDataSource dataSource, @NotNull DBSAttributeBase attribute, @NotNull DBDValueHandler valueHandler, @Nullable Object value, DBDDisplayFormat displayFormat) {
        if (DBUtils.isNullValue(value)) {
            return "NULL";
        }
        String strValue = value instanceof DBDContent ? SQLUtils.convertStreamToSQL(attribute, (DBDContent)value, valueHandler, dataSource) : valueHandler.getValueDisplayString(attribute, value, displayFormat);
        if (value instanceof Number) {
            return strValue;
        }
        SQLDialect sqlDialect = dataSource.getSQLDialect();
        DBPDataKind dataKind = attribute.getDataKind();
        switch (dataKind) {
            case BOOLEAN: 
            case NUMERIC: {
                if (sqlDialect != null) {
                    return sqlDialect.escapeScriptValue(attribute, value, strValue);
                }
                return strValue;
            }
            case CONTENT: {
                String contentType;
                if (value instanceof DBDContent && (contentType = ((DBDContent)value).getContentType()) != null && !contentType.startsWith("text")) {
                    return strValue;
                }
            }
            case STRING: 
            case ROWID: {
                if (sqlDialect != null) {
                    strValue = sqlDialect.escapeString(strValue);
                }
                if (dataKind == DBPDataKind.STRING || !strValue.startsWith("'") || !strValue.endsWith("'")) {
                    strValue = String.valueOf('\'') + strValue + '\'';
                }
                return sqlDialect.getTypeCastClause(attribute, strValue);
            }
        }
        if (sqlDialect != null) {
            return sqlDialect.escapeScriptValue(attribute, value, strValue);
        }
        return strValue;
    }

    public static String convertStreamToSQL(DBSAttributeBase attribute, DBDContent content, DBDValueHandler valueHandler, DBPDataSource dataSource) {
        try {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            if (!content.isNull() && ContentUtils.isTextContent(content)) {
                String strValue = ContentUtils.getContentStringValue(monitor, content);
                return dataSource.getSQLDialect().escapeString(strValue);
            }
            byte[] binValue = ContentUtils.getContentBinaryValue(monitor, content);
            return dataSource.getSQLDialect().getNativeBinaryFormatter().toString(binValue, 0, binValue.length);
        }
        catch (Throwable e) {
            log.warn(e);
            return "NULL";
        }
    }

    public static String getColumnTypeModifiers(@Nullable DBPDataSource dataSource, DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        if (column == null) {
            return null;
        }
        if (dataSource == null) {
            return null;
        }
        return dataSource.getSQLDialect().getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    public static String getScriptDescripion(@NotNull String sql) {
        Matcher matcher = CREATE_PREFIX_PATTERN.matcher(sql = SQLUtils.stripComments(BasicSQLDialect.INSTANCE, sql));
        if (matcher.find() && matcher.start(0) == 0) {
            sql = sql.substring(matcher.end(1));
        }
        if ((sql = sql.replaceAll(" +", " ")).length() > 500) {
            sql = String.valueOf(sql.substring(0, 500)) + " ...";
        }
        return sql;
    }

    @Nullable
    public static String getScriptDescription(@NotNull IFile sqlScript) {
        try {
            StringBuilder sql = new StringBuilder();
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader is = new BufferedReader(new InputStreamReader(sqlScript.getContents()));){
                String line;
                while ((line = is.readLine()) != null) {
                    if ((line = line.trim()).startsWith("--") || line.startsWith("Rem") || line.startsWith("rem") || line.startsWith("REM")) continue;
                    sql.append(line).append('\n');
                    if (sql.length() > 512) break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return SQLUtils.getScriptDescripion(sql.toString());
        }
        catch (Exception e) {
            log.warn("", e);
            return null;
        }
    }

    public static String generateEntityAlias(DBSEntity entity, DBRFinder<Boolean, String> aliasFinder) {
        String name = entity.getName();
        if (CommonUtils.isEmpty((String)name)) {
            return name;
        }
        StringBuilder buf = new StringBuilder();
        boolean prevNonLetter = true;
        char prevChar = '\u0000';
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Character.isLetter(c)) {
                prevNonLetter = true;
            } else {
                if (prevNonLetter || prevChar != '\u0000' && Character.isLowerCase(prevChar) && Character.isUpperCase(c)) {
                    buf.append(c);
                }
                prevNonLetter = false;
            }
            prevChar = c;
            ++i;
        }
        String alias = !CommonUtils.isEmpty((CharSequence)buf) ? buf.toString().toLowerCase(Locale.ENGLISH) : "t";
        String result = alias;
        int i2 = 2;
        while (i2 < 500) {
            if (!aliasFinder.findObject(result).booleanValue()) {
                return result;
            }
            result = String.valueOf(alias) + i2;
            ++i2;
        }
        return alias;
    }

    @NotNull
    public static String generateCommentLine(DBPDataSource dataSource, String comment) {
        Object[] slComments;
        Object slComment = "*/";
        if (dataSource != null && !ArrayUtils.isEmpty((Object[])(slComments = dataSource.getSQLDialect().getSingleLineComments()))) {
            slComment = slComments[0];
        }
        return String.valueOf(slComment) + " " + comment + GeneralUtils.getDefaultLineSeparator();
    }

    public static String generateParamList(int paramCount) {
        if (paramCount == 0) {
            return "";
        }
        if (paramCount == 1) {
            return "?";
        }
        StringBuilder sql = new StringBuilder("?");
        int i = 0;
        while (i < paramCount - 1) {
            sql.append(",?");
            ++i;
        }
        return sql.toString();
    }

    public static String fixLineFeeds(String sql) {
        if (sql.indexOf(13) == -1) {
            return sql;
        }
        boolean hasFixes = false;
        char[] fixed = sql.toCharArray();
        int i = 0;
        while (i < fixed.length) {
            if (fixed[i] == '\r' && (i <= 0 || fixed[i - 1] != '\n') && i != fixed.length - 1 && fixed[i + 1] != '\n') {
                fixed[i] = 32;
                hasFixes = true;
            }
            ++i;
        }
        return hasFixes ? String.valueOf(fixed) : sql;
    }

    public static boolean compareAliases(String str1, String str2) {
        return SQLUtils.removeExtraSpaces(str1).equals(SQLUtils.removeExtraSpaces(str2));
    }

    public static String removeExtraSpaces(String str) {
        if (str.indexOf(32) == -1) {
            return str;
        }
        StringBuilder result = new StringBuilder(str.length());
        int length = str.length();
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                boolean needsSpace = i > 0 && Character.isLetterOrDigit(str.charAt(i - 1));
                ++i;
                while (i < length) {
                    c = str.charAt(i);
                    if (!Character.isWhitespace(c)) {
                        if (needsSpace && Character.isLetterOrDigit(c)) {
                            result.append(' ');
                        }
                        result.append(c);
                        break;
                    }
                    ++i;
                }
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    @NotNull
    public static String generateScript(DBPDataSource dataSource, DBEPersistAction[] persistActions, boolean addComments) {
        SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource(dataSource);
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder script = new StringBuilder(64);
        if (addComments) {
            script.append(DBEAVER_DDL_COMMENT).append(Platform.getProduct().getName()).append(lineSeparator).append(DBEAVER_DDL_WARNING).append(lineSeparator);
        }
        if (persistActions != null) {
            String redefiner = sqlDialect.getScriptDelimiterRedefiner();
            DBEPersistAction[] dBEPersistActionArray = persistActions;
            int n = persistActions.length;
            int n2 = 0;
            while (n2 < n) {
                DBEPersistAction action = dBEPersistActionArray[n2];
                String scriptLine = action.getScript();
                if (!CommonUtils.isEmpty((String)scriptLine)) {
                    String delimiter = SQLUtils.getScriptLineDelimiter(sqlDialect);
                    if (action.isComplex() && redefiner != null) {
                        script.append(lineSeparator).append(redefiner).append(" ").append(DBEAVER_SCRIPT_DELIMITER).append(lineSeparator);
                        delimiter = DBEAVER_SCRIPT_DELIMITER;
                        script.append(delimiter).append(lineSeparator);
                    } else if (action.getType() == DBEPersistAction.ActionType.COMMENT && script.length() > 2) {
                        int lfCount = 0;
                        int i = script.length() - 1;
                        while (i >= 0) {
                            if (!Character.isWhitespace(script.charAt(i))) break;
                            if (script.charAt(i) == '\n') {
                                ++lfCount;
                            }
                            --i;
                        }
                        if (lfCount < 2) {
                            script.append(lineSeparator);
                        }
                    }
                    script.append(scriptLine);
                    if (action.getType() != DBEPersistAction.ActionType.COMMENT) {
                        String testLine = scriptLine.trim();
                        if (testLine.lastIndexOf(delimiter) != testLine.length() - delimiter.length()) {
                            script.append(delimiter);
                        }
                    } else {
                        script.append(lineSeparator);
                    }
                    script.append(lineSeparator);
                    if (action.isComplex() && redefiner != null) {
                        script.append(redefiner).append(" ").append(SQLUtils.getScriptLineDelimiter(sqlDialect)).append(lineSeparator);
                    }
                }
                ++n2;
            }
        }
        return script.toString();
    }

    @NotNull
    public static String generateComments(DBPDataSource dataSource, DBEPersistAction[] persistActions, boolean addComments) {
        StringBuilder script;
        block5: {
            SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource(dataSource);
            String lineSeparator = GeneralUtils.getDefaultLineSeparator();
            script = new StringBuilder(64);
            if (addComments) {
                script.append(DBEAVER_DDL_COMMENT).append(Platform.getProduct().getName()).append(lineSeparator).append(DBEAVER_DDL_WARNING).append(lineSeparator);
            }
            if (persistActions == null) break block5;
            Object[] slComments = sqlDialect.getSingleLineComments();
            Object slComment = ArrayUtils.isEmpty((Object[])slComments) ? "--" : slComments[0];
            DBEPersistAction[] dBEPersistActionArray = persistActions;
            int n = persistActions.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    block8: {
                        String scriptLine;
                        DBEPersistAction action;
                        block6: {
                            action = dBEPersistActionArray[n2];
                            if (action.getType() == DBEPersistAction.ActionType.COMMENT) break block6;
                            scriptLine = action.getTitle();
                            if (CommonUtils.isEmpty((String)scriptLine)) break block7;
                            script.append((String)slComment).append(" ").append(scriptLine);
                            break block8;
                        }
                        scriptLine = action.getScript();
                        if (CommonUtils.isEmpty((String)scriptLine)) break block7;
                        script.append(scriptLine);
                    }
                    script.append(lineSeparator);
                }
                ++n2;
            }
        }
        return script.toString();
    }

    public static String getScriptLineDelimiter(SQLDialect sqlDialect) {
        String delimiter = sqlDialect.getScriptDelimiter();
        if (!delimiter.isEmpty() && Character.isLetterOrDigit(delimiter.charAt(0))) {
            delimiter = String.valueOf(' ') + delimiter;
        }
        return delimiter;
    }

    public static String[] splitFullIdentifier(String fullName, char nameSeparator, String[][] quoteStrings) {
        return SQLUtils.splitFullIdentifier(fullName, String.valueOf(nameSeparator), quoteStrings, false);
    }

    public static String[] splitFullIdentifier(String fullName, String nameSeparator, String[][] quoteStrings, boolean keepQuotes) {
        String name = fullName.trim();
        if (ArrayUtils.isEmpty((Object[])quoteStrings)) {
            return name.split(Pattern.quote(nameSeparator));
        }
        if (!name.contains(nameSeparator)) {
            return new String[]{DBUtils.getUnQuotedIdentifier(name, quoteStrings)};
        }
        ArrayList<String> nameList = new ArrayList<String>();
        while (!name.isEmpty()) {
            boolean hadQuotedPart = false;
            String[][] stringArray = quoteStrings;
            int n = quoteStrings.length;
            int n2 = 0;
            while (n2 < n) {
                int endPos;
                String[] quotePair = stringArray[n2];
                String startQuote = quotePair[0];
                String endQuote = quotePair[1];
                if (!CommonUtils.isEmpty((String)startQuote) && !CommonUtils.isEmpty((String)endQuote) && name.startsWith(startQuote) && (endPos = name.indexOf(endQuote, startQuote.length())) != -1) {
                    String partName = keepQuotes ? name.substring(0, endPos + endQuote.length()) : name.substring(startQuote.length(), endPos);
                    while (partName.endsWith(nameSeparator)) {
                        partName = partName.substring(0, partName.length() - 1);
                    }
                    if (!partName.isEmpty()) {
                        nameList.add(partName);
                    }
                    name = name.substring(endPos + endQuote.length()).trim();
                    hadQuotedPart = true;
                    break;
                }
                ++n2;
            }
            if (!hadQuotedPart) {
                int endPos = name.indexOf(nameSeparator);
                if (endPos != -1) {
                    nameList.add(name.substring(0, endPos));
                    name = name.substring(endPos);
                } else {
                    nameList.add(name);
                    break;
                }
            }
            if (name.isEmpty() || !name.startsWith(nameSeparator)) continue;
            name = name.substring(nameSeparator.length()).trim();
        }
        return nameList.toArray(new String[0]);
    }

    public static String generateTableJoin(DBRProgressMonitor monitor, DBSEntity leftTable, String leftAlias, DBSEntity rightTable, String rightAlias) throws DBException {
        String sql = SQLUtils.generateTableJoinByAssociation(monitor, leftTable, leftAlias, rightTable, rightAlias);
        if (sql != null) {
            return sql;
        }
        sql = SQLUtils.generateTableJoinByAssociation(monitor, rightTable, rightAlias, leftTable, leftAlias);
        if (sql != null) {
            return sql;
        }
        sql = SQLUtils.generateTableJoinByColumns(monitor, leftTable, leftAlias, rightTable, rightAlias);
        if (sql != null) {
            return sql;
        }
        sql = SQLUtils.generateTableJoinByColumns(monitor, rightTable, rightAlias, leftTable, leftAlias);
        if (sql != null) {
            return sql;
        }
        return null;
    }

    private static String generateTableJoinByColumns(DBRProgressMonitor monitor, DBSEntity leftTable, String leftAlias, DBSEntity rightTable, String rightAlias) throws DBException {
        ArrayList<? extends DBSEntityAttribute> leftIdentifier = new ArrayList<DBSEntityAttribute>(DBUtils.getBestTableIdentifier(monitor, leftTable));
        if (!leftIdentifier.isEmpty()) {
            ArrayList<DBSEntityAttribute> rightAttributes = new ArrayList<DBSEntityAttribute>();
            for (DBSEntityAttribute dBSEntityAttribute : leftIdentifier) {
                DBSEntityAttribute rightAttr = rightTable.getAttribute(monitor, dBSEntityAttribute.getName());
                if (rightAttr == null) break;
                rightAttributes.add(rightAttr);
            }
            if (leftIdentifier.size() != rightAttributes.size()) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int i = 0;
            while (i < leftIdentifier.size()) {
                stringBuilder.append(leftAlias).append(".").append(DBUtils.getQuotedIdentifier((DBSObject)leftIdentifier.get(i))).append(" = ").append(rightAlias).append(".").append(DBUtils.getQuotedIdentifier((DBSObject)rightAttributes.get(i)));
                ++i;
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private static String generateTableJoinByAssociation(DBRProgressMonitor monitor, DBSEntity leftTable, String leftAlias, DBSEntity rightTable, String rightAlias) throws DBException {
        Collection<? extends DBSEntityAssociation> associations = leftTable.getAssociations(monitor);
        if (!CommonUtils.isEmpty(associations)) {
            for (DBSEntityAssociation dBSEntityAssociation : associations) {
                if (!(dBSEntityAssociation instanceof DBSTableForeignKey) || dBSEntityAssociation.getAssociatedEntity() != rightTable) continue;
                return SQLUtils.generateTablesJoin(monitor, (DBSTableForeignKey)dBSEntityAssociation, leftAlias, rightAlias);
            }
        }
        return null;
    }

    private static String generateTablesJoin(DBRProgressMonitor monitor, DBSTableForeignKey fk, String leftAlias, String rightAlias) throws DBException {
        boolean hasCriteria = false;
        StringBuilder joinSQL = new StringBuilder();
        for (DBSEntityAttributeRef dBSEntityAttributeRef : fk.getAttributeReferences(monitor)) {
            if (!(dBSEntityAttributeRef instanceof DBSTableForeignKeyColumn)) continue;
            if (hasCriteria) {
                joinSQL.append(" AND ");
            }
            DBSTableForeignKeyColumn fkc = (DBSTableForeignKeyColumn)dBSEntityAttributeRef;
            joinSQL.append(leftAlias).append(".").append(DBUtils.getQuotedIdentifier(fkc)).append(" = ").append(rightAlias).append(".").append(DBUtils.getQuotedIdentifier(fkc.getReferencedColumn()));
            hasCriteria = true;
        }
        return joinSQL.toString();
    }

    public static String getTableAlias(DBSEntity table) {
        return CommonUtils.escapeIdentifier((String)table.getName());
    }

    public static void appendQueryConditions(DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) {
        if (dataFilter != null && dataFilter.hasConditions()) {
            query.append("\nWHERE ");
            SQLUtils.appendConditionString(dataFilter, dataSource, tableAlias, query, true);
        }
    }

    public static void appendQueryOrder(DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) {
        if (dataFilter != null && dataFilter.hasOrdering()) {
            query.append("\nORDER BY ");
            SQLUtils.appendOrderString(dataFilter, dataSource, tableAlias, query);
        }
    }

    public static boolean isExecQuery(@NotNull SQLDialect dialect, String query) {
        String[] executeKeywords = dialect.getExecuteKeywords();
        if (executeKeywords != null && executeKeywords.length > 0) {
            String queryStart = SQLUtils.getFirstKeyword(dialect, query);
            return SQLUtils.isExecKeyword(dialect, queryStart);
        }
        return false;
    }

    public static boolean isExecKeyword(SQLDialect dialect, String word) {
        return ArrayUtils.containsIgnoreCase((String[])dialect.getExecuteKeywords(), (String)word);
    }

    public static String stripColumnTypeModifiers(String type) {
        int endPos;
        int startPos = type.indexOf("(");
        if (startPos != -1 && (endPos = type.lastIndexOf(")")) != -1) {
            return type.substring(0, startPos);
        }
        return type;
    }

    public static void fillQueryParameters(SQLQuery sqlStatement, List<SQLQueryParameter> parameters) {
        String query = sqlStatement.getText();
        int i = parameters.size();
        while (i > 0) {
            SQLQueryParameter parameter = parameters.get(i - 1);
            String paramValue = parameter.getValue();
            if (paramValue == null || paramValue.isEmpty()) {
                paramValue = "NULL";
            }
            query = String.valueOf(query.substring(0, parameter.getTokenOffset())) + paramValue + query.substring(parameter.getTokenOffset() + parameter.getTokenLength());
            --i;
        }
        sqlStatement.setText(query);
    }

    public static boolean needQueryDelimiter(SQLDialect sqlDialect, String query) {
        String delimiter = sqlDialect.getScriptDelimiter();
        if (!delimiter.isEmpty()) {
            if (Character.isLetterOrDigit(delimiter.charAt(0))) {
                if (query.toUpperCase().endsWith(delimiter.toUpperCase()) && !Character.isLetterOrDigit(query.charAt(query.length() - delimiter.length() - 1))) {
                    return true;
                }
            } else {
                return !query.endsWith(delimiter);
            }
        }
        return true;
    }
}

