/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data.preferences;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageResultSetEditors
extends TargetPrefPage {
    static final Log log = Log.getLog(PrefPageResultSetEditors.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.resultset.editors";
    private Button stringUseEditorCheck;
    private Combo binaryPresentationCombo;
    private Combo binaryEditorType;
    private Spinner binaryStringMaxLength;
    private Spinner memoryContentSize;
    private Combo encodingCombo;
    private Button contentCacheClob;
    private Button contentCacheBlob;
    private Spinner contentCacheMaxSize;
    private Spinner maxTextContentSize;
    private Button editLongAsLobCheck;
    private Button commitOnEditApplyCheck;
    private Button commitOnContentApplyCheck;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("resultset.string.use.content.editor") || store.contains("content.memory.maxsize") || store.contains("resultset.binary.representation") || store.contains("resultset.binary.editor") || store.contains("resultset.binary.stringMaxLength") || store.contains("content.hex.encoding") || store.contains("content.cache.clob") || store.contains("content.cache.blob") || store.contains("content.cache.maxsize") || store.contains("resultset.edit.longaslob") || store.contains("resultset.edit.maxtextsize") || store.contains("resultset.commit.oneditapply") || store.contains("resultset.commit.oncontentapply");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group stringGroup = UIUtils.createControlGroup((Composite)composite, (String)ResultSetMessages.pref_page_database_resultsets_group_string, (int)2, (int)0, (int)0);
        GridData gd = new GridData(2);
        gd.horizontalSpan = 2;
        stringGroup.setLayoutData((Object)gd);
        this.stringUseEditorCheck = UIUtils.createLabelCheckbox((Composite)stringGroup, (String)ResultSetMessages.pref_page_database_resultsets_checkbox_string_use_editor, (String)ResultSetMessages.pref_page_database_resultsets_checkbox_string_use_editor_tip, (boolean)true, (int)2);
        Group binaryGroup = UIUtils.createControlGroup((Composite)composite, (String)ResultSetMessages.pref_page_database_resultsets_group_binary, (int)2, (int)0, (int)0);
        gd = new GridData(2);
        gd.horizontalSpan = 2;
        binaryGroup.setLayoutData((Object)gd);
        this.binaryPresentationCombo = UIUtils.createLabelCombo((Composite)binaryGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_binary_presentation, (int)12);
        DBDBinaryFormatter[] dBDBinaryFormatterArray = DBConstants.BINARY_FORMATS;
        int n = DBConstants.BINARY_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DBDBinaryFormatter formatter = dBDBinaryFormatterArray[n2];
            this.binaryPresentationCombo.add(formatter.getTitle());
            ++n2;
        }
        this.binaryEditorType = UIUtils.createLabelCombo((Composite)binaryGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_binary_editor_type, (int)12);
        this.binaryEditorType.add("Editor");
        this.binaryEditorType.add("Dialog");
        this.binaryStringMaxLength = UIUtils.createLabelSpinner((Composite)binaryGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_binary_strings_max_length, (int)0, (int)0, (int)10000);
        this.binaryStringMaxLength.setDigits(0);
        this.binaryStringMaxLength.setIncrement(1);
        this.memoryContentSize = UIUtils.createLabelSpinner((Composite)binaryGroup, (String)ResultSetMessages.pref_page_database_general_label_max_lob_length, (int)0, (int)0, (int)0x40000000);
        this.memoryContentSize.setDigits(0);
        this.memoryContentSize.setIncrement(1);
        UIUtils.createControlLabel((Composite)binaryGroup, (String)ResultSetMessages.pref_page_content_editor_hex_encoding);
        this.encodingCombo = UIUtils.createEncodingCombo((Composite)binaryGroup, (String)GeneralUtils.getDefaultFileEncoding());
        this.contentCacheClob = UIUtils.createLabelCheckbox((Composite)binaryGroup, (String)ResultSetMessages.pref_page_content_cache_clob, (boolean)true);
        this.contentCacheBlob = UIUtils.createLabelCheckbox((Composite)binaryGroup, (String)ResultSetMessages.pref_page_content_cache_blob, (boolean)true);
        this.contentCacheMaxSize = UIUtils.createLabelSpinner((Composite)binaryGroup, (String)ResultSetMessages.pref_page_database_general_label_cache_max_size, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.contentCacheMaxSize.setDigits(0);
        this.contentCacheMaxSize.setIncrement(100000);
        this.editLongAsLobCheck = UIUtils.createLabelCheckbox((Composite)binaryGroup, (String)ResultSetMessages.pref_page_content_editor_checkbox_edit_long_as_lobs, (boolean)false);
        Group contentGroup = new Group(composite, 0);
        contentGroup.setText(ResultSetMessages.pref_page_content_editor_group_content);
        contentGroup.setLayout((Layout)new GridLayout(2, false));
        this.maxTextContentSize = UIUtils.createLabelSpinner((Composite)contentGroup, (String)ResultSetMessages.pref_page_content_editor_label_max_text_length, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.maxTextContentSize.setDigits(0);
        this.maxTextContentSize.setIncrement(1000000);
        this.commitOnEditApplyCheck = UIUtils.createLabelCheckbox((Composite)contentGroup, (String)ResultSetMessages.pref_page_content_editor_checkbox_commit_on_value_apply, (boolean)false);
        this.commitOnContentApplyCheck = UIUtils.createLabelCheckbox((Composite)contentGroup, (String)ResultSetMessages.pref_page_content_editor_checkbox_commit_on_content_apply, (boolean)false);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.stringUseEditorCheck.setSelection(store.getBoolean("resultset.string.use.content.editor"));
            this.memoryContentSize.setSelection(store.getInt("content.memory.maxsize"));
            this.binaryStringMaxLength.setSelection(store.getInt("resultset.binary.stringMaxLength"));
            DBDBinaryFormatter formatter = DBValueFormatting.getBinaryPresentation((String)store.getString("resultset.binary.representation"));
            int i = 0;
            while (i < this.binaryPresentationCombo.getItemCount()) {
                if (this.binaryPresentationCombo.getItem(i).equals(formatter.getTitle())) {
                    this.binaryPresentationCombo.select(i);
                    break;
                }
                ++i;
            }
            IValueController.EditType editorType = IValueController.EditType.valueOf(store.getString("resultset.binary.editor"));
            if (editorType == IValueController.EditType.EDITOR) {
                this.binaryEditorType.select(0);
            } else {
                this.binaryEditorType.select(1);
            }
            UIUtils.setComboSelection((Combo)this.encodingCombo, (String)store.getString("content.hex.encoding"));
            this.contentCacheClob.setSelection(store.getBoolean("content.cache.clob"));
            this.contentCacheBlob.setSelection(store.getBoolean("content.cache.blob"));
            this.contentCacheMaxSize.setSelection(store.getInt("content.cache.maxsize"));
            this.editLongAsLobCheck.setSelection(store.getBoolean("resultset.edit.longaslob"));
            this.maxTextContentSize.setSelection(store.getInt("resultset.edit.maxtextsize"));
            this.commitOnEditApplyCheck.setSelection(store.getBoolean("resultset.commit.oneditapply"));
            this.commitOnContentApplyCheck.setSelection(store.getBoolean("resultset.commit.oncontentapply"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("resultset.string.use.content.editor", this.stringUseEditorCheck.getSelection());
            store.setValue("content.memory.maxsize", this.memoryContentSize.getSelection());
            String presentationTitle = this.binaryPresentationCombo.getItem(this.binaryPresentationCombo.getSelectionIndex());
            DBDBinaryFormatter[] dBDBinaryFormatterArray = DBConstants.BINARY_FORMATS;
            int n = DBConstants.BINARY_FORMATS.length;
            int n2 = 0;
            while (n2 < n) {
                DBDBinaryFormatter formatter = dBDBinaryFormatterArray[n2];
                if (formatter.getTitle().equals(presentationTitle)) {
                    store.setValue("resultset.binary.representation", formatter.getId());
                    break;
                }
                ++n2;
            }
            store.setValue("resultset.binary.stringMaxLength", this.binaryStringMaxLength.getSelection());
            store.setValue("resultset.binary.editor", this.binaryEditorType.getSelectionIndex() == 0 ? IValueController.EditType.EDITOR.name() : IValueController.EditType.PANEL.name());
            store.setValue("content.hex.encoding", UIUtils.getComboSelection((Combo)this.encodingCombo));
            store.setValue("content.cache.clob", this.contentCacheClob.getSelection());
            store.setValue("content.cache.blob", this.contentCacheBlob.getSelection());
            store.setValue("content.cache.maxsize", this.contentCacheMaxSize.getSelection());
            store.setValue("resultset.edit.longaslob", this.editLongAsLobCheck.getSelection());
            store.setValue("resultset.edit.maxtextsize", this.maxTextContentSize.getSelection());
            store.setValue("resultset.commit.oneditapply", this.commitOnEditApplyCheck.getSelection());
            store.setValue("resultset.commit.oncontentapply", this.commitOnContentApplyCheck.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.string.use.content.editor");
        store.setToDefault("content.memory.maxsize");
        store.setToDefault("resultset.binary.representation");
        store.setToDefault("resultset.binary.stringMaxLength");
        store.setToDefault("resultset.binary.editor");
        store.setToDefault("content.hex.encoding");
        store.setToDefault("content.cache.clob");
        store.setToDefault("content.cache.blob");
        store.setToDefault("content.cache.maxsize");
        store.setToDefault("resultset.edit.longaslob");
        store.setToDefault("resultset.edit.maxtextsize");
        store.setToDefault("resultset.commit.oneditapply");
        store.setToDefault("resultset.commit.oncontentapply");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

