/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.security;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthIDType;
import org.jkiss.dbeaver.ext.db2.model.security.DB2Grantee;
import org.jkiss.dbeaver.ext.db2.model.security.DB2RoleDep;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class DB2Role
extends DB2Grantee
implements DBPSaveableObject,
DBARole,
DBPRefreshableObject {
    private static final String C_RL = "SELECT * FROM SYSCAT.ROLEAUTH WHERE ROLENAME=? ORDER BY GRANTEETYPE,GRANTEE WITH UR";
    private final DBSObjectCache<DB2Role, DB2RoleDep> roleDepCache;
    private Integer id;
    private Timestamp createTime;
    private Integer auditPolicyId;
    private String auditPolicyName;
    private String remarks;

    public DB2Role(DB2DataSource db2DataSource, ResultSet resultSet) {
        super((DBRProgressMonitor)new VoidProgressMonitor(), db2DataSource, resultSet, "ROLENAME");
        this.id = JDBCUtils.safeGetInteger((ResultSet)resultSet, (String)"ROLEID");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATE_TIME");
        this.remarks = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMARKS");
        if (db2DataSource.isAtLeastV10_1()) {
            this.auditPolicyId = JDBCUtils.safeGetInteger((ResultSet)resultSet, (String)"AUDITPOLICYID");
            this.auditPolicyName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"AUDITPOLICYNAME");
        }
        this.roleDepCache = new JDBCObjectSimpleCache(DB2RoleDep.class, C_RL, new Object[]{this.getName()});
    }

    @Override
    public DB2AuthIDType getType() {
        return DB2AuthIDType.R;
    }

    @Association
    public Collection<DB2RoleDep> getRoleDeps(DBRProgressMonitor monitor) throws DBException {
        return this.roleDepCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.roleDepCache.clearCache();
        return this;
    }

    @Property(viewable=true, order=2)
    public Integer getId() {
        return this.id;
    }

    @Property(viewable=false, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, category="Audit")
    public Integer getAuditPolicyId() {
        return this.auditPolicyId;
    }

    @Property(viewable=false, category="Audit")
    public String getAuditPolicyName() {
        return this.auditPolicyName;
    }

    @Override
    @Property(viewable=true, multiline=true)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }
}

