/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageSQLCompletion
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageSQLCompletion.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sql.completion";
    private Button csAutoActivationCheck;
    private Spinner csAutoActivationDelaySpinner;
    private Button csAutoActivateOnKeystroke;
    private Button csAutoInsertCheck;
    private Combo csInsertCase;
    private Button csReplaceWordAfter;
    private Button csHideDuplicates;
    private Button csShortName;
    private Button csLongName;
    private Button csInsertSpace;
    private Button csSortAlphabetically;
    private Button csInsertTableAlias;
    private Button csShowServerHelpTopics;
    private Button csMatchContains;
    private Button csUseGlobalSearch;
    private Button csShowColumnProcedures;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("SQLEditor.ContentAssistant.auto.activation.enable") || store.contains("SQLEditor.ContentAssistant.auto.activation.delay") || store.contains("SQLEditor.ContentAssistant.auto.keystrokes.activation") || store.contains("SQLEditor.ContentAssistant.insert.single.proposal") || store.contains("SQLEditor.ContentAssistant.insert.case") || store.contains("SQLEditor.ContentAssistant.replace.word") || store.contains("SQLEditor.ContentAssistant.hide.duplicates") || store.contains("SQLEditor.ContentAssistant.proposals.short.name") || store.contains("SQLEditor.ContentAssistant.proposals.long.name") || store.contains("SQLEditor.ContentAssistant.insert.space.after.proposal") || store.contains("SQLEditor.ContentAssistant.proposals.sort.alphabetically") || store.contains("sql.proposals.insert.table.alias") || store.contains("SQLEditor.ContentAssistant.matching.fuzzy") || store.contains("SQLEditor.ContentAssistant.use.global.search") || store.contains("SQLEditor.ContentAssistant.show.column.procedures") || store.contains("SQLEditor.ContentAssistant.show.helpTopics");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group assistGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_completion_group_sql_assistant, (int)2, (int)2, (int)0);
        this.csAutoActivationCheck = UIUtils.createCheckbox((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_enable_auto_activation, (String)SQLEditorMessages.pref_page_sql_completion_label_enable_auto_activation_tip, (boolean)false, (int)2);
        UIUtils.createControlLabel((Composite)assistGroup, (String)(String.valueOf(SQLEditorMessages.pref_page_sql_completion_label_auto_activation_delay) + UIMessages.label_ms));
        this.csAutoActivationDelaySpinner = new Spinner((Composite)assistGroup, 2048);
        this.csAutoActivationDelaySpinner.setSelection(0);
        this.csAutoActivationDelaySpinner.setDigits(0);
        this.csAutoActivationDelaySpinner.setIncrement(50);
        this.csAutoActivationDelaySpinner.setMinimum(0);
        this.csAutoActivationDelaySpinner.setMaximum(1000000);
        this.csAutoActivationDelaySpinner.setToolTipText(SQLEditorMessages.pref_page_sql_completion_label_set_auto_activation_delay_tip);
        this.csAutoActivateOnKeystroke = UIUtils.createCheckbox((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_activate_on_typing, (String)SQLEditorMessages.pref_page_sql_completion_label_activate_on_typing_tip, (boolean)false, (int)2);
        this.csAutoInsertCheck = UIUtils.createCheckbox((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_auto_insert_proposal, (String)SQLEditorMessages.pref_page_sql_completion_label_auto_insert_proposal_tip, (boolean)false, (int)2);
        UIUtils.createControlLabel((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_insert_case);
        this.csInsertCase = new Combo((Composite)assistGroup, 2060);
        this.csInsertCase.add(SQLEditorMessages.pref_page_sql_insert_case_default);
        this.csInsertCase.add(SQLEditorMessages.pref_page_sql_insert_case_upper_case);
        this.csInsertCase.add(SQLEditorMessages.pref_page_sql_insert_case_lower_case);
        this.csReplaceWordAfter = UIUtils.createCheckbox((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_replace_word_after, (String)SQLEditorMessages.pref_page_sql_completion_label_replace_word_after_tip, (boolean)false, (int)2);
        this.csHideDuplicates = UIUtils.createCheckbox((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_hide_duplicate_names, null, (boolean)false, (int)2);
        this.csShortName = UIUtils.createCheckbox((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_use_short_names, null, (boolean)false, (int)2);
        this.csLongName = UIUtils.createCheckbox((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_use_long_names, null, (boolean)false, (int)2);
        this.csInsertSpace = UIUtils.createCheckbox((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_insert_space, null, (boolean)false, (int)2);
        this.csSortAlphabetically = UIUtils.createCheckbox((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_sort_alphabetically, null, (boolean)false, (int)2);
        this.csInsertTableAlias = UIUtils.createCheckbox((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_insert_table_alias, null, (boolean)false, (int)2);
        this.csShowServerHelpTopics = UIUtils.createCheckbox((Composite)assistGroup, (String)SQLEditorMessages.pref_page_sql_completion_label_show_server_help_topics, (String)SQLEditorMessages.pref_page_sql_completion_label_show_server_help_topics_tip, (boolean)false, (int)2);
        Composite rightPanel = new Composite(composite, 0);
        rightPanel.setLayoutData((Object)new GridData(2));
        rightPanel.setLayout((Layout)new GridLayout(1, false));
        Group assistGroup2 = UIUtils.createControlGroup((Composite)rightPanel, (String)SQLEditorMessages.pref_page_sql_format_group_search, (int)1, (int)770, (int)0);
        this.csMatchContains = UIUtils.createCheckbox((Composite)assistGroup2, (String)SQLEditorMessages.pref_page_sql_completion_label_match_contains, (String)SQLEditorMessages.pref_page_sql_completion_label_match_contains_tip, (boolean)false, (int)2);
        this.csUseGlobalSearch = UIUtils.createCheckbox((Composite)assistGroup2, (String)SQLEditorMessages.pref_page_sql_completion_label_use_global_search, (String)SQLEditorMessages.pref_page_sql_completion_label_use_global_search_tip, (boolean)false, (int)2);
        this.csShowColumnProcedures = UIUtils.createCheckbox((Composite)assistGroup2, (String)SQLEditorMessages.pref_page_sql_completion_label_show_column_procedures, (String)SQLEditorMessages.pref_page_sql_completion_label_show_column_procedures_tip, (boolean)false, (int)2);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.csAutoActivationCheck.setSelection(store.getBoolean("SQLEditor.ContentAssistant.auto.activation.enable"));
            this.csAutoActivationDelaySpinner.setSelection(store.getInt("SQLEditor.ContentAssistant.auto.activation.delay"));
            this.csAutoActivateOnKeystroke.setSelection(store.getBoolean("SQLEditor.ContentAssistant.auto.keystrokes.activation"));
            this.csAutoInsertCheck.setSelection(store.getBoolean("SQLEditor.ContentAssistant.insert.single.proposal"));
            this.csInsertCase.select(store.getInt("SQLEditor.ContentAssistant.insert.case"));
            this.csReplaceWordAfter.setSelection(store.getBoolean("SQLEditor.ContentAssistant.replace.word"));
            this.csHideDuplicates.setSelection(store.getBoolean("SQLEditor.ContentAssistant.hide.duplicates"));
            this.csShortName.setSelection(store.getBoolean("SQLEditor.ContentAssistant.proposals.short.name"));
            this.csLongName.setSelection(store.getBoolean("SQLEditor.ContentAssistant.proposals.long.name"));
            this.csInsertSpace.setSelection(store.getBoolean("SQLEditor.ContentAssistant.insert.space.after.proposal"));
            this.csSortAlphabetically.setSelection(store.getBoolean("SQLEditor.ContentAssistant.proposals.sort.alphabetically"));
            this.csInsertTableAlias.setSelection(store.getBoolean("sql.proposals.insert.table.alias"));
            this.csShowServerHelpTopics.setSelection(store.getBoolean("SQLEditor.ContentAssistant.show.helpTopics"));
            this.csMatchContains.setSelection(store.getBoolean("SQLEditor.ContentAssistant.matching.fuzzy"));
            this.csUseGlobalSearch.setSelection(store.getBoolean("SQLEditor.ContentAssistant.use.global.search"));
            this.csShowColumnProcedures.setSelection(store.getBoolean("SQLEditor.ContentAssistant.show.column.procedures"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("SQLEditor.ContentAssistant.auto.activation.enable", this.csAutoActivationCheck.getSelection());
            store.setValue("SQLEditor.ContentAssistant.auto.activation.delay", this.csAutoActivationDelaySpinner.getSelection());
            store.setValue("SQLEditor.ContentAssistant.auto.keystrokes.activation", this.csAutoActivateOnKeystroke.getSelection());
            store.setValue("SQLEditor.ContentAssistant.insert.single.proposal", this.csAutoInsertCheck.getSelection());
            store.setValue("SQLEditor.ContentAssistant.insert.case", this.csInsertCase.getSelectionIndex());
            store.setValue("SQLEditor.ContentAssistant.replace.word", this.csReplaceWordAfter.getSelection());
            store.setValue("SQLEditor.ContentAssistant.hide.duplicates", this.csHideDuplicates.getSelection());
            store.setValue("SQLEditor.ContentAssistant.proposals.short.name", this.csShortName.getSelection());
            store.setValue("SQLEditor.ContentAssistant.proposals.long.name", this.csLongName.getSelection());
            store.setValue("SQLEditor.ContentAssistant.insert.space.after.proposal", this.csInsertSpace.getSelection());
            store.setValue("SQLEditor.ContentAssistant.proposals.sort.alphabetically", this.csSortAlphabetically.getSelection());
            store.setValue("sql.proposals.insert.table.alias", this.csInsertTableAlias.getSelection());
            store.setValue("SQLEditor.ContentAssistant.show.helpTopics", this.csShowServerHelpTopics.getSelection());
            store.setValue("SQLEditor.ContentAssistant.matching.fuzzy", this.csMatchContains.getSelection());
            store.setValue("SQLEditor.ContentAssistant.use.global.search", this.csUseGlobalSearch.getSelection());
            store.setValue("SQLEditor.ContentAssistant.show.column.procedures", this.csShowColumnProcedures.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("SQLEditor.ContentAssistant.auto.activation.enable");
        store.setToDefault("SQLEditor.ContentAssistant.auto.activation.delay");
        store.setToDefault("SQLEditor.ContentAssistant.auto.keystrokes.activation");
        store.setToDefault("SQLEditor.ContentAssistant.insert.single.proposal");
        store.setToDefault("SQLEditor.ContentAssistant.insert.case");
        store.setToDefault("SQLEditor.ContentAssistant.replace.word");
        store.setToDefault("SQLEditor.ContentAssistant.hide.duplicates");
        store.setToDefault("SQLEditor.ContentAssistant.proposals.short.name");
        store.setToDefault("SQLEditor.ContentAssistant.proposals.long.name");
        store.setToDefault("SQLEditor.ContentAssistant.insert.space.after.proposal");
        store.setToDefault("SQLEditor.ContentAssistant.proposals.sort.alphabetically");
        store.setToDefault("sql.proposals.insert.table.alias");
        store.setToDefault("SQLEditor.ContentAssistant.show.helpTopics");
        store.setToDefault("SQLEditor.ContentAssistant.matching.fuzzy");
        store.setToDefault("SQLEditor.ContentAssistant.use.global.search");
        store.setToDefault("SQLEditor.ContentAssistant.show.column.procedures");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

