/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.DBeaverIdentityRepository;
import org.jkiss.dbeaver.model.net.ssh.JSCHUserInfoPromptProvider;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementationAbstract;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SSHImplementationJsch
extends SSHImplementationAbstract {
    private static final Log log = Log.getLog(SSHImplementationJsch.class);
    private transient JSch jsch;
    private volatile transient Session session;

    protected synchronized void setupTunnel(DBRProgressMonitor monitor, DBWHandlerConfiguration configuration, String sshHost, int aliveInterval, int sshPortNum, File privKeyFile, int connectTimeout, String sshLocalHost, int sshLocalPort, String sshRemoteHost, int sshRemotePort) throws DBException, IOException {
        try {
            SSHConstants.AuthType authType;
            String autoTypeString;
            if (this.jsch == null) {
                this.jsch = new JSch();
                JSch.setLogger((Logger)new LoggerProxy());
            }
            SSHConstants.AuthType authType2 = CommonUtils.isEmpty((String)(autoTypeString = CommonUtils.toString((Object)configuration.getProperty("authType")))) ? (privKeyFile == null ? SSHConstants.AuthType.PASSWORD : SSHConstants.AuthType.PUBLIC_KEY) : (authType = (SSHConstants.AuthType)CommonUtils.valueOf(SSHConstants.AuthType.class, (String)autoTypeString, (Enum)SSHConstants.AuthType.PASSWORD));
            if (authType == SSHConstants.AuthType.PUBLIC_KEY) {
                this.addIdentityKey(monitor, configuration.getDataSource(), privKeyFile, configuration.getPassword());
            } else if (authType == SSHConstants.AuthType.AGENT) {
                log.debug((Object)"Creating identityRepository");
                DBeaverIdentityRepository identityRepository = new DBeaverIdentityRepository(this, this.getAgentData());
                this.jsch.setIdentityRepository((IdentityRepository)identityRepository);
            }
            log.debug((Object)"Instantiate SSH tunnel");
            this.session = this.jsch.getSession(configuration.getUserName(), sshHost, sshPortNum);
            this.session.setConfig("StrictHostKeyChecking", "no");
            if (authType == SSHConstants.AuthType.PASSWORD) {
                this.session.setConfig("PreferredAuthentications", "password,keyboard-interactive");
            } else {
                this.session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
            }
            this.session.setConfig("ConnectTimeout", String.valueOf(connectTimeout));
            UserInfo userInfo = null;
            JSCHUserInfoPromptProvider promptProvider = (JSCHUserInfoPromptProvider)GeneralUtils.adapt((Object)((Object)this), JSCHUserInfoPromptProvider.class);
            if (promptProvider != null) {
                userInfo = promptProvider.createUserInfoPrompt(configuration, this.session);
            }
            if (userInfo == null) {
                userInfo = new UIUserInfo(configuration);
            }
            this.session.setUserInfo(userInfo);
            if (aliveInterval != 0) {
                this.session.setServerAliveInterval(aliveInterval);
            }
            log.debug((Object)"Connect to tunnel host");
            this.session.connect(connectTimeout);
            try {
                if (CommonUtils.isEmpty((String)sshLocalHost)) {
                    this.session.setPortForwardingL(sshLocalPort, sshRemoteHost, sshRemotePort);
                } else {
                    this.session.setPortForwardingL(sshLocalHost, sshLocalPort, sshRemoteHost, sshRemotePort);
                }
            }
            catch (JSchException e) {
                this.closeTunnel(monitor);
                throw e;
            }
        }
        catch (JSchException e) {
            throw new DBException("Cannot establish tunnel", (Throwable)e);
        }
    }

    public synchronized void closeTunnel(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.session != null) {
            RuntimeUtils.runTask(monitor1 -> {
                if (this.session != null) {
                    try {
                        this.session.disconnect();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, (String)"Close SSH session", (long)1000L);
            this.session = null;
        }
    }

    public synchronized String getClientVersion() {
        return this.session == null ? null : this.session.getClientVersion();
    }

    public synchronized String getServerVersion() {
        return this.session == null ? null : this.session.getServerVersion();
    }

    public void invalidateTunnel(DBRProgressMonitor monitor) throws DBException, IOException {
        boolean isAlive = false;
        if (isAlive) {
            try {
                this.session.sendKeepAliveMsg();
            }
            catch (Exception exception) {
                isAlive = false;
            }
        }
        if (!isAlive) {
            this.closeTunnel(monitor);
            this.initTunnel(monitor, DBWorkbench.getPlatform(), this.savedConfiguration, this.savedConnectionInfo);
        }
    }

    private void addIdentityKey(DBRProgressMonitor monitor, DBPDataSourceContainer dataSource, File key, String password) throws IOException, JSchException {
        block30: {
            String header;
            Throwable throwable = null;
            Object var7_7 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(key));){
                header = reader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (header.equals("-----BEGIN OPENSSH PRIVATE KEY-----")) {
                log.debug((Object)"Attempting to convert an unsupported key into suitable format");
                String id = dataSource != null ? dataSource.getId() : "profile";
                File dir = DBWorkbench.getPlatform().getTempFolder(monitor, "openssh-pkey");
                File tmp = new File(dir, String.valueOf(id) + ".pem");
                Files.copy(key.toPath(), tmp.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                password = CommonUtils.notEmpty((String)password);
                if (RuntimeUtils.isPlatformWindows()) {
                    password = String.valueOf('\"') + password + '\"';
                }
                Process process = new ProcessBuilder(new String[0]).command("ssh-keygen", "-p", "-P", password, "-N", password, "-m", "PEM", "-f", tmp.getAbsolutePath(), "-q").start();
                try {
                    try {
                        int status;
                        if (!process.waitFor(5000L, TimeUnit.MILLISECONDS)) {
                            process.destroyForcibly();
                        }
                        if ((status = process.exitValue()) != 0) {
                            String message;
                            Throwable throwable3 = null;
                            Object var13_16 = null;
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                                message = reader.lines().collect(Collectors.joining("\n"));
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                            throw new IOException("Specified private key cannot be converted:\n" + message);
                        }
                        this.addIdentityKey0(tmp, password);
                        break block30;
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                finally {
                    if (!tmp.delete()) {
                        log.debug((Object)"Failed to delete private key file");
                    }
                }
            }
            this.addIdentityKey0(key, password);
        }
    }

    private void addIdentityKey0(File key, String password) throws JSchException {
        if (!CommonUtils.isEmpty((String)password)) {
            this.jsch.addIdentity(key.getAbsolutePath(), password);
        } else {
            this.jsch.addIdentity(key.getAbsolutePath());
        }
    }

    private class LoggerProxy
    implements Logger {
        private LoggerProxy() {
        }

        public boolean isEnabled(int level) {
            return true;
        }

        public void log(int level, String message) {
            String levelStr;
            switch (level) {
                case 1: {
                    levelStr = "INFO";
                    break;
                }
                case 2: {
                    levelStr = "WARN";
                    break;
                }
                case 3: {
                    levelStr = "ERROR";
                    break;
                }
                case 4: {
                    levelStr = "FATAL";
                    break;
                }
                default: {
                    levelStr = "DEBUG";
                }
            }
            log.debug((Object)("SSH " + levelStr + ": " + message));
        }
    }

    private class UIUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        DBWHandlerConfiguration configuration;

        private UIUserInfo(DBWHandlerConfiguration configuration) {
            this.configuration = configuration;
        }

        public String getPassphrase() {
            return this.configuration.getPassword();
        }

        public String getPassword() {
            return this.configuration.getPassword();
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptYesNo(String message) {
            return false;
        }

        public void showMessage(String message) {
            log.info((Object)message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            log.debug((Object)"JSCH keyboard interactive auth");
            return new String[]{this.configuration.getPassword()};
        }
    }
}

