/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import hhapplet.FTSPane;
import hhapplet.FTSSearcher;
import hhapplet.ResourceLib;
import hhapplet.URLFileHandler;
import java.applet.Applet;
import java.awt.Label;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sitemap.MyBufferedInputStream;

public class FTSParser
extends Thread {
    protected Applet m_applet;
    protected FTSPane m_spSearch;
    protected FTSSearcher m_ftsSearcher;
    protected Thread m_Thread;
    protected MyBufferedInputStream m_is;
    protected int m_nTotalBytesRead;
    protected int m_nOffset = 0;
    protected String m_strFileName;
    protected URL m_urlDocBase;
    private InputStream m_ZipIs = null;
    protected boolean m_bZipSupport = false;
    private boolean m_bZipFileLoaded = false;
    protected String m_strTopicTitle = null;
    protected String m_strTopicURL = null;

    public FTSSearcher getSearcher() {
        return this.m_ftsSearcher;
    }

    public void parse() {
        this.run();
    }

    public Thread parseInSeparateThread(String string, URL uRL) {
        this.m_strFileName = string;
        this.m_urlDocBase = uRL;
        this.setPriority(4);
        this.start();
        return this;
    }

    protected boolean advancePastQuoteInStream() {
        try {
            byte by;
            do {
                by = (byte)this.m_is.read();
                ++this.m_nTotalBytesRead;
            } while (by != 10 && by != 34);
            return by == 34;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    protected boolean advancePastCommaInStream() {
        try {
            byte by;
            do {
                by = (byte)this.m_is.read();
                ++this.m_nTotalBytesRead;
            } while (by != 10 && by != 44);
            return by == 44;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public FTSParser(Applet applet) {
        this.m_applet = applet;
        this.m_ftsSearcher = new FTSSearcher(this.m_applet);
        this.m_spSearch = new FTSPane(this.m_applet, this.m_ftsSearcher);
        try {
            Class.forName("java.util.zip.ZipFile");
            this.m_bZipSupport = true;
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            this.m_bZipSupport = false;
            return;
        }
    }

    protected boolean advancePastEOLInStream() {
        try {
            byte by;
            do {
                by = (byte)this.m_is.read();
                ++this.m_nTotalBytesRead;
            } while (by != 10);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    protected String getStringFromStream() {
        String string = new String();
        try {
            byte by = (byte)this.m_is.read();
            ++this.m_nTotalBytesRead;
            if (by == 34) {
                by = (byte)this.m_is.read();
                ++this.m_nTotalBytesRead;
            }
            while (by != 34) {
                string = by < 0 ? string + (char)(by + 256) : string + (char)by;
                by = (byte)this.m_is.read();
                ++this.m_nTotalBytesRead;
            }
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    protected String getStopWordFromStream() {
        String string = new String();
        string = this.getStringFromStream();
        this.advancePastEOLInStream();
        return string;
    }

    protected String getKeywordNameFromStream() {
        String string = this.getStringFromStream();
        this.advancePastCommaInStream();
        return string;
    }

    protected void getTopicTitleandURL() {
        String string = new String();
        try {
            byte by;
            do {
                string = (by = (byte)this.m_is.read()) < 0 ? string + (char)(by + 256) : string + (char)by;
                ++this.m_nTotalBytesRead;
            } while (by != 10);
            int n = string.lastIndexOf("\",\"");
            if (n != -1) {
                this.m_strTopicTitle = string.substring(1, n);
                this.m_strTopicURL = string.substring(n + 3);
                int n2 = this.m_strTopicURL.lastIndexOf("\"");
                if (n2 != -1) {
                    this.m_strTopicURL = this.m_strTopicURL.substring(0, n2);
                    return;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void UpdateStreamStatus() {
        this.m_applet.showStatus(ResourceLib.GetRes("LoadingFTS") + " [" + this.m_nTotalBytesRead + "]");
    }

    public void run() {
        try {
            String string;
            Object object;
            Object object2;
            this.m_spSearch.getEditBox().enable(false);
            if (this.m_bZipSupport && this.m_strFileName.toLowerCase().endsWith(".zip")) {
                try {
                    InputStream inputStream = URLFileHandler.makeURL(this.m_urlDocBase, this.m_strFileName, null).openStream();
                    object2 = new ZipInputStream(inputStream);
                    while (!((ZipEntry)(object = ((ZipInputStream)object2).getNextEntry())).getName().toLowerCase().endsWith(".hhs")) {
                    }
                    this.m_is = new MyBufferedInputStream((InputStream)object2);
                    this.m_ZipIs = object2;
                    this.m_bZipFileLoaded = true;
                }
                catch (Exception exception) {}
            }
            if (!this.m_bZipFileLoaded) {
                try {
                    this.m_is = new MyBufferedInputStream(URLFileHandler.makeURL(this.m_urlDocBase, this.m_strFileName, null).openStream());
                }
                catch (Exception exception) {
                    this.m_applet.add("Center", new Label(ResourceLib.GetRes("CantOpenURLorFile") + " " + exception.getMessage()));
                    exception.printStackTrace();
                    return;
                }
            }
            this.m_nTotalBytesRead = 0;
            int n = this.getCountFromStream("TOPICS=");
            this.UpdateStreamStatus();
            this.m_ftsSearcher.setTopicCount(n);
            int n2 = 0;
            while (n2 < n) {
                this.getTopicTitleandURL();
                object2 = this.m_strTopicTitle;
                object = this.m_strTopicURL;
                this.m_ftsSearcher.setTopicData(n2, (String)object2, (String)object);
                if (n2 % 200 == 0) {
                    this.UpdateStreamStatus();
                }
                ++n2;
            }
            int n3 = this.getCountFromStream("KEYWORDS=");
            this.UpdateStreamStatus();
            this.m_ftsSearcher.setKeywordCount(n3);
            n2 = 0;
            while (n2 < n3) {
                String string2 = this.getKeywordNameFromStream();
                string = string2 == null ? null : string2.toLowerCase();
                int[] nArray = this.getKeywordLinksFromStream();
                this.m_ftsSearcher.setKeywordData(n2, string2, nArray);
                if (n2 % 200 == 0) {
                    this.UpdateStreamStatus();
                }
                ++n2;
            }
            int n4 = this.getCountFromStream("STOPWORDS=");
            this.UpdateStreamStatus();
            this.m_ftsSearcher.setStopWordCount(n4);
            n2 = 0;
            while (n2 < n4) {
                string = this.getStopWordFromStream();
                this.m_ftsSearcher.setStopWord(n2, string);
                if (n2 % 200 == 0) {
                    this.UpdateStreamStatus();
                }
                ++n2;
            }
            if (this.m_spSearch != null && this.m_spSearch.getList() != null) {
                this.m_spSearch.getList().clear();
            }
            if (this.m_spSearch != null && this.m_spSearch.getforappleList() != null) {
                this.m_spSearch.getforappleList().clear();
                this.m_spSearch.paintComponents(this.m_spSearch.getGraphics());
            }
            this.m_spSearch.ShowList();
            this.m_applet.showStatus(ResourceLib.GetRes("Done"));
            if (this.m_is != null) {
                try {
                    this.m_is.close();
                    this.m_is = null;
                }
                catch (Exception exception) {}
            }
            if (this.m_ZipIs != null) {
                try {
                    this.m_ZipIs.close();
                    this.m_ZipIs = null;
                }
                catch (Exception exception) {}
            }
            this.m_spSearch.getEditBox().enable(true);
            this.m_spSearch.getEditBox().requestFocus();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public FTSPane getFTS() {
        return this.m_spSearch;
    }

    protected Integer getIntegerFromStream() {
        String string = new String();
        try {
            byte by = (byte)this.m_is.read();
            ++this.m_nTotalBytesRead;
            while (by == 32) {
                by = (byte)this.m_is.read();
                ++this.m_nTotalBytesRead;
            }
            while (by >= 48 && by <= 57) {
                string = by < 0 ? string + (char)(by + 256) : string + (char)by;
                by = (byte)this.m_is.read();
                ++this.m_nTotalBytesRead;
            }
            if (by == 10) {
                return null;
            }
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = null;
                System.out.println("Error at Byte #" + this.m_nTotalBytesRead + " in stream.");
                numberFormatException.printStackTrace();
            }
            return n;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int getCountFromStream(String var1_1) {
        var2_2 = new String();
        var4_3 = false;
        var5_4 = 0;
        try {
            var3_5 = (byte)this.m_is.read();
            ++this.m_nTotalBytesRead;
            ** GOTO lbl23
            {
                var3_5 = (byte)this.m_is.read();
                ++this.m_nTotalBytesRead;
                do {
                    if (var3_5 != 91) continue block2;
                    var3_5 = (byte)this.m_is.read();
                    ++this.m_nTotalBytesRead;
                    while (var5_4 < var1_1.length() && var3_5 == var1_1.charAt(var5_4) && var3_5 != 93) {
                        var3_5 = (byte)this.m_is.read();
                        ++this.m_nTotalBytesRead;
                        ++var5_4;
                    }
                    if (var5_4 == var1_1.length()) {
                        var4_3 = true;
                        continue;
                    }
                    var5_4 = 0;
lbl23:
                    // 3 sources

                } while (!var4_3);
            }
            while (var3_5 >= 48 && var3_5 <= 57) {
                var2_2 = var3_5 < 0 ? var2_2 + (char)(var3_5 + 256) : var2_2 + (char)var3_5;
                var3_5 = (byte)this.m_is.read();
                ++this.m_nTotalBytesRead;
            }
            if (var3_5 == 10) {
                return 0;
            }
            this.advancePastEOLInStream();
            return Integer.parseInt(var2_2);
        }
        catch (IOException var6_6) {
            var6_6.printStackTrace();
            return 0;
        }
    }

    protected int[] getKeywordLinksFromStream() {
        Vector<Integer> vector = new Vector<Integer>();
        Integer n = null;
        do {
            if ((n = this.getIntegerFromStream()) == null) continue;
            vector.addElement(n);
        } while (n != null);
        int[] nArray = new int[vector.size()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = (Integer)vector.elementAt(n2);
            ++n2;
        }
        return nArray;
    }
}

