/*
 ***********************************************************************
 *
 *                           Coryright (c)
 *     Digital Equipment Corporation 1995. All rights reserved.
 *
 *    Restricted Rights: Use, duplication, or disclosure by the U.S.
 *    Government is subject to restrictions as set forth in subparagraph
 *    (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *    52.227-14 Alt. III, as applicable.
 *
 *    This software is proprietary to and embodies the confidential
 *    technology of Digital Equipment Corporation and other parties.
 *    Possession, use, or copying of this software and media is authorized
 *    only pursuant to a valid written license from Digital or an
 *    authorized sublicensor.
 *
 ***********************************************************************
 *    File Name:	mn_char.h
 *    Author:
 *    Creation Date:
 *
 *    Functionality:
 *  Multi-national codes for printable characters in the right side
 *
 ***********************************************************************
 *    Revision History:
 */

#ifndef MN_CHARH
#define MN_CHARH 1

#define	C_SP		0240	/* Space */
#define	C_IEX		0241	/* Inverted exclamation mark */
#define	C_CENT	0242	/* Cent */
#define	C_POUN	0243	/* Pound */
#define	C_YEN		0245	/* Yen */
#define	C_SECT	0247	/* Section sign */
#define	C_ICUR	0250	/* International currency sign */
#define	C_COPY	0251	/* Copyright */
#define	C_FORD	0252	/* Feminine number ordinalizer */
#define	C_DAPL	0253	/* Double angle paretneses left */
#define	C_RING	0260	/* Ring (Degree) */
#define	C_PLMI	0261	/* Plus/minus */
#define	C_S2		0262	/* Superscipt 2 */
#define	C_S3		0263	/* Superscipt 3 */
#define	C_MICR	0265	/* Micro */
#define	C_PARA	0266	/* Paragraph sign */
#define	C_CDOT	0267	/* Centered dot */
#define	C_S1		0271	/* Superscipt 1 */
#define	C_MORD	0272	/* Masculine number ordinalizer */
#define	C_DAPR	0273	/* Double angle parenthesis right */
#define	C_F14		0274	/* Fraction one fourth */
#define	C_F12		0275	/* Fraction one half */
#define	C_IQU		0277	/* Inverted question mark */
#define	C_GR_A	0300	/* Grave accent on capital A */
#define	C_AC_A	0301	/* Acute accent on capital A */
#define	C_CF_A	0302	/* Circumflex accent on capital A */
#define	C_TL_A	0303	/* Tilde accent on capital A */
#define	C_UM_A	0304	/* Umlaut or diaresis accent on capital A */
#define	C_RI_A	0305	/* Ring accent on capital A */
#define	C_AE		0306	/* Capital A-E ligature */
#define	C_CD_C	0307	/* Cedilla accent on capital C */
#define	C_GR_E	0310	/* Grave accent on capital E */
#define	C_AC_E	0311	/* Acute accent on capital E */
#define	C_CF_E	0312	/* Circumflex accent on capital E */
#define	C_UM_E	0313	/* Umlaut or diaresis accent on capital E */
#define	C_GR_I	0314	/* Grave accent on capital I */
#define	C_AC_I	0315	/* Acute accent on capital I */
#define	C_CF_I	0316	/* Circumflex accent on capital I */
#define	C_UM_I	0317	/* Umlaut or diaresis accent on capital I */
#define	C_TL_N	0321	/* Tilde accent on capital N */
#define	C_GR_O	0322	/* Grave accent on capital O */
#define	C_AC_O	0323	/* Acute accent on capital O */
#define	C_CF_O	0324	/* Circumflex accent on capital O */
#define	C_TL_O	0325	/* Tilde accent on capital O */
#define	C_UM_O	0326	/* Umlaut or diaresis accent on capital O */
#define	C_OE		0327	/* Capital O-E ligature */
#define	C_SL_O	0330	/* Slash accent on capital O */
#define	C_GR_U	0331	/* Grave accent on capital U */
#define	C_AC_U	0332	/* Acute accent on capital U */
#define	C_CF_U	0333	/* Circumflex accent on capital U */
#define	C_UM_U	0334	/* Umlaut or diaresis accent on capital U */
#define	C_UM_Y	0335	/* Umlaut or diaresis accent on capital Y */
#define	C_ss		0337	/* German sharp s (There is no uppercase version!) */
#define	C_GR_a	0340	/* Grave accent on lowercase a */
#define	C_AC_a	0341	/* Acute accent on lowercase a */
#define	C_CF_a	0342	/* Circumflex accent on lowercase a */
#define	C_TL_a	0343	/* Tilde accent on lowercase a */
#define	C_UM_a	0344	/* Umlaut or diaresis accent on lowercase a */
#define	C_RI_a	0345	/* Ring accent on lowercase a */
#define	C_ae		0346	/* Lowercase a-e ligature */
#define	C_CD_c	0347	/* Cedilla accent on lowercase c */
#define	C_GR_e	0350	/* Grave accent on lowercase e */
#define	C_AC_e	0351	/* Acute accent on lowercase e */
#define	C_CF_e	0352	/* Circumflex accent on lowercase e */
#define	C_UM_e	0353	/* Umlaut or diaresis accent on lowercase e */
#define	C_GR_i	0354	/* Grave accent on lowercase i */
#define	C_AC_i	0355	/* Acute accent on lowercase i */
#define	C_CF_i	0356	/* Circumflex accent on lowercase i */
#define	C_UM_i	0357	/* Umlaut or diaresis accent on lowercase i */
#define	C_TL_n	0361	/* Tilde accent on lowercase n */
#define	C_GR_o	0362	/* Grave accent on lowercase o */
#define	C_AC_o	0363	/* Acute accent on lowercase o */
#define	C_CF_o	0364	/* Circumflex accent on lowercase o */
#define	C_TL_o	0365	/* Tilde accent on lowercase o */
#define	C_UM_o	0366	/* Umlaut or diaresis accent on lowercase o */
#define	C_oe		0367	/* Lowercase o-e ligature */
#define	C_SL_o	0370	/* Slash accent on lowercase o */
#define	C_GR_u	0371	/* Grave accent on lowercase u */
#define	C_AC_u	0372	/* Acute accent on lowercase u */
#define	C_CF_u	0373	/* Circumflex accent on lowercase u */
#define	C_UM_u	0374	/* Umlaut or diaresis accent on lowercase u */
#define	C_UM_y	0375	/* Umlaut or diaresis accent on lowercase y */

#endif
