/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.ClassData;
import fpc.tools.javapp.RuntimeConstants;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

class InnerClassData
implements RuntimeConstants {
    ClassData cls;
    int inner_class_info_index;
    int outer_class_info_index;
    int inner_name_index;
    int access;

    public InnerClassData(ClassData cls) {
        this.cls = cls;
    }

    public void read(DataInputStream in) throws IOException {
        this.inner_class_info_index = in.readUnsignedShort();
        this.outer_class_info_index = in.readUnsignedShort();
        this.inner_name_index = in.readUnsignedShort();
        this.access = in.readUnsignedShort();
    }

    public String[] getAccess() {
        Vector<String> v = new Vector<String>();
        if ((this.access & 1) != 0) {
            v.addElement("public");
        }
        if ((this.access & 4) != 0) {
            v.addElement("protected");
        }
        if ((this.access & 2) != 0) {
            v.addElement("private");
        }
        if ((this.access & 0x10) != 0) {
            v.addElement("final");
        }
        if ((this.access & 0x400) != 0) {
            v.addElement("abstract");
        }
        Object[] accflags = new String[v.size()];
        v.copyInto(accflags);
        return accflags;
    }
}

