/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.AttrData;
import fpc.tools.javapp.ClassData;
import fpc.tools.javapp.ClassIdentifierInfo;
import fpc.tools.javapp.FieldData;
import fpc.tools.javapp.PascalTypeSignature;
import fpc.tools.javapp.TypeSignature;
import java.util.Vector;

public class PascalFieldData
extends FieldData {
    private String cachedName;

    public PascalFieldData(ClassData cls) {
        super(cls);
    }

    public String getVisibilitySectionName() {
        if ((this.access & 1) != 0) {
            return "public";
        }
        if ((this.access & 2) != 0) {
            return "strict private";
        }
        if ((this.access & 4) != 0) {
            return "strict protected";
        }
        return "private";
    }

    public boolean isFormalConst() {
        int i = 0;
        while (i < this.attrs.size()) {
            if (((AttrData)this.attrs.elementAt(i)).getAttrName().equals("ConstantValue")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getModifiers() {
        Vector<String> v = new Vector<String>();
        if (this.isFormalConst()) {
            return "const";
        }
        if ((this.access & 0x10) != 0) {
            v.addElement("final");
        }
        if ((this.access & 8) != 0) {
            v.addElement("class var");
        } else {
            v.addElement("var");
        }
        String res = (String)v.elementAt(0);
        int i = 1;
        while (i < v.size()) {
            res = String.valueOf(res) + " " + (String)v.elementAt(i);
            ++i;
        }
        return res;
    }

    public String getType() {
        return new PascalTypeSignature(this.getInternalSig(), this.cls, false, false, false).getFieldType();
    }

    public String getRawBaseType() {
        String res = new TypeSignature(this.getInternalSig()).getFieldType();
        int arrIndex = res.indexOf(91);
        if (arrIndex != -1) {
            res = res.substring(0, arrIndex);
        }
        return res;
    }

    public String getName() {
        if (this.cachedName == null) {
            String realName = super.getName();
            if (!this.isFormalConst()) {
                realName = "f" + realName;
            }
            this.cachedName = ClassIdentifierInfo.AddIdentifierNameForClass(this.cls.getClassName(), realName);
        }
        return this.cachedName;
    }
}

