/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.alg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;

public abstract class IntArrayGraphAlgorithm<V, E> {
    protected final List<V> _vertices;
    protected final int[][] _neighbors;
    protected final Map<V, Integer> _vertexToPos;

    public IntArrayGraphAlgorithm(Graph<V, E> g) {
        int numVertices = g.vertexSet().size();
        this._vertices = new ArrayList<V>(numVertices);
        this._neighbors = new int[numVertices][];
        this._vertexToPos = new HashMap<V, Integer>(numVertices);
        int index = 0;
        for (V vertex : g.vertexSet()) {
            this._vertices.add(vertex);
            this._neighbors[index++] = new int[g.edgesOf(vertex).size()];
            this._vertexToPos.put((Integer)vertex, index);
        }
        for (int i = 0; i < numVertices; ++i) {
            int nbIndex = 0;
            V vertex = this._vertices.get(i);
            for (E e : g.edgesOf(vertex)) {
                this._neighbors[i][nbIndex++] = this._vertexToPos.get(Graphs.getOppositeVertex(g, e, vertex));
            }
        }
    }
}

