#!/usr/bin/env bash

# The msp430-gcc toolchain can be built from source by applying the patch files
# in this directory to the corresponding upstream sources.
#
# The name of the patch files indicate the upstream git tag the sources were
# diff'ed against to generate the patches.
# 
# The following example script will automatically fetch the upstream sources and
# apply the patches. It assume you are on a GNU/Linux system with common
# development tools installed. If you have trouble running the script, it may be
# easier to manually download the correct upstream sources and apply the
# patches.
# 
# The supplied README-build.txt file contains an example script which builds the
# toolchain from the resulting source tree.

set -e
set -x

gcc_patch="$(echo gcc-*.patch)"
gdb_patch="$(echo gdb-*-release.patch)"
binutils_patch="$(echo binutils-*.patch)"
newlib_patch="$(echo newlib-*.patch)"

temp="${gcc_patch##gcc-}"
gcc_ver="${temp%%.patch}"

temp="${gdb_patch##gdb-}"
gdb_ver="${temp%%-release*}"

temp="${binutils_patch##binutils-}"
temp="${temp%%.patch}"
binutils_ver="$(echo $temp | tr '_' '.')"

temp="${newlib_patch##newlib-}"
temp="${temp%%.patch}"
newlib_ver="$(echo $temp | tr '_' '.')"

gdb_url="https://ftp.gnu.org/gnu/gdb/gdb-$gdb_ver.tar.gz"
binutils_url="https://ftp.gnu.org/gnu/binutils/binutils-$binutils_ver.tar.bz2"
newlib_url="ftp://sourceware.org/pub/newlib/newlib-$newlib_ver.tar.gz"
gcc_url="https://ftp.gnu.org/gnu/gcc/gcc-$gcc_ver/gcc-$gcc_ver.tar.gz"

curl -O $gcc_url
curl -O $gdb_url
curl -O $binutils_url
curl -O $newlib_url

tar -xf "$(basename $gcc_url)"
ln -nfs "gcc-$gcc_ver" gcc
pushd gcc
  patch -p0 -i ../$gcc_patch
popd

tar -xf $(basename $binutils_url)
ln -nfs "binutils-$binutils_ver" binutils
pushd binutils
  patch -p0 -i ../$binutils_patch
popd

tar -xf $(basename $newlib_url)
ln -nfs "newlib-$newlib_ver" newlib
pushd newlib
  patch -p0 -i ../$newlib_patch
popd

tar -xf $(basename $gdb_url)
ln -nfs "gdb-$gdb_ver" gdb
pushd gdb
  patch -p0 -i ../$gdb_patch
popd

