/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.xml;

import java.nio.charset.Charset;
import java.util.List;
import org.catacombae.xml.Attribute;
import org.catacombae.xml.ExternalID;
import org.catacombae.xml.XMLContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugXMLContentHandler
extends XMLContentHandler {
    public DebugXMLContentHandler(Charset encoding) {
        super(encoding);
    }

    @Override
    public void xmlDecl(String version, String encoding, Boolean standalone) {
        DebugXMLContentHandler.print("xmlDecl: <?xml version=\"" + version + "\"");
        if (encoding != null) {
            DebugXMLContentHandler.print(" encoding=\"" + encoding + "\"");
        }
        if (standalone != null) {
            DebugXMLContentHandler.print(" standalone=\"");
            if (standalone.booleanValue()) {
                DebugXMLContentHandler.print("yes");
            } else {
                DebugXMLContentHandler.print("no");
            }
            DebugXMLContentHandler.print("\"");
        }
        DebugXMLContentHandler.println("?>");
    }

    @Override
    public void pi(String id, String content) {
        DebugXMLContentHandler.print("pi: <?" + id);
        if (content != null) {
            DebugXMLContentHandler.print(" " + content);
        }
        DebugXMLContentHandler.println("?>");
    }

    @Override
    public void comment(String content) {
        DebugXMLContentHandler.println("comment: <!--" + content + "-->");
    }

    @Override
    public void doctype(String name, ExternalID eid) {
        DebugXMLContentHandler.print("doctype: <!DOCTYPE " + name);
        if (eid != null) {
            if (eid.type == 0) {
                DebugXMLContentHandler.print("SYSTEM \"" + eid.systemLiteral + "\"");
            } else if (eid.type == 1) {
                DebugXMLContentHandler.print("PUBLIC \"" + eid.pubidLiteral + "\" \"" + eid.systemLiteral + "\"");
            }
        }
        DebugXMLContentHandler.println(">");
    }

    @Override
    public void cdata(String cdata) {
        DebugXMLContentHandler.println("cdata: <![CDATA[" + cdata + "]]>");
    }

    @Override
    public void emptyElement(String name, List<Attribute> attributes) {
        DebugXMLContentHandler.print("emptyElement: <" + name);
        for (Attribute attr : attributes) {
            DebugXMLContentHandler.print(" " + attr.identifier + "=\"" + attr.value + "\"");
        }
        DebugXMLContentHandler.println("/>");
    }

    @Override
    public void startElement(String name, List<Attribute> attributes) {
        DebugXMLContentHandler.print("startElement: <" + name);
        for (Attribute attr : attributes) {
            DebugXMLContentHandler.print(" " + attr.identifier + "=\"" + attr.value + "\"");
        }
        DebugXMLContentHandler.println(">");
    }

    @Override
    public void endElement(String name) {
        DebugXMLContentHandler.println("endElement: </" + name + ">");
    }

    @Override
    public void chardata(int beginLine, int beginColumn, int endLine, int endColumn) {
        DebugXMLContentHandler.println("chardata: starting at (" + beginLine + "," + beginColumn + ") and ending at (" + endLine + "," + endColumn + ")");
    }

    @Override
    public void reference(String ref) {
        DebugXMLContentHandler.println("reference: \"" + ref + "\"");
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

