/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.NotFoundException;

public class AVR32_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 185;
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        int type = relocation.getType();
        int symbolIndex = relocation.getSymbolIndex();
        long addend = relocation.getAddend();
        ElfHeader elf = elfRelocationContext.getElfHeader();
        long offset = (int)relocationAddress.getOffset();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        int oldValue = memory.getInt(relocationAddress);
        int byteLength = 4;
        if (elf.e_machine() == 185) {
            int newValueShiftToAligntoUpper = 0;
            switch (type) {
                case 0: {
                    return RelocationResult.SKIPPED;
                }
                case 1: {
                    int newValue = (int)symbolValue + (int)addend & 0xFFFFFFFF;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                case 7: {
                    int newValue = (int)symbolValue + (int)addend + oldValue & 0xFFFFFFFF;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                case 18: {
                    int newValue = (int)(symbolValue + (long)((int)addend) - offset >> 1);
                    int nVpart1 = newValue & 0xFFFF;
                    int nVpart2 = newValue & 0x10000;
                    int nVpart3 = newValue & 0x1E0000;
                    int newValueParts = (nVpart3 << 8 | nVpart2 << 4 | nVpart1) & 0x1E10FFFF;
                    int newValueSet = oldValue | newValueParts;
                    memory.setInt(relocationAddress, newValueSet);
                    break;
                }
                case 23: {
                    int newValue = (int)(symbolValue + (long)((int)addend) - offset >> 1 << 4);
                    int tempNewValHold = newValue & 0xFF3;
                    int tempDispHold = (newValue & 0x3000) >> 12;
                    newValueShiftToAligntoUpper = tempNewValHold << 16 | tempDispHold << 16;
                    newValue = (oldValue | newValueShiftToAligntoUpper) & 0xFFFFFFFF;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                case 25: {
                    int newValue = (int)(symbolValue + (long)((int)addend) - offset >> 1 << 4 & 0xFF0L);
                    newValueShiftToAligntoUpper = newValue << 16;
                    newValue = (oldValue | newValueShiftToAligntoUpper) & 0xFFFFFFFF;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                case 36: {
                    int newValue = (int)symbolValue + (int)addend & 0xFFFFFFFF;
                    memory.setInt(relocationAddress, newValue);
                    Address currNewAddress = space.getAddress((long)newValue);
                    if (!memory.contains(currNewAddress) && sym != null) {
                        byte currElfSymbolInfoBind = sym.getBind();
                        byte currElfSymbolInfoType = sym.getType();
                        if (currElfSymbolInfoBind == 1 && (currElfSymbolInfoType == 1 || currElfSymbolInfoType == 0)) {
                            String currElfSymbolName = sym.getNameAsString();
                            long currElfSymbolSize = sym.getSize();
                            if (currElfSymbolSize == 0L) {
                                currElfSymbolSize = 2L;
                            }
                            StringBuffer newSectionNameBuff = new StringBuffer();
                            newSectionNameBuff.append("cpool.");
                            newSectionNameBuff.append(currElfSymbolName);
                            StringBuffer newSectionTypeBuff = new StringBuffer();
                            newSectionTypeBuff.append("Constant Pool ");
                            boolean isReadable = true;
                            boolean isWritable = true;
                            boolean isExecutable = true;
                            if (currElfSymbolInfoType == 1) {
                                isReadable = true;
                                isWritable = true;
                                isExecutable = false;
                                newSectionTypeBuff.append("Global Variable Object");
                            } else {
                                isReadable = true;
                                isWritable = false;
                                isExecutable = true;
                                newSectionTypeBuff.append("Global External Function");
                            }
                            ElfLoadHelper loadHelper = elfRelocationContext.getLoadHelper();
                            MemoryBlockUtils.createInitializedBlock((Program)program, (boolean)false, (String)newSectionNameBuff.toString(), (Address)currNewAddress, (long)currElfSymbolSize, (String)newSectionTypeBuff.toString(), (String)"AVR32-ELF Loader", (boolean)isReadable, (boolean)isWritable, (boolean)isExecutable, (MessageLog)loadHelper.getLog());
                        }
                    }
                    try {
                        Listing listing = program.getListing();
                        listing.createData(relocationAddress, StructConverter.POINTER, relocationAddress.getPointerSize());
                    }
                    catch (CodeUnitInsertionException cuie) {
                        System.out.println("Attempting to create Pointer Data: " + cuie);
                    }
                    break;
                }
                case 37: {
                    int checkForPC = oldValue & 0xF0000;
                    int newValue = checkForPC == 983040 ? (int)(symbolValue + (long)((int)addend) - (offset & 0xFFFFFFFFFFFFFFFCL) >> 2 & 0xFFFFL) : (int)(symbolValue + (long)((int)addend) - offset >> 2 & 0xFFFFL);
                    int newValueSet_CPCALL = (oldValue | newValue) & 0xFFFFFFFF;
                    memory.setInt(relocationAddress, newValueSet_CPCALL);
                    break;
                }
                case 39: {
                    int newValue = (int)(symbolValue + (long)((int)addend) - (offset & 0xFFFFFFFFFFFFFFFCL) >>> 2 << 4 & 0x7F0L);
                    newValueShiftToAligntoUpper = newValue << 16;
                    newValue = (oldValue | newValueShiftToAligntoUpper) & 0xFFFFFFFF;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                case 43: {
                    return RelocationResult.SKIPPED;
                }
                default: {
                    AVR32_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)elfRelocationContext.getSymbolName(symbolIndex), (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.UNSUPPORTED;
                }
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

