/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.BitFieldGroupCompositeMember;
import ghidra.app.util.bin.format.pdb.CompositeMember;
import ghidra.app.util.bin.format.pdb.PdbBitField;
import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.WrappedDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.datastruct.RangeMap;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;

public class DefaultCompositeMember
extends CompositeMember {
    private static int MAX_CONSTRUCTION_DEPTH = 20;
    private DataTypeManager dataTypeManager;
    private Consumer<String> errorConsumer;
    private DefaultCompositeMember parent;
    private boolean isClass;
    private String memberName;
    private String memberDataTypeName;
    private int memberOffset;
    private String memberComment;
    private MemberType memberType;
    private int memberLength;
    private DataType memberDataType;
    private boolean memberIsZeroLengthArray;
    private BitFieldGroupCompositeMember bitFieldGroup;
    private Map<Integer, CompositeMember> structureMemberOffsetMap;
    private RangeMap structureMemberRangeMap;
    private List<CompositeMember> unionMemberList;
    private static long nextTemporaryValue;

    private static synchronized String allocateTemporaryContainerName(String type) {
        return "_tmp_" + type + nextTemporaryValue++;
    }

    private DefaultCompositeMember(boolean isClass, Composite editComposite, Consumer<String> errorConsumer) throws CancelledException {
        this.isClass = isClass;
        this.memberDataType = editComposite;
        this.memberOffset = -1;
        this.dataTypeManager = editComposite.getDataTypeManager();
        this.errorConsumer = errorConsumer;
        this.initializeContainer();
    }

    private DefaultCompositeMember(PdbMember member, DataTypeManager dataTypeManager, Consumer<String> errorConsumer, TaskMonitor monitor) throws DataTypeDependencyException, CancelledException {
        this.memberName = member.memberName;
        this.memberDataTypeName = member.memberDataTypeName;
        this.memberOffset = member.memberOffset;
        this.memberComment = member.memberComment;
        this.memberType = MemberType.MEMBER;
        this.memberLength = 0;
        this.dataTypeManager = dataTypeManager;
        WrappedDataType wrappedDataType = member.getDataType();
        if (wrappedDataType == null) {
            throw new DataTypeDependencyException("Failed to resolve datatype " + this.memberDataTypeName + " " + this.memberName);
        }
        this.memberDataType = wrappedDataType.getDataType().clone(dataTypeManager);
        this.memberIsZeroLengthArray = wrappedDataType.isZeroLengthArray();
    }

    private DefaultCompositeMember(DefaultCompositeMember member) {
        this.memberName = member.memberName;
        this.memberDataTypeName = member.memberDataTypeName;
        this.memberDataType = member.memberDataType;
        this.memberIsZeroLengthArray = member.memberIsZeroLengthArray;
        this.memberOffset = member.memberOffset;
        this.memberComment = member.memberComment;
        this.memberType = member.memberType;
        this.memberLength = member.memberLength;
        this.errorConsumer = member.errorConsumer;
        this.dataTypeManager = member.dataTypeManager;
        this.structureMemberOffsetMap = member.structureMemberOffsetMap;
        this.structureMemberRangeMap = member.structureMemberRangeMap;
        this.unionMemberList = member.unionMemberList;
    }

    private DefaultCompositeMember(int componentOffset, DataType baseDataType, int bitSize, int bitOffsetWithinBaseType) throws InvalidDataTypeException {
        this.memberName = "padding";
        this.memberDataType = new PdbBitField(baseDataType, bitSize, bitOffsetWithinBaseType);
        this.memberIsZeroLengthArray = false;
        this.memberOffset = componentOffset;
        this.memberType = MemberType.MEMBER;
        this.memberLength = baseDataType.getLength();
        this.dataTypeManager = baseDataType.getDataTypeManager();
    }

    @Override
    DefaultCompositeMember getParent() {
        return this.parent;
    }

    @Override
    void setParent(DefaultCompositeMember newParent) {
        this.parent = newParent;
    }

    private String getName() {
        return this.memberName;
    }

    private String getDataTypeName() {
        return this.memberDataType != null ? this.memberDataType.getName() : this.memberDataTypeName;
    }

    DataType getDataType() {
        return this.memberDataType;
    }

    private void updateContainerNameAndCategoryPath(String typeMnemonic) {
        if (this.parent == null || !this.isContainer()) {
            return;
        }
        String baseName = this.parent.getDataTypeName();
        String oldMemberName = this.memberName;
        String name = "_" + typeMnemonic + "_";
        if (this.parent.isUnionContainer()) {
            try {
                name = name + this.parent.getOrdinal(oldMemberName);
            }
            catch (NotFoundException e) {
                Msg.error((Object)this, (Object)("Failed to rename anonymous compsite: " + this.getDataTypeName()));
            }
        } else {
            name = name + this.memberOffset;
        }
        try {
            this.memberDataType.setName(baseName + name);
            this.memberDataType.setCategoryPath(this.parent.getChildCategoryPath());
            this.memberName = name;
            this.parent.memberNameChanged(oldMemberName, this.memberName);
        }
        catch (InvalidNameException | DuplicateNameException e) {
            throw new AssertException(e);
        }
    }

    private void transformLastMemberIntoFlexArray(CompositeMember lastMember) {
        if (!(lastMember instanceof DefaultCompositeMember)) {
            return;
        }
        DefaultCompositeMember m = (DefaultCompositeMember)lastMember;
        if (m.memberIsZeroLengthArray) {
            Structure struct = (Structure)this.memberDataType;
            Array array = (Array)m.getDataType();
            struct.delete(struct.getNumComponents() - 1);
            struct.insertAtOffset(m.memberOffset, (DataType)new ArrayDataType(array.getDataType(), 0, 1, this.dataTypeManager), 0, m.getName(), m.memberComment);
        }
    }

    @Override
    void finalizeDataType(int preferredSize) {
        if (!this.isContainer()) {
            return;
        }
        if (this.isStructureContainer()) {
            this.updateContainerNameAndCategoryPath("s");
            CompositeMember lastMember = null;
            for (CompositeMember member : this.structureMemberOffsetMap.values()) {
                member.finalizeDataType(0);
                lastMember = member;
            }
            this.transformLastMemberIntoFlexArray(lastMember);
            this.adjustSize(preferredSize);
        } else if (this.isUnionContainer()) {
            this.updateContainerNameAndCategoryPath("u");
            for (CompositeMember member : this.unionMemberList) {
                member.finalizeDataType(0);
            }
        }
        this.alignComposite(preferredSize);
    }

    private void adjustSize(int preferredSize) {
        DataTypeComponent comp;
        if (!this.isStructureContainer()) {
            return;
        }
        Structure struct = (Structure)this.getDataType();
        if (struct.isNotYetDefined() && preferredSize > 0) {
            struct.growStructure(preferredSize);
            return;
        }
        if (struct.getLength() < preferredSize) {
            struct.growStructure(preferredSize - struct.getLength());
            return;
        }
        DataTypeComponent dtc = struct.getComponentContaining(preferredSize);
        if (dtc == null) {
            return;
        }
        int startOrdinal = dtc.getOrdinal();
        if (dtc.getOffset() != preferredSize) {
            ++startOrdinal;
        }
        for (int i = struct.getNumComponents() - 1; i >= startOrdinal && (comp = struct.getComponent(i)).getDataType() == DataType.DEFAULT; --i) {
            struct.delete(i);
        }
    }

    private void alignComposite(int preferredSize) {
        if (this.isStructureContainer() ? this.structureMemberOffsetMap.isEmpty() : this.unionMemberList.isEmpty()) {
            return;
        }
        Composite composite = (Composite)this.memberDataType;
        Composite copy = (Composite)composite.copy(this.dataTypeManager);
        int pack = 0;
        copy.setToDefaultPacking();
        boolean alignOK = this.isGoodAlignment(copy, preferredSize);
        if (alignOK) {
            composite.setToDefaultPacking();
        } else {
            copy.setToMachineAligned();
            alignOK = this.isGoodAlignment(copy, preferredSize);
            if (alignOK) {
                composite.setToDefaultPacking();
                composite.setToMachineAligned();
            } else {
                pack = 1;
                copy.setExplicitPackingValue(pack);
                alignOK = this.isGoodAlignment(copy, preferredSize);
                if (alignOK) {
                    composite.setExplicitPackingValue(pack);
                }
            }
        }
        if (!alignOK && this.errorConsumer != null && !this.isClass) {
            String anonymousStr = this.parent != null ? " anonymous " : "";
            this.errorConsumer.accept("PDB " + anonymousStr + this.memberType + " reconstruction failed to align " + composite.getPathName());
        }
    }

    private boolean isGoodAlignment(Composite testComposite, int preferredSize) {
        boolean alignOK = true;
        if (preferredSize > 0 && testComposite.getNumComponents() != 0) {
            boolean bl = alignOK = testComposite.getLength() == preferredSize;
        }
        if (alignOK && this.isStructureContainer()) {
            Structure struct = (Structure)this.memberDataType;
            DataTypeComponent[] nonPackedComponents = struct.getDefinedComponents();
            int index = 0;
            for (DataTypeComponent dtc : testComposite.getComponents()) {
                DataTypeComponent nonPackedDtc;
                if (this.isComponentUnchanged(dtc, nonPackedDtc = nonPackedComponents[index++])) continue;
                alignOK = false;
                break;
            }
        }
        return alignOK;
    }

    private boolean isComponentUnchanged(DataTypeComponent dtc, DataTypeComponent nonPackedDtc) {
        if (nonPackedDtc.getOffset() != dtc.getOffset() || nonPackedDtc.getLength() != dtc.getLength() || nonPackedDtc.isBitFieldComponent() != dtc.isBitFieldComponent()) {
            return false;
        }
        if (dtc.isBitFieldComponent()) {
            BitFieldDataType bitfieldDt = (BitFieldDataType)dtc.getDataType();
            BitFieldDataType nonPackedBitfieldDt = (BitFieldDataType)nonPackedDtc.getDataType();
            if (bitfieldDt.getBitOffset() != nonPackedBitfieldDt.getBitOffset() || bitfieldDt.getBitSize() != nonPackedBitfieldDt.getBitSize()) {
                return false;
            }
        }
        return true;
    }

    @Override
    int getOffset() {
        return this.memberOffset;
    }

    @Override
    void setOffset(int offset) {
        this.memberOffset = offset;
    }

    @Override
    int getLength() {
        if (this.memberDataType instanceof BitFieldDataType) {
            BitFieldDataType bitfield = (BitFieldDataType)this.memberDataType;
            return bitfield.getBaseTypeSize();
        }
        return this.memberDataType != null ? this.memberDataType.getLength() : this.memberLength;
    }

    private void initializeContainer() {
        if (!(this.memberDataType instanceof Composite)) {
            throw new AssertException("Root must resolve to a composite type");
        }
        if (this.memberDataType instanceof Structure) {
            this.memberType = MemberType.STRUCTURE;
            this.structureMemberOffsetMap = new TreeMap<Integer, CompositeMember>();
            this.structureMemberRangeMap = new RangeMap(-1);
            this.unionMemberList = null;
        } else {
            if (this.isClass) {
                throw new AssertException();
            }
            this.memberType = MemberType.UNION;
            this.unionMemberList = new ArrayList<CompositeMember>();
            this.structureMemberOffsetMap = null;
            this.structureMemberRangeMap = null;
        }
        this.memberLength = 0;
    }

    @Override
    boolean isContainer() {
        return this.memberType != MemberType.MEMBER;
    }

    @Override
    boolean isUnionContainer() {
        return this.unionMemberList != null;
    }

    @Override
    boolean isStructureContainer() {
        return this.structureMemberOffsetMap != null;
    }

    @Override
    boolean isBitFieldMember() {
        return this.memberDataType instanceof PdbBitField;
    }

    @Override
    boolean isSingleBitFieldMember() {
        return this.isBitFieldMember() && this.bitFieldGroup == null;
    }

    private int getDepth() {
        int depth = 0;
        DefaultCompositeMember p = this.parent;
        while (p != null) {
            p = p.parent;
            ++depth;
        }
        return depth;
    }

    public String toString() {
        String type = this.isUnionContainer() ? "Union" : (this.isStructureContainer() ? "Structure" : (this.isBitFieldMember() ? this.memberDataType.toString() : this.memberDataTypeName));
        return "[CompositeMember: " + this.memberOffset + " " + this.memberName + " " + type + "]";
    }

    private boolean addMember(PdbMember child, TaskMonitor monitor) throws CancelledException, DataTypeDependencyException {
        if (!this.isContainer()) {
            throw new AssertException("addMember only permitted on root members");
        }
        if (!(this.memberDataType instanceof Composite)) {
            throw new AssertException();
        }
        return this.addMember(new DefaultCompositeMember(child, this.dataTypeManager, this.errorConsumer, monitor));
    }

    private CategoryPath getChildCategoryPath() {
        return new CategoryPath(this.memberDataType.getCategoryPath(), new String[]{this.getDataTypeName()});
    }

    private String getOutermostDataTypeName() {
        if (this.parent != null) {
            return this.parent.getOutermostDataTypeName();
        }
        return this.getDataTypeName();
    }

    private boolean transformIntoUnionContainer() {
        if (this.parent == null) {
            throw new AssertException();
        }
        if (this.getDepth() >= MAX_CONSTRUCTION_DEPTH) {
            Msg.error((Object)this, (Object)("PDB composite reconstruction exceeded maximum allowed depth: " + this.getOutermostDataTypeName()));
            return false;
        }
        List<CompositeMember> elderSiblings = this.kidnapElderSiblingsFromParentStructure();
        DefaultCompositeMember memberCopy = new DefaultCompositeMember(this);
        memberCopy.memberOffset = 0;
        CategoryPath tempCategoryPath = this.parent.getDataType().getCategoryPath();
        String tempName = DefaultCompositeMember.allocateTemporaryContainerName("union");
        UnionDataType nestedUnion = new UnionDataType(tempCategoryPath, tempName, this.dataTypeManager);
        nestedUnion.add(this.memberDataType, this.memberName, memberCopy.getMemberComment());
        String oldName = this.memberName;
        this.memberName = tempName;
        this.memberDataType = nestedUnion;
        this.memberIsZeroLengthArray = false;
        this.memberDataTypeName = null;
        this.initializeContainer();
        this.unionMemberList.add(memberCopy);
        memberCopy.parent = this;
        if (!elderSiblings.isEmpty()) {
            if (!memberCopy.transformIntoStructureContainer()) {
                return false;
            }
            for (CompositeMember sibling : elderSiblings) {
                sibling.setOffset(sibling.getOffset() - this.memberOffset);
                if (sibling.addToStructure(memberCopy)) continue;
                return false;
            }
        }
        if (this.parent != null) {
            this.parent.memberChanged(oldName, this);
        }
        return true;
    }

    @Override
    boolean addToStructure(DefaultCompositeMember structure) {
        return structure.addStructureMember(this);
    }

    boolean transformIntoStructureContainer() {
        if (this.parent == null) {
            throw new AssertException();
        }
        if (this.getDepth() >= MAX_CONSTRUCTION_DEPTH) {
            Msg.error((Object)this, (Object)("PDB composite reconstruction exceeded maximum allowed depth: " + this.getOutermostDataTypeName()));
            return false;
        }
        DefaultCompositeMember memberCopy = new DefaultCompositeMember(this);
        memberCopy.memberOffset = 0;
        CategoryPath tempCategoryPath = this.parent.getDataType().getCategoryPath();
        String tempName = DefaultCompositeMember.allocateTemporaryContainerName("struct");
        StructureDataType nestedStructure = new StructureDataType(tempCategoryPath, tempName, 0, this.dataTypeManager);
        String oldName = this.memberName;
        DataType oldDataType = this.memberDataType;
        DefaultCompositeMember deferredBitFieldMember = null;
        if (oldDataType instanceof PdbBitField) {
            PdbBitField bitfieldDt = (PdbBitField)oldDataType;
            try {
                int bitOffset = bitfieldDt.getBitOffsetWithinBase();
                DefaultCompositeMember padding = this.getPaddingBitField(null, memberCopy);
                if (padding != null) {
                    deferredBitFieldMember = memberCopy;
                    memberCopy = padding;
                    bitfieldDt = (PdbBitField)memberCopy.memberDataType;
                    bitOffset = bitfieldDt.getBitOffsetWithinBase();
                } else if (bitOffset < 0) {
                    bitOffset = 0;
                }
                DefaultCompositeMember.insertMinimalStructureBitfield((Structure)nestedStructure, 0, memberCopy.memberName, bitfieldDt, memberCopy.getMemberComment());
            }
            catch (InvalidDataTypeException e) {
                Msg.error((Object)this, (Object)("PDB failed to add bitfield: " + e.getMessage()));
                return false;
            }
        } else {
            nestedStructure.insertAtOffset(0, oldDataType, oldDataType.getLength(), oldName, memberCopy.getMemberComment());
        }
        this.memberName = tempName;
        this.memberDataType = nestedStructure;
        this.memberIsZeroLengthArray = false;
        this.memberDataTypeName = null;
        this.initializeContainer();
        this.structureMemberRangeMap.paintRange(0L, (long)(memberCopy.getLength() - 1), 0);
        this.structureMemberOffsetMap.put(0, memberCopy);
        memberCopy.setParent(this);
        if (this.parent != null) {
            this.parent.memberChanged(oldName, this);
        }
        if (deferredBitFieldMember != null) {
            return this.addStructureMember(deferredBitFieldMember);
        }
        return true;
    }

    private String getMemberComment() {
        if (this.memberComment == null && !this.memberIsZeroLengthArray) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (this.memberComment != null) {
            buf.append(this.memberComment);
        }
        if (this.memberIsZeroLengthArray) {
            if (buf.length() != 0) {
                buf.append("; ");
            }
            buf.append("warning: zero length array forced to have one element");
        }
        return buf.toString();
    }

    private static DataTypeComponent insertMinimalStructureBitfield(Structure struct, int memberOffset, String memberName, PdbBitField bitfieldDt, String comment) {
        try {
            int baseOffsetAdjustment = bitfieldDt.getBitOffsetWithinBase() / 8;
            return struct.insertBitFieldAt(memberOffset + baseOffsetAdjustment, bitfieldDt.getStorageSize(), bitfieldDt.getBitOffset(), bitfieldDt.getBaseDataType(), bitfieldDt.getDeclaredBitSize(), memberName, comment);
        }
        catch (InvalidDataTypeException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isRelatedBitField(int conflictOffset, DefaultCompositeMember newMember) {
        if (!this.isContainer()) {
            throw new AssertException();
        }
        if (conflictOffset < 0 || !newMember.isBitFieldMember()) {
            return false;
        }
        CompositeMember conflictMember = this.structureMemberOffsetMap.get(conflictOffset);
        return this.isRelatedBitField(conflictMember, newMember);
    }

    private boolean isRelatedBitField(CompositeMember existingMember, DefaultCompositeMember newMember) {
        int consumed;
        if (!newMember.isBitFieldMember()) {
            return false;
        }
        if (existingMember == null) {
            return false;
        }
        if (this.isUnionContainer() && existingMember.isStructureContainer()) {
            DefaultCompositeMember structureMember = (DefaultCompositeMember)existingMember;
            return structureMember.isRelatedBitField(newMember.getOffset(), newMember);
        }
        if (!existingMember.isBitFieldMember() || existingMember.getOffset() != newMember.getOffset() || existingMember.getLength() != newMember.getLength()) {
            return false;
        }
        Composite composite = (Composite)this.memberDataType;
        DataTypeComponent component = composite.getComponent(composite.getNumComponents() - 1);
        DataType dataType = component.getDataType();
        if (!(dataType instanceof BitFieldDataType) && dataType != DataType.DEFAULT) {
            return false;
        }
        PdbBitField newBitField = (PdbBitField)newMember.getDataType();
        if (existingMember instanceof BitFieldGroupCompositeMember) {
            consumed = ((BitFieldGroupCompositeMember)existingMember).getConsumedBits();
        } else {
            DefaultCompositeMember m = (DefaultCompositeMember)existingMember;
            BitFieldDataType conflictBitField = (BitFieldDataType)m.memberDataType;
            consumed = conflictBitField.getBitOffset() + conflictBitField.getBitSize();
        }
        int relativeBitOffset = 0;
        int bitOffsetWithinBase = newBitField.getBitOffsetWithinBase();
        if (bitOffsetWithinBase >= 0 && (relativeBitOffset = bitOffsetWithinBase - consumed) < 0) {
            return false;
        }
        return consumed + relativeBitOffset + newBitField.getBitSize() <= 8 * newBitField.getBaseTypeSize();
    }

    private DefaultCompositeMember getPaddingBitField(BitFieldGroupCompositeMember bfGroup, DefaultCompositeMember nextBitFieldMember) throws InvalidDataTypeException {
        PdbBitField nextBitfieldDt;
        int bitOffsetWithinBase;
        if (!nextBitFieldMember.isBitFieldMember()) {
            throw new AssertException();
        }
        int nextBitOffset = 0;
        if (bfGroup != null) {
            nextBitOffset = bfGroup.getConsumedBits();
        }
        if ((bitOffsetWithinBase = (nextBitfieldDt = (PdbBitField)nextBitFieldMember.getDataType()).getBitOffsetWithinBase()) > nextBitOffset) {
            int fillerBitSize = bitOffsetWithinBase - nextBitOffset;
            return new DefaultCompositeMember(nextBitFieldMember.memberOffset, nextBitfieldDt.getBaseDataType(), fillerBitSize, nextBitOffset);
        }
        return null;
    }

    private boolean addStructureMember(DefaultCompositeMember member) {
        try {
            int conflictOffset = this.structureMemberRangeMap.getValue((long)member.memberOffset);
            if (conflictOffset < 0) {
                DefaultCompositeMember deferredBitFieldMember = null;
                if (member.isBitFieldMember()) {
                    PdbBitField bitfieldDt = (PdbBitField)member.memberDataType;
                    int bitOffset = bitfieldDt.getBitOffsetWithinBase();
                    DefaultCompositeMember padding = this.getPaddingBitField(null, member);
                    if (padding != null) {
                        deferredBitFieldMember = member;
                        member = padding;
                        bitfieldDt = (PdbBitField)member.memberDataType;
                        bitOffset = bitfieldDt.getBitOffsetWithinBase();
                    } else if (bitOffset < 0) {
                        bitOffset = 0;
                    }
                    DefaultCompositeMember.insertMinimalStructureBitfield((Structure)this.memberDataType, member.memberOffset, member.getName(), bitfieldDt, member.getMemberComment());
                } else {
                    ((Structure)this.memberDataType).insertAtOffset(member.memberOffset, member.memberDataType, member.getLength(), member.memberName, member.getMemberComment());
                }
                member.parent = this;
                this.structureMemberOffsetMap.put(member.memberOffset, member);
                this.structureMemberRangeMap.paintRange((long)member.memberOffset, (long)(member.memberOffset + member.getLength() - 1), member.memberOffset);
                if (deferredBitFieldMember != null) {
                    return this.addStructureMember(deferredBitFieldMember);
                }
                if (this.parent != null) {
                    this.parent.sizeChanged(this);
                }
                return true;
            }
            CompositeMember conflictMember = this.structureMemberOffsetMap.get(conflictOffset);
            if (this.isRelatedBitField(conflictOffset, member)) {
                BitFieldGroupCompositeMember bfGroup;
                if (conflictMember instanceof BitFieldGroupCompositeMember) {
                    bfGroup = (BitFieldGroupCompositeMember)conflictMember;
                } else {
                    bfGroup = new BitFieldGroupCompositeMember();
                    bfGroup.addToGroup(conflictMember);
                    this.structureMemberOffsetMap.put(bfGroup.getOffset(), bfGroup);
                }
                DefaultCompositeMember deferredBitFieldMember = null;
                PdbBitField bitfieldDt = (PdbBitField)member.memberDataType;
                int bitOffset = bitfieldDt.getBitOffsetWithinBase();
                DefaultCompositeMember padding = this.getPaddingBitField(bfGroup, member);
                if (padding != null) {
                    deferredBitFieldMember = member;
                    member = padding;
                    bitfieldDt = (PdbBitField)member.memberDataType;
                    bitOffset = bitfieldDt.getBitOffsetWithinBase();
                } else if (bitOffset < 0) {
                    bitOffset = bfGroup.getConsumedBits();
                }
                bfGroup.addToGroup(member);
                DefaultCompositeMember.insertMinimalStructureBitfield((Structure)this.memberDataType, member.memberOffset, member.getName(), bitfieldDt, member.getMemberComment());
                member.parent = this;
                if (deferredBitFieldMember != null) {
                    return this.addStructureMember(deferredBitFieldMember);
                }
                return true;
            }
            member.setOffset(member.getOffset() - conflictMember.getOffset());
            return conflictMember.addMember(member);
        }
        catch (InvalidDataTypeException e) {
            Msg.error((Object)this, (Object)("PDB failed to add bitfield: " + e.getMessage()));
            return false;
        }
    }

    private boolean addUnionMember(DefaultCompositeMember member) {
        DefaultCompositeMember m;
        DefaultCompositeMember struct;
        if (member.memberOffset == 0) {
            CompositeMember lastUnionMember;
            if (this.unionMemberList.size() != 0 && member.isBitFieldMember() && this.isRelatedBitField(lastUnionMember = this.unionMemberList.get(this.unionMemberList.size() - 1), member)) {
                if (lastUnionMember.isSingleBitFieldMember() && !((DefaultCompositeMember)lastUnionMember).transformIntoStructureContainer()) {
                    return false;
                }
                return lastUnionMember.addMember(member);
            }
            this.unionMemberList.add(member);
            member.parent = this;
            ((Union)this.memberDataType).add(member.memberDataType, member.memberName, member.getMemberComment());
            if (this.parent != null) {
                this.parent.sizeChanged(this);
            }
            return !member.memberIsZeroLengthArray || member.transformIntoStructureContainer();
        }
        CompositeMember lastUnionMember = this.unionMemberList.get(this.unionMemberList.size() - 1);
        if (lastUnionMember.isStructureContainer() && member.memberOffset >= lastUnionMember.getOffset() && (struct = (DefaultCompositeMember)lastUnionMember).isRelatedBitField(member.memberOffset - lastUnionMember.getOffset(), member)) {
            member.memberOffset -= lastUnionMember.getOffset();
            return lastUnionMember.addMember(member);
        }
        if (member.memberOffset >= lastUnionMember.getOffset() + lastUnionMember.getLength()) {
            member.memberOffset -= lastUnionMember.getOffset();
            return lastUnionMember.addMember(member);
        }
        if (lastUnionMember instanceof DefaultCompositeMember && (m = (DefaultCompositeMember)lastUnionMember).isUnionContainer() && !m.transformIntoStructureContainer()) {
            return false;
        }
        return lastUnionMember.addMember(member);
    }

    private void sizeChanged(DefaultCompositeMember pdbMember) {
        if (this.structureMemberRangeMap != null) {
            this.structureMemberRangeMap.paintRange((long)pdbMember.memberOffset, (long)(pdbMember.memberOffset + pdbMember.getLength() - 1), pdbMember.memberOffset);
        }
        if (this.parent != null) {
            this.parent.sizeChanged(this);
        }
    }

    private void memberChanged(String fieldName, DefaultCompositeMember newContainerMember) {
        if (!newContainerMember.isContainer()) {
            throw new AssertException();
        }
        if (this.isUnionContainer()) {
            Union union = (Union)this.memberDataType;
            int count = union.getNumComponents();
            for (int i = 0; i < count; ++i) {
                DataTypeComponent component = union.getComponent(i);
                if (!fieldName.equals(component.getFieldName())) continue;
                union.delete(i);
                union.insert(i, newContainerMember.getDataType(), newContainerMember.getLength(), newContainerMember.memberName, null);
                break;
            }
        } else if (this.isStructureContainer()) {
            Structure struct = (Structure)this.memberDataType;
            struct.deleteAtOffset(newContainerMember.getOffset());
            struct.insertAtOffset(newContainerMember.getOffset(), newContainerMember.getDataType(), newContainerMember.getLength());
            this.structureMemberOffsetMap.put(newContainerMember.getOffset(), newContainerMember);
        }
    }

    private void memberNameChanged(String oldFieldName, String newFieldName) {
        if (this.isContainer()) {
            Composite composite = (Composite)this.memberDataType;
            int count = composite.getNumComponents();
            for (int i = 0; i < count; ++i) {
                DataTypeComponent component = composite.getComponent(i);
                if (!oldFieldName.equals(component.getFieldName())) continue;
                try {
                    component.setFieldName(newFieldName);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Failed to rename temporary component name: " + this.getDataTypeName() + "." + oldFieldName + " -> " + newFieldName));
                }
                break;
            }
        }
    }

    private int getOrdinal(String fieldName) throws NotFoundException {
        if (!this.isContainer()) {
            throw new AssertException();
        }
        Composite composite = (Composite)this.memberDataType;
        int count = composite.getNumComponents();
        for (int i = 0; i < count; ++i) {
            DataTypeComponent component = composite.getComponent(i);
            if (!fieldName.equals(component.getFieldName())) continue;
            return i;
        }
        throw new NotFoundException();
    }

    @Override
    boolean addMember(DefaultCompositeMember member) {
        if (member.memberDataType == null || member.memberDataType.getLength() <= 0) {
            Msg.debug((Object)this, (Object)("Failed to resolve member datatype for '" + this.getDataTypeName() + "': " + member.getDataTypeName()));
            return false;
        }
        if (!this.isContainer() && (member.memberOffset != 0 ? !this.transformIntoStructureContainer() : !this.transformIntoUnionContainer())) {
            return false;
        }
        if (this.isUnionContainer()) {
            return this.addUnionMember(member);
        }
        return this.addStructureMember(member);
    }

    private List<CompositeMember> kidnapElderSiblingsFromParentStructure() {
        ArrayList<CompositeMember> list = new ArrayList<CompositeMember>();
        if (this.parent == null || !this.parent.isStructureContainer()) {
            return list;
        }
        Structure parentStruct = (Structure)this.parent.memberDataType;
        for (int offset : this.parent.structureMemberOffsetMap.keySet()) {
            CompositeMember m = this.parent.structureMemberOffsetMap.get(offset);
            if (m.getOffset() < this.memberOffset || m == this) continue;
            list.add(m);
        }
        boolean skipIfEqual = true;
        int truncateOrdinal = -1;
        for (DataTypeComponent component : parentStruct.getComponents()) {
            int offset = component.getOffset();
            if (offset < this.memberOffset) continue;
            if (skipIfEqual && offset == this.memberOffset) {
                skipIfEqual = false;
                continue;
            }
            if (truncateOrdinal < 0) {
                truncateOrdinal = component.getOrdinal();
            }
            this.parent.structureMemberOffsetMap.remove(offset);
        }
        if (truncateOrdinal >= 0) {
            while (parentStruct.getNumComponents() > truncateOrdinal) {
                parentStruct.delete(truncateOrdinal);
            }
        }
        this.parent.structureMemberRangeMap.paintRange((long)(this.memberOffset + this.getLength()), (long)this.parent.getLength(), -1);
        return list;
    }

    public static boolean applyDataTypeMembers(Composite composite, boolean isClass, int preferredCompositeSize, List<? extends PdbMember> members, Consumer<String> errorConsumer, TaskMonitor monitor) throws CancelledException {
        Composite editComposite = composite;
        DefaultCompositeMember rootMember = new DefaultCompositeMember(isClass, editComposite, errorConsumer);
        for (PdbMember pdbMember : members) {
            monitor.checkCancelled();
            try {
                if (rootMember.addMember(pdbMember, monitor)) continue;
                return false;
            }
            catch (DataTypeDependencyException e) {
                String message = "Failed to resolve datatype dependency for " + composite.getPathName() + ": " + pdbMember.getDataTypeName();
                if (errorConsumer != null) {
                    errorConsumer.accept(message);
                    continue;
                }
                Msg.error(DefaultCompositeMember.class, (Object)message);
            }
        }
        rootMember.finalizeDataType(preferredCompositeSize);
        return true;
    }

    void setBitFieldGroup(BitFieldGroupCompositeMember group) {
        this.bitFieldGroup = group;
    }

    private static enum MemberType {
        STRUCTURE,
        UNION,
        MEMBER;

    }
}

