/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumerateMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractIndexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractIndirectVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractNestedTypeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractOneMethodMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractOverloadedMethodMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractStaticMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFieldListMsType
extends AbstractMsType {
    private List<MsTypeField> baseClassList = new ArrayList<MsTypeField>();
    private List<MsTypeField> memberList = new ArrayList<MsTypeField>();
    private List<MsTypeField> methodList = new ArrayList<MsTypeField>();
    private List<AbstractIndexMsType> indexList = new ArrayList<AbstractIndexMsType>();

    public AbstractFieldListMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException, CancelledException {
        super(pdb, reader);
        while (reader.hasMore()) {
            MsTypeField type = TypeParser.parseField(pdb, reader);
            if (type instanceof AbstractBaseClassMsType || type instanceof AbstractVirtualBaseClassMsType || type instanceof AbstractIndirectVirtualBaseClassMsType) {
                this.baseClassList.add(type);
                continue;
            }
            if (type instanceof AbstractOverloadedMethodMsType || type instanceof AbstractOneMethodMsType) {
                this.methodList.add(type);
                continue;
            }
            if (type instanceof AbstractMemberMsType || type instanceof AbstractNestedTypeMsType || type instanceof AbstractStaticMemberMsType || type instanceof AbstractVirtualFunctionTablePointerMsType || type instanceof AbstractEnumerateMsType) {
                this.memberList.add(type);
                continue;
            }
            if (type instanceof AbstractIndexMsType) {
                this.indexList.add((AbstractIndexMsType)type);
                continue;
            }
            PdbLog.message("Unexpected type in Field List" + type.getClass().getSimpleName());
        }
    }

    public List<MsTypeField> getBaseClassList() {
        return this.baseClassList;
    }

    public List<MsTypeField> getMemberList() {
        return this.memberList;
    }

    public List<MsTypeField> getMethodList() {
        return this.methodList;
    }

    public List<AbstractIndexMsType> getIndexList() {
        return this.indexList;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        StringBuilder classBuilder = new StringBuilder();
        DelimiterState dsBases = new DelimiterState(" : ", ", ");
        for (MsTypeField type : this.baseClassList) {
            classBuilder.append(dsBases.out(true, type.toString()));
        }
        StringBuilder memberBuilder = new StringBuilder();
        memberBuilder.append(" {");
        DelimiterState dsMembers = new DelimiterState("", ",");
        for (MsTypeField type : this.memberList) {
            memberBuilder.append(dsMembers.out(true, type.toString()));
        }
        memberBuilder.append("}");
        StringBuilder otherBuilder = new StringBuilder();
        if (this.methodList.size() != 0) {
            otherBuilder.append("...");
        }
        builder.append((CharSequence)classBuilder);
        builder.append((CharSequence)memberBuilder);
        builder.append((CharSequence)otherBuilder);
    }
}

