/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.pdb.pdbapplicator.ObjectOrientedClassLayout;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorControl;
import ghidra.framework.options.Options;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PdbApplicatorOptions {
    private static final boolean DEVELOPER_MODE = Boolean.getBoolean("ghidra.pdb.developerMode");
    private static final String OPTION_NAME_PROCESSING_CONTROL = "Control";
    private static final String OPTION_DESCRIPTION_PROCESSING_CONTROL = "Applicator processing control.";
    private static final PdbApplicatorControl DEFAULT_CONTROL = PdbApplicatorControl.ALL;
    private PdbApplicatorControl control;
    private static final String OPTION_NAME_APPLY_CODE_SCOPE_BLOCK_COMMENTS = "Apply Code Scope Block Comments";
    private static final String OPTION_DESCRIPTION_APPLY_CODE_SCOPE_BLOCK_COMMENTS = "If checked, pre/post-comments will be applied when code scope blocks are specified.";
    private static final boolean DEFAULT_APPLY_CODE_SCOPE_BLOCK_COMMENTS = false;
    private boolean applyCodeScopeBlockComments;
    private static final String OPTION_NAME_APPLY_INSTRUCTION_LABELS = "Apply Instruction Labels";
    private static final String OPTION_DESCRIPTION_APPLY_INSTRUCTION_LABELS = "If checked, labels associated with instructions will be applied.";
    private static final boolean DEFAULT_APPLY_INSTRUCTION_LABELS = false;
    private boolean applyInstructionLabels;
    private static final String OPTION_NAME_EXCLUDE_INSTRUCTION_LABELS = "Exclude Instruction Labels";
    private static final String OPTION_DESCRIPTION_EXCLUDE_INSTRUCTION_LABELS = "Regular expression describing instruction labels to be excluded when \"Apply Instruction Labels\" is enabled.";
    private static final String DEFAULT_EXCLUDE_INSTRUCTION_LABELS = "$a";
    private Pattern DEFAULT_EXCLUDE_INSTRUCTION_LABELS_PATTERN;
    private String excludeInstructionLabels;
    private Pattern excludeInstructionLabelsPattern;
    private static final String OPTION_NAME_ADDRESS_REMAP = "Address Remap Using Existing Symbols";
    private static final String OPTION_DESCRIPTION_ADDRESS_REMAP = "If checked, attempts to remap address to those matching existing public symbols.";
    private static final boolean DEFAULT_REMAP_ADDRESSES_USING_EXISTING_SYMBOLS = false;
    private boolean remapAddressUsingExistingPublicMangledSymbols;
    private static final String OPTION_NAME_ALLOW_DEMOTE_MANGLED_PRIMARY = "Allow demote mangled symbol from primary";
    private static final String OPTION_DESCRIPTION_ALLOW_DEMOTE_MANGLED_PRIMARY = "If checked, allows a mangled symbol to be demoted from primary if a possibly better data type can be laid down with a nonmangled symbol.";
    private static final boolean DEFAULT_ALLOW_DEMOTE_PRIMARY_MANGLED_SYMBOLS = true;
    private boolean allowDemotePrimaryMangledSymbols;
    private static final String OPTION_NAME_APPLY_FUNCTION_VARIABLES = "Apply Function Variables";
    private static final String OPTION_DESCRIPTION_APPLY_FUNCTION_VARIABLES = "If checked, attempts to apply function parameters and local variables for program functions.";
    private static final boolean DEFAULT_APPLY_FUNCTION_VARIABLES = false;
    private boolean applyFunctionVariables;
    private static final String OPTION_NAME_COMPOSITE_LAYOUT = "Composite Layout Choice";
    private static final String OPTION_DESCRIPTION_COMPOSITE_LAYOUT = "Legacy layout like original PDB Analyzer. Warning: other choices have no compatibility guarantee with future Ghidra releases or minor PDB Analyzer changes";
    private static final ObjectOrientedClassLayout DEFAULT_CLASS_LAYOUT = ObjectOrientedClassLayout.MEMBERS_ONLY;
    private ObjectOrientedClassLayout compositeLayout;

    public PdbApplicatorOptions() {
        try {
            this.DEFAULT_EXCLUDE_INSTRUCTION_LABELS_PATTERN = Pattern.compile(DEFAULT_EXCLUDE_INSTRUCTION_LABELS);
        }
        catch (PatternSyntaxException e) {
            throw new AssertException("Programming error: invalid default exclude labels pattern");
        }
        this.setDefaults();
    }

    public void registerAnalyzerOptions(Options options) {
        this.registerOptions(options, false);
    }

    public void loadAnalyzerOptions(Options options) {
        this.loadOptions(options, false);
    }

    public void registerLoaderOptions(Options options) {
        this.registerOptions(options, true);
    }

    public void loadLoaderOptions(Options options) {
        this.loadOptions(options, true);
    }

    private void registerOptions(Options options, boolean enableControl) {
        HelpLocation help = null;
        if (DEVELOPER_MODE || enableControl) {
            options.registerOption(OPTION_NAME_PROCESSING_CONTROL, (Object)PdbApplicatorControl.ALL, help, OPTION_DESCRIPTION_PROCESSING_CONTROL);
        }
        if (DEVELOPER_MODE) {
            options.registerOption(OPTION_NAME_APPLY_CODE_SCOPE_BLOCK_COMMENTS, (Object)this.applyCodeScopeBlockComments, help, OPTION_DESCRIPTION_APPLY_CODE_SCOPE_BLOCK_COMMENTS);
            options.registerOption(OPTION_NAME_APPLY_INSTRUCTION_LABELS, (Object)this.applyInstructionLabels, help, OPTION_DESCRIPTION_APPLY_INSTRUCTION_LABELS);
            options.registerOption(OPTION_NAME_EXCLUDE_INSTRUCTION_LABELS, (Object)this.excludeInstructionLabels, help, OPTION_DESCRIPTION_EXCLUDE_INSTRUCTION_LABELS);
            this.validatePattern(options);
            options.registerOption(OPTION_NAME_ADDRESS_REMAP, (Object)this.remapAddressUsingExistingPublicMangledSymbols, help, OPTION_DESCRIPTION_ADDRESS_REMAP);
            options.registerOption(OPTION_NAME_ALLOW_DEMOTE_MANGLED_PRIMARY, (Object)this.allowDemotePrimaryMangledSymbols, help, OPTION_DESCRIPTION_ALLOW_DEMOTE_MANGLED_PRIMARY);
            options.registerOption(OPTION_NAME_APPLY_FUNCTION_VARIABLES, (Object)this.applyFunctionVariables, help, OPTION_DESCRIPTION_APPLY_FUNCTION_VARIABLES);
            options.registerOption(OPTION_NAME_COMPOSITE_LAYOUT, (Object)this.compositeLayout, help, OPTION_DESCRIPTION_COMPOSITE_LAYOUT);
        }
    }

    private void loadOptions(Options options, boolean enableControl) {
        if (DEVELOPER_MODE || enableControl) {
            this.control = (PdbApplicatorControl)options.getEnum(OPTION_NAME_PROCESSING_CONTROL, (Enum)PdbApplicatorControl.ALL);
        }
        if (DEVELOPER_MODE) {
            this.applyCodeScopeBlockComments = options.getBoolean(OPTION_NAME_APPLY_CODE_SCOPE_BLOCK_COMMENTS, this.applyCodeScopeBlockComments);
            this.applyInstructionLabels = options.getBoolean(OPTION_NAME_APPLY_INSTRUCTION_LABELS, this.applyInstructionLabels);
            this.excludeInstructionLabels = options.getString(OPTION_NAME_EXCLUDE_INSTRUCTION_LABELS, this.excludeInstructionLabels);
            this.validatePattern(options);
            this.remapAddressUsingExistingPublicMangledSymbols = options.getBoolean(OPTION_NAME_ADDRESS_REMAP, this.remapAddressUsingExistingPublicMangledSymbols);
            this.allowDemotePrimaryMangledSymbols = options.getBoolean(OPTION_NAME_ALLOW_DEMOTE_MANGLED_PRIMARY, this.allowDemotePrimaryMangledSymbols);
            this.applyFunctionVariables = options.getBoolean(OPTION_NAME_APPLY_FUNCTION_VARIABLES, this.applyFunctionVariables);
            this.compositeLayout = (ObjectOrientedClassLayout)options.getEnum(OPTION_NAME_COMPOSITE_LAYOUT, (Enum)this.compositeLayout);
        }
    }

    private void validatePattern(Options options) {
        try {
            this.excludeInstructionLabelsPattern = Pattern.compile(this.excludeInstructionLabels);
        }
        catch (PatternSyntaxException e) {
            Msg.error((Object)this, (Object)("Invalid Exclude Instruction Labels value: " + this.excludeInstructionLabels + "\n  Resetting to default value."));
            this.excludeInstructionLabels = DEFAULT_EXCLUDE_INSTRUCTION_LABELS;
            this.excludeInstructionLabelsPattern = this.DEFAULT_EXCLUDE_INSTRUCTION_LABELS_PATTERN;
            options.restoreDefaultValue(OPTION_NAME_EXCLUDE_INSTRUCTION_LABELS);
        }
    }

    public void setDefaults() {
        this.applyCodeScopeBlockComments = false;
        this.applyInstructionLabels = false;
        this.excludeInstructionLabels = DEFAULT_EXCLUDE_INSTRUCTION_LABELS;
        this.excludeInstructionLabelsPattern = this.DEFAULT_EXCLUDE_INSTRUCTION_LABELS_PATTERN;
        this.control = DEFAULT_CONTROL;
        this.remapAddressUsingExistingPublicMangledSymbols = false;
        this.allowDemotePrimaryMangledSymbols = true;
        this.applyFunctionVariables = false;
        this.compositeLayout = DEFAULT_CLASS_LAYOUT;
    }

    public void setApplyCodeScopeBlockComments(boolean applyCodeScopeBlockComments) {
        this.applyCodeScopeBlockComments = applyCodeScopeBlockComments;
    }

    public boolean applyCodeScopeBlockComments() {
        return this.applyCodeScopeBlockComments;
    }

    public void setApplyInstructionLabels(boolean applyInstructionLabels) {
        this.applyInstructionLabels = applyInstructionLabels;
    }

    public boolean applyInstructionLabels() {
        return this.applyInstructionLabels;
    }

    public void setApplyInstructionLabels(String excludeInstructionLabels) {
        this.excludeInstructionLabels = excludeInstructionLabels;
    }

    public String excludeInstructionLabels() {
        return this.excludeInstructionLabels;
    }

    public Pattern excludeInstructionLabelsPattern() {
        return this.excludeInstructionLabelsPattern;
    }

    public void setProcessingControl(PdbApplicatorControl control) {
        this.control = control;
    }

    public PdbApplicatorControl getProcessingControl() {
        return this.control;
    }

    public void setRemapAddressUsingExistingPublicSymbols(boolean enable) {
        this.remapAddressUsingExistingPublicMangledSymbols = enable;
    }

    public boolean remapAddressUsingExistingPublicSymbols() {
        return this.remapAddressUsingExistingPublicMangledSymbols;
    }

    public void setAllowDemotePrimaryMangledSymbols(boolean enable) {
        this.allowDemotePrimaryMangledSymbols = enable;
    }

    public boolean allowDemotePrimaryMangledSymbols() {
        return this.allowDemotePrimaryMangledSymbols;
    }

    public void setApplyFunctionVariables(boolean applyFunctionVariables) {
        this.applyFunctionVariables = applyFunctionVariables;
    }

    public boolean applyFunctionVariables() {
        return this.applyFunctionVariables;
    }

    public void setCompositeLayout(ObjectOrientedClassLayout classLayout) {
        this.compositeLayout = classLayout;
    }

    public ObjectOrientedClassLayout getCompositeLayout() {
        return this.compositeLayout;
    }
}

