/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBBreakpoint;
import SWIG.SBTarget;
import SWIG.SBWatchpoint;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.Map;

public class LldbEnableBreakpointsCommand
extends AbstractLldbCommand<Void> {
    private final String[] ids;

    public LldbEnableBreakpointsCommand(LldbManagerImpl manager, String ... ids) {
        super(manager);
        this.ids = ids;
    }

    @Override
    public Void complete(LldbPendingCommand<?> pending) {
        SBTarget currentSession = this.manager.getCurrentSession();
        for (String id : this.ids) {
            this.manager.doBreakpointEnabled(currentSession, id, pending);
        }
        return null;
    }

    @Override
    public void invoke() {
        Map<String, Object> knownBreakpoints = this.manager.getKnownBreakpoints(this.manager.getCurrentSession());
        for (String id : this.ids) {
            if (!knownBreakpoints.containsKey(id)) continue;
            Object obj = knownBreakpoints.get(id);
            if (obj instanceof SBBreakpoint) {
                ((SBBreakpoint)obj).SetEnabled(true);
            }
            if (!(obj instanceof SBWatchpoint)) continue;
            ((SBWatchpoint)obj).SetEnabled(true);
        }
    }
}

