/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DockingWindowManager;
import docking.EditListener;
import generic.theme.GThemeDefaults;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditWindow
extends JWindow {
    private DockingWindowManager mgr;
    private JTextField textField;
    private boolean active = false;
    private Component comp;
    private Rectangle rect;
    private EditListener listener;
    private AssociatedComponentListener compListener = new AssociatedComponentListener();

    EditWindow(DockingWindowManager mgr) {
        super(mgr.getRootFrame());
        this.mgr = mgr;
        this.create();
    }

    Component getAssociatedComponent() {
        return this.comp;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setVisible(boolean state) {
        this.active = state;
        super.setVisible(state);
        if (!state && this.comp != null) {
            this.comp.removeComponentListener(this.compListener);
            if (this.comp instanceof JTabbedPane) {
                ((JTabbedPane)this.comp).removeChangeListener(this.compListener);
            }
            JFrame frame = this.mgr.getRootFrame();
            frame.removeComponentListener(this.compListener);
            this.comp = null;
            this.listener = null;
        }
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    void show(String defaultText, Component c, Rectangle r, EditListener editListener) {
        if (this.comp != null) {
            this.setVisible(false);
        }
        if (c == null || !c.isVisible()) {
            return;
        }
        this.comp = c;
        this.rect = r;
        this.listener = editListener;
        this.comp.addComponentListener(this.compListener);
        if (this.comp instanceof JTabbedPane) {
            ((JTabbedPane)this.comp).addChangeListener(this.compListener);
        }
        JFrame frame = this.mgr.getRootFrame();
        frame.addComponentListener(this.compListener);
        this.setLocation();
        this.textField.setText(defaultText != null ? defaultText : "");
        Dimension d = this.textField.getPreferredSize();
        this.textField.setPreferredSize(new Dimension(this.rect.width, d.height));
        this.pack();
        this.setVisible(true);
        this.toFront();
        this.textField.requestFocus();
        this.textField.selectAll();
    }

    private void setLocation() {
        Point p = this.comp.getLocationOnScreen();
        this.setLocation(p.x + this.rect.x + 3, p.y + this.rect.y);
    }

    private void create() {
        this.textField = new JTextField(" ");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
        panel.add((Component)this.textField, "Center");
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    EditWindow.this.close();
                }
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    EditWindow.this.close();
                }
            }
        });
        this.textField.addActionListener(e -> {
            if (this.listener != null) {
                String text = this.textField.getText();
                EditListener l = this.listener;
                this.close();
                l.editCompleted(text);
            }
        });
        this.getContentPane().add((Component)panel, "Center");
    }

    private class AssociatedComponentListener
    implements ComponentListener,
    ChangeListener {
        private AssociatedComponentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            EditWindow.this.close();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            EditWindow.this.close();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (EditWindow.this.comp != null && EditWindow.this.comp.isVisible()) {
                EditWindow.this.setLocation();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            EditWindow.this.close();
        }
    }
}

