/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AddRemoveListItem;
import docking.widgets.table.TableSortingContext;
import docking.widgets.table.threaded.TableAddRemoveStrategy;
import docking.widgets.table.threaded.TableData;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CoalescingAddRemoveStrategy<T>
implements TableAddRemoveStrategy<T> {
    @Override
    public void process(List<AddRemoveListItem<T>> addRemoveList, TableData<T> tableData, TaskMonitor monitor) throws CancelledException {
        T value;
        Set<AddRemoveListItem<T>> items = this.coalesceAddRemoveItems(addRemoveList);
        HashMap<T, T> hashed = new HashMap<T, T>();
        for (T t : tableData) {
            hashed.put(t, t);
        }
        HashSet failedToRemove = new HashSet();
        int n = items.size();
        monitor.setMessage("Removing " + n + " items...");
        monitor.initialize((long)n);
        Iterator<AddRemoveListItem<T>> it = items.iterator();
        while (it.hasNext()) {
            AddRemoveListItem<T> item = it.next();
            value = item.getValue();
            if (item.isChange()) {
                toRemove = hashed.remove(value);
                this.remove(tableData, toRemove, failedToRemove);
                monitor.incrementProgress(1L);
            } else if (item.isRemove()) {
                toRemove = hashed.remove(value);
                this.remove(tableData, toRemove, failedToRemove);
                it.remove();
            }
            monitor.checkCancelled();
        }
        if (!failedToRemove.isEmpty()) {
            int size = failedToRemove.size();
            Object message = size == 1 ? "1 old symbol..." : size + " old symbols...";
            monitor.setMessage("Removing " + (String)message);
            tableData.process((data, sortContext) -> this.expungeLostItems(failedToRemove, (List<T>)data, (TableSortingContext<T>)sortContext));
        }
        n = items.size();
        monitor.setMessage("Adding " + n + " items...");
        for (AddRemoveListItem<T> item : items) {
            value = item.getValue();
            if (item.isChange()) {
                tableData.insert(value);
                hashed.put(value, value);
            } else if (item.isAdd()) {
                tableData.insert(value);
                hashed.put(value, value);
            }
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
        }
        monitor.setMessage("Done adding/removing");
    }

    private Set<AddRemoveListItem<T>> coalesceAddRemoveItems(List<AddRemoveListItem<T>> addRemoveList) {
        HashMap map = new HashMap();
        for (AddRemoveListItem<T> item : addRemoveList) {
            if (item.isChange()) {
                this.handleChange(item, map);
                continue;
            }
            if (item.isAdd()) {
                this.handleAdd(item, map);
                continue;
            }
            this.handleRemove(item, map);
        }
        return new HashSet<AddRemoveListItem<T>>(map.values());
    }

    private void handleAdd(AddRemoveListItem<T> item, Map<T, AddRemoveListItem<T>> map) {
        T rowObject = item.getValue();
        AddRemoveListItem<T> existing = map.get(rowObject);
        if (existing == null) {
            map.put(rowObject, item);
            return;
        }
        if (existing.isChange()) {
            return;
        }
        if (existing.isAdd()) {
            return;
        }
        map.put(rowObject, new AddRemoveListItem<T>(AddRemoveListItem.Type.CHANGE, existing.getValue()));
    }

    private void handleRemove(AddRemoveListItem<T> item, Map<T, AddRemoveListItem<T>> map) {
        T rowObject = item.getValue();
        AddRemoveListItem<T> existing = map.get(rowObject);
        if (existing == null) {
            map.put(rowObject, item);
            return;
        }
        if (existing.isChange()) {
            map.put(rowObject, item);
            return;
        }
        if (existing.isRemove()) {
            return;
        }
        map.remove(rowObject);
    }

    private void handleChange(AddRemoveListItem<T> item, Map<T, AddRemoveListItem<T>> map) {
        T rowObject = item.getValue();
        AddRemoveListItem<T> existing = map.get(rowObject);
        if (existing == null) {
            map.put(rowObject, item);
            return;
        }
        if (!existing.isChange()) {
            map.put(rowObject, item);
        }
    }

    private void remove(TableData<T> tableData, T t, Set<T> failedToRemove) {
        if (t == null) {
            return;
        }
        if (!tableData.remove(t)) {
            failedToRemove.add(t);
        }
    }

    private List<T> expungeLostItems(Set<T> toRemove, List<T> data, TableSortingContext<T> sortContext) {
        if (sortContext.isUnsorted()) {
            return data;
        }
        ArrayList<T> newList = new ArrayList<T>(data.size() - toRemove.size());
        for (int i = 0; i < data.size(); ++i) {
            T rowObject = data.get(i);
            if (toRemove.contains(rowObject)) continue;
            newList.add(rowObject);
        }
        return newList;
    }
}

