/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.DockingWindowManager;
import docking.widgets.table.AbstractGTableModel;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.ConfigurableColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.table.SortListener;
import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableSortState;
import docking.widgets.table.VariableColumnTableModel;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.options.PreferenceState;
import ghidra.util.SystemUtilities;
import ghidra.util.task.SwingUpdateManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class TableColumnModelState
implements SortListener {
    private static final int LARGE_DEFAULT_COL_WIDTH = 500;
    private static final int SAVE_DELAY = 1000;
    private static final String XML_COLUMN_VISIBLE = "VISIBLE";
    private static final String XML_COLUMN_WIDTH = "WIDTH";
    private static final String XML_COLUMN_NAME = "NAME";
    private static final String XML_SETTING_NAME = "NAME";
    private static final String XML_SETTING_VALUE = "VALUE";
    private static final String XML_SETTING_TYPE = "TYPE";
    private static final String XML_COLUMN = "COLUMN";
    private static final String XML_COLUMN_DATA = "COLUMN_DATA";
    private static final String XML_COLUMN_SETTING = "COLUMN_SETTING";
    private final GTableColumnModel columnModel;
    private final GTable table;
    private final SwingUpdateManager saveUpdateManager;
    private final SwingUpdateManager restoreUpdateManager;
    private boolean restoring = false;
    private boolean enabled = false;
    private TableSortState lastSortState;

    TableColumnModelState(GTable table, GTableColumnModel columnModel) {
        this.table = table;
        this.columnModel = columnModel;
        this.saveUpdateManager = new SwingUpdateManager(1000, () -> this.doSaveState());
        this.restoreUpdateManager = new SwingUpdateManager(250, () -> this.doRestoreState());
        this.installListeners();
        DockingWindowManager.registerComponentLoadedListener(table, (windowManager, provider) -> {
            if (!this.enabled) {
                this.setEnabled(true);
                this.restoreState();
            }
        });
    }

    private void installListeners() {
        this.table.addPropertyChangeListener("model", evt -> this.installSortListener());
        this.installSortListener();
    }

    private void installSortListener() {
        TableModel model = this.table.getModel();
        if (model instanceof SortedTableModel) {
            SortedTableModel sortedModel = (SortedTableModel)model;
            sortedModel.addSortListener(this);
        }
    }

    @Override
    public void modelSorted(TableSortState sortState) {
        if (sortState.equals(this.lastSortState)) {
            return;
        }
        this.lastSortState = sortState;
        this.saveState();
    }

    void saveState() {
        if (!this.restoring && this.enabled) {
            this.saveUpdateManager.updateLater();
        }
    }

    void forceSaveState() {
        this.doSaveState(this.saveToXML());
        this.saveUpdateManager.stop();
    }

    private void doSaveState() {
        if (this.restoreUpdateManager.isBusy()) {
            this.saveUpdateManager.updateLater();
            return;
        }
        if (this.isTableModelDisposed()) {
            return;
        }
        this.doSaveState(this.saveToXML());
    }

    private boolean isTableModelDisposed() {
        TableModel tableModel = this.table.getUnwrappedTableModel();
        if (tableModel instanceof AbstractGTableModel) {
            AbstractGTableModel gTableModel = (AbstractGTableModel)tableModel;
            return gTableModel.isDisposed();
        }
        return false;
    }

    private void doSaveState(Element xmlElement) {
        PreferenceState preferenceState = new PreferenceState();
        preferenceState.putXmlElement(XML_COLUMN_DATA, xmlElement);
        DockingWindowManager dockingWindowManager = DockingWindowManager.getInstance(this.table);
        if (dockingWindowManager == null) {
            return;
        }
        String preferenceKey = this.getPreferenceKey();
        dockingWindowManager.putPreferenceState(preferenceKey, preferenceState);
    }

    Element saveToXML() {
        Element xmlElement = new Element("Table_State");
        List<TableColumn> columnList = this.columnModel.getAllColumns();
        for (TableColumn column : columnList) {
            String columnName = this.getColumnName(column);
            String width = Integer.toString(column.getWidth());
            boolean visible = this.columnModel.isVisible(column);
            Element columnElement = new Element(XML_COLUMN);
            columnElement.setAttribute("NAME", columnName);
            columnElement.setAttribute(XML_COLUMN_WIDTH, width);
            columnElement.setAttribute(XML_COLUMN_VISIBLE, Boolean.toString(visible));
            this.saveColumnSettings(columnElement, column);
            xmlElement.addContent((Content)columnElement);
        }
        this.saveSortedColumnState(xmlElement);
        return xmlElement;
    }

    private String getColumnName(TableColumn column) {
        TableModel tableModel = this.table.getUnwrappedTableModel();
        if (tableModel instanceof VariableColumnTableModel) {
            VariableColumnTableModel variableTableModel = (VariableColumnTableModel)tableModel;
            return variableTableModel.getUniqueIdentifier(column.getModelIndex());
        }
        return column.getHeaderValue().toString();
    }

    private void saveSortedColumnState(Element xmlElement) {
        TableModel tableModel = this.table.getModel();
        if (!(tableModel instanceof SortedTableModel)) {
            return;
        }
        SortedTableModel sortedTableModel = (SortedTableModel)tableModel;
        TableSortState tableSortState = sortedTableModel.getTableSortState();
        Element sortStateElement = tableSortState.writeToXML();
        xmlElement.addContent((Content)sortStateElement);
    }

    private void saveColumnSettings(Element columnElement, TableColumn column) {
        TableModel tableModel = this.table.getUnwrappedTableModel();
        if (!(tableModel instanceof ConfigurableColumnTableModel)) {
            return;
        }
        ConfigurableColumnTableModel configurableTableModel = (ConfigurableColumnTableModel)tableModel;
        Settings settings = configurableTableModel.getColumnSettings(column.getModelIndex());
        if (settings == null) {
            return;
        }
        for (String name : settings.getNames()) {
            Object value = settings.getValue(name);
            if (value instanceof String) {
                this.addSettingElement(columnElement, name, "String", (String)value);
                continue;
            }
            if (!(value instanceof Long)) continue;
            this.addSettingElement(columnElement, name, "Long", value.toString());
        }
    }

    private void addSettingElement(Element columnElement, String name, String type, String value) {
        Element settingsElement = new Element(XML_COLUMN_SETTING);
        settingsElement.setAttribute("NAME", name);
        settingsElement.setAttribute(XML_SETTING_TYPE, type);
        settingsElement.setAttribute(XML_SETTING_VALUE, value);
        columnElement.addContent((Content)settingsElement);
    }

    private Settings getColumnSettings(Element columnElement) throws DataConversionException {
        SettingsImpl settings = new SettingsImpl();
        for (Object obj : columnElement.getChildren(XML_COLUMN_SETTING)) {
            Element element = (Element)obj;
            this.parseSetting(element, settings);
        }
        return settings;
    }

    private void parseSetting(Element settingElement, Settings settings) throws DataConversionException {
        String name = settingElement.getAttributeValue("NAME");
        String type = settingElement.getAttributeValue(XML_SETTING_TYPE);
        String valueStr = settingElement.getAttributeValue(XML_SETTING_VALUE);
        if (name == null || type == null || valueStr == null) {
            throw new IllegalStateException("Unexpected data format reading saved TableColumn state.");
        }
        if ("Long".equals(type)) {
            long value = settingElement.getAttribute(XML_SETTING_VALUE).getLongValue();
            settings.setLong(name, value);
        } else if ("String".equals(type)) {
            settings.setString(name, valueStr);
        } else {
            throw new IllegalStateException("Unexpected data format reading saved TableColumn state.");
        }
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    void restoreState() {
        if (!this.enabled) {
            return;
        }
        this.restoreUpdateManager.update();
    }

    void restoreStateNow() {
        this.restoreUpdateManager.updateNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRestoreState() {
        if (this.isTableModelDisposed()) {
            return;
        }
        this.restoring = true;
        try {
            DockingWindowManager dockingWindowManager = DockingWindowManager.getInstance(this.table);
            if (dockingWindowManager == null) {
                this.setDefaultColumnsVisible();
                return;
            }
            String key = this.getPreferenceKey();
            PreferenceState preferenceState = dockingWindowManager.getPreferenceState(key);
            if (preferenceState == null) {
                this.setDefaultColumnsVisible();
                return;
            }
            Element xmlElement = preferenceState.getXmlElement(XML_COLUMN_DATA);
            this.restoreFromXML(xmlElement);
        }
        finally {
            this.restoring = false;
        }
    }

    void restoreFromXML(Element xmlElement) {
        try {
            List children = xmlElement.getChildren(XML_COLUMN);
            List<TableColumn> oldCompleteList = this.columnModel.getAllColumns();
            if (children.size() != oldCompleteList.size()) {
                this.setDefaultColumnsVisible();
                return;
            }
            ArrayList<TableColumn> visibleList = new ArrayList<TableColumn>();
            ArrayList<TableColumn> completeList = new ArrayList<TableColumn>();
            ArrayList<Settings> settingsList = new ArrayList<Settings>();
            for (Object object : children) {
                Element element = (Element)object;
                String columnName = element.getAttributeValue("NAME");
                TableColumn column = this.getColumn(columnName, oldCompleteList);
                if (column == null) {
                    this.setDefaultColumnsVisible();
                    return;
                }
                Attribute widthAttribute = element.getAttribute(XML_COLUMN_WIDTH);
                int width = widthAttribute.getIntValue();
                Attribute visibleAttribute = element.getAttribute(XML_COLUMN_VISIBLE);
                boolean visible = visibleAttribute.getBooleanValue();
                Settings columnSettings = this.getColumnSettings(element);
                completeList.add(column);
                column.setWidth(width);
                column.setPreferredWidth(width);
                if (visible) {
                    SystemUtilities.assertTrue((!visibleList.contains(column) ? 1 : 0) != 0, (String)("Duplicate columns being added to the visible columns of table: " + this.getTableModelName() + " - column: " + column.getHeaderValue()));
                    visibleList.add(column);
                }
                settingsList.add(columnSettings);
            }
            this.columnModel.restoreState(completeList, settingsList, visibleList);
            this.restoreColumnSortState(xmlElement);
            this.doSaveState(xmlElement);
        }
        catch (DataConversionException dce) {
            throw new IllegalStateException("Unexpected data format reading saved TableColumn state.");
        }
    }

    private void restoreColumnSortState(Element xmlElement) {
        TableSortState sortState = TableSortState.restoreFromXML(xmlElement);
        if (sortState == null) {
            return;
        }
        TableModel model = this.table.getModel();
        if (!(model instanceof SortedTableModel)) {
            return;
        }
        SortedTableModel sortedModel = (SortedTableModel)model;
        if (!this.isValidSortState(sortState, sortedModel)) {
            return;
        }
        sortedModel.setTableSortState(sortState);
    }

    private boolean isValidSortState(TableSortState tableSortState, SortedTableModel model) {
        int columnCount = model.getColumnCount();
        int sortedColumnCount = tableSortState.getSortedColumnCount();
        if (sortedColumnCount > columnCount) {
            return false;
        }
        for (int i = 0; i < columnCount; ++i) {
            ColumnSortState state = tableSortState.getColumnSortState(i);
            if (state == null || model.isSortable(i)) continue;
            return false;
        }
        return true;
    }

    private String getPreferenceKey() {
        String preferenceKey = this.table.getPreferenceKey();
        if (preferenceKey != null) {
            return preferenceKey;
        }
        TableModel tableModel = this.table.getModel();
        int columnCount = this.getDefaultColumnCount();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getTableModelName());
        buffer.append(":");
        for (int i = 0; i < columnCount; ++i) {
            String columnName = tableModel.getColumnName(i);
            buffer.append(columnName).append(":");
        }
        return buffer.toString();
    }

    private int getDefaultColumnCount() {
        TableModel tableModel = this.table.getUnwrappedTableModel();
        if (tableModel instanceof VariableColumnTableModel) {
            VariableColumnTableModel variableTableModel = (VariableColumnTableModel)tableModel;
            return variableTableModel.getDefaultColumnCount();
        }
        return tableModel.getColumnCount();
    }

    private void setDefaultColumnsVisible() {
        TableModel tableModel = this.table.getUnwrappedTableModel();
        List<TableColumn> columnList = this.columnModel.getAllColumns();
        if (tableModel instanceof VariableColumnTableModel) {
            VariableColumnTableModel variableModel = (VariableColumnTableModel)tableModel;
            int numVisible = 0;
            for (TableColumn column : columnList) {
                int modelIndex = column.getModelIndex();
                boolean isVisible = variableModel.isVisibleByDefault(modelIndex);
                this.columnModel.setVisible(column, isVisible);
                if (!isVisible) continue;
                ++numVisible;
            }
            if (numVisible == 0) {
                this.columnModel.setVisible(columnList.get(0), true);
            }
        }
        this.setDefaultPreferredColumnSizes();
    }

    private void setDefaultPreferredColumnSizes() {
        TableModel model = this.table.getUnwrappedTableModel();
        if (!(model instanceof AbstractGTableModel)) {
            return;
        }
        AbstractGTableModel gModel = (AbstractGTableModel)model;
        List<TableColumn> columnList = this.columnModel.getAllColumns();
        for (TableColumn col : columnList) {
            int defaultPreferred = col.getPreferredWidth();
            if (defaultPreferred > 0 && defaultPreferred != 75) {
                col.setWidth(defaultPreferred);
                continue;
            }
            int preferred = gModel.getPreferredColumnWidth(col.getModelIndex());
            if (preferred < 15) {
                preferred = 500;
            }
            int size = preferred;
            col.setWidth(size);
            col.setPreferredWidth(size);
        }
    }

    private String getTableModelName() {
        TableModel tableModel = this.table.getUnwrappedTableModel();
        return tableModel.getClass().getName();
    }

    private TableColumn getColumn(String columnName, List<TableColumn> columnList) {
        for (TableColumn column : columnList) {
            String existingName = this.getColumnName(column);
            if (!columnName.equals(existingName)) continue;
            return column;
        }
        return null;
    }

    void dispose() {
        this.saveUpdateManager.dispose();
        this.restoreUpdateManager.dispose();
    }
}

