/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.client;

import com.google.protobuf.Message;
import ghidra.dbg.gadp.client.DelegateGadpClientTargetObject;
import ghidra.dbg.gadp.client.GadpClientTargetObject;
import ghidra.dbg.gadp.client.GadpValueUtils;
import ghidra.dbg.gadp.client.annot.GadpEventHandler;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterBank;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface GadpClientTargetRegisterBank
extends GadpClientTargetObject,
TargetRegisterBank {
    default public CompletableFuture<? extends Map<String, byte[]>> readRegistersNamed(Collection<String> names) {
        this.getDelegate().assertValid();
        LinkedHashMap<String, byte[]> result = new LinkedHashMap<String, byte[]>();
        Map<String, byte[]> cache = this.getDelegate().getRegisterCache();
        HashSet<String> needed = new HashSet<String>();
        for (String name : names) {
            byte[] value = cache.get(name);
            if (value == null) {
                needed.add(name);
            }
            result.put(name, value);
        }
        if (needed.isEmpty()) {
            return CompletableFuture.completedFuture(result);
        }
        return this.getModel().sendChecked((Message.Builder)Gadp.RegisterReadRequest.newBuilder().setPath(GadpValueUtils.makePath(this.getPath())).addAllName(needed), Gadp.RegisterReadReply.getDefaultInstance()).thenApply(rep -> {
            for (Gadp.RegisterValue rv : rep.getValueList()) {
                result.put(rv.getName(), rv.getContent().toByteArray());
            }
            return result;
        });
    }

    default public CompletableFuture<Void> writeRegistersNamed(Map<String, byte[]> values) {
        this.getDelegate().assertValid();
        Map<String, byte[]> copy = Map.copyOf(values);
        Map<String, byte[]> cache = this.getDelegate().getRegisterCache();
        return this.getModel().sendChecked((Message.Builder)Gadp.RegisterWriteRequest.newBuilder().setPath(GadpValueUtils.makePath(this.getPath())).addAllValue(GadpValueUtils.makeRegisterValues(copy)), Gadp.RegisterWriteReply.getDefaultInstance()).thenAccept(rep -> cache.putAll(copy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Map<String, byte[]> getCachedRegisters() {
        Map<String, byte[]> cache;
        this.getDelegate().assertValid();
        Map<String, byte[]> map = cache = this.getDelegate().getRegisterCache();
        synchronized (map) {
            return Map.copyOf(cache);
        }
    }

    @GadpEventHandler(value=Gadp.EventNotification.EvtCase.REGISTER_UPDATE_EVENT)
    default public void handleRegisterUpdateEvent(Gadp.EventNotification notification) {
        Gadp.RegisterUpdateEvent evt = notification.getRegisterUpdateEvent();
        Map<String, byte[]> updates = GadpValueUtils.getRegisterValueMap(evt.getValueList());
        DelegateGadpClientTargetObject delegate = this.getDelegate();
        delegate.getRegisterCache().putAll(updates);
        this.broadcast().registersUpdated((TargetObject)this, updates);
    }
}

