/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.frida;

import agent.frida.frida.FridaClient;
import agent.frida.frida.FridaEng;
import agent.frida.frida.FridaServerId;
import agent.frida.manager.FridaDebugger;
import agent.frida.manager.FridaError;
import agent.frida.manager.FridaEvent;
import agent.frida.manager.FridaManager;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaSession;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaTarget;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FridaClientImpl
implements FridaClient {
    private FridaManager manager;
    private FridaDebugger d;
    private FridaTarget initialTarget;
    private List<FridaTarget> targets;

    @Override
    public FridaClient createClient() {
        this.d = FridaEng.init();
        this.targets = new ArrayList<FridaTarget>();
        this.initialTarget = FridaEng.createTarget(this.d);
        this.targets.add(this.initialTarget);
        return this;
    }

    public FridaTarget createTargetById(String id) {
        FridaTarget target = FridaEng.createTargetById(this.d, id);
        this.targets.add(target);
        this.manager.setCurrentTarget(target);
        return target;
    }

    public FridaTarget createTargetByType(String type) {
        Integer typeid = 0;
        if (type.equalsIgnoreCase("Remote")) {
            typeid = 1;
        }
        if (type.equalsIgnoreCase("USB")) {
            typeid = 2;
        }
        FridaTarget target = FridaEng.createTargetByType(this.d, typeid.intValue());
        this.targets.add(target);
        this.manager.setCurrentTarget(target);
        return target;
    }

    public FridaDebugger getDebugger() {
        return this.d;
    }

    @Override
    public FridaServerId getLocalServer() {
        return new FridaServerId(0L);
    }

    @Override
    public FridaSession attachProcess(FridaServerId si, int keyType, String key, boolean wait, boolean async) {
        FridaError error = new FridaError();
        FridaTarget target = this.manager.getCurrentTarget();
        if (target == null) {
            target = this.createNullSession();
            this.targets.add(target);
            this.manager.setCurrentTarget(target);
        }
        int radix = 10;
        if (key.startsWith("0x")) {
            key = key.substring(2);
            radix = 16;
        }
        BigInteger processId = new BigInteger(key, radix);
        FridaSession session = target.attach(processId, error);
        if (!error.success()) {
            Msg.error((Object)this, (Object)("Error while attaching to " + key));
            Msg.error((Object)this, (Object)error.getDescription());
            return null;
        }
        this.manager.updateState(session);
        target.setSession(session);
        return session;
    }

    @Override
    public FridaSession createProcess(FridaServerId si, String fileName) {
        return this.createProcess(si, fileName, new ArrayList<String>(), new ArrayList<String>(), "");
    }

    @Override
    public FridaSession createProcess(FridaServerId si, String fileName, List<String> args, List<String> envp, String workingDir) {
        FridaError error = new FridaError();
        String[] argArr = args.toArray(new String[args.size()]);
        String[] envArr = envp.isEmpty() ? null : envp.toArray(new String[envp.size()]);
        FridaSession session = this.manager.getCurrentTarget().launchSimple(argArr, envArr, workingDir);
        if (!error.success()) {
            Msg.error((Object)this, (Object)"Error for create process");
            Msg.error((Object)this, (Object)error.getDescription());
            return null;
        }
        this.manager.updateState(session);
        return session;
    }

    @Override
    public FridaSession createProcess(FridaServerId si, String fileName, List<String> args, List<String> envp, List<String> pathsIO, String workingDir, long createFlags, boolean stopAtEntry) {
        FridaTarget target = this.manager.getCurrentTarget();
        String[] argArr = args.toArray(new String[args.size()]);
        String[] envArr = envp.isEmpty() ? null : envp.toArray(new String[envp.size()]);
        String pathSTDIN = pathsIO.get(0);
        String pathSTDOUT = pathsIO.get(1);
        String pathSTDERR = pathsIO.get(2);
        FridaError error = new FridaError();
        FridaSession session = target.launch(fileName, argArr, envArr, pathSTDIN, pathSTDOUT, pathSTDERR, workingDir, createFlags, stopAtEntry, error);
        if (!error.success()) {
            Msg.error((Object)this, (Object)("Error while launching " + fileName));
            Msg.error((Object)this, (Object)error.getDescription());
            return null;
        }
        this.manager.updateState(session);
        return session;
    }

    @Override
    public void terminateCurrentProcess(FridaTarget target) {
        FridaError error;
        FridaProcess process = target.getProcess();
        if (process != null && !(error = process.kill()).success()) {
            Msg.error((Object)this, (Object)error.getDescription());
        }
    }

    @Override
    public void destroyCurrentProcess(FridaTarget target) {
        FridaProcess process = target.getProcess();
        FridaError error = process.destroy();
        if (!error.success()) {
            Msg.error((Object)this, (Object)error.getDescription());
        }
    }

    @Override
    public void detachCurrentProcess(FridaTarget target) {
        FridaProcess process = target.getProcess();
        FridaError error = process.destroy();
        if (!error.success()) {
            Msg.error((Object)this, (Object)error.getDescription());
        }
    }

    public FridaTarget createNullSession() {
        return FridaEng.createTarget(this.d);
    }

    @Override
    public FridaTarget connectSession(String fileName) {
        return FridaEng.createTarget(this.d);
    }

    @Override
    public Map<String, FridaSession> listSessions() {
        HashMap<String, FridaSession> map = new HashMap<String, FridaSession>();
        for (FridaTarget t : this.targets) {
            FridaSession session = t.getSession();
            if (session == null) continue;
            map.put(FridaClient.getId(session), session);
        }
        return map;
    }

    @Override
    public void endSession(FridaTarget target, FridaClient.DebugEndSessionFlags flags) {
    }

    @Override
    public void processEvent(FridaEvent<?> fridaEvt) {
        this.manager.processEvent(fridaEvt);
    }

    @Override
    public FridaClient.DebugStatus getExecutionStatus() {
        FridaState state = this.manager.getState();
        return FridaClient.DebugStatus.fromArgument(state);
    }

    @Override
    public boolean getInterrupt() {
        return false;
    }

    @Override
    public void setManager(FridaManager manager) {
        this.manager = manager;
        manager.setCurrentTarget(this.initialTarget);
    }
}

