/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.iface1;

import agent.frida.model.iface1.FridaModelSelectableObject;
import agent.frida.model.iface2.FridaModelTargetObject;
import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetActiveScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface FridaModelTargetActiveScope
extends FridaModelTargetObject,
TargetActiveScope {
    default public CompletableFuture<Void> requestActivation(TargetObject obj) {
        return this.getModel().gateFuture(this.getManager().requestActivation(this, obj));
    }

    default public CompletableFuture<Void> doRequestActivation(TargetObject obj) {
        if (this.getManager().isWaiting()) {
            return AsyncUtils.NIL;
        }
        this.getModel().assertMine(TargetObject.class, obj);
        if (!PathUtils.isAncestor((List)this.getPath(), (List)obj.getPath())) {
            throw new DebuggerIllegalArgumentException("Can only focus a successor of the scope");
        }
        TargetObject cur = obj;
        while (cur != null) {
            if (cur instanceof FridaModelSelectableObject) {
                FridaModelSelectableObject sel = (FridaModelSelectableObject)cur;
                return sel.setActive();
            }
            if (cur instanceof FridaModelTargetObject) {
                FridaModelTargetObject def = (FridaModelTargetObject)cur;
                cur = def.getParent();
                continue;
            }
            throw new AssertionError();
        }
        return AsyncUtils.NIL;
    }
}

