/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.iface2;

import agent.frida.manager.FridaEventsListenerAdapter;
import agent.frida.manager.FridaFrame;
import agent.frida.model.iface1.FridaModelSelectableObject;
import agent.frida.model.iface2.FridaModelTargetObject;
import agent.frida.model.iface2.FridaModelTargetProcess;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface FridaModelTargetStackFrame
extends TargetStackFrame,
FridaEventsListenerAdapter,
FridaModelSelectableObject {
    public static final String FUNC_ATTRIBUTE_NAME = "function";
    public static final String FILE_ATTRIBUTE_NAME = "file";
    public static final String MODULE_ATTRIBUTE_NAME = "module";
    public static final String LINE_ATTRIBUTE_NAME = "line";
    public static final String FUNC_TABLE_ENTRY_ATTRIBUTE_NAME = "Table Entry";
    public static final String FRAME_OFFSET_ATTRIBUTE_NAME = "Frame Offset";
    public static final String INST_OFFSET_ATTRIBUTE_NAME = "Inst. Offset";
    public static final String RETURN_OFFSET_ATTRIBUTE_NAME = "Return Offset";
    public static final String CALL_FRAME_OFFSET_ATTRIBUTE_NAME = "Call Frame Offset";
    public static final String STACK_OFFSET_ATTRIBUTE_NAME = "Stack Offset";
    public static final String VIRTUAL_ATTRIBUTE_NAME = "Virtual";
    public static final String PARAM0_ATTRIBUTE_NAME = "Param[0]";
    public static final String PARAM1_ATTRIBUTE_NAME = "Param[1]";
    public static final String PARAM2_ATTRIBUTE_NAME = "Param[2]";
    public static final String PARAM3_ATTRIBUTE_NAME = "Param[3]";

    @Override
    default public CompletableFuture<Void> setActive() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    default public CompletableFuture<Void> init(Map<String, Object> map) {
        AddressSpace space = this.getModel().getAddressSpace("ram");
        return this.requestNativeAttributes().thenCompose(attrs -> {
            if (attrs == null) {
                return CompletableFuture.completedFuture(null);
            }
            map.putAll((Map<String, Object>)attrs);
            FridaModelTargetObject attributes = (FridaModelTargetObject)attrs.get("Attributes");
            if (attributes == null) {
                return CompletableFuture.completedFuture(null);
            }
            return attributes.requestAugmentedAttributes().thenCompose(ax -> {
                Map subattrs = attributes.getCachedAttributes();
                if (subattrs == null) {
                    return CompletableFuture.completedFuture(null);
                }
                FridaModelTargetObject frameNumber = (FridaModelTargetObject)subattrs.get("FrameNumber");
                return frameNumber.requestAugmentedAttributes().thenCompose(bx -> {
                    Object noval = frameNumber.getCachedAttribute("_value");
                    String nostr = noval.toString();
                    FridaModelTargetObject instructionOffset = (FridaModelTargetObject)subattrs.get("InstructionOffset");
                    return instructionOffset.requestAugmentedAttributes().thenAccept(cx -> {
                        String oldval = (String)this.getCachedAttribute("_display");
                        Object pcval = instructionOffset.getCachedAttribute("_value");
                        String pcstr = pcval.toString();
                        long pc = Long.parseUnsignedLong(pcstr, 16);
                        map.put("_pc", space.getAddress(pc));
                        String display = String.format("#%s 0x%s", nostr, pcstr);
                        map.put("_display", display);
                        this.setModified(map, !display.equals(oldval));
                    });
                });
            });
        });
    }

    public void setFrame(FridaFrame var1);

    public TargetObject getThread();

    public Address getPC();

    public FridaModelTargetProcess getProcess();
}

