/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaManager;
import agent.frida.manager.impl.FridaManagerImpl;
import agent.frida.model.AbstractFridaModel;
import agent.frida.model.iface2.FridaModelTargetProcess;
import agent.frida.model.iface2.FridaModelTargetSession;
import agent.frida.model.impl.FridaModelTargetMemoryContainerImpl;
import agent.frida.model.impl.FridaModelTargetRootImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelClosedReason;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModelWithMemory;
import ghidra.dbg.error.DebuggerModelTerminatingException;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.AnnotatedSchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.GenericAddressSpace;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FridaModelImpl
extends AbstractFridaModel
implements DebuggerObjectModelWithMemory {
    protected static final String SPACE_NAME = "ram";
    protected static final AnnotatedSchemaContext SCHEMA_CTX = new AnnotatedSchemaContext();
    protected static final TargetObjectSchema ROOT_SCHEMA = SCHEMA_CTX.getSchemaForClass(FridaModelTargetRootImpl.class);
    protected final AddressSpace space = new GenericAddressSpace("ram", 64, 1, 0);
    protected final AddressFactory addressFactory = new DefaultAddressFactory(new AddressSpace[]{this.space});
    protected FridaManager manager;
    protected FridaModelTargetSession session;
    protected final FridaModelTargetRootImpl root;
    protected final CompletableFuture<FridaModelTargetRootImpl> completedRoot;
    protected Map<Object, TargetObject> objectMap = new HashMap<Object, TargetObject>();

    public FridaModelImpl() {
        this.manager = FridaManager.newInstance();
        this.root = new FridaModelTargetRootImpl(this, ROOT_SCHEMA);
        this.completedRoot = CompletableFuture.completedFuture(this.root);
        this.addModelRoot(this.root);
    }

    public String getBrief() {
        return "FRIDA@" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    public AddressSpace getAddressSpace(String name) {
        if (!SPACE_NAME.equals(name)) {
            return null;
        }
        return this.space;
    }

    @Override
    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    @Override
    public CompletableFuture<Void> startFrida(String[] args) {
        return this.manager.start(args).thenApplyAsync(__ -> null, (Executor)this.clientExecutor);
    }

    @Override
    public boolean isRunning() {
        return this.manager.isRunning();
    }

    @Override
    public void terminate() throws IOException {
        ((DebuggerModelListener)this.listeners.fire).modelClosed(DebuggerModelClosedReason.NORMAL);
        this.root.invalidateSubtree((TargetObject)this.root, "Frida is terminating");
        this.manager.terminate();
    }

    public TargetObjectSchema getRootSchema() {
        return this.root.getSchema();
    }

    public CompletableFuture<? extends TargetObject> fetchModelRoot() {
        return this.completedRoot;
    }

    @Override
    public FridaManagerImpl getManager() {
        return (FridaManagerImpl)this.manager;
    }

    public CompletableFuture<Void> close() {
        try {
            this.terminate();
            return super.close();
        }
        catch (RejectedExecutionException e) {
            this.reportError((Object)this, "Model is already closing", e);
            return AsyncUtils.NIL;
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    @Override
    public FridaModelTargetSession getSession() {
        return this.session;
    }

    public TargetMemory getMemory(TargetObject target, Address address, int length) {
        if (target instanceof FridaModelTargetProcess) {
            FridaModelTargetProcess process = (FridaModelTargetProcess)target;
            return new FridaModelTargetMemoryContainerImpl(process);
        }
        return null;
    }

    @Override
    public void addModelObject(Object object, TargetObject targetObject) {
        if (object == null) {
            return;
        }
        this.objectMap.put(FridaClient.getModelKey(object), targetObject);
    }

    @Override
    public TargetObject getModelObject(Object object) {
        if (object == null) {
            return null;
        }
        return this.objectMap.get(FridaClient.getModelKey(object));
    }

    public void deleteModelObject(Object object) {
        if (object == null) {
            return;
        }
        this.objectMap.remove(FridaClient.getModelKey(object));
    }

    public <T> CompletableFuture<T> gateFuture(CompletableFuture<T> future) {
        return super.gateFuture(future).exceptionally(ex -> {
            for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RejectedExecutionException)) continue;
                throw new DebuggerModelTerminatingException("Frida is terminating", ex);
            }
            return ExceptionUtils.rethrow((Throwable)ex);
        });
    }
}

