/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.methods;

import agent.frida.model.iface1.FridaModelTargetMethod;
import agent.frida.model.iface2.FridaModelTargetMemoryContainer;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="MemoryPatch", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class FridaModelTargetMemoryPatchImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetMethod {
    protected final TargetMethod.TargetParameterMap paramDescs = TargetMethod.TargetParameterMap.copyOf(this.computeParameters());

    public FridaModelTargetMemoryPatchImpl(FridaModelTargetMemoryContainer memory) {
        super(memory.getModel(), (TargetObject)memory, "patch", "MemoryPatch");
        this.changeAttributes(List.of(), List.of(), Map.of("_parameters", this.paramDescs), "Initialized");
    }

    protected Map<String, TargetMethod.ParameterDescription<?>> computeParameters() {
        HashMap map = new HashMap();
        TargetMethod.ParameterDescription address = TargetMethod.ParameterDescription.create(String.class, (String)"Address", (boolean)true, (Object)"", (String)"Address", (String)"addres to patch");
        TargetMethod.ParameterDescription size = TargetMethod.ParameterDescription.create(Long.class, (String)"Size", (boolean)true, (Object)0L, (String)"Size", (String)"size of patch");
        TargetMethod.ParameterDescription pattern = TargetMethod.ParameterDescription.create(String.class, (String)"Callback", (boolean)true, (Object)"", (String)"Callback", (String)"e.g. code => {const cw = new X86Writer(code, { pc: addr }); cw.putRet(); cw.flush();}");
        map.put("Address", address);
        map.put("Size", size);
        map.put("Callback", pattern);
        return map;
    }

    public CompletableFuture<Object> invoke(Map<String, ?> arguments) {
        Object addr = (String)arguments.get("Address");
        if (!((String)addr).startsWith("0x")) {
            addr = "0x" + (String)addr;
        }
        this.getManager().console("Memory.patchCode(ptr(" + (String)addr + "), " + arguments.get("Size") + ", " + arguments.get("Callback") + ");");
        return CompletableFuture.completedFuture(null);
    }
}

