/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.methods;

import agent.frida.model.iface1.FridaModelTargetMethod;
import agent.frida.model.iface2.FridaModelTargetMemoryContainer;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="MemoryScan", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class FridaModelTargetMemoryScanImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetMethod {
    protected final TargetMethod.TargetParameterMap paramDescs;
    private boolean kernel;

    public FridaModelTargetMemoryScanImpl(FridaModelTargetMemoryContainer memory, boolean kernel) {
        super(memory.getModel(), (TargetObject)memory, "scan", "MemoryScan");
        this.kernel = kernel;
        this.paramDescs = TargetMethod.TargetParameterMap.copyOf(this.computeParameters());
        this.changeAttributes(List.of(), List.of(), Map.of("_parameters", this.paramDescs), "Initialized");
    }

    protected Map<String, TargetMethod.ParameterDescription<?>> computeParameters() {
        HashMap map = new HashMap();
        TargetMethod.ParameterDescription address = TargetMethod.ParameterDescription.create(String.class, (String)"Address", (boolean)true, (Object)"", (String)"Address", (String)"starting address");
        TargetMethod.ParameterDescription size = TargetMethod.ParameterDescription.create(Long.class, (String)"Size", (boolean)true, (Object)4096L, (String)"Size", (String)"size to scan");
        TargetMethod.ParameterDescription pattern = TargetMethod.ParameterDescription.create(String.class, (String)"Pattern", (boolean)true, (Object)"", (String)"Pattern", (String)"e.g. DE AD ?? BE EF");
        TargetMethod.ParameterDescription stopOnMatch = TargetMethod.ParameterDescription.create(Boolean.class, (String)"Stop", (boolean)true, (Object)true, (String)"Stop on match", (String)"stop on match");
        TargetMethod.ParameterDescription script = TargetMethod.ParameterDescription.create(String.class, (String)"Script", (boolean)false, (Object)"", (String)"script", (String)"script to execute on result");
        map.put("Address", address);
        map.put("Size", size);
        map.put("Pattern", pattern);
        map.put("Stop", stopOnMatch);
        map.put("Script", script);
        return map;
    }

    public CompletableFuture<Object> invoke(Map<String, ?> arguments) {
        String ret = (Boolean)arguments.get("Stop") != false ? "  return 'stop'; " : "";
        Object addr = (String)arguments.get("Address");
        if (!((String)addr).startsWith("0x")) {
            addr = "0x" + (String)addr;
        }
        String cmd = this.kernel ? "Kernel" : "Memory";
        this.getManager().console("result = " + cmd + ".scan(ptr(" + (String)addr + "), " + arguments.get("Size") + ", '" + arguments.get("Pattern") + "', { onMatch(address, size) {     console.log('Found match at ', address); " + ret + "  },  onComplete() {     console.log('scan complete');   } });");
        return CompletableFuture.completedFuture(null);
    }
}

