/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import org.jungrapht.visualization.SatelliteVisualizationViewer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.ScalingControl;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;

public class SatelliteScalingGraphMousePlugin
extends ScalingGraphMousePlugin {
    public static Builder builder() {
        return new Builder();
    }

    public SatelliteScalingGraphMousePlugin() {
        this(SatelliteScalingGraphMousePlugin.builder());
    }

    public SatelliteScalingGraphMousePlugin(Builder builder) {
        this(builder.scalingControl, builder.scalingMask, builder.xAxisScalingMask, builder.yAxisScalingMask);
    }

    public SatelliteScalingGraphMousePlugin(ScalingControl scaler, int scalingMask, int xAxisScalingMask, int yAxisScalingMask) {
        super(scaler, scalingMask, xAxisScalingMask, yAxisScalingMask);
    }

    public SatelliteScalingGraphMousePlugin(ScalingControl scaler, int scalingMask, int xAxisScalingMask, int yAxisScalingMask, float in, float out) {
        super(scaler, scalingMask, xAxisScalingMask, yAxisScalingMask, in, out);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            VisualizationViewer vv;
            ScalingControl scalingControl = this.scaler;
            float xin = this.in;
            float yin = this.in;
            float xout = this.out;
            float yout = this.out;
            if (e.getModifiersEx() == this.xAxisScalingMask) {
                yout = 1.0f;
                yin = 1.0f;
                scalingControl = this.layoutScalingControl;
            }
            if (e.getModifiersEx() == this.yAxisScalingMask) {
                xout = 1.0f;
                xin = 1.0f;
                scalingControl = this.layoutScalingControl;
            }
            if ((vv = (VisualizationViewer)e.getSource()) instanceof SatelliteVisualizationViewer) {
                VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
                int amount = e.getWheelRotation();
                if (amount < 0) {
                    scalingControl.scale(vvMaster, xin, yin, vvMaster.getCenter());
                } else if (amount > 0) {
                    scalingControl.scale(vvMaster, xout, yout, vvMaster.getCenter());
                }
                e.consume();
                vv.repaint();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public static class Builder
    extends ScalingGraphMousePlugin.Builder {
        @Override
        public SatelliteScalingGraphMousePlugin build() {
            return new SatelliteScalingGraphMousePlugin(this);
        }
    }
}

