/*
 * Decompiled with CFR 0.152.
 */
package ghidra.python;

import ghidra.python.PythonPlugin;
import ghidra.python.PythonPluginExecutionThread;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;

class PythonPluginInputThread
extends Thread {
    private static int generationCount = 0;
    private final PythonPlugin plugin;
    private final AtomicBoolean moreInputWanted = new AtomicBoolean(false);
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    private final InputStream consoleStdin;
    private PythonPluginExecutionThread pythonExecutionThread;

    PythonPluginInputThread(PythonPlugin plugin) {
        super("Python plugin input thread (generation " + ++generationCount + ")");
        this.plugin = plugin;
        this.consoleStdin = plugin.getConsole().getStdin();
    }

    PythonPluginExecutionThread getPythonPluginExecutionThread() {
        return this.pythonExecutionThread;
    }

    @Override
    public void run() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.consoleStdin));){
            String line;
            while (!this.shutdownRequested.get() && (line = reader.readLine()) != null) {
                this.pythonExecutionThread = new PythonPluginExecutionThread(this.plugin, line, this.moreInputWanted);
                this.pythonExecutionThread.start();
                try {
                    this.pythonExecutionThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.plugin.getConsole().setPrompt(this.moreInputWanted.get() ? this.plugin.getInterpreter().getSecondaryPrompt() : this.plugin.getInterpreter().getPrimaryPrompt());
            }
        }
        catch (IOException e) {
            Msg.error(PythonPluginInputThread.class, (Object)"Internal error reading commands from interpreter console.  Please reset the interpreter.", (Throwable)e);
        }
    }

    void shutdown() {
        try {
            this.shutdownRequested.set(true);
            this.consoleStdin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

